/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.cardgenerate.IFinCardGenerate;
import kd.fi.fa.business.dao.factory.BdPeriodDaoFactory;
import kd.fi.fa.business.utils.FaCardInitFieldUtil;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.cache.FaBusinessImportCardThreadCacheUtil;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public abstract class AbstractFinCardGenerate
implements IFinCardGenerate {
    private static final Map<Long, Date> dateMap = new HashMap<Long, Date>();
    private static final Log log = LogFactory.getLog(AbstractFinCardGenerate.class);
    private final Map<Object, DynamicObject> depresystemCache = new HashMap<Object, DynamicObject>();
    private final Map<Object, DynamicObject> defaultDateByBookCache = new HashMap<Object, DynamicObject>();
    private final Map<Object, DynamicObject> periodByDateMap = new HashMap<Object, DynamicObject>();
    protected Map<Object, BigDecimal> netresidualvalrateMap = new HashMap<Object, BigDecimal>();

    protected abstract List<DynamicObject> generate(List<DynamicObject> var1, Map<Object, DynamicObject[]> var2, MainEntityType var3, DynamicObjectType var4, Long var5, Map<Object, Object> var6);

    @Override
    public List<DynamicObject> generateDynamicFinCard(List<DynamicObject> dynamicAdd, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        return this.generate(dynamicAdd, orgAssetbooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
    }

    protected List<DynamicObject> getFinCardDynamicObject(List<DynamicObject> realCards, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>();
        for (DynamicObject realCard : realCards) {
            long realCardId;
            DynamicObject[] assetBooks;
            DynamicObject org = realCard.getDynamicObject("org");
            if (org == null || (assetBooks = orgAssetbooksMap.get(realCardId = realCard.getLong("id"))) == null || assetBooks.length <= 0) continue;
            Date nowTime = new Date();
            for (DynamicObject assetBook : assetBooks) {
                DynamicObject finCard = (DynamicObject)finCardType.createInstance();
                finCard.set("realcard", (Object)realCard);
                finCard.set("realcardmasterid", (Object)realCard.getLong("masterid"));
                finCard.set("org", (Object)org);
                finCard.set("billno", realCard.get("billno"));
                finCard.set("number", realCard.get("number"));
                finCard.set("assetbook", (Object)assetBook);
                finCard.set("depreuse", assetBook.get("depreuse"));
                finCard.set("billstatus", (Object)BillStatus.A);
                this.setDefaultInfo(assetBook, realCard, finCard, nowTime);
                DynamicObjectCollection billHeads = finCard.getDynamicObjectCollection("billhead_lk");
                DynamicObject billHead = new DynamicObject(billHeadType);
                billHead.set("billhead_lk_stableid", (Object)realCardTableId);
                billHead.set("billhead_lk_sbillid", realCard.getPkValue());
                billHead.set("billhead_lk_sid", realCard.getPkValue());
                billHead.set("seq", (Object)1);
                billHeads.add((Object)billHead);
                finCards.add(finCard);
                finCardAndrealCard.put(finCard.get("number") + "" + finCard.get("depreuse_id"), realCard.getPkValue());
            }
        }
        FaCardInitFieldUtil.restoreInitFields(finCards.toArray(new DynamicObject[0]));
        return finCards;
    }

    protected DynamicObject getAssetPolicyEntryByBook(long depresystemId, DynamicObject assetCat) {
        DynamicObject dyn = null;
        if (this.depresystemCache.get(depresystemId) != null) {
            dyn = this.depresystemCache.get(depresystemId);
        } else {
            dyn = BusinessDataServiceHelper.loadSingle((Object)depresystemId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_depresystem"));
            this.depresystemCache.put(depresystemId, dyn);
        }
        DynamicObjectCollection entrysDOC = dyn.getDynamicObjectCollection("assetpolicy_entry");
        DynamicObject selectedRow = null;
        int index = 999;
        for (int i = 0; i < entrysDOC.size(); ++i) {
            String rowAssetCatNumber;
            DynamicObject wholeRow = (DynamicObject)entrysDOC.get(i);
            DynamicObject rowAssetCat = (DynamicObject)wholeRow.get("assetcat");
            String cardAssetNumber = assetCat.getString("longnumber");
            if (cardAssetNumber.indexOf(rowAssetCatNumber = rowAssetCat.getString("longnumber")) != 0) continue;
            int differenceLength = cardAssetNumber.length() - rowAssetCatNumber.length();
            if (differenceLength == 0) {
                selectedRow = wholeRow;
                break;
            }
            if (differenceLength >= index) continue;
            index = differenceLength;
            selectedRow = wholeRow;
        }
        long assetCatId = assetCat.getLong("id");
        if (selectedRow != null) {
            String keyStr = String.format("%s_%s", depresystemId, assetCatId);
            this.netresidualvalrateMap.put(keyStr, selectedRow.getBigDecimal("netresidualvalrate"));
        }
        return selectedRow;
    }

    protected void setValToCard(DynamicObject card, String property, Object value) {
        card.set(property, value);
    }

    protected BigDecimal getBigDecimal(Object obj) {
        return FaCommonUtils.getBigDecimal(obj);
    }

    private void setDefaultInfo(DynamicObject assetBook, DynamicObject realCard, DynamicObject finCard, Date nowTime) {
        finCard.set(FaCommonUtils.addString_id("realcard"), realCard.getPkValue());
        finCard.set("billno", realCard.get("billno"));
        finCard.set("assetbook", (Object)assetBook);
        finCard.set("depredept", realCard.get("headusedept"));
        finCard.set("isneeddepre", (Object)"1");
        finCard.set("modifytime", (Object)nowTime);
        finCard.set("createtime", (Object)nowTime);
        finCard.set("endperiod_id", (Object)99999999999L);
        finCard.set("creator_id", (Object)ContextUtil.getUserId());
        DynamicObject assetcat = realCard.getDynamicObject("assetcat");
        finCard.set("assetcat", (Object)assetcat);
        this.setBookRelatedInfo(realCard, finCard, assetBook, assetcat);
    }

    private void setBookRelatedInfo(DynamicObject realCard, DynamicObject finCard, DynamicObject assetBook, DynamicObject assetcat) {
        finCard.set("basecurrency", assetBook.get("basecurrency"));
        finCard.set("currency", assetBook.get("basecurrency"));
        finCard.set("currencyrate", (Object)new BigDecimal(1).toString());
        if (finCard.get("finaccountdate") == null) {
            Date realAccountDate = (Date)realCard.get("realaccountdate");
            Date defaultDateByBook = this.getDefaultDateByBook(assetBook);
            if ((realAccountDate == null || realAccountDate.before(defaultDateByBook)) && !realCard.getBoolean("initialcard")) {
                finCard.set("finaccountdate", (Object)defaultDateByBook);
            } else {
                finCard.set("finaccountdate", (Object)realAccountDate);
            }
        }
        DynamicObject pd = null;
        String periodByDateMapKey = finCard.getDate("finaccountdate").toString() + assetBook.getLong("periodtype_Id");
        if (this.periodByDateMap.get(periodByDateMapKey) != null) {
            pd = this.periodByDateMap.get(periodByDateMapKey);
        } else {
            pd = PeriodUtil.getPeriodFullObjByDate(finCard.getDate("finaccountdate"), assetBook.getLong("periodtype_Id"));
            this.periodByDateMap.put(periodByDateMapKey, pd);
        }
        if (realCard.getBoolean("initialcard")) {
            finCard.set("bizperiod_id", (Object)0L);
            finCard.set("period_id", (Object)0L);
        } else {
            if (pd == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u542f\u7528\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"AbstractFinCardGenerate_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            long periodId = pd.getLong("id");
            finCard.set("period_id", (Object)periodId);
            finCard.set("bizperiod_id", (Object)periodId);
            finCard.set("bizperiod", (Object)pd);
        }
        if (assetcat != null) {
            long depresystemId = assetBook.getDynamicObject("depresystem").getLong("id");
            DynamicObject assetPolicyEntry = this.getAssetPolicyEntryByBook(depresystemId, assetcat);
            long periodId = assetBook.getDynamicObject("periodtype").getLong("id");
            if (assetPolicyEntry != null) {
                Calendar ca = Calendar.getInstance();
                ca.setTime(finCard.getDate("finaccountdate"));
                DynamicObject depreMethod = assetPolicyEntry.getDynamicObject("depremethod");
                finCard.set("depremethod", (Object)depreMethod);
                String depreMethodType = "";
                if (depreMethod != null) {
                    depreMethodType = depreMethod.getString("type");
                }
                BigDecimal rate = assetPolicyEntry.getBigDecimal("netresidualvalrate");
                finCard.set("netresidualvalrate", (Object)rate);
                BigDecimal expectUse = assetPolicyEntry.getBigDecimal("expectuse");
                if (!"5".equals(depreMethodType)) {
                    int yearPeriodType = FaBusinessImportCardThreadCacheUtil.getYearPeriodType(Calendar.getInstance().get(1), periodId);
                    finCard.set("preusingamount", (Object)expectUse.multiply(new BigDecimal(yearPeriodType)));
                } else {
                    finCard.set("preusingamount", (Object)expectUse);
                    this.setValToCard(finCard, "workloadunit", assetPolicyEntry.get("workloadunit"));
                }
            } else {
                String longNumber = assetcat.getString("longnumber");
                String depreSystemName = assetBook.getDynamicObject("depresystem").getString("name");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u7c7b\u522b\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e0b\u627e\u4e0d\u5230\u6298\u65e7\u653f\u7b56\u3002", (String)"AssetPolicyUtil_1", (String)"fi-fa-business", (Object[])new Object[0]), longNumber, depreSystemName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getDefaultDateByBook(DynamicObject book) {
        Date endDate;
        if (book.getDynamicObject("curperiod") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u8d26\u7c3f\u5e76\u8bbe\u7f6e\u542f\u7528\u72b6\u6001\u3002", (String)"AbstractFinCardGenerate_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        Date nowDate = null;
        Long currentPeriodId = Long.parseLong(book.getDynamicObject("curperiod").getPkValue() + "");
        nowDate = dateMap.get(currentPeriodId);
        if (nowDate != null) {
            return nowDate;
        }
        DynamicObject period = null;
        if (this.defaultDateByBookCache.get(currentPeriodId) == null) {
            period = BdPeriodDaoFactory.getInstance().queryOne(book.getDynamicObject("curperiod").getPkValue());
            this.defaultDateByBookCache.put(currentPeriodId, period);
        } else {
            period = this.defaultDateByBookCache.get(currentPeriodId);
        }
        Date beginDate = period.getDate("begindate");
        nowDate = endDate = period.getDate("enddate");
        Date now = Calendar.getInstance().getTime();
        if (beginDate.getTime() / 24L * 60L * 60L <= now.getTime() / 24L * 60L * 60L && now.getTime() / 24L * 60L * 60L <= endDate.getTime() / 24L * 60L * 60L) {
            nowDate = now;
        }
        try {
            nowDate = Fa.getDF().parse(Fa.getDF().format(nowDate));
        }
        catch (ParseException parseException) {
        }
        finally {
            dateMap.put(currentPeriodId, nowDate);
        }
        return nowDate;
    }
}

