/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.cardgenerate.impl.AbstractFinCardGenerate;

public class EngineeringToFinCardGenerate
extends AbstractFinCardGenerate {
    private Map<String, BigDecimal> exchangeRateMapCache = new HashMap<String, BigDecimal>();

    @Override
    protected List<DynamicObject> generate(List<DynamicObject> dynamicInventory, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        List<DynamicObject> finCards = this.getFinCardDynamicObject(dynamicInventory, orgAssetbooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
        Map<Long, DynamicObject> map = this.getOriginalVal(dynamicInventory);
        this.setOriginalValue(finCards, map);
        return finCards;
    }

    private Map<Long, DynamicObject> getOriginalVal(List<DynamicObject> realCards) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(realCards.size());
        ArrayList<Long> sourceBills = new ArrayList<Long>(16);
        HashMap<String, DynamicObject> engineerMap = new HashMap<String, DynamicObject>(16);
        DynamicObject engineer = null;
        for (DynamicObject realCard : realCards) {
            sourceBills.add(realCard.getLong("srcbillnumber"));
        }
        QFilter sourceBill = new QFilter("assetsentryadd.id", "in", sourceBills);
        DynamicObjectCollection engineeringbillList = QueryServiceHelper.query((String)"fa_engineeringbill", (String)"assetsentryadd.originalval,assetsentryadd.id,basecurrency", (QFilter[])new QFilter[]{sourceBill});
        for (DynamicObject dy : engineeringbillList) {
            engineerMap.put(dy.getString("assetsentryadd.id"), dy);
        }
        for (DynamicObject realCard : realCards) {
            if (!engineerMap.containsKey(realCard.getString("srcbillnumber"))) continue;
            engineer = (DynamicObject)engineerMap.get(realCard.getString("srcbillnumber"));
            map.put((Long)realCard.getPkValue(), engineer);
        }
        return map;
    }

    private void setOriginalValue(List<DynamicObject> finCards, Map<Long, DynamicObject> map) {
        int amtprecision = 2;
        String dateKey = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject finCard : finCards) {
            Long realcardId;
            DynamicObject inBaseCurrency;
            DynamicObject engineer = map.get(finCard.getDynamicObject("realcard").get("id"));
            if (null == engineer) continue;
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            DynamicObject exchangetable = null;
            long exchangetableId = 0L;
            long inBaseCurrencyId = 0L;
            BigDecimal exchangeRate = BigDecimal.ONE;
            if (assetBook != null) {
                exchangetable = assetBook.getDynamicObject("exchangetable");
            }
            if (exchangetable != null) {
                exchangetableId = exchangetable.getLong("id");
            }
            if ((inBaseCurrency = finCard.getDynamicObject("basecurrency")) != null) {
                amtprecision = inBaseCurrency.getInt("amtprecision");
            }
            if (inBaseCurrency != null) {
                inBaseCurrencyId = inBaseCurrency.getLong("id");
            }
            if (!map.containsKey(realcardId = Long.valueOf(finCard.getDynamicObject("realcard").getLong("id")))) continue;
            BigDecimal originalVal = engineer.getBigDecimal("assetsentryadd.originalval");
            long currencyId = engineer.getLong("basecurrency");
            String finaccountdate = sdf.format(finCard.getDate("finaccountdate"));
            String key = finaccountdate + exchangetableId + currencyId + inBaseCurrencyId;
            if (currencyId != inBaseCurrencyId) {
                if (!this.exchangeRateMapCache.containsKey(key)) {
                    exchangeRate = (BigDecimal)this.getExchangeRate(exchangetableId, currencyId, inBaseCurrencyId, finCard.getDate("finaccountdate"));
                    this.exchangeRateMapCache.put(key, exchangeRate);
                }
                if ((exchangeRate = this.exchangeRateMapCache.get(key)) == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u539f\u5e01\u4e0e\u672c\u4f4d\u5e01\u4e4b\u95f4\u7684\u6c47\u7387\uff0c\u8bf7\u5148\u5728\u7cfb\u7edf\u4e91->\u57fa\u7840\u8d44\u6599->\u6c47\u7387\u5217\u8868\u7ef4\u62a4\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"EngineeringToFinCardGenerate_0", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                this.setValToCard(finCard, "originalval", originalVal.multiply(exchangeRate).setScale(amtprecision, RoundingMode.HALF_UP));
            } else {
                this.setValToCard(finCard, "originalval", originalVal);
            }
            this.setValToCard(finCard, "originalamount", originalVal);
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(finCard);
            this.setValToCard(finCard, "networth", FinCardCalc.setNetWorth(objWrapper));
            this.setValToCard(finCard, "netamount", FinCardCalc.setNetAmount(objWrapper));
            BigDecimal preresidualval = FinCardCalc.setPreResidualVal(objWrapper, false, inBaseCurrency);
            this.setValToCard(finCard, "preresidualval", preresidualval);
        }
    }

    private Object getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        return BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)date);
    }
}

