/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.cardgenerate.impl.AbstractFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.LeaseContractToFinCardGenerate;
import kd.fi.fa.business.enums.lease.LeaseContractDepreTypeEnum;

public class InitLeaseContractToFinCardGenerate
extends AbstractFinCardGenerate {
    @Override
    protected List<DynamicObject> generate(List<DynamicObject> dynamicInventory, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        List<DynamicObject> finCards = this.getFinCardDynamicObject(dynamicInventory, orgAssetbooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
        Map<Long, DynamicObject> oriValMap = LeaseContractToFinCardGenerate.getOriginalVal(dynamicInventory);
        this.setOriginalValue(finCards, oriValMap);
        return finCards;
    }

    private void setOriginalValue(List<DynamicObject> finCards, Map<Long, DynamicObject> oriValMap) {
        DynamicObject dayDepreMethod = BusinessDataServiceHelper.loadSingle((String)"fa_depremethod", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"51")});
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getDynamicObject("realcard").getLong("id");
            if (!oriValMap.containsKey(realCardId)) continue;
            DynamicObject contract = oriValMap.get(realCardId);
            BigDecimal originalVal = contract.getBigDecimal("leaseassets");
            this.setValToCard(finCard, "originalval", originalVal);
            long preUsingAmount = contract.getLong("depremonths");
            this.setValToCard(finCard, "preusingamount", preUsingAmount);
            if (finCard.getLong("bizperiod_id") == 0L) {
                this.setValToCard(finCard, "finaccountdate", contract.getDate("initconfirmdate"));
            } else {
                Date finAccountDate = finCard.getDynamicObject("assetbook").getDynamicObject("curperiod").getDate("begindate");
                this.setValToCard(finCard, "finaccountdate", finAccountDate);
            }
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            long depReSys = assetBook.getDynamicObject("depresystem").getLong("id");
            DynamicObject assetCat = finCard.getDynamicObject("assetcat");
            DynamicObject result = this.getAssetPolicyEntryByBook(depReSys, assetCat);
            if (result != null) {
                BigDecimal netResidualValRate = result.getBigDecimal("netresidualvalrate");
                DynamicObject currency = assetBook.getDynamicObject("basecurrency");
                int precision = currency.getInt("amtprecision");
                this.setValToCard(finCard, "preresidualval", originalVal.multiply(netResidualValRate).divide(new BigDecimal(100), 4).setScale(precision, 4));
            }
            BigDecimal assetsAccumDep = contract.getBigDecimal("assetsaccumdepre");
            this.setValToCard(finCard, "accumdepre", assetsAccumDep);
            long hasDepReMonths = contract.getLong("hasdepremonths");
            this.setValToCard(finCard, "depredamount", hasDepReMonths);
            BigDecimal assetsAddUpYearDepRe = contract.getBigDecimal("assetsaddupyeardepre");
            this.setValToCard(finCard, "addupyeardepre", assetsAddUpYearDepRe);
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(finCard);
            this.setValToCard(finCard, "networth", FinCardCalc.setNetWorth(objWrapper));
            this.setValToCard(finCard, "netamount", FinCardCalc.setNetAmount(objWrapper));
            String contractDepreType = contract.getString("depretype");
            if (!LeaseContractDepreTypeEnum.DAY.getValue().equals(contractDepreType)) continue;
            this.setValToCard(finCard, "depremethod", dayDepreMethod);
        }
    }
}

