/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.cardgenerate.impl.AbstractFinCardGenerate;
import kd.fi.fa.business.enums.lease.LeaseContractDepreTypeEnum;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseContractToFinCardGenerate
extends AbstractFinCardGenerate {
    @Override
    protected List<DynamicObject> generate(List<DynamicObject> dynamicInventory, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        List<DynamicObject> finCards = this.getFinCardDynamicObject(dynamicInventory, orgAssetbooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
        Map<Long, DynamicObject> oriValMap = LeaseContractToFinCardGenerate.getOriginalVal(dynamicInventory);
        this.setOriginalValue(finCards, oriValMap);
        return finCards;
    }

    protected static Map<Long, DynamicObject> getOriginalVal(List<DynamicObject> realCards) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(realCards.size());
        Map<Long, Long> contractCardIdMap = realCards.stream().collect(Collectors.toMap(v -> v.getLong("srcbillid"), v -> v.getLong("id")));
        String selectFields = Fa.comma((String[])new String[]{"id", "leaseassets", "depremonths", "initconfirmdate", "transitionplan", "assetsaccumdepre", "leasetermstartdate", "sysswitchdate", "hasdepremonths", "assetsaddupyeardepre", "depretype"});
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", contractCardIdMap.keySet())};
        DynamicObjectCollection leaseContractList = QueryServiceHelper.query((String)"fa_lease_contract", (String)selectFields, (QFilter[])filters);
        for (DynamicObject leaseContract : leaseContractList) {
            long contractId = leaseContract.getLong("id");
            Long realCardId = contractCardIdMap.get(contractId);
            map.put(realCardId, leaseContract);
        }
        return map;
    }

    private void setOriginalValue(List<DynamicObject> finCards, Map<Long, DynamicObject> oriValMap) {
        DynamicObject dayDepreMethod = BusinessDataServiceHelper.loadSingle((String)"fa_depremethod", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"51")});
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getDynamicObject("realcard").getLong("id");
            if (!oriValMap.containsKey(realCardId)) continue;
            DynamicObject contract = oriValMap.get(realCardId);
            BigDecimal originalVal = contract.getBigDecimal("leaseassets");
            this.setValToCard(finCard, "originalval", originalVal);
            this.setValToCard(finCard, "preusingamount", contract.get("depremonths"));
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            DynamicObject curPeriod = assetBook.getDynamicObject("curperiod");
            Date beginDate = curPeriod.getDate("begindate");
            Date initConfirmDate = (Date)contract.get("initconfirmdate");
            if (DateUtil.compareShortDate((Date)initConfirmDate, (Date)beginDate) < 0) {
                this.setValToCard(finCard, "finaccountdate", beginDate);
            } else {
                this.setValToCard(finCard, "finaccountdate", initConfirmDate);
            }
            String transitionPlan = contract.getString("transitionplan");
            if (TransitionPlan.A.name().equals(transitionPlan)) {
                BigDecimal assetsAccumDepre = contract.getBigDecimal("assetsaccumdepre");
                this.setValToCard(finCard, "accumdepre", assetsAccumDepre);
                Date leaseTermStartDate = contract.getDate("leasetermstartdate");
                int diffMonths = DateUtil.getDiffMonthsByLocalDate((Date)leaseTermStartDate, (Date)initConfirmDate, (boolean)true);
                this.setValToCard(finCard, "depredamount", new BigDecimal(diffMonths));
            }
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(finCard);
            DynamicObject dynObj = objWrapper.getDynamicObject();
            this.setValToCard(finCard, "networth", FinCardCalc.setNetWorth(objWrapper));
            this.setValToCard(finCard, "netamount", FinCardCalc.setNetAmount(objWrapper));
            DynamicObject dynamicObject = dynObj.getDynamicObject("basecurrency");
            try {
                this.setValToCard(finCard, "preresidualval", FinCardCalc.setPreResidualVal(objWrapper, false, dynamicObject));
            }
            catch (Exception e) {
                this.setValToCard(finCard, "preresidualval", new BigDecimal(0));
            }
            String contractDepreType = contract.getString("depretype");
            if (!LeaseContractDepreTypeEnum.DAY.getValue().equals(contractDepreType)) continue;
            this.setValToCard(finCard, "depremethod", dayDepreMethod);
        }
    }
}

