/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.change;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.change.Bill2RealEntry;
import kd.fi.fa.business.change.ChangeBillEntry;
import kd.fi.fa.business.change.FieldEntry;
import kd.fi.fa.business.change.IChangeBillOp;
import kd.fi.fa.business.change.RealEntry;
import kd.fi.fa.business.coderule.CodeRuleService;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.model.FaCard;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.ContextUtil;

public class ChangeBillOpImp
implements IChangeBillOp {
    private static Log logger = LogFactory.getLog(ChangeBillOpImp.class);

    @Override
    public void updateCardByJson(FaCard current, FaCard previous, DynamicObject card) {
    }

    @Override
    public void restoreCardByJson(FaCard current, FaCard previous, DynamicObject card) {
    }

    public List<String> createOriginValueChangeBill(DynamicObject[] objs) {
        String algoKey = this.getClass().getName() + ".createOriginValueChangeBill";
        ArrayList<String> result = new ArrayList<String>();
        if (objs == null) {
            return result;
        }
        for (DynamicObject dy : objs) {
            DynamicObject changeBillDy;
            Long orgId = dy.getDynamicObject("org").getLong("id");
            String billNo = dy.getString("billno");
            String billType = dy.getString("billtype");
            DataSet faCardRelationDs = this.getFaCardRelationDs(algoKey, billNo, billType);
            Map<Object, Object> changeValueMap = new HashMap();
            changeValueMap = this.getRelationMap(dy, faCardRelationDs);
            if (changeValueMap.size() <= 0 || (changeBillDy = this.createOriginValueChangeBill(orgId, changeValueMap)) == null) continue;
            result.add(changeBillDy.getString("billno"));
        }
        return result;
    }

    public DynamicObject createOriginValueChangeBill(Long orgId, Map<Long, BigDecimal> changeValue) {
        Long changeTypeId = 733956066525898752L;
        Map<String, ChangeBillEntry> originValueChange = this.getOriginValueChange(changeValue);
        DynamicObject result = this.createChangeBill(orgId, changeTypeId, originValueChange);
        return result;
    }

    private Map<String, ChangeBillEntry> getOriginValueChange(Map<Long, BigDecimal> changeValue) {
        HashMap<String, ChangeBillEntry> originValueChange = new HashMap<String, ChangeBillEntry>();
        List<DynamicObject> finDys = this.getFinByReal(changeValue.keySet());
        Map<Long, List<DynamicObject>> fin2RealMap = finDys.stream().collect(Collectors.groupingBy(finDy -> finDy.getDynamicObject("realcard").getLong("id")));
        for (Map.Entry<Long, BigDecimal> cardValue : changeValue.entrySet()) {
            BigDecimal diffOriginValue = cardValue.getValue();
            Long realCardId = cardValue.getKey();
            if (!fin2RealMap.containsKey(realCardId)) continue;
            List<DynamicObject> curFinDys = fin2RealMap.get(realCardId);
            Map<Long, List<DynamicObject>> depreFinMap = curFinDys.stream().collect(Collectors.groupingBy(finDy -> finDy.getDynamicObject("depreuse").getLong("id")));
            for (Map.Entry<Long, List<DynamicObject>> depreFins : depreFinMap.entrySet()) {
                List<DynamicObject> sameDepreFins = depreFins.getValue();
                for (DynamicObject curfinDy : sameDepreFins) {
                    Long depreuseId = curfinDy.getDynamicObject("depreuse").getLong("id");
                    String cardKey = String.format("%s_%s", realCardId, depreuseId);
                    ChangeBillEntry changeEntry = new ChangeBillEntry();
                    changeEntry.setRealCard(realCardId);
                    changeEntry.setFinCard(curfinDy.getLong("id"));
                    changeEntry.setDepreuse(depreuseId);
                    changeEntry.setCurrent(curfinDy.getDynamicObject("currency").getLong("id"));
                    changeEntry.setBasecurrent(curfinDy.getDynamicObject("assetbook").getDynamicObject("basecurrency").getLong("id"));
                    changeEntry.setReason("auto verification");
                    ArrayList<FieldEntry> fieldEntrys = new ArrayList<FieldEntry>();
                    BigDecimal befOriginalValue = curfinDy.getBigDecimal("originalval");
                    BigDecimal aftOriginalValue = befOriginalValue.subtract(diffOriginValue);
                    FieldEntry originalField = new FieldEntry();
                    originalField.setFiledName("originalval");
                    originalField.setFormMeta("fa_card_fin");
                    originalField.setBeforeValue(befOriginalValue);
                    originalField.setAfterValue(aftOriginalValue);
                    FieldEntry preresidualvalField = new FieldEntry();
                    preresidualvalField.setFiledName("preresidualval");
                    preresidualvalField.setFormMeta("fa_card_fin");
                    BigDecimal netResidualValRate = FinCardCalc.getNetResidualValRate(curfinDy, true);
                    preresidualvalField.setBeforeValue(befOriginalValue.multiply(netResidualValRate).divide(new BigDecimal(100), 4));
                    preresidualvalField.setAfterValue(aftOriginalValue.multiply(netResidualValRate).divide(new BigDecimal(100), 4));
                    fieldEntrys.add(originalField);
                    fieldEntrys.add(preresidualvalField);
                    changeEntry.setFieldEntryList(fieldEntrys);
                    originValueChange.put(cardKey, changeEntry);
                }
            }
        }
        return originValueChange;
    }

    public DynamicObject getChangeBillObj() {
        MainEntityType changeBillType = EntityMetadataCache.getDataEntityType((String)"fa_change_dept");
        DynamicObject changeDy = new DynamicObject((DynamicObjectType)changeBillType);
        return changeDy;
    }

    public DynamicObject createChangeBill(Long orgId, Long changeTypeId, Map<String, ChangeBillEntry> changeEntryMap) {
        DynamicObject changeDy = this.getChangeBillObj();
        DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        changeDy.set("org", (Object)orgDy);
        changeDy.set("changetype", (Object)changeTypeId);
        changeDy.set("billstatus", (Object)BillStatus.A);
        changeDy.set("sourcetype", (Object)"2");
        changeDy.set("appliantid", (Object)ContextUtil.getUserId());
        changeDy.set("creator", (Object)ContextUtil.getUserId());
        changeDy.set("createtime", (Object)TimeServiceHelper.now());
        Date changeDate = this.getChangeDate(orgId);
        changeDy.set("changedate", (Object)changeDate);
        Object billNo = this.getAutoNumber(changeDy);
        changeDy.set("billno", billNo);
        DynamicObjectCollection fieldEntries = changeDy.getDynamicObjectCollection("fieldentry");
        for (Map.Entry<String, ChangeBillEntry> changeEntryRow : changeEntryMap.entrySet()) {
            ChangeBillEntry changeEntry = changeEntryRow.getValue();
            this.addFiledChangeEntry(fieldEntries, changeEntry);
        }
        this.addRealChangeEntry(changeDy, changeEntryMap);
        String algoKey = this.getClass().getName() + ".createChangeBill";
        try (TXHandle tx = TX.requiresNew((String)algoKey);){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{changeDy});
                this.setRealCardStatus(changeEntryMap, changeDy);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        return changeDy;
    }

    public void addFiledChangeEntry(DynamicObjectCollection fieldEntries, ChangeBillEntry changeEntry) {
        for (FieldEntry field : changeEntry.getFieldEntryList()) {
            DynamicObject fieldRowDy = fieldEntries.addNew();
            fieldRowDy.set("realcard1", (Object)changeEntry.getRealCard());
            fieldRowDy.set("fincard1", (Object)changeEntry.getFinCard());
            fieldRowDy.set("currency1", (Object)changeEntry.getCurrent());
            fieldRowDy.set("basecurrency1", (Object)changeEntry.getBasecurrent());
            fieldRowDy.set("depreuse1", (Object)changeEntry.getDepreuse());
            fieldRowDy.set("field", (Object)String.format("%s.%s", field.getFormMeta(), field.getFiledName()));
            fieldRowDy.set("beforevalue", field.getBeforeValue());
            fieldRowDy.set("aftervalue", field.getAfterValue());
            fieldRowDy.set("reason", (Object)changeEntry.getReason());
        }
    }

    public void addRealChangeEntry(DynamicObject billDy, Map<String, ChangeBillEntry> changeEntryMap) {
        Map<Long, List<ChangeBillEntry>> realEntryMap = changeEntryMap.values().stream().collect(Collectors.groupingBy(changeEntry -> changeEntry.getRealCard()));
        DynamicObjectCollection realEntries = billDy.getDynamicObjectCollection("realentry");
        for (Map.Entry<Long, List<ChangeBillEntry>> realMap : realEntryMap.entrySet()) {
            DynamicObject realEntry = realEntries.addNew();
            realEntry.set("realcard", (Object)realMap.getKey());
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            for (ChangeBillEntry finEntry : realMap.getValue()) {
                DynamicObject finDy = finEntries.addNew();
                finDy.set("fincard", (Object)finEntry.getFinCard());
                finDy.set("currency", (Object)finEntry.getCurrent());
                finDy.set("depreuse", (Object)finEntry.getDepreuse());
            }
        }
    }

    public void setRealCardStatus(Map<String, ChangeBillEntry> changeEntryMap, DynamicObject bill) {
        List<Object> realCardIds = changeEntryMap.values().stream().map(changeEntry -> changeEntry.getRealCard()).collect(Collectors.toList());
        Object[] realCardIdArr = realCardIds.toArray(new Object[realCardIds.size()]);
        DynamicObjectType typeDo = bill.getDynamicObjectType();
        String entityType = typeDo.getName();
        HashSet<Long> masterIds = new HashSet<Long>(realCardIds.size());
        SqlBuilder sbReal = new SqlBuilder();
        sbReal.append("select fmasterid FROM t_fa_card_real where ", new Object[0]);
        sbReal.appendIn("fid", realCardIds.toArray());
        DataSet sbRealDS = DB.queryDataSet((String)"ChangeBillOpImp_setRealCardStatus", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sbReal);
        for (Row row : sbRealDS) {
            masterIds.add(row.getLong("fmasterid"));
        }
        FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(realCardIdArr, BizStatusEnum.CHG, BizStatusEnum.READY, masterIds, bill.getPkValue(), entityType);
    }

    public Map<Long, List<DynamicObject>> getReal2FinCardMap(DynamicObject billDy) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        ArrayList<Long> finIds = new ArrayList<Long>();
        DynamicObjectCollection fieldDys = billDy.getDynamicObjectCollection("fieldentry");
        for (int i = 0; i < fieldDys.size(); ++i) {
            DynamicObject realCard = ((DynamicObject)fieldDys.get(i)).getDynamicObject("realcard1");
            DynamicObject finCard = ((DynamicObject)fieldDys.get(i)).getDynamicObject("fincard1");
            if (realCard == null || finCard == null) continue;
            Long finID = finCard.getLong("id");
            Long realID = realCard.getLong("id");
            if (finIds.contains(finID)) continue;
            if (result.containsKey(realID)) {
                ((List)result.get(realID)).add(finCard);
            } else {
                ArrayList<DynamicObject> curInitFinLst = new ArrayList<DynamicObject>();
                curInitFinLst.add(finCard);
                result.put(realID, curInitFinLst);
            }
            finIds.add(finID);
        }
        return result;
    }

    private Object getAutoNumber(DynamicObject billDy) {
        CodeRuleService code = CodeRuleService.getInstance(billDy, billDy.get("org_id").toString());
        return code.getNumber();
    }

    private Date getChangeDate(Long orgId) {
        Date result = null;
        Date now = new Date();
        String errmsg = null;
        Date maxBeginDate = null;
        Date minEndDate = null;
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg(orgId);
        if (mainBook != null) {
            boolean flag;
            maxBeginDate = (Date)mainBook.get("begindate");
            minEndDate = (Date)mainBook.get("enddate");
            if (maxBeginDate == null) {
                errmsg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"ChangeBillOpImp_0", (String)"fi-fa-business", (Object[])new Object[0]);
                throw new KDBizException(errmsg);
            }
            boolean bl = flag = now.after(maxBeginDate) && now.before(minEndDate);
            result = flag ? now : minEndDate;
        } else {
            errmsg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"ChangeBillOpImp_1", (String)"fi-fa-business", (Object[])new Object[0]);
            throw new KDBizException(errmsg);
        }
        return result;
    }

    Map<String, DynamicObject> getFinByRealMap(Set<Long> realCards) {
        List<DynamicObject> finCardLst = this.getFinByReal(realCards);
        HashMap<String, DynamicObject> finCardMap = new HashMap<String, DynamicObject>(finCardLst.size());
        for (DynamicObject finCard : finCardLst) {
            String readCardStr = finCard.getDynamicObject("realcard").getPkValue().toString();
            String depreuseStr = finCard.getDynamicObject("depreuse").getPkValue().toString();
            String keyStr = String.format("%s_%s", readCardStr, depreuseStr);
            finCardMap.put(keyStr, finCard);
        }
        return finCardMap;
    }

    List<DynamicObject> getFinByReal(Set<Long> realCards) {
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCards)};
        String selector = FaDaoOrmImpl.comma("id", "realcard", "currency", FaDaoOrmImpl.dot("realcard", "usestatus", "isdepre"), "originalval", "assetcat", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot("assetbook", "basecurrency"), FaDaoOrmImpl.dot("assetbook", "curperiod", "id"), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre");
        DynamicObject[] finCards = FaBillDaoFactory.getInstance("fa_card_fin").query(selector, filters);
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> this.filterFinCards((DynamicObject)fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    private boolean filterFinCards(DynamicObject fincard) {
        long curPeriodId = fincard.getDynamicObject("assetbook").getDynamicObject("curperiod").getLong("id");
        DynamicObject bizPeriodDyn = fincard.getDynamicObject("bizperiod");
        long bizPeriodId = 0L;
        if (bizPeriodDyn != null) {
            bizPeriodId = fincard.getDynamicObject("bizperiod").getLong("id");
        }
        long endPeriodId = 99999999999L;
        DynamicObject endPeriod = fincard.getDynamicObject("endperiod");
        if (endPeriod != null) {
            endPeriodId = endPeriod.getLong("id");
        }
        return bizPeriodId <= curPeriodId && curPeriodId < endPeriodId;
    }

    public Map<Long, BigDecimal> getRelationMap(DynamicObject recordDy, DataSet faCardRelationDs) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        Map<Long, BigDecimal> curChangeValue = this.getChangeValueByDs(faCardRelationDs, recordDy);
        for (Map.Entry<Long, BigDecimal> changeValue : curChangeValue.entrySet()) {
            if (result.containsKey(changeValue.getKey())) continue;
            result.put(changeValue.getKey(), changeValue.getValue());
        }
        return result;
    }

    private DataSet getFaCardRelationDs(String algoKey, String billNo, String billType) {
        DataSet faPurchaseDs = this.getFaPurchaseDs(algoKey, billNo, billType);
        Set<String> purChaseBillNos = this.getPurBillNo(faPurchaseDs.copy());
        DataSet getFaRealCardDs = this.getFaRealCardDs(algoKey, purChaseBillNos);
        DataSet faCardRelationDs = faPurchaseDs.join(getFaRealCardDs, JoinType.INNER).on("billno", "srcbillnumber").on("entryid", "sourceentryid").select(new String[]{"billno as purBillNo", "entryid as purEntryId", "sourcebillno", "sourceentryid"}, new String[]{"id as realcardid", "assetamount"}).finish();
        return faCardRelationDs;
    }

    Map<Long, BigDecimal> getChangeValueByDs(DataSet faCardRelationDs, DynamicObject recordDy) {
        Map<String, Bill2RealEntry> bill2RealEntry = this.getBill2RealEntry(faCardRelationDs, recordDy);
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        for (Bill2RealEntry billEntry : bill2RealEntry.values()) {
            if (billEntry.getVerifyamount().compareTo(billEntry.getE_verifyamount()) == 0) continue;
            BigDecimal sumDiffAmount = BigDecimal.ZERO;
            BigDecimal diffAmount = billEntry.getVerifyamount().subtract(billEntry.getE_verifyamount());
            if (billEntry.getRealEntrys() == null || billEntry.getRealEntrys().size() == 0) continue;
            BigDecimal totalCount = billEntry.getRealEntrys().stream().map(x -> x.getQty()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal diffPerice = diffAmount.divide(totalCount, 4);
            for (int i = 0; i < billEntry.getRealEntrys().size(); ++i) {
                if (i < billEntry.getRealEntrys().size() - 1) {
                    BigDecimal count = billEntry.getRealEntrys().get(i).getQty();
                    BigDecimal diffRealAmount = diffPerice.multiply(count);
                    sumDiffAmount = sumDiffAmount.add(diffRealAmount);
                    result.put(billEntry.getRealEntrys().get(i).getRealId(), diffRealAmount);
                    continue;
                }
                result.put(billEntry.getRealEntrys().get(i).getRealId(), diffAmount.subtract(sumDiffAmount));
            }
        }
        return result;
    }

    Map<String, Bill2RealEntry> getBill2RealEntry(DataSet faCardRelationDs, DynamicObject recordDy) {
        HashMap<String, Bill2RealEntry> result = new HashMap<String, Bill2RealEntry>();
        String billNo = recordDy.getString("billno");
        Long billentryid = recordDy.getLong("billentryid");
        Long fid = recordDy.getLong("id");
        String billType = recordDy.getString("billtype");
        BigDecimal verifyamount = recordDy.getBigDecimal("verifyamount");
        BigDecimal verifyqty = recordDy.getBigDecimal("verifyqty");
        BigDecimal e_verifyamount = BigDecimal.ZERO;
        BigDecimal e_verifyqty = BigDecimal.ZERO;
        for (DynamicObject row : recordDy.getDynamicObjectCollection("entry")) {
            e_verifyamount = e_verifyamount.add(row.getBigDecimal("e_verifyamount"));
            e_verifyqty = e_verifyqty.add(row.getBigDecimal("e_verifyqty"));
        }
        if (verifyqty.compareTo(e_verifyqty) != 0) {
            return result;
        }
        String keyStr = String.format("%s_%s", billNo, billentryid);
        Bill2RealEntry billEntry = new Bill2RealEntry();
        billEntry.setBillid(fid);
        billEntry.setBillType(billType);
        billEntry.setBillNo(billNo);
        billEntry.setBillentryid(billentryid);
        billEntry.setVerifyamount(verifyamount);
        billEntry.setVerifyqty(verifyqty);
        billEntry.setE_verifyamount(e_verifyamount);
        billEntry.setE_verifyqty(e_verifyqty);
        billEntry.setRealQty(BigDecimal.ZERO);
        HashMap<Long, RealEntry> realEntryMap = new HashMap<Long, RealEntry>();
        int rowCount = 0;
        for (Row row : faCardRelationDs) {
            if (rowCount == 0) {
                billEntry.setPurBillNo(row.getString("purBillNo"));
                billEntry.setPurEntryId(row.getLong("purEntryId"));
            }
            BigDecimal realQty = row.getBigDecimal("assetamount");
            Long realId = row.getLong("realCardid");
            billEntry.setRealQty(billEntry.getRealQty().add(realQty));
            if (realEntryMap.containsKey(realId)) {
                ((RealEntry)realEntryMap.get(realId)).setQty(((RealEntry)realEntryMap.get(realId)).getQty().add(realQty));
            } else {
                RealEntry realEntry = new RealEntry();
                realEntry.setRealId(realId);
                realEntry.setQty(realQty);
                realEntryMap.put(realId, realEntry);
            }
            ++rowCount;
        }
        if (realEntryMap.size() > 0) {
            billEntry.setRealEntrys(new ArrayList<RealEntry>(realEntryMap.values()));
            result.put(keyStr, billEntry);
        }
        return result;
    }

    Set<String> getPurBillNo(DataSet faPurchaseDs) {
        HashSet<String> billNos = new HashSet<String>();
        for (Row row : faPurchaseDs) {
            String billNo = row.getString("billno");
            billNos.add(billNo);
        }
        return billNos;
    }

    DataSet getFaPurchaseDs(String algoKey, String srcBillNo, String formId) {
        DataSet faPurchaseDs = null;
        ArrayList<QFilter> faPurchaseFilters = new ArrayList<QFilter>();
        faPurchaseFilters.add(new QFilter("sourcebillno", "=", (Object)srcBillNo));
        faPurchaseFilters.add(new QFilter("sourcebillsign", "=", (Object)formId));
        faPurchaseDs = ORM.create().queryDataSet(algoKey, "fa_purchasebill", this.getFaPurchaseSelectedFieds(), faPurchaseFilters.toArray(new QFilter[0]));
        return faPurchaseDs;
    }

    DataSet getFaRealCardDs(String algoKey, Set<String> purChaseBillNos) {
        DataSet faRealCardDs = null;
        ArrayList<QFilter> faRealCardFilters = new ArrayList<QFilter>();
        faRealCardFilters.add(new QFilter("sourceflag", "=", (Object)SourceFlagEnum.PURCHASE));
        faRealCardFilters.add(new QFilter("srcbillnumber", "in", purChaseBillNos));
        faRealCardDs = ORM.create().queryDataSet(algoKey, "fa_card_real", this.getFaRealCardSelectedFieds(), faRealCardFilters.toArray(new QFilter[0]));
        return faRealCardDs;
    }

    private String getFaPurchaseSelectedFieds() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("%s as %s", "id", "id"));
        result.add(String.format("%s as %s", "billno", "billno"));
        result.add(String.format("%s as %s", FaDaoOrmImpl.dot("assetsentry", "id"), "entryid"));
        result.add(String.format("%s as %s", "sourcebillno", "sourcebillno"));
        result.add(String.format("%s as %s", "sourcebillsign", "sourcebillsign"));
        result.add(String.format("%s as %s", FaDaoOrmImpl.dot("assetsentry", "sourceentryid"), "sourceentryid"));
        return result.stream().collect(Collectors.joining(","));
    }

    private String getFaRealCardSelectedFieds() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("%s as %s", "id", "id"));
        result.add(String.format("%s as %s", "billno", "billno"));
        result.add(String.format("%s as %s", "srcbillnumber", "srcbillnumber"));
        result.add(String.format("%s as %s", "sourceentryid", "sourceentryid"));
        result.add(String.format("%s as %s", "sourceentrysplitseq", "sourceentrysplitseq"));
        result.add(String.format("%s as %s", "assetamount", "assetamount"));
        return result.stream().collect(Collectors.joining(","));
    }
}

