/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear.convertor;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public abstract class AbstractBill2ClearBillConvertor
implements IClearBillConvertor {
    private static final Log log = LogFactory.getLog(AbstractBill2ClearBillConvertor.class);

    @Override
    public ClearBillData convert(DynamicObject bill) {
        ClearBillData data = new ClearBillData();
        this.setAssetOrg(bill, data);
        this.setHeadData(bill, data);
        this.setDetailData(bill, data);
        return data;
    }

    public Object pk(DynamicObject dobj) {
        if (dobj != null) {
            return dobj.getPkValue();
        }
        return null;
    }

    protected void setAssetOrg(DynamicObject bill, ClearBillData data) {
        data.setAssetOrgID(bill.getDynamicObject("org").getPkValue());
    }

    protected abstract void setHeadData(DynamicObject var1, ClearBillData var2);

    protected abstract void setDetailData(DynamicObject var1, ClearBillData var2);

    public boolean isNeedDepre(DynamicObject finCard, long curPeriodId) {
        return finCard.getLong("bizperiod_id") < curPeriodId || finCard.getBoolean("isneeddepre");
    }

    public boolean isDepreWhenClear(DynamicObject finCard, List<Tuple<String, DynamicObject>> assetPolicyInfo, Map<Object, Boolean> useStatusMap) {
        if (finCard.getBigDecimal("originalval").compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        String catLNumber = finCard.get("assetcat.longnumber").toString();
        DynamicObject policy = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber(catLNumber, assetPolicyInfo);
        if (policy.getBoolean("nodepre")) {
            return false;
        }
        return useStatusMap.get(finCard.get("realcard.usestatus.id"));
    }

    protected boolean filterFinCards(DynamicObject finCard) {
        boolean isCanFiltered;
        long curPeriodId = finCard.getDynamicObject("assetbook").getDynamicObject("curperiod").getLong("id");
        DynamicObject bizPeriodDyn = finCard.getDynamicObject("bizperiod");
        long bizPeriodId = 0L;
        if (bizPeriodDyn != null) {
            bizPeriodId = finCard.getDynamicObject("bizperiod").getLong("id");
        }
        long endPeriodId = 99999999999L;
        DynamicObject endPeriod = finCard.getDynamicObject("endperiod");
        if (endPeriod != null) {
            endPeriodId = endPeriod.getLong("id");
        }
        boolean bl = isCanFiltered = bizPeriodId <= curPeriodId && curPeriodId < endPeriodId;
        if (!isCanFiltered) {
            log.info(String.format("\u88ab\u8fc7\u6ee4\u7684\u8d22\u52a1\u5361\u7247ID\u4e3a\uff1a%s,bizPeriodId:%s,curPeriodId:%s", finCard.getPkValue(), bizPeriodId, curPeriodId));
        }
        return isCanFiltered;
    }

    public DynamicObject[] queryFinCards(Set<Object> realCardSet) {
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"number", "masterid", "org"}), (QFilter[])new QFilter("id", "in", realCardSet).toArray());
        Set masterIds = realCards.stream().map(v -> v.get("masterid")).collect(Collectors.toSet());
        if (realCards.isEmpty()) {
            return null;
        }
        long orgId = ((DynamicObject)realCards.get(0)).getLong("org");
        DynamicObject book = FaBizUtils.getAsstBookByOrg(orgId, "curperiod");
        Long curPeriodId = book.getLong("curperiod");
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", masterIds), new QFilter("bizperiod", "<=", (Object)curPeriodId), new QFilter("endperiod", ">", (Object)curPeriodId)};
        DynamicObject[] finCards = FaBillDaoFactory.getInstance("fa_card_fin").query(FaDaoOrmImpl.comma("id", "realcard", FaDaoOrmImpl.dot("realcard", "usestatus", "isdepre"), "originalval", "accumdepre", "assetcat", "decval", "netamount", "preresidualval", FaDaoOrmImpl.dot("assetbook", "basecurrency"), FaDaoOrmImpl.dot("assetbook", "curperiod", "id"), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre"), filters);
        Set finRealCards = Arrays.stream(finCards).map(v -> v.get("realcard")).collect(Collectors.toSet());
        if (masterIds.size() != finRealCards.size()) {
            Map<Object, String> masterAndNumber = realCards.stream().collect(Collectors.toMap(v -> v.get("masterid"), v -> v.getString("number")));
            HashSet<String> lessNumber = new HashSet<String>(masterIds.size() - finRealCards.size());
            for (Map.Entry<Object, String> entry : masterAndNumber.entrySet()) {
                if (!finRealCards.add(entry.getKey())) continue;
                lessNumber.add(entry.getValue());
            }
            String cardNumber = String.join((CharSequence)"\u3001", lessNumber);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%s\u5bf9\u5e94\u7684\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u665a\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"AbstractBill2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber));
        }
        return finCards;
    }
}

