/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear.convertor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.fi.fa.business.clear.convertor.AbstractBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillDetailData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class MergeBill2ClearBillConvertor
extends AbstractBill2ClearBillConvertor
implements IClearBillConvertor {
    @Override
    protected void setHeadData(DynamicObject bill, ClearBillData data) {
        data.setSrcEntityName("fa_mergebill");
        ClearBillHeadData headData = new ClearBillHeadData();
        Date mergeDate = bill.getDate("mergedate");
        String mergeDateStr = DateUtil.getShortDate().format(mergeDate);
        headData.setReason(String.format(ResManager.loadKDString((String)"%s\u8d44\u4ea7\u5408\u5e76\u3002", (String)"MergeBill2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]), mergeDateStr));
        headData.setOrgID(this.pk(bill.getDynamicObject("org")));
        headData.setChangeModeID(21);
        headData.setSourceBillID(bill.getPkValue());
        headData.setBillStatus(BillStatus.A);
        headData.setClearSource(FaClearSourceEnum.MERGE);
        headData.setClearDate(mergeDate);
        headData.setClearPeriod(bill.getLong(Fa.id((String)"mergeperiod")));
        headData.setCreatorId(ContextUtil.getUserId());
        headData.setCreateTime(Calendar.getInstance().getTime());
        data.setHeadData(headData);
    }

    @Override
    protected void setDetailData(DynamicObject bill, ClearBillData data) {
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(8);
        DynamicObjectCollection inEntryEntity = bill.getDynamicObjectCollection("inentryentity");
        DynamicObject inEntry = (DynamicObject)inEntryEntity.get(0);
        DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
        Set<Object> realCardIds = outEntryEntity.stream().map(v -> v.get("OUTREALCARDMASTERID")).collect(Collectors.toSet());
        DynamicObject[] finCards = this.queryFinCards(realCardIds);
        if (finCards.length == 0) {
            data.setDetailDataMap(detailDataMap);
            return;
        }
        Map<Object, List<DynamicObject>> group = Stream.of(finCards).collect(Collectors.groupingBy(v -> v.getDynamicObject("assetbook").getPkValue()));
        Set<Map.Entry<Object, List<DynamicObject>>> entrySet = group.entrySet();
        for (Map.Entry<Object, List<DynamicObject>> entry : entrySet) {
            detailDataMap.putAll(this.setDetailDataByBook(entry.getKey(), entry.getValue(), bill));
        }
        data.setDetailDataMap(detailDataMap);
    }

    private Map<Object, List<ClearBillDetailData>> setDetailDataByBook(Object bookId, List<DynamicObject> finCards, DynamicObject bill) {
        Date mergeDate = bill.getDate("mergedate");
        DynamicObjectCollection inEntryEntity = bill.getDynamicObjectCollection("inentryentity");
        DynamicObject entry = (DynamicObject)inEntryEntity.get(0);
        for (DynamicObject inEntry : inEntryEntity) {
            long inAssetBookId = inEntry.getDynamicObject("infincard").getLong(Fa.id((String)"assetbook"));
            if (Long.parseLong(bookId.toString()) != inAssetBookId) continue;
            entry = inEntry;
            break;
        }
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(8);
        DynamicObjectCollection outEntryEntity = entry.getDynamicObjectCollection("outentryentity");
        Map<Long, DynamicObject> finCardId2OutEntry = outEntryEntity.stream().collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"outfincard")), v -> v));
        for (DynamicObject finCard : finCards) {
            Long finCardId = finCard.getLong("id");
            DynamicObject outEntry = finCardId2OutEntry.get(finCardId);
            if (outEntry == null) continue;
            ClearBillDetailData detailData = new ClearBillDetailData();
            DynamicObject realCard = outEntry.getDynamicObject("outrealcard");
            detailData.setRealCardID(realCard.getPkValue());
            detailData.setFinCardID(finCard.getPkValue());
            detailData.setDepreuseID(this.pk(finCard.getDynamicObject("depreuse")));
            detailData.setClearQty(realCard.getBigDecimal("assetamount"));
            detailData.setMeasureunit(realCard.getDynamicObject("unit"));
            detailData.setClearIncome(BigDecimal.ZERO);
            detailData.setClearFare(BigDecimal.ZERO);
            detailData.setOriginalVal(finCard.getBigDecimal("originalval"));
            detailData.setAddupDepre(finCard.getBigDecimal("accumdepre"));
            detailData.setDecVal(finCard.getBigDecimal("decval"));
            detailData.setNetAmount(finCard.getBigDecimal("netamount"));
            detailData.setPreresidualval(finCard.getBigDecimal("preresidualval"));
            detailData.setBaseCurrencyID(this.pk(finCard.getDynamicObject(FaDaoOrmImpl.dot("assetbook", "basecurrency"))));
            detailData.setBizDate(mergeDate);
            if (detailDataMap.containsKey(bookId)) {
                ((List)detailDataMap.get(bookId)).add(detailData);
                continue;
            }
            ArrayList<ClearBillDetailData> detailDetailList = new ArrayList<ClearBillDetailData>(8);
            detailDetailList.add(detailData);
            detailDataMap.put(bookId, detailDetailList);
        }
        return detailDataMap;
    }
}

