/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.coderule;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.fa.business.coderule.CodeRuleService;

public class FaRealCardCodeRuleServiceImpl {
    private static final String s_true = "1";
    private static final String s_false = "0";
    private CodeRuleService service = null;
    private DynamicObject dymObj = null;
    private String orgID = null;

    FaRealCardCodeRuleServiceImpl(DynamicObject dymObj, String orgID) {
        this.dymObj = dymObj;
        this.orgID = orgID;
    }

    public static FaRealCardCodeRuleServiceImpl getInstance(DynamicObject dymObj, String orgID) {
        return new FaRealCardCodeRuleServiceImpl(dymObj, orgID);
    }

    private static DynamicObject dealRuleState(DynamicObject dataEntity, String billnoValue, String numberValue, String barCodeValue) {
        dataEntity.set("billnocoderule", (Object)billnoValue);
        dataEntity.set("numberrule", (Object)numberValue);
        dataEntity.set("barcoderule", (Object)barCodeValue);
        return dataEntity;
    }

    private String genNumber(DynamicObject dataEntity, String prop, boolean isThrow) {
        String orgNum;
        this.service = CodeRuleService.getInstance(dataEntity, this.orgID);
        if (this.service.isExistRule()) {
            String number = StringUtils.getEmpty();
            int retriesNum = 50;
            for (int i = 0; i < retriesNum && this.existNumber(dataEntity, prop, number = this.service.readNumber()); ++i) {
            }
            return number;
        }
        if (isThrow) {
            String propName = dataEntity.getDynamicObjectType().getProperty(prop).getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u542f\u7528%s\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"FaRealCardCodeRuleServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), propName));
        }
        try {
            orgNum = dataEntity.getDynamicObject("org").getString("number");
        }
        catch (Exception ex) {
            orgNum = "";
        }
        return this.getDefalutNo(orgNum);
    }

    private boolean existNumber(DynamicObject realCard, String prop, String number) {
        DynamicObject assetUnit = realCard.getDynamicObject("assetunit");
        QFilter assetUnitFilter = null;
        if ("billno".equals(prop) && assetUnit != null) {
            assetUnitFilter = new QFilter("assetunit", "=", assetUnit.getPkValue());
        }
        QFilter numberFilter = new QFilter(prop, "=", (Object)number);
        return QueryServiceHelper.exists((String)"fa_card_real", (QFilter[])new QFilter[]{numberFilter, assetUnitFilter});
    }

    public String getBillNo() {
        return this.genNumber(FaRealCardCodeRuleServiceImpl.dealRuleState(this.dymObj, s_true, s_false, s_false), "billno", false);
    }

    public String getNumber() {
        return this.genNumber(FaRealCardCodeRuleServiceImpl.dealRuleState(this.dymObj, s_false, s_true, s_false), "number", false);
    }

    public String getBarCode() {
        return this.genNumber(FaRealCardCodeRuleServiceImpl.dealRuleState(this.dymObj, s_false, s_false, s_true), "barcode", false);
    }

    private String getDefalutNo(String orgNum) {
        String timeStr;
        String result = "";
        Date nowDate = TimeServiceHelper.GetSystemDateTime();
        SimpleDateFormat longDate = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        result = timeStr = longDate.format(nowDate);
        return result;
    }
}

