/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.constants.PCSubStatusEnum;
import kd.fi.fa.business.dao.IFaAssetBookDao;
import kd.fi.fa.business.dao.factory.AssetPolicyDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.FaBaseDaoOrmImpl;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;

public class FaAssetBookDaoOrmImpl
extends FaBaseDaoOrmImpl
implements IFaAssetBookDao {
    private static final String TAB_ENABLE = "1";
    private static final String ALGO = "kd.fi.fa.business.dao.impl.FaAssetBookDaoOrmImpl";
    private Map<Object, DynamicObjectCollection> depresystemCache = new HashMap<Object, DynamicObjectCollection>();
    private Map<Object, Object> bookIdAndassetPolicyId = new HashMap<Object, Object>();

    public FaAssetBookDaoOrmImpl() {
        super("fa_assetbook");
    }

    @Override
    public boolean isExistDepredMainBook(Object orgPK) {
        DynamicObject mainBook = this.queryMainBookByOrg(orgPK);
        DynamicObject currentPeriod = this.queryCurrentPeriodByBook(mainBook.getPkValue());
        boolean hasDepreVouchered = FaDepreUtil.hasVoucher(mainBook.getLong(Fa.id((String)"org")), mainBook.getLong(Fa.id((String)"depreuse")), (Long)currentPeriod.getPkValue(), Boolean.TRUE);
        return hasDepreVouchered;
    }

    private boolean hasDepreVouchered(DynamicObject[] depreObjs) {
        return false;
    }

    @Override
    public DynamicObject queryMainBookByOrg(Object orgid) {
        DynamicObject[] dobjs = this.dao.query(this.getMainBookFilter(orgid));
        if (dobjs != null && dobjs.length > 0) {
            return dobjs[0];
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e3b\u8d26\u7c3f", (String)"FaAssetBookDaoOrmImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    @Override
    public DynamicObject[] queryAllBookByOrg(Object orgid) {
        DynamicObject[] dobjs = this.dao.query(this.getAllBookFilter(orgid));
        if (dobjs != null) {
            return dobjs;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e3b\u8d26\u7c3f", (String)"FaAssetBookDaoOrmImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    @Override
    public DynamicObject queryMainBookByRealCard(Object realCardPK) {
        DynamicObject realCard = FaRealCardDaoFactory.getInstance().queryOne(realCardPK);
        return this.queryMainBookByOrg(realCard.get(FaAssetBookDaoOrmImpl.id("org")));
    }

    @Override
    public DynamicObject queryCurrentPeriodByBook(Object pk) {
        return this.queryOne(pk).getDynamicObject("curperiod");
    }

    @Override
    public DynamicObject queryCurrencyByBook(Object pk) {
        return this.queryOne(pk).getDynamicObject("basecurrency");
    }

    @Override
    public Long getOrgFromBook(Object bookPk) {
        DynamicObject book = this.queryOne(bookPk);
        DynamicObject org = book.getDynamicObject("org");
        return (Long)org.getPkValue();
    }

    @Override
    public Long getPeriodFromBook(Object bookPk) {
        DynamicObject book = this.queryOne(bookPk);
        DynamicObject curPeriod = book.getDynamicObject("curperiod");
        return (Long)curPeriod.getPkValue();
    }

    @Override
    public DynamicObjectCollection queryAssetPolicyEntriesByBook(Object pk) {
        Object assetPolicyId = null;
        if (this.bookIdAndassetPolicyId.get(pk) != null) {
            assetPolicyId = this.bookIdAndassetPolicyId.get(pk);
        } else {
            assetPolicyId = this.getAssetPolicyId(pk);
            this.bookIdAndassetPolicyId.put(pk, assetPolicyId);
        }
        if (this.depresystemCache.get(assetPolicyId) != null) {
            return this.depresystemCache.get(assetPolicyId);
        }
        DynamicObjectCollection assetPolicEntry = AssetPolicyDaoFactory.getInstance().queryOne(assetPolicyId).getDynamicObjectCollection("assetpolicy_entry");
        this.depresystemCache.put(assetPolicyId, assetPolicEntry);
        return assetPolicEntry;
    }

    @Override
    public BigDecimal queryNetResidualValRateByBookAndCat(Object pk, Object catPK) {
        Object assetPolicyId = this.getAssetPolicyId(pk);
        return AssetPolicyDaoFactory.getInstance().queryNetResidualValRateByBookAndCat(assetPolicyId, catPK);
    }

    private Object getAssetPolicyId(Object assetBookPk) {
        DynamicObject book = this.dao.queryOne(assetBookPk);
        return book.get("depresystem.id");
    }

    @Override
    public boolean updatePCSubStatus(Object pk, PCSubStatusEnum subStatus) {
        DynamicObject dbobj = this.dao.generateDynamicObject(pk, FaAssetBookDaoOrmImpl.comma("id", "pcStatus", "pcSubStatus"));
        dbobj.set("id", pk);
        dbobj.set("pcStatus", (Object)subStatus.getPcStatus().name());
        dbobj.set("pcSubStatus", (Object)subStatus.name());
        return this.dao.updateOne(dbobj);
    }

    private QFilter[] getMainBookFilter(Object orgPK) {
        return new QFilter[]{new QFilter(FaAssetBookDaoOrmImpl.id("org"), "=", orgPK), new QFilter("ismainbook", "=", (Object)TAB_ENABLE)};
    }

    @Override
    public void updateCurrentPeriod(Object pk, Object periodPk) {
        String sql = "UPDATE t_fa_assetBook SET fCurrentPeriodId = ? WHERE fid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{periodPk, pk});
    }

    private QFilter[] getAllBookFilter(Object orgPK) {
        return new QFilter[]{new QFilter(FaAssetBookDaoOrmImpl.id("org"), "=", orgPK)};
    }
}

