/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.IFaBillDao;
import kd.fi.fa.business.dao.IFaClearDao;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaBizDaoOrmImpl;

public class FaClearBillDaoOrmImpl
extends FaBizDaoOrmImpl
implements IFaClearDao {
    public FaClearBillDaoOrmImpl() {
        super("fa_clearbill");
    }

    @Override
    public DynamicObject queryEntryByPKAndRealCard(Object pk, Object realCardPK) {
        DynamicObject clearBill = this.queryOne(FaClearBillDaoOrmImpl.comma("id", "detail_entry"), pk);
        DynamicObjectCollection entryCol = clearBill.getDynamicObjectCollection("detail_entry");
        for (DynamicObject entry : entryCol) {
            if (!realCardPK.equals(entry.getDynamicObject("realcard").getPkValue())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public DynamicObject queryOneByClearApply(Object clearApplyPK) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", clearApplyPK), new QFilter("clearsource", "=", (Object)FaClearSourceEnum.APPLY)};
        return this.queryOne(filters);
    }

    @Override
    public DynamicObject queryOneByDispatch(Object dispatchPK) {
        QFilter[] filters = new QFilter[]{new QFilter("srcbill", "=", dispatchPK), new QFilter("clearsource", "=", (Object)FaClearSourceEnum.DISPATCH.toString())};
        return this.queryOne(filters);
    }

    @Override
    public DynamicObject queryOneBySplit(Object splitPK) {
        return null;
    }

    @Override
    public DynamicObject queryOneByCombin(Object combinPK) {
        return null;
    }

    @Override
    public boolean deleteOne(Object pk) {
        this.deleteClearEntry(pk);
        return super.deleteOne(pk);
    }

    private void deleteClearEntry(Object pk) {
        DynamicObject[] entrys;
        IFaBillDao dao = FaBillDaoFactory.getInstance("fa_clearentry_entity");
        for (DynamicObject entry : entrys = dao.query(new QFilter[]{new QFilter("fid", "=", pk)})) {
            dao.deleteOne(entry.getPkValue());
        }
    }
}

