/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FaOrm {
    private String entityName;

    public FaOrm(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return this.generateEmptyDynamicObject(this.getEntityName());
    }

    public DynamicObject generateEmptyDynamicObject(String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return (DynamicObject)type.createInstance();
    }

    public DynamicObject generateDynamicObject(Object pk, String selectProperties) {
        return this.generateDynamicObjectsWithRef(new Object[]{pk}, selectProperties)[0];
    }

    public DynamicObject[] generateDynamicObjectsWithRef(Object[] pks, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), pks, selectProperties);
    }

    private DynamicObject[] generateDynamicObject(String entityName, Object[] pk, String selectProperties) {
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter("id", "in", (Object)pk).toArray());
    }

    public DynamicObject[] generateDynamicObjects(Object[] pks) {
        return BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityName()));
    }

    public DynamicObject[] generateDynamicObjects(Object[] pks, String selectProperties) {
        DynamicObjectType type = FaOrm.getSubEntityType(this.getEntityName(), selectProperties);
        return BusinessDataReader.load((Object[])pks, (DynamicObjectType)type, (Boolean)true);
    }

    public DynamicObject generateDynamicObject(DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObjects(new DynamicObject[]{dobj}, selectProperties)[0];
    }

    public DynamicObject[] generateDynamicObjects(DynamicObject[] dobj, String selectProperties) {
        Object[] pks = new Object[dobj.length];
        for (int i = 0; i < dobj.length; ++i) {
            pks[i] = dobj[i].getPkValue();
        }
        return this.generateDynamicObjects(pks, selectProperties);
    }

    @Deprecated
    public DynamicObject generateDynamicObject(String entityName, DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(entityName, dobj.getPkValue(), selectProperties);
    }

    private DynamicObject generateDynamicObject(String entityName, Object pk, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName, (String)selectProperties);
    }

    public boolean updateOne(DynamicObject dobj) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return true;
    }

    public boolean update(DynamicObject[] dobjs) {
        SaveServiceHelper.save((DynamicObject[])dobjs);
        return true;
    }

    public boolean update(Object[] pks, String prop, Object value) {
        DynamicObject[] dbobjs = this.generateDynamicObjects(pks, prop);
        Stream.of(dbobjs).forEach(v -> v.set(prop, value));
        return this.update(dbobjs);
    }

    public boolean update(QFilter[] filters, String prop, Object value) {
        DynamicObject[] objs = this.query("id", filters);
        Object[] pks = Stream.of(objs).map(DataEntityBase::getPkValue).toArray();
        return this.update(pks, prop, value);
    }

    public DynamicObject queryOne(Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityName());
    }

    public DynamicObject queryOne(QFilter[] filters) {
        DynamicObject[] dobjs = this.load(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject[] query(QFilter[] filters) {
        return this.load(this.getEntityName(), filters);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
    }

    public DynamicObject[] query(QFilter[] filters, String orderBys, int top) {
        return this.load(this.getEntityName(), filters, orderBys, top);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderBys, int top) {
        return this.load(this.getEntityName(), selectProperties, filters, orderBys, top);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters, String orderBys, int top) {
        return ORM.create().queryDataSet(algoKey, this.getEntityName(), selectFields, filters, orderBys, top);
    }

    public boolean deleteOne(Object pk) {
        this.delete(new Object[]{pk});
        return true;
    }

    public int delete(Object[] pks) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])pks);
        return pks.length;
    }

    public int deleteByFilter(QFilter[] filters) {
        DynamicObject[] dobjs = this.query("id", filters);
        if (dobjs == null || dobjs.length == 0) {
            return 0;
        }
        ArrayList<Object> pkList = new ArrayList<Object>(dobjs.length);
        for (DynamicObject dobj : dobjs) {
            pkList.add(dobj.getPkValue());
        }
        this.delete(pkList.toArray());
        return pkList.size();
    }

    public Object saveOne(DynamicObject dobj) {
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return pks[0];
    }

    public Object[] save(DynamicObject[] dobjs) {
        return SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    private DynamicObject[] load(String entityName, QFilter[] filters) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList listIds = new ArrayList();
        DynamicObjectCollection dync = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filters);
        dync.forEach(row -> listIds.add(row.get(0)));
        return BusinessDataReader.load((Object[])listIds.toArray(new Object[0]), (DynamicObjectType)type, (Boolean)true);
    }

    private DynamicObject[] load(String entityName, QFilter[] filters, String orderBys, int top) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList listIds = new ArrayList();
        DynamicObjectCollection dync = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filters, (String)orderBys, (int)top);
        dync.forEach(row -> listIds.add(row.get(0)));
        return BusinessDataReader.load((Object[])listIds.toArray(new Object[0]), (DynamicObjectType)type, (Boolean)true);
    }

    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBys, int top) {
        DynamicObjectType type = FaOrm.getSubEntityType(entityName, selectProperties);
        ArrayList listIds = new ArrayList();
        DynamicObjectCollection dync = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filters, (String)orderBys, (int)top);
        dync.forEach(row -> listIds.add(row.get(0)));
        return BusinessDataReader.load((Object[])listIds.toArray(new Object[0]), (DynamicObjectType)type, (Boolean)true);
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet select = new HashSet(properties.length);
        Collections.addAll(select, properties);
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    public boolean exist(QFilter[] qFilters) {
        return QueryServiceHelper.exists((String)this.entityName, (QFilter[])qFilters);
    }

    public boolean exist(Object pkId) {
        return QueryServiceHelper.exists((String)this.entityName, (Object)pkId);
    }
}

