/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.business.depreciation.FaBizStrategy;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class ChangeBillStrategy
extends FaBizStrategy {
    private static final Set<String> DEPRE_FIELD_SET = new HashSet<String>();
    private static final Set<String> DEPRE_REAL_FIELD_SET;

    public static Set<String> getDepreFieldSet() {
        return DEPRE_FIELD_SET;
    }

    public static Set<String> getDepreRealFieldSet() {
        return DEPRE_REAL_FIELD_SET;
    }

    @Override
    protected String getSelectFields() {
        String selectFields = "changeDate, auditdate, billno,fieldentry.realcardmasterid realcard,fieldentry.field field,fieldentry.beforevalue beforeValue,fieldentry.aftervalue afterValue,fieldentry.isadjustdepre1 dynamic,fieldentry.bizdate1 bizDate";
        return selectFields;
    }

    @Override
    protected QFilter getFilter(DepreBook book) {
        if (book.getBook().getBoolean("ismainbook")) {
            return super.getFilter(book).and(new QFilter("fieldentry.field", "in", DEPRE_FIELD_SET));
        }
        QFilter filter1 = super.getFilter(book).and(new QFilter("fieldentry.field", "in", DEPRE_FIELD_SET));
        DynamicObject org = book.getOrg();
        QFilter filter2 = new QFilter("org", "=", org.getPkValue()).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("fieldentry.field", "in", DEPRE_REAL_FIELD_SET));
        return filter1.or(filter2);
    }

    @Override
    protected String getBizDateFieldName() {
        return "fieldentry.bizdate1";
    }

    @Override
    protected String getDepreUseFieldName() {
        return "fieldentry.depreuse1";
    }

    @Override
    protected String getRealCardMasterIdFieldName() {
        return Fa.dot((String[])new String[]{"fieldentry", "realcardmasterid"});
    }

    @Override
    public List<FaBizInfo> build(FaBizInfoPool pool, DataSet bizBillDataSet, Set<Object> realcardMasterIdSet) {
        ArrayList<FaBizInfo> lst = new ArrayList<FaBizInfo>(1600);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        MainEntityType realType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        MainEntityType finType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        String typeName = type.getDisplayName().getLocaleValue();
        for (Row row : bizBillDataSet) {
            Long realCardMasterId = row.getLong("realcard");
            if (realcardMasterIdSet != null && !realcardMasterIdSet.contains(realCardMasterId)) continue;
            String bizName = String.format("%s(%s)", typeName, row.getString("billno"));
            Date changeDate = row.getDate("changeDate");
            Date auditDate = row.getDate("auditdate");
            Date bizDate = row.getDate("bizDate");
            boolean dynamic = row.getBoolean("dynamic");
            int bizType = dynamic ? 1 : 2;
            FaBizInfo bizInfo = new FaBizInfo(bizName, realCardMasterId, changeDate, auditDate, bizDate, bizType);
            String[] split = row.getString("field").split("\\.");
            boolean realCardField = split[0].equals("fa_card_real");
            bizInfo.setRealCardField(realCardField);
            bizInfo.setField(split[1]);
            MainEntityType cardType = realCardField ? realType : finType;
            bizInfo.setNewValue(this.parseValue(row.getString("afterValue"), cardType, bizInfo));
            bizInfo.setOldValue(this.parseValue(row.getString("beforeValue"), cardType, bizInfo));
            lst.add(bizInfo);
        }
        return lst;
    }

    private Object parseValue(String rawValue, MainEntityType cardType, FaBizInfo biz) {
        Object value;
        String field = biz.getField();
        DynamicProperty prop = cardType.getProperty(field);
        if (prop instanceof BasedataProp) {
            biz.setField(field + "_id");
            value = Long.valueOf(rawValue);
        } else if (prop instanceof AmountProp) {
            value = new BigDecimal(rawValue);
        } else if (prop instanceof DateProp) {
            try {
                value = Fa.getDF().parse(rawValue);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            value = rawValue;
        }
        return value;
    }

    @Override
    public String getEntityName() {
        return "fa_change_dept";
    }

    @Override
    public Tuple<Boolean, String> getBillDateTuple() {
        return new Tuple((Object)false, (Object)"changeDate");
    }

    static {
        DEPRE_FIELD_SET.add("fa_card_real.usestatus");
        DEPRE_FIELD_SET.add("fa_card_real.realaccountdate");
        DEPRE_FIELD_SET.add("fa_card_fin.originalval");
        DEPRE_FIELD_SET.add("fa_card_fin.preresidualval");
        DEPRE_FIELD_SET.add("fa_card_fin.preusingamount");
        DEPRE_FIELD_SET.add("fa_card_fin.depremethod");
        DEPRE_REAL_FIELD_SET = new HashSet<String>();
        DEPRE_REAL_FIELD_SET.add("fa_card_real.usestatus");
        DEPRE_REAL_FIELD_SET.add("fa_card_real.realaccountdate");
    }
}

