/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.business.depreciation.FaBizStrategy;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class ClearBillStrategy
extends FaBizStrategy {
    @Override
    protected String getSelectFields() {
        String selectFields = "clearDate, auditdate, billno,detail_entry.realcardmasterid realcard,detail_entry.assetvalue assetvalue,detail_entry.addupdepre addupdepre,detail_entry.decval decval,detail_entry.preresidualval preresidualval,detail_entry.bizDate bizDate,detail_entry.isClearAll isClearAll";
        return selectFields;
    }

    @Override
    protected String getBizDateFieldName() {
        return "detail_entry.bizdate";
    }

    @Override
    protected String getDepreUseFieldName() {
        return "detail_entry.depreuse";
    }

    @Override
    protected String getRealCardMasterIdFieldName() {
        return Fa.dot((String[])new String[]{"detail_entry", "realcardmasterid"});
    }

    @Override
    public String getEntityName() {
        return "fa_clearbill";
    }

    @Override
    public List<FaBizInfo> build(FaBizInfoPool pool, DataSet bizBillDataSet, Set<Object> realcardMasterIdSet) {
        ArrayList<FaBizInfo> lst = new ArrayList<FaBizInfo>(1600);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        String typeName = type.getDisplayName().getLocaleValue();
        for (Row row : bizBillDataSet) {
            Long realCardMasterId = row.getLong("realcard");
            if (realcardMasterIdSet != null && !realcardMasterIdSet.contains(realCardMasterId)) continue;
            String bizName = String.format("%s(%s)", typeName, row.getString("billno"));
            Date clearDate = row.getDate("clearDate");
            Date auditDate = row.getDate("auditdate");
            Date bizDate = row.getDate("bizDate");
            FaBizInfo bizInfo = new FaBizInfo(bizName, realCardMasterId, clearDate, auditDate, bizDate, 3);
            String clearFlag = row.getString("isClearAll");
            if ("1".equals(clearFlag)) {
                bizInfo.setAllClear(true);
            } else {
                BigDecimal partClearOriginalVal = row.getBigDecimal("assetvalue");
                BigDecimal partClearAccumDepre = row.getBigDecimal("addupdepre");
                BigDecimal partClearDecVal = row.getBigDecimal("decval");
                BigDecimal partClearResidualVal = row.getBigDecimal("preresidualval");
                bizInfo.setPartClear(partClearOriginalVal, partClearAccumDepre, partClearDecVal, partClearResidualVal);
            }
            lst.add(bizInfo);
        }
        return lst;
    }

    @Override
    public Tuple<Boolean, String> getBillDateTuple() {
        return new Tuple((Object)false, (Object)"clearDate");
    }
}

