/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreDaySegment;
import kd.fi.fa.business.depreciation.DepreSegment;

public abstract class DepreMethod {
    protected final DepreBook book;
    private String type;
    private DepreDaySegment depreDaySegment;
    public static final String AVE_USING_AGE = "7";
    public static final String DOUBLE_SUBTRACT = "4";
    public static final String TOTAL_YEAR = "6";
    public static final String WORKLOAD = "5";
    public static final String TABLE = "1";
    public static final String FORMULA = "2";
    public static final String SUBTRACT = "3";
    public static final String DAYDEPRE = "51";

    public abstract BigDecimal compute(DepreAlgoInter var1, DepreSegment var2);

    public boolean getDepretimeEffective() {
        return !WORKLOAD.equals(this.type) && !TABLE.equals(this.type);
    }

    public String getDepreMethodType() {
        return this.type;
    }

    public DepreMethod(DepreBook book) {
        this.book = book;
    }

    public DepreMethod(DepreBook book, String type) {
        this.book = book;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DepreDaySegment getDepreDaySegment() {
        return this.depreDaySegment;
    }

    public void setDepreDaySegment(DepreDaySegment depreDaySegment) {
        this.depreDaySegment = depreDaySegment;
    }
}

