/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depreciation.ChangeBillStrategy;
import kd.fi.fa.business.depreciation.ClearBillStrategy;
import kd.fi.fa.business.depreciation.DecValStrategy;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizStrategy;
import kd.fi.fa.business.depreciation.MergeBillStrategy;
import kd.fi.fa.business.depreciation.SplitBillStrategy;

public class FaBizInfoPool {
    private static List<FaBizStrategy> strategies = new ArrayList<FaBizStrategy>();
    private DepreBook book;
    private Map<Object, List<FaBizInfo>> bizInfoCache = new HashMap<Object, List<FaBizInfo>>();

    public FaBizInfoPool(DepreBook book) {
        this.book = book;
    }

    public Map<Object, List<FaBizInfo>> getBizData(Set<Object> realcardMasterISet) {
        Date minAdjustDate = this.getMinAdjustDate(realcardMasterISet);
        if (minAdjustDate == null) {
            return null;
        }
        DynamicObject adjustPeriod = this.book.getPeriodGroup().getPeriod(minAdjustDate, null);
        ArrayList bizInfoLst = new ArrayList();
        strategies.forEach(stat -> {
            DataSet bizBillDataSet = stat.queryBizBill(this, adjustPeriod, realcardMasterISet);
            if (bizBillDataSet != null && bizBillDataSet.hasNext()) {
                bizInfoLst.addAll(stat.build(this, bizBillDataSet, realcardMasterISet));
            }
        });
        return bizInfoLst.stream().collect(Collectors.groupingBy(v -> v.realcardMasterId));
    }

    public Date getMinAdjustDate(Set<Object> realcardMasterISet) {
        Date date;
        ArrayList bizInfoLst = new ArrayList();
        strategies.forEach(stat -> {
            DataSet curPeriodBizBill = null;
            curPeriodBizBill = stat instanceof ChangeBillStrategy ? stat.queryCurPeriodBizBill(this, true) : stat.queryCurPeriodBizBill(this, false);
            if (curPeriodBizBill != null && !curPeriodBizBill.isEmpty()) {
                bizInfoLst.addAll(stat.build(this, curPeriodBizBill, realcardMasterISet));
            }
        });
        Map<Boolean, List<FaBizInfo>> parti = bizInfoLst.stream().collect(Collectors.partitioningBy(v -> v.type != 2));
        List<FaBizInfo> notTraceBizLst = parti.get(true);
        parti = parti.get(false).stream().collect(Collectors.partitioningBy(v -> v.isRealCardField() && v.getField().equalsIgnoreCase("realaccountdate")));
        List<FaBizInfo> realDateBizLst = parti.get(true);
        List<FaBizInfo> otherTraceBizLst = parti.get(false);
        Optional<Date> a = notTraceBizLst.stream().map(v -> v.bizDate).min(Date::compareTo);
        Optional<Date> b = realDateBizLst.stream().map(v -> (Date)v.getNewValue()).min(Date::compareTo);
        Set realIdSet = otherTraceBizLst.stream().map(v -> v.realcardMasterId).collect(Collectors.toSet());
        DynamicObjectCollection realDates = QueryServiceHelper.query((String)"fa_card_real", (String)"realaccountdate", (QFilter[])new QFilter("id", "in", realIdSet).toArray());
        Optional<Date> c = realDates.stream().map(v -> v.getDate("realaccountdate")).min(Date::compareTo);
        Date minAdjustDate = null;
        if (a.isPresent()) {
            minAdjustDate = a.get();
        }
        if (b.isPresent()) {
            date = b.get();
            if (minAdjustDate == null || date.compareTo(minAdjustDate) < 0) {
                minAdjustDate = date;
            }
        }
        if (c.isPresent()) {
            date = c.get();
            if (minAdjustDate == null || date.compareTo(minAdjustDate) < 0) {
                minAdjustDate = date;
            }
        }
        return minAdjustDate;
    }

    public List<FaBizInfo> getBizInfos(DynamicObject finCard) {
        return this.bizInfoCache.get(finCard.get("realcard.masterid"));
    }

    public DepreBook getBook() {
        return this.book;
    }

    static {
        strategies.add(new ChangeBillStrategy());
        strategies.add(new ClearBillStrategy());
        strategies.add(new DecValStrategy());
        strategies.add(new SplitBillStrategy());
        strategies.add(new MergeBillStrategy());
    }
}

