/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Fraction {
    public static final Fraction ONE = new Fraction(BigDecimal.ONE, BigDecimal.ONE);
    public final BigDecimal numerator;
    public final BigDecimal denominator;

    public Fraction(BigDecimal numerator, BigDecimal denominator) {
        if (denominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException("denominator cannot be ZERO");
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Fraction(BigDecimal numerator) {
        this(numerator, BigDecimal.ONE);
    }

    public Fraction(BigDecimal numerator, Fraction denominator) {
        this(numerator.multiply(denominator.denominator), denominator.numerator);
    }

    public Fraction(Fraction numerator, Fraction denominator) {
        this(numerator.numerator.multiply(denominator.denominator), numerator.denominator.multiply(denominator.numerator));
    }

    public Fraction add(Fraction other) {
        BigDecimal _denominator = this.denominator.multiply(other.denominator);
        BigDecimal _numerator = this.numerator.multiply(other.denominator).add(other.numerator.multiply(this.denominator));
        return new Fraction(_numerator, _denominator);
    }

    public Fraction subtract(Fraction other) {
        BigDecimal _denominator = this.denominator.multiply(other.denominator);
        BigDecimal _numerator = this.numerator.multiply(other.denominator).subtract(other.numerator.multiply(this.denominator));
        return new Fraction(_numerator, _denominator);
    }

    public Fraction subtract(BigDecimal other) {
        return this.subtract(new Fraction(other));
    }

    public Fraction multiply(Fraction other) {
        BigDecimal _denominator = this.denominator.multiply(other.denominator);
        BigDecimal _numerator = this.numerator.multiply(other.numerator);
        return new Fraction(_numerator, _denominator);
    }

    public Fraction multiply(BigDecimal number) {
        BigDecimal _numerator = this.numerator.multiply(number);
        return new Fraction(_numerator, this.denominator);
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    public Fraction divide(Fraction other) {
        return this.multiply(other.reciprocal());
    }

    public Fraction divide(BigDecimal number) {
        return new Fraction(this.numerator, this.denominator.multiply(number));
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode mode) {
        return this.numerator.divide(this.denominator, scale, mode);
    }

    public String toString() {
        if (this.denominator.compareTo(BigDecimal.ONE) == 0) {
            return this.numerator.toString();
        }
        return String.format("(%s/%s)", this.numerator, this.denominator);
    }
}

