/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;

public class PeriodYear {
    private final Date yearBeginDate;
    private final Date yearEndDate;
    private List<DynamicObject> periodLst = null;

    public String toString() {
        return String.format("PeriodYear[%s, %s]", this.yearBeginDate, this.yearEndDate);
    }

    public PeriodYear(Date yearBeginDate, Date yearEndDate, List<DynamicObject> periodLst) {
        this.yearBeginDate = yearBeginDate;
        this.yearEndDate = yearEndDate;
        this.periodLst = periodLst;
    }

    public BigDecimal getPeriodCount() {
        return new BigDecimal(this.periodLst.size());
    }

    @Deprecated
    public BigDecimal getPeriodCount(Date begindate, Date enddate) {
        int beginIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < this.periodLst.size(); ++i) {
            DynamicObject period = this.periodLst.get(i);
            if (begindate.compareTo(period.getDate("begindate")) >= 0 && begindate.compareTo(period.getDate("enddate")) <= 0) {
                beginIndex = i;
            }
            if (enddate.compareTo(period.getDate("begindate")) < 0 || enddate.compareTo(period.getDate("enddate")) > 0) continue;
            endIndex = i;
        }
        return new BigDecimal(endIndex - beginIndex + 1);
    }

    public int compareToDate(Date date) {
        Date beginDate = this.yearBeginDate;
        Date endDate = this.yearEndDate;
        if (endDate.before(date)) {
            return -1;
        }
        if (beginDate.after(date)) {
            return 1;
        }
        return 0;
    }

    public Date getYearBeginDate() {
        return this.yearBeginDate;
    }

    public Date getYearEndDate() {
        return this.yearEndDate;
    }

    public List<DynamicObject> getPeriodLst() {
        return this.periodLst;
    }
}

