/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreMethod;
import kd.fi.fa.business.depreciation.DepreSegment;

public class RateDepreMethod
extends DepreMethod {
    private List<BigDecimal> depreRateData;
    private boolean deductresidualval;

    public RateDepreMethod(List<BigDecimal> depreRateData, boolean deductresidualval, DepreBook book) {
        super(book);
        this.depreRateData = depreRateData;
        this.deductresidualval = deductresidualval;
    }

    public RateDepreMethod(List<BigDecimal> depreRateData, boolean deductresidualval, String type, DepreBook book) {
        super(book, type);
        this.depreRateData = depreRateData;
        this.deductresidualval = deductresidualval;
    }

    @Override
    public BigDecimal compute(DepreAlgoInter depreCard, DepreSegment seg) {
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal originalVal = finCard.getBigDecimal("originalval");
        BigDecimal preResidualVal = finCard.getBigDecimal("preresidualval");
        Integer depredAmount = finCard.getBigDecimal("depredamount").intValue();
        if (depredAmount > this.depreRateData.size() - 1) {
            return BigDecimal.ZERO;
        }
        BigDecimal depreRate = this.depreRateData.get(depredAmount);
        if (this.deductresidualval) {
            originalVal = originalVal.subtract(preResidualVal);
        }
        BigDecimal monthDepre = originalVal.multiply(depreRate).setScale(this.book.precision, RoundingMode.HALF_UP);
        depreCard.getLogger().log("rateDepreMethod", this.depreRateData, this.deductresidualval, depreCard, monthDepre);
        return monthDepre;
    }
}

