/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.business.depreciation.FaBizStrategy;
import kd.fi.fa.business.depreciation.Fraction;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class SplitBillStrategy
extends FaBizStrategy {
    @Override
    public String getEntityName() {
        return "fa_assetsplitbill";
    }

    @Override
    public List<FaBizInfo> build(FaBizInfoPool pool, DataSet bizBillDataSet, Set<Object> realcardMasterIdSet) {
        ArrayList<FaBizInfo> lst = new ArrayList<FaBizInfo>(16);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        String typeName = type.getDisplayName().getLocaleValue();
        for (Row row : bizBillDataSet) {
            Long realCardMasterId = row.getLong("realcard");
            if (realcardMasterIdSet != null && !realcardMasterIdSet.contains(realCardMasterId) || row.getLong("realcard").longValue() != row.getLong("aftrealcard").longValue()) continue;
            String bizName = String.format("%s(%s)", typeName, row.getString("billno"));
            Date splitDate = row.getDate("splitdate");
            Date auditDate = row.getDate("auditdate");
            Date bizDate = row.getDate("splitdate");
            FaBizInfo bizInfo = new FaBizInfo(bizName, realCardMasterId, splitDate, auditDate, bizDate, 4);
            BigDecimal bfrOriginalVal = row.getBigDecimal("bfrOriginalVal");
            BigDecimal aftOriginalVal = row.getBigDecimal("aftOriginalVal");
            if (bfrOriginalVal.compareTo(BigDecimal.ZERO) == 0) continue;
            bizInfo.setSplit(new Fraction(aftOriginalVal, bfrOriginalVal));
            lst.add(bizInfo);
        }
        return lst;
    }

    @Override
    protected String getSelectFields() {
        String selectFields = "splitdate, auditdate, billno,assetsplitentry.realcardmasterid realcard,assetsplitentry.subassetsplitentry.aft_realcard.masterid aftrealcard,assetsplitentry.bef_originalval bfrOriginalVal,assetsplitentry.subassetsplitentry.aft_originalval aftOriginalVal";
        return selectFields;
    }

    @Override
    protected String getBizDateFieldName() {
        return "splitDate";
    }

    @Override
    protected String getDepreUseFieldName() {
        return null;
    }

    @Override
    protected String getRealCardMasterIdFieldName() {
        return Fa.dot((String[])new String[]{"assetsplitentry", "realcardmasterid"});
    }

    @Override
    public Tuple<Boolean, String> getBillDateTuple() {
        return new Tuple((Object)false, (Object)"splitDate");
    }
}

