/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreMethod;
import kd.fi.fa.business.depreciation.DepreSegment;

public class SubtractDepreMethod
extends DepreMethod {
    private String base;
    private boolean deductresidualval;
    private BigDecimal times;

    public SubtractDepreMethod(String base, boolean deductresidualval, BigDecimal times, String type, DepreBook book) {
        super(book, type);
        this.base = base;
        this.deductresidualval = deductresidualval;
        this.times = times;
    }

    @Override
    public BigDecimal compute(DepreAlgoInter depreCard, DepreSegment seg) {
        String log_formula = "";
        String log_calculate = "";
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal originalVal = finCard.getBigDecimal("originalval");
        BigDecimal accumDepre = finCard.getBigDecimal("accumdepre");
        BigDecimal decVal = finCard.getBigDecimal("decval");
        BigDecimal preResidualVal = finCard.getBigDecimal("preresidualval");
        BigDecimal addupYearDepre = finCard.getBigDecimal("addupyeardepre");
        BigDecimal baseNumber = originalVal;
        if (this.base.equals("2")) {
            log_formula = "originalVal-(accumDepre-addupYearDepre)-decVal";
            log_calculate = String.format("%s-(%s-%s)-%s", baseNumber, accumDepre, addupYearDepre, decVal);
            baseNumber = baseNumber.subtract(accumDepre.subtract(addupYearDepre)).subtract(decVal);
        }
        if (this.deductresidualval) {
            log_formula = log_formula + "-preResidualVal";
            log_calculate = log_calculate + "-" + preResidualVal;
            baseNumber = baseNumber.subtract(preResidualVal);
        }
        BigDecimal yearDepre = baseNumber.multiply(this.times);
        BigDecimal monthDepre = yearDepre.divide(this.book.getYearPeriodCount(), this.book.calcPrecision, RoundingMode.HALF_UP);
        log_formula = String.format("(%s) * %s / %s", log_formula, "times", "periodcount_year");
        log_calculate = String.format("(%s) * %s / %s", log_calculate, this.times, this.book.getYearPeriodCount());
        depreCard.getLogger().log("calcProcess", log_formula, log_calculate, monthDepre);
        return monthDepre;
    }
}

