/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreDaySegment;
import kd.fi.fa.business.depreciation.DepreMethod;
import kd.fi.fa.business.depreciation.DepreSegment;
import kd.fi.fa.business.depreciation.FinCardUtil;
import kd.fi.fa.business.depreciation.Fraction;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;

public class SystemDepreMethod
extends DepreMethod {
    private final String type;

    public SystemDepreMethod(String type, DepreBook book) {
        super(book, type);
        this.type = type;
    }

    @Override
    public BigDecimal compute(DepreAlgoInter depreCard, DepreSegment seg) {
        switch (this.type) {
            case "7": {
                return this.compute100(depreCard, seg);
            }
            case "4": {
                return this.compute200(depreCard, seg);
            }
            case "6": {
                return this.compute300(depreCard, seg);
            }
            case "5": {
                return this.compute400(depreCard, seg);
            }
            case "51": {
                return this.compute500(depreCard, seg, super.getDepreDaySegment());
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u7cfb\u7edf\u9884\u7f6e\u6298\u65e7\u65b9\u6cd5\u3002", (String)"SystemDepreMethod_0", (String)"fi-fa-business", (Object[])new Object[0]), this.type));
    }

    private BigDecimal compute400(DepreAlgoInter depreCard, DepreSegment seg) {
        BigDecimal result;
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal monthworkload = depreCard.getBook().getCardtoworkloadMap().get(FaDepreUtil.getFinCardWorkLoadKey(depreCard, seg));
        if (monthworkload == null) {
            monthworkload = BigDecimal.ZERO;
        }
        if (seg.isDynamic()) {
            BigDecimal remainderWorkLoad = finCard.getBigDecimal("preusingamount").subtract(finCard.getBigDecimal("depredamount"));
            if (remainderWorkLoad.compareTo(BigDecimal.ZERO) == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u603b\u5de5\u4f5c\u91cf\u51cf\u53bb\u7d2f\u8ba1\u5de5\u4f5c\u91cf\u4e3a0\uff0c\u52a8\u6001\u7b97\u6cd5\u9664\u6570\u4e0d\u80fd\u4e3a0\u3002", (String)"SystemDepreMethod_1", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            result = FinCardUtil.getLeftAmount(finCard).multiply(monthworkload).divide(remainderWorkLoad, this.book.calcPrecision, RoundingMode.HALF_UP);
        } else {
            result = FinCardUtil.getLeftAmount2(finCard).multiply(monthworkload).divide(finCard.getBigDecimal("preusingamount"), this.book.calcPrecision, RoundingMode.HALF_UP);
        }
        return result;
    }

    private BigDecimal compute300(DepreAlgoInter depreCard, DepreSegment seg) {
        BigDecimal monthDepre;
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal yearPeriodCount = this.book.getYearPeriodCount();
        BigDecimal preUseYear = depreCard.getPreUseYear();
        BigDecimal usedYear = depreCard.getUsedYear();
        if (seg.isDynamic()) {
            BigDecimal leftYear = preUseYear.subtract(usedYear);
            if (leftYear.compareTo(BigDecimal.ZERO) == 0) {
                leftYear = BigDecimal.ONE;
            }
            Fraction yearDepreRate = new Fraction(leftYear, new Fraction(leftYear.multiply(leftYear.add(BigDecimal.ONE)), Fa.TWO));
            BigDecimal leftAmount = FinCardUtil.getLeftAmount(finCard);
            Fraction yearDepre = yearDepreRate.multiply(leftAmount);
            monthDepre = yearDepre.divide(yearPeriodCount).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
        } else {
            BigDecimal leftAmount = FinCardUtil.getLeftAmount2(finCard);
            Fraction yearDepreRate = new Fraction(preUseYear.subtract(usedYear), new Fraction(preUseYear.multiply(preUseYear.add(BigDecimal.ONE)), new BigDecimal(2)));
            Fraction yearDepre = yearDepreRate.multiply(leftAmount);
            monthDepre = yearDepre.divide(yearPeriodCount).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
        }
        depreCard.getLogger().log("compute300", depreCard, seg);
        return monthDepre;
    }

    private BigDecimal compute200(DepreAlgoInter depreCard, DepreSegment seg) {
        BigDecimal monthDepre;
        boolean lastTwoYear;
        BigDecimal usedYear;
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal preUseYear = depreCard.getPreUseYear();
        BigDecimal leftYear = preUseYear.subtract(usedYear = depreCard.getUsedYear());
        boolean bl = lastTwoYear = leftYear.compareTo(Fa.TWO) < 0 || leftYear.compareTo(Fa.TWO) == 0 && FinCardUtil.getLeftPeriod(finCard).add(depreCard.getPeriodNumber().subtract(BigDecimal.ONE)).compareTo(this.book.getYearPeriodCount().multiply(Fa.TWO)) <= 0;
        if (seg.isDynamic()) {
            if (lastTwoYear) {
                BigDecimal leftAmount = FinCardUtil.getLeftAmount(finCard);
                monthDepre = leftAmount.divide(Fa.TWO.multiply(this.book.getYearPeriodCount()), this.book.calcPrecision, RoundingMode.HALF_UP);
            } else {
                Fraction yearDepreRate = new Fraction(Fa.TWO).divide(leftYear);
                BigDecimal leftAmount = FinCardUtil.getLeftAmount3(finCard);
                Fraction yearDepre = yearDepreRate.multiply(leftAmount);
                monthDepre = yearDepre.divide(this.book.getYearPeriodCount()).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
            }
        } else if (lastTwoYear) {
            BigDecimal leftPeriod = FinCardUtil.getLeftPeriod(finCard);
            monthDepre = finCard.getBigDecimal("originalval").subtract(finCard.getBigDecimal("accumdepre")).subtract(finCard.getBigDecimal("preresidualval")).divide(leftPeriod, this.book.calcPrecision, RoundingMode.HALF_UP);
        } else {
            Fraction yearDepreRate = new Fraction(Fa.TWO).divide(preUseYear);
            BigDecimal leftAmount = FinCardUtil.getLeftAmount4(finCard);
            Fraction yearDepre = new Fraction(leftAmount).multiply(yearDepreRate);
            monthDepre = yearDepre.divide(this.book.getYearPeriodCount()).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
        }
        depreCard.getLogger().log("compute200", depreCard, seg);
        return monthDepre;
    }

    private BigDecimal compute100(DepreAlgoInter depreCard, DepreSegment seg) {
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal result = seg.isDynamic() ? FinCardUtil.getLeftAmount(finCard).divide(FinCardUtil.getLeftPeriod(finCard), this.book.calcPrecision, RoundingMode.HALF_UP) : FinCardUtil.getLeftAmount2(finCard).divide(finCard.getBigDecimal("preusingamount"), this.book.calcPrecision, RoundingMode.HALF_UP);
        depreCard.getLogger().log("compute100", seg.isDynamic(), finCard, result);
        return result;
    }

    private BigDecimal compute500(DepreAlgoInter depreCard, DepreSegment seg, DepreDaySegment depreDaySegment) {
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal dayDepreAmt = seg.isDynamic() ? FinCardUtil.getLeftAmount(finCard).divide(FinCardUtil.getLeftPeriod(finCard), this.book.calcPrecision, RoundingMode.HALF_UP) : FinCardUtil.getLeftAmount2(finCard).divide(finCard.getBigDecimal("preusingamount"), this.book.calcPrecision, RoundingMode.HALF_UP);
        BigDecimal result = dayDepreAmt.multiply(depreDaySegment.getDayCount()).setScale(this.book.calcPrecision, RoundingMode.HALF_UP);
        depreCard.getLogger().log("compute500", seg.isDynamic(), finCard, dayDepreAmt, dayDepreAmt, depreDaySegment.getDayCount(), result);
        return result;
    }
}

