/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.fa.business.depreciation.ClearValue;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreForecast;
import kd.fi.fa.business.depreciation.FaDepreCheckUtils;
import kd.fi.fa.business.depretask.DepreSplitDetailUtils;
import kd.fi.fa.business.depretask.DepreSplitSumUtils;
import kd.fi.fa.business.depretask.DepreSplitTask;
import kd.fi.fa.business.depretask.DepreStatusEnum;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.depretask.DepreThreadResult;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.DisDepreMessage;
import kd.fi.fa.business.po.DisDepreMsgCache;
import kd.fi.fa.business.po.FaDisDepreLogEntryInsertPo;
import kd.fi.fa.business.po.FaDisDepreLogEntryUpdatePo;
import kd.fi.fa.business.po.FaDisDepreLogPo;
import kd.fi.fa.business.po.FaDisDepreLogPo4Repair;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.reposimpl.ObjectPool;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaDisDepreLogUtils;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class DailyDepreImpl {
    private static final String ALGO = "kd.fi.fa.business.depretask.DailyDepreImpl";
    public static final int THREAD_SIZE = Integer.parseInt(System.getProperty("prop.fi.fa.depre.threadcount", "3"));
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"kd.fi.fa.business.depretask.DailyDepreImpl", (int)THREAD_SIZE);
    private final Log logger = LogFactory.getLog((String)"kd.fi.fa.business.depretask.DailyDepreImpl");
    private AtomicInteger finishThreadCount = new AtomicInteger(0);
    public static final String CACHE_KEY = "DailyDepreImpl_cacheKey";
    private static final DBRoute faDBRoute = DBRoute.of((String)"fa");
    IAppCache cache = AppCache.get((String)"fa");
    private int depreFinCount = 0;
    private int oneThreadCardNum = 1999;
    private Boolean isManual = false;
    private String fromEntityName = " ";
    private Long disLogId = 0L;
    private boolean enabledisdepre = false;

    public DailyDepreImpl() {
    }

    public DailyDepreImpl(Boolean isManual, String fromEntityName) {
        if (isManual != null) {
            this.isManual = isManual;
        }
        if (fromEntityName != null) {
            this.fromEntityName = fromEntityName;
        }
    }

    public DailyDepreImpl(Boolean isManual, String fromEntityName, Long orgId) {
        if (orgId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"orgId\u4e0d\u80fd\u4e3a\u7a7a", (String)"DailyDepreImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        this.enabledisdepre = SystemParamHelper.getBooleanParam("enabledisdepre", orgId, false);
        if (isManual != null) {
            this.isManual = isManual;
        }
        if (fromEntityName != null) {
            this.fromEntityName = fromEntityName;
        }
    }

    public void dailyDepre(boolean needLock, Object assetBookId) {
        block24: {
            String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"DailyDepreImpl_1", (String)"fi-fa-business", (Object[])new Object[0]);
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingle((Object)assetBookId, (String)"fa_assetbook");
            Long orgId = bookObj.getLong("org_id");
            Long bookDepreusegId = bookObj.getLong("depreuse_id");
            Long bookCurperiodId = bookObj.getLong("curperiod_id");
            try {
                FaDisDepreLogPo logPo = new FaDisDepreLogPo(orgId, bookDepreusegId, bookCurperiodId, (Long)assetBookId, 0, this.isManual, ContextUtil.getUserId(), this.fromEntityName, true);
                this.disLogId = FaDisDepreLogUtils.insertDisDepreLog(logPo, true);
                this.checkUpgradeMasterId(orgId);
                if (assetBookId == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"DailyDepreImpl_2", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", assetBookId), new QFilter("status", "=", (Object)"C")};
                if (!QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])filters)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u672a\u542f\u7528\u3002", (String)"DailyDepreImpl_3", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                Map<String, Object[]> unFinishedCheckMap = this.checkUnFinishedBiz(bookObj);
                if (unFinishedCheckMap != null && !unFinishedCheckMap.isEmpty()) {
                    FaDisDepreLogUtils.updateDisDepreLog4BillHead(this.disLogId, DepreStatusEnum2.NEED_RE_DEPRE, JSONUtils.toString(unFinishedCheckMap), true, true);
                    return;
                }
                if (this.enabledisdepre) {
                    if (needLock) {
                        FunctionMutexHelper.lockWithBook("fa_new_depre", bookObj, false, () -> {
                            try (TXHandle tx = TX.requiresNew();){
                                try {
                                    this.disDepreNumForBatch(assetBookId, needLock, this.disLogId);
                                    tx.commit();
                                }
                                catch (Throwable e) {
                                    tx.markRollback();
                                    throw e;
                                }
                            }
                        });
                    } else {
                        this.disDepreNumForBatch(assetBookId, needLock, this.disLogId);
                    }
                    break block24;
                }
                if (needLock) {
                    FunctionMutexHelper.lockWithBook("fa_new_depre", bookObj, () -> {
                        try (TXHandle tx = TX.requiresNew();){
                            try {
                                this.depreNumForBatch(assetBookId, null, this.disLogId);
                                tx.commit();
                            }
                            catch (Throwable e) {
                                tx.markRollback();
                                throw e;
                            }
                        }
                    });
                    break block24;
                }
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        this.depreNumForBatch(assetBookId, null, this.disLogId);
                        tx.commit();
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            catch (Throwable e) {
                errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
                if (this.disLogId != 0L) {
                    FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
                }
                FaDisDepreLogPo4Repair logPoRepair = new FaDisDepreLogPo4Repair(orgId, bookDepreusegId, bookCurperiodId, (Long)assetBookId, ContextUtil.getUserId(), this.fromEntityName, DepreStatusEnum2.FAI);
                logPoRepair.setResult(errMsg);
                FaDisDepreLogUtils.insertDisDepreLog4Repair(logPoRepair);
            }
        }
    }

    private Map<String, Object[]> checkUnFinishedBiz(DynamicObject assetBookObj) throws IOException {
        HashMap<String, Object[]> checkResultMap = new HashMap<String, Object[]>(9);
        DynamicObject currentPeriod = assetBookObj.getDynamicObject("curperiod");
        if (currentPeriod == null) {
            return checkResultMap;
        }
        Long curPeriodId = assetBookObj.getLong(Fa.id((String)"curperiod"));
        Long orgId = assetBookObj.getLong(Fa.id((String)"org"));
        Long depreuseId = assetBookObj.getLong(Fa.id((String)"depreuse"));
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        List<Object> unAuditCards = FaDepreCheckUtils.needAddCheckFinCard(orgId, depreuseId, beginDate, endDate);
        List<Object> unAuditMergedCards = FaDepreCheckUtils.needAddMergedCard(orgId, depreuseId, beginDate, endDate);
        Object[] clearObjects = FaDepreCheckUtils.clearBillIds(orgId, beginDate, endDate, depreuseId);
        Object[] useDeptChangeObjects = FaDepreCheckUtils.changeBillIdCommRealCardMethod(orgId, beginDate, endDate, "fa_change_dept");
        Object[] devalsObjects = FaDepreCheckUtils.deavalBillIds(orgId, depreuseId, curPeriodId);
        Object[] splitObjects = FaDepreCheckUtils.splitBillIds(orgId, beginDate, endDate);
        Object[] workLoadObjects = FaDepreCheckUtils.workLoadBillIds(orgId, depreuseId, curPeriodId);
        Object[] mergeObjects = FaDepreCheckUtils.mergeBillIds(orgId, beginDate, endDate);
        Object[] unAuditRealCards = FaDepreCheckUtils.needAuditCard(orgId, curPeriodId);
        Object[] unAuditRestartBills = FaDepreCheckUtils.restartBills(orgId, depreuseId, curPeriodId);
        if (CollectionUtils.isEmpty(unAuditCards) && ArrayUtils.isEmpty((Object[])clearObjects) && ArrayUtils.isEmpty((Object[])useDeptChangeObjects) && ArrayUtils.isEmpty((Object[])splitObjects) && ArrayUtils.isEmpty((Object[])devalsObjects) && ArrayUtils.isEmpty((Object[])workLoadObjects) && CollectionUtils.isEmpty(unAuditMergedCards) && ArrayUtils.isEmpty((Object[])mergeObjects) && ArrayUtils.isEmpty((Object[])unAuditRealCards) && ArrayUtils.isEmpty((Object[])unAuditRestartBills)) {
            return checkResultMap;
        }
        checkResultMap.put("unAuditCards", unAuditCards.toArray());
        checkResultMap.put("unAuditMergedCards", unAuditMergedCards.toArray());
        checkResultMap.put("clearObjects", clearObjects);
        checkResultMap.put("useDeptChangeObjects", useDeptChangeObjects);
        checkResultMap.put("devalsObjects", devalsObjects);
        checkResultMap.put("splitObjects", splitObjects);
        checkResultMap.put("workLoadObjects", workLoadObjects);
        checkResultMap.put("mergeObjects", mergeObjects);
        checkResultMap.put("unAuditRealCards", unAuditRealCards);
        checkResultMap.put("unAuditRestartBills", unAuditRestartBills);
        return checkResultMap;
    }

    private void checkUpgradeMasterId(Long orgId) {
        boolean exist = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("realcardmasterid", "=", (Object)0)});
        if (exist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u4e2d\u7684\u5361\u7247\u4e3b\u6570\u636eID\u5b57\u6bb5\u81ea\u52a8\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DailyDepreImpl_4", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void depreNumForBatch(Object assetBookId, Set<String> numberSet, Long disLogId) {
        DynamicObject depreObj = null;
        boolean isFail = false;
        String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"DailyDepreImpl_1", (String)"fi-fa-business", (Object[])new Object[0]);
        DepreThreadResult depreThreadResult = new DepreThreadResult();
        Date beginDate = new Date();
        DepreSplitTask splitTask = null;
        try {
            long curTime = System.currentTimeMillis();
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingle((Object)assetBookId, (String)"fa_assetbook");
            Map<Object, Object> finId2RealIdMap = new HashMap(1);
            HashSet<Long> noEnterWkRealSet = new HashSet<Long>(100);
            finId2RealIdMap = numberSet == null ? this.queryByBookIdAndParse(bookObj, noEnterWkRealSet) : this.queryNumberByBookIdAndParse(bookObj, numberSet);
            long bookOrgId = bookObj.getLong("org_id");
            long bookDepreusegId = bookObj.getLong("depreuse_id");
            long bookCurperiodId = bookObj.getLong("curperiod_id");
            Map<String, String> dimField = FaDepreUtil.getDimFieldMap();
            ArrayBlockingQueue<DepreThread> queue = new ArrayBlockingQueue<DepreThread>(THREAD_SIZE);
            int i = 0;
            HashSet<Long> finCardIdSet = new HashSet<Long>();
            HashSet<Long> realCardIdSet = new HashSet<Long>();
            int listsize = finId2RealIdMap.size() % this.oneThreadCardNum == 0 ? finId2RealIdMap.size() / this.oneThreadCardNum : finId2RealIdMap.size() / this.oneThreadCardNum + 1;
            Object o = new Object();
            ObjectPool<Object> objPool = new ObjectPool<Object>();
            DepreBook bookBox = new DepreBook(bookObj);
            bookBox.setBeginDate(beginDate);
            bookBox.setNoEnterWkRealSet(noEnterWkRealSet);
            this.logger.info("------\u7528\u65f6\uff1aDailyDepreImpl \u6570\u636e\u67e5\u8be2\u51c6\u5907\uff1a" + (System.currentTimeMillis() - curTime) + "s.");
            splitTask = new DepreSplitTask(bookOrgId, bookDepreusegId, bookCurperiodId, true, true, SplitMode.DETAILADDREVERSE);
            splitTask.setBeginDate(beginDate);
            depreObj = splitTask.depreSum;
            FaDisDepreLogUtils.updateDisLogAllCount(disLogId, finId2RealIdMap.size());
            int disBatchNo = 1;
            boolean enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, "enableplatformthreadpool");
            Object object = o;
            synchronized (object) {
                Iterator<Map.Entry<Object, Object>> ite = finId2RealIdMap.entrySet().iterator();
                while (ite.hasNext()) {
                    if (i == this.oneThreadCardNum) {
                        AssetBookDepreData data = new AssetBookDepreData(bookBox, finCardIdSet, realCardIdSet);
                        data.setDisBatchNo(disBatchNo++);
                        DepreThread t = new DepreThread(data, depreThreadResult, queue, dimField, o, listsize, this, objPool, splitTask, true, true);
                        queue.put(t);
                        if (enablePlatformThreadPool) {
                            ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DAILY_DEPRE);
                        } else {
                            threadPool.executeIncludeRequestContext((Runnable)t);
                        }
                        finCardIdSet = new HashSet();
                        realCardIdSet = new HashSet();
                        i = 0;
                        continue;
                    }
                    Map.Entry<Object, Object> finId2RealId = ite.next();
                    finCardIdSet.add((Long)finId2RealId.getKey());
                    realCardIdSet.add((Long)finId2RealId.getValue());
                    ++i;
                }
                if (!finCardIdSet.isEmpty()) {
                    AssetBookDepreData data = new AssetBookDepreData(bookBox, finCardIdSet, realCardIdSet);
                    data.setDisBatchNo(disBatchNo++);
                    DepreThread t = new DepreThread(data, depreThreadResult, queue, dimField, o, listsize, this, objPool, splitTask, true, true);
                    queue.put(t);
                    if (enablePlatformThreadPool) {
                        ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DAILY_DEPRE);
                    } else {
                        threadPool.executeIncludeRequestContext((Runnable)t);
                    }
                }
                while (listsize > 0) {
                    o.wait();
                    listsize = -1;
                }
            }
            List<Exception> exceptions = depreThreadResult.getExceptions();
            if (exceptions.size() > 0) {
                Exception exception = exceptions.get(0);
                throw exception;
            }
            try (TXHandle tx = TX.required();){
                try {
                    splitTask.close();
                    List<Exception> exceptions2 = depreThreadResult.getExceptions();
                    if (exceptions2.size() > 0) {
                        Exception exception2 = exceptions2.get(0);
                        throw exception2;
                    }
                    this.logger.info("------\u7528\u65f6\uff1aDailyDepreImpl\u6298\u65e7\u8017\u65f6\uff1a" + (System.currentTimeMillis() - curTime) + "s.");
                    boolean hasCardDepred = this.checkIfHasCardDepred(bookOrgId, bookDepreusegId, bookCurperiodId);
                    DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_fa_card_fin");
                    cacheManager.removeByDt();
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            FaDisDepreLogUtils.updateDisDepreLog4BillHead(disLogId, DepreStatusEnum2.SUC, null, true, true);
            this.logger.info("------\u7528\u65f6\uff1aDailyDepreImpl\u6298\u65e7\u3001\u6c47\u603b\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - curTime) + "s.");
            if (!isFail) return;
        }
        catch (KDException e) {
            try {
                isFail = true;
                errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
                throw e;
                catch (Exception e2) {
                    isFail = true;
                    errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e2));
                    throw new KDException((Throwable)e2, new ErrorCode("1", errMsg), new Object[0]);
                }
            }
            catch (Throwable throwable) {
                if (!isFail) throw throwable;
                this.logger.error("\u6298\u65e7\u6c47\u603b\u4fdd\u5b58\u5931\u8d25:" + errMsg);
                if (depreObj == null) throw throwable;
                try (TXHandle h = TX.required((String)"accountmappingversion");){
                    try {
                        DepreSplitSumUtils.updateDepreStatus(depreObj, "3");
                        h.commit();
                        throw throwable;
                    }
                    catch (Throwable e3) {
                        this.logger.error("updateDepreStatus", e3);
                        h.markRollback();
                        this.logger.error("\u6298\u65e7\u6c47\u603b\u4fdd\u5b58\u5931\u8d25\u540e\u66f4\u65b0\u72b6\u6001\u4e3a3\u5931\u8d25\uff1a" + ThrowableHelper.toString((Throwable)e3));
                        throw throwable;
                    }
                }
            }
        }
        this.logger.error("\u6298\u65e7\u6c47\u603b\u4fdd\u5b58\u5931\u8d25:" + errMsg);
        if (depreObj == null) return;
        try (TXHandle h = TX.required((String)"accountmappingversion");){
            try {
                DepreSplitSumUtils.updateDepreStatus(depreObj, "3");
                h.commit();
                return;
            }
            catch (Throwable e) {
                this.logger.error("updateDepreStatus", e);
                h.markRollback();
                this.logger.error("\u6298\u65e7\u6c47\u603b\u4fdd\u5b58\u5931\u8d25\u540e\u66f4\u65b0\u72b6\u6001\u4e3a3\u5931\u8d25\uff1a" + ThrowableHelper.toString((Throwable)e));
                return;
            }
        }
    }

    private void disDepreNumForBatch(Object assetBookId, boolean needLock, Long disLogId) {
        String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"DailyDepreImpl_1", (String)"fi-fa-business", (Object[])new Object[0]);
        Long bookOrgId = 0L;
        Long bookDepreusegId = 0L;
        Long bookCurperiodId = 0L;
        DynamicObject depreObj = null;
        try {
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingle((Object)assetBookId, (String)"fa_assetbook");
            bookOrgId = bookObj.getLong("org_id");
            bookDepreusegId = bookObj.getLong("depreuse_id");
            bookCurperiodId = bookObj.getLong("curperiod_id");
            boolean enableSumMutilVoucher = SystemParamHelper.getBooleanParam("enable_sum_mutil_voucher", bookOrgId, false);
            if (!enableSumMutilVoucher && FaDepreUtil.hasVoucher(bookOrgId, bookDepreusegId, bookCurperiodId, true)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DailyDepreImpl_5", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            HashSet<Long> noEnterWkRealSet = new HashSet<Long>(100);
            Map<Long, Long> finId2RealIdMap = this.queryByBookIdAndParse(bookObj, noEnterWkRealSet);
            FaDisDepreLogUtils.updateDisLogAllCount(disLogId, finId2RealIdMap.size());
            QFilter[] filters = new QFilter[]{new QFilter("period", "=", bookObj.get("curperiod_id")), new QFilter("assetbook", "=", assetBookId)};
            DynamicObjectCollection depres = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])filters);
            HashSet<Long> sumIdsSet = new HashSet<Long>(depres.size());
            if (depres.size() > 0) {
                ArrayList<String> sumIdsList = new ArrayList<String>(depres.size());
                for (DynamicObject depre : depres) {
                    sumIdsSet.add(depre.getLong("id"));
                    sumIdsList.add(depre.getString("id"));
                }
                Set<Long> existedVouncherSumIds = FaDepreUtil.getIds4HaveVouncher(sumIdsList, "fa_depre_sum");
                sumIdsSet.removeAll(existedVouncherSumIds);
            }
            if (sumIdsSet.size() > 0) {
                depreObj = BusinessDataServiceHelper.loadSingle((String)"fa_depre_sum", (String)"id,billno,totaldepreamount,version,deprestatus,billstatus", (QFilter[])filters);
            }
            if (depreObj == null) {
                depreObj = this.insertHeadByBook(assetBookId);
            } else {
                DepreSplitSumUtils.updateDepreStatus(depreObj, "1");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{depreObj});
            DynamicObject depreSchema = DepreSplitDetailUtils.priproGet(bookOrgId, bookDepreusegId);
            List<String> schemaFields = DepreSplitDetailUtils.parsedepreScheme(depreSchema);
            DepreSplitSumUtils.initSumAssEntry(bookOrgId, bookDepreusegId, bookCurperiodId, depreObj, schemaFields);
            if (finId2RealIdMap.size() == 0) {
                DepreSplitSumUtils.updateDepreStatus(depreObj, "2");
                FaDisDepreLogUtils.updateDisDepreLog4BillHead(disLogId, DepreStatusEnum2.SUC, null, false, true);
                if (needLock) {
                    FunctionMutexHelper.releaseLockWithBook("fa_new_depre", bookObj);
                }
                return;
            }
            int i = 0;
            StringBuilder realIdsSb = new StringBuilder();
            StringBuilder finIdsSb = new StringBuilder();
            int disBatchNo = 1;
            DisDepreMsgCache cache = new DisDepreMsgCache();
            cache.setNoEnterWkRealSet(noEnterWkRealSet);
            cache.setEnabledisdepre(this.enabledisdepre);
            cache.setNeedLock(needLock);
            try (MessagePublisher msPublisher = MQFactory.get().createSimplePublisher("fi", "fi.fa.depre_queue");){
                Iterator<Map.Entry<Long, Long>> ite = finId2RealIdMap.entrySet().iterator();
                while (ite.hasNext()) {
                    if (i == this.oneThreadCardNum) {
                        DisDepreMessage ms = new DisDepreMessage((Long)assetBookId, disLogId, disBatchNo);
                        ms.setCache(cache);
                        msPublisher.publishInDbTranscation(null, (Object)ms);
                        FaDisDepreLogEntryInsertPo logEntryPo = new FaDisDepreLogEntryInsertPo(disLogId, disBatchNo);
                        String ids = realIdsSb.append(";").append((CharSequence)finIdsSb).toString();
                        logEntryPo.setIds(ids);
                        FaDisDepreLogUtils.insertInitDisDepreLogEntry(logEntryPo);
                        realIdsSb = new StringBuilder();
                        finIdsSb = new StringBuilder();
                        i = 0;
                        ++disBatchNo;
                        continue;
                    }
                    Map.Entry<Long, Long> finId2RealId = ite.next();
                    realIdsSb.append(finId2RealId.getValue()).append(",");
                    finIdsSb.append(finId2RealId.getKey()).append(",");
                    ++i;
                }
                if (finIdsSb.length() != 0) {
                    DisDepreMessage ms = new DisDepreMessage((Long)assetBookId, disLogId, disBatchNo);
                    ms.setCache(cache);
                    msPublisher.publishInDbTranscation(null, (Object)ms);
                    FaDisDepreLogEntryInsertPo logEntryPo = new FaDisDepreLogEntryInsertPo(disLogId, disBatchNo);
                    String ids = realIdsSb.append(";").append((CharSequence)finIdsSb).toString();
                    logEntryPo.setIds(ids);
                    FaDisDepreLogUtils.insertInitDisDepreLogEntry(logEntryPo);
                    ++disBatchNo;
                }
            }
        }
        catch (Exception e) {
            if (depreObj != null) {
                try (TXHandle h = TX.required();){
                    try {
                        DepreSplitSumUtils.updateDepreStatus(depreObj, "3");
                        h.commit();
                    }
                    catch (Throwable e3) {
                        h.markRollback();
                        this.logger.error("\u6298\u65e7\u6c47\u603b\u4fdd\u5b58\u5931\u8d25\u540e\u66f4\u65b0\u72b6\u6001\u4e3a3\u5931\u8d25\uff1a" + ThrowableHelper.toString((Throwable)e));
                    }
                }
            }
            errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
            throw new KDException((Throwable)e, new ErrorCode("1", errMsg), new Object[0]);
        }
    }

    public Map<String, Map<String, Object>> clearPrePeriodDepe(Object orgId, Long depreUseId, DynamicObject predictPeriod, Set<String> numberSet, Set<Long> realIdSet) {
        return this.clearPrePeriodDepe(orgId, depreUseId, predictPeriod, numberSet, realIdSet, null);
    }

    public Map<String, Map<String, Object>> clearPrePeriodDepe(Object orgId, Long depreUseId, DynamicObject predictPeriod, Set<String> numberSet, Set<Long> realIdSet, Map<Long, Date> realMasterId2Bizdate) {
        if (numberSet.size() == 0) {
            return new HashMap<String, Map<String, Object>>(1);
        }
        String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"DailyDepreImpl_1", (String)"fi-fa-business", (Object[])new Object[0]);
        try {
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("depreuse", "=", (Object)depreUseId)});
            SqlBuilder sbSql = new SqlBuilder();
            Long predictPeriodId = predictPeriod.getLong("id");
            Long curPeriodId = bookObj.getDynamicObject("curperiod").getLong("id");
            if (predictPeriodId < curPeriodId) {
                sbSql.append("SELECT fid id, frealcardid realId FROM T_FA_CARD_FIN WHERE ", new Object[0]).appendIn(" frealcardmasterid ", realIdSet.toArray()).append(" and forg = ? ", new Object[]{orgId}).append(" and fdepreuseid = ? ", new Object[]{depreUseId}).append(" and fbizperiodid = ? ", new Object[]{predictPeriodId});
            } else {
                sbSql.append("SELECT fid id, frealcardid realId FROM T_FA_CARD_FIN WHERE ", new Object[0]).appendIn(" frealcardmasterid ", realIdSet.toArray()).append(" and forg = ? ", new Object[]{orgId}).append(" and fdepreuseid = ? ", new Object[]{depreUseId}).append(" and fendperiodid > ? ", new Object[]{curPeriodId}).append(" and fbizperiodid <= ? ", new Object[]{curPeriodId});
            }
            HashMap<Long, Long> finId2RealIdMap = new HashMap<Long, Long>(numberSet.size(), 1.0f);
            try (DataSet finDS = DB.queryDataSet((String)"clearPrePeriodDepeQueryFin", (DBRoute)faDBRoute, (SqlBuilder)sbSql);){
                for (Row row : finDS) {
                    finId2RealIdMap.put(row.getLong("id"), row.getLong("realId"));
                }
            }
            HashSet<Long> cardId = new HashSet<Long>(2000);
            HashSet<Long> realCardId = new HashSet<Long>(2000);
            DepreThreadResult depreThreadResult = new DepreThreadResult();
            DepreBook bookBox = new DepreBook(bookObj, predictPeriod, null);
            bookBox.setClearPreDepre(true);
            bookBox.setRealMasterId2ClearBizdate(realMasterId2Bizdate);
            String logParams = String.format("orgId:%s; depreUseId:%s; predictPeriod:%s; numberSet:%s", orgId, depreUseId, predictPeriod.toString(), JSON.toJSONString(numberSet));
            FaOperationLogInsertPo insertLogPo = new FaOperationLogInsertPo((Long)orgId, depreUseId, bookObj.getLong("id"), curPeriodId, (Integer)finId2RealIdMap.size(), this.fromEntityName, logParams, FaOperationOpTypeEnum.CLEARPRE);
            this.disLogId = FaOperationLogUtils.insertOperationLog(insertLogPo);
            for (Map.Entry finId2RealId : finId2RealIdMap.entrySet()) {
                cardId.add((Long)finId2RealId.getKey());
                realCardId.add((Long)finId2RealId.getValue());
            }
            AssetBookDepreData data = new AssetBookDepreData(bookBox, cardId, realCardId);
            this.depreForABatch(this, data, depreThreadResult, false, false);
            List<Exception> exceptions = depreThreadResult.getExceptions();
            if (exceptions.size() > 0) {
                Exception exception = exceptions.get(0);
                throw exception;
            }
            FaOperationLogUtils.updateOperationLog(this.disLogId, FaOperationStatusEnum.SUCCESS, null);
            return depreThreadResult.getPredictResultMap();
        }
        catch (KDException e) {
            errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
            FaOperationLogUtils.updateOperationLog(this.disLogId, FaOperationStatusEnum.FAILED, errMsg);
            throw e;
        }
        catch (Exception e) {
            errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
            FaOperationLogUtils.updateOperationLog(this.disLogId, FaOperationStatusEnum.FAILED, errMsg);
            throw new KDException((Throwable)e, new ErrorCode("1", errMsg), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> isNeedDeprePeriodClose(Object assetBookId, Set<Long> cardAllIds) {
        String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"DailyDepreImpl_1", (String)"fi-fa-business", (Object[])new Object[0]);
        try {
            List<Exception> exceptions;
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingle((Object)assetBookId, (String)"fa_assetbook");
            Map<String, String> dimField = FaDepreUtil.getDimFieldMap();
            ArrayBlockingQueue<DepreThread> queue = new ArrayBlockingQueue<DepreThread>(3);
            DepreThreadResult depreThreadResult = new DepreThreadResult();
            Object o = new Object();
            ObjectPool<Object> objPool = new ObjectPool<Object>();
            DepreBook bookBox = new DepreBook(bookObj);
            int checkBatchNum = 3 * this.oneThreadCardNum;
            int checkBatchSize = cardAllIds.size() % checkBatchNum == 0 ? cardAllIds.size() / checkBatchNum : cardAllIds.size() / checkBatchNum + 1;
            Object[] cardidAllArray = cardAllIds.toArray();
            FaDisDepreLogPo logPo = new FaDisDepreLogPo(bookObj.getLong("org.id"), bookObj.getLong("depreUse.id"), bookObj.getLong("curperiod.id"), (Long)assetBookId, cardAllIds.size(), this.isManual, ContextUtil.getUserId(), this.fromEntityName, false);
            this.disLogId = FaDisDepreLogUtils.insertDisDepreLog(logPo, true);
            int disBatchNo = 1;
            boolean enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, "enableplatformthreadpool");
            for (int b = 0; b < checkBatchSize; ++b) {
                HashSet<Long> cardIds = new HashSet<Long>(checkBatchNum);
                int maxIndex = (b + 1) * checkBatchNum;
                if (maxIndex > cardAllIds.size()) {
                    maxIndex = cardAllIds.size();
                }
                for (int arrayIndex = b * checkBatchNum; arrayIndex < maxIndex; ++arrayIndex) {
                    cardIds.add((Long)cardidAllArray[arrayIndex]);
                }
                int i = 0;
                HashSet<Long> cardId = new HashSet<Long>();
                int listsize = cardIds.size() % this.oneThreadCardNum == 0 ? cardIds.size() / this.oneThreadCardNum : cardIds.size() / this.oneThreadCardNum + 1;
                Object object = o;
                synchronized (object) {
                    Iterator ite = cardIds.iterator();
                    while (ite.hasNext()) {
                        if (i == this.oneThreadCardNum) {
                            AssetBookDepreData data = new AssetBookDepreData(bookBox, cardId, null);
                            data.setDisBatchNo(disBatchNo++);
                            DepreThread t = new DepreThread(data, depreThreadResult, queue, dimField, o, listsize, this, objPool, null, false, false);
                            queue.put(t);
                            if (enablePlatformThreadPool) {
                                ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DAILY_DEPRE);
                            } else {
                                threadPool.executeIncludeRequestContext((Runnable)t);
                            }
                            cardId = new HashSet();
                            i = 0;
                            continue;
                        }
                        cardId.add((Long)ite.next());
                        ++i;
                    }
                    if (!cardId.isEmpty()) {
                        AssetBookDepreData data = new AssetBookDepreData(bookBox, cardId, null);
                        data.setDisBatchNo(disBatchNo++);
                        DepreThread t = new DepreThread(data, depreThreadResult, queue, dimField, o, listsize, this, objPool, null, false, false);
                        queue.put(t);
                        if (enablePlatformThreadPool) {
                            ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DAILY_DEPRE);
                        } else {
                            threadPool.executeIncludeRequestContext((Runnable)t);
                        }
                    }
                    while (listsize > 0) {
                        o.wait();
                        listsize = -1;
                        this.finishThreadCount.set(0);
                    }
                    Set<String> needDepreFinNums = depreThreadResult.getNeedDepreFinNums();
                    if (needDepreFinNums.size() > 0) {
                        break;
                    }
                }
                FaDisDepreLogUtils.updateDisDepreLog4BillHead(this.disLogId, DepreStatusEnum2.SUC, null, false, true);
            }
            if ((exceptions = depreThreadResult.getExceptions()).size() > 0) {
                Exception exception = exceptions.get(0);
                throw exception;
            }
            Set<String> needDepreFinNums = depreThreadResult.getNeedDepreFinNums();
            return needDepreFinNums;
        }
        catch (KDBizException e) {
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
            throw e;
        }
        catch (KDException e) {
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
            throw e;
        }
        catch (Exception e) {
            errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
            throw new KDException((Throwable)e, new ErrorCode("1", errMsg), new Object[0]);
        }
    }

    public Map<String, Map<String, Map<String, Object>>> predictPeriodDepe(Object orgId, Long depreUseId, DynamicObject predictPeriod, boolean needTemPredictData, boolean addFinishDepreDataToMax, Set<String> numberSet) {
        DeprePredictParam param = new DeprePredictParam(orgId, depreUseId, predictPeriod, needTemPredictData, addFinishDepreDataToMax, numberSet);
        return this.predictPeriodDepe(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Map<String, Object>>> predictPeriodDepe(DeprePredictParam param) {
        Object orgId = param.getOrgId();
        Long depreUseId = param.getDepreUseId();
        DynamicObject predictPeriod = param.getPredictPeriod();
        boolean needTemPredictData = param.isNeedTemPredictData();
        boolean addFinishDepreDataToMax = param.isAddFinishDepreDataToMax();
        Set<String> numberSet = param.getNumberSet();
        boolean ignoreUseStatus = param.isIgnoreUseStatus();
        String errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"DailyDepreImpl_1", (String)"fi-fa-business", (Object[])new Object[0]);
        try {
            StringBuilder keySb;
            boolean enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, "enableplatformthreadpool");
            HashMap<String, Map<String, Map<String, Object>>> predictResultMap = new HashMap<String, Map<String, Map<String, Object>>>(10000);
            HashMap finishDepredPreReultMap = new HashMap(256);
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("depreuse", "=", (Object)depreUseId)});
            DynamicObjectCollection periodList = DepreForecast.getPeriodList(bookObj, predictPeriod);
            Map<Long, DynamicObject> predictPrefinCardMap2 = new HashMap<Long, DynamicObject>();
            int needDeprePeriodIndex = 0;
            int offSet = 0;
            for (int a = 0; a < periodList.size(); ++a) {
                Map<String, Long> unNeedDepreFinMap;
                DynamicObject prePeriod = (DynamicObject)periodList.get(a);
                StringBuilder keySb2 = new StringBuilder();
                keySb2.append(orgId).append("_").append(depreUseId).append("_").append(prePeriod.getLong("id"));
                String orgId_depreUseId_prePeriodId = keySb2.toString();
                boolean bl = a == 0;
                boolean isLastedPeriod = a == periodList.size() - 1;
                Map<String, Map<String, Object>> hisDepreData = FaDepreUtil.depreHisCardHandle((Long)orgId, depreUseId, prePeriod.getLong("id"), numberSet);
                Set<Long> cardIds = FaDepreUtil.queryForDeprePredictFinId((Long)orgId, depreUseId, prePeriod.getLong("id"), numberSet);
                if (ignoreUseStatus && (unNeedDepreFinMap = FaDepreUtil.queryUnNeedDepreFinMap4IgnoreUseStatus((Long)orgId, depreUseId, prePeriod.getLong("id"), numberSet)) != null && !unNeedDepreFinMap.isEmpty()) {
                    for (Map.Entry<String, Long> entry : unNeedDepreFinMap.entrySet()) {
                        hisDepreData.remove(entry.getKey());
                        cardIds.add(entry.getValue());
                    }
                }
                if (cardIds.size() == 0) {
                    if (hisDepreData != null && hisDepreData.size() > 0) {
                        if (predictResultMap.get(orgId_depreUseId_prePeriodId) == null) {
                            predictResultMap.put(orgId_depreUseId_prePeriodId, hisDepreData);
                        }
                    } else {
                        predictResultMap.put(orgId_depreUseId_prePeriodId, new HashMap());
                    }
                    ++offSet;
                    continue;
                }
                ArrayBlockingQueue<DepreThread> queue = new ArrayBlockingQueue<DepreThread>(3);
                int i = 0;
                HashSet<Long> cardId = new HashSet<Long>();
                int listsize = cardIds.size() % this.oneThreadCardNum == 0 ? cardIds.size() / this.oneThreadCardNum : cardIds.size() / this.oneThreadCardNum + 1;
                DepreThreadResult depreThreadResult = new DepreThreadResult();
                Object o = new Object();
                ObjectPool<Object> objPool = new ObjectPool<Object>();
                DepreBook bookBox = new DepreBook(bookObj, prePeriod, predictPrefinCardMap2);
                bookBox.setIgnoreUseStatus(ignoreUseStatus);
                if (!"fa_card_fin".equals(this.fromEntityName) || needDeprePeriodIndex == 0 || needDeprePeriodIndex + offSet == periodList.size() - 1) {
                    FaDisDepreLogPo logPo = new FaDisDepreLogPo((Long)orgId, depreUseId, prePeriod.getLong("id"), bookObj.getLong("id"), cardIds.size(), this.isManual, ContextUtil.getUserId(), this.fromEntityName, false);
                    this.disLogId = FaDisDepreLogUtils.insertDisDepreLog(logPo, true);
                } else {
                    this.disLogId = 0L;
                }
                ++needDeprePeriodIndex;
                int disBatchNo = 1;
                Object object = o;
                synchronized (object) {
                    Iterator<Long> ite = cardIds.iterator();
                    while (ite.hasNext()) {
                        if (i == this.oneThreadCardNum) {
                            AssetBookDepreData data = new AssetBookDepreData(bookBox, cardId, null);
                            data.setLastedPeriod(isLastedPeriod);
                            data.setDisBatchNo(disBatchNo++);
                            DepreThread t = new DepreThread(data, depreThreadResult, queue, null, o, listsize, this, objPool, null, false, false);
                            queue.put(t);
                            if (enablePlatformThreadPool) {
                                ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DAILY_DEPRE);
                            } else {
                                threadPool.executeIncludeRequestContext((Runnable)t);
                            }
                            cardId = new HashSet();
                            i = 0;
                            continue;
                        }
                        cardId.add(ite.next());
                        ++i;
                    }
                    if (!cardId.isEmpty()) {
                        AssetBookDepreData data = new AssetBookDepreData(bookBox, cardId, null);
                        data.setLastedPeriod(isLastedPeriod);
                        data.setDisBatchNo(disBatchNo++);
                        DepreThread t = new DepreThread(data, depreThreadResult, queue, null, o, listsize, this, objPool, null, false, false);
                        queue.put(t);
                        if (enablePlatformThreadPool) {
                            ThreadService.execute((Runnable)t, (TaskType)TaskType.FA_DAILY_DEPRE);
                        } else {
                            threadPool.executeIncludeRequestContext((Runnable)t);
                        }
                    }
                    while (listsize > 0) {
                        o.wait();
                        listsize = -1;
                    }
                }
                predictPrefinCardMap2.clear();
                predictPrefinCardMap2 = depreThreadResult.getPredictPrefinCardMap();
                if (predictResultMap.get(orgId_depreUseId_prePeriodId) == null) {
                    predictResultMap.put(orgId_depreUseId_prePeriodId, new HashMap());
                }
                Map predictResultInnerMap = (Map)predictResultMap.get(orgId_depreUseId_prePeriodId);
                if (hisDepreData != null && hisDepreData.size() != 0) {
                    predictResultInnerMap.putAll(hisDepreData);
                }
                if (depreThreadResult.getPredictResultMap().size() != 0) {
                    predictResultInnerMap.putAll(depreThreadResult.getPredictResultMap());
                }
                if (addFinishDepreDataToMax && !bl) {
                    DynamicObject previousPrePeriod = (DynamicObject)periodList.get(a - 1);
                    StringBuilder previousPeriodkeySb = new StringBuilder();
                    previousPeriodkeySb.append(orgId).append("_").append(depreUseId).append("_").append(previousPrePeriod.getLong("id"));
                    Map predictResultNextPeriodInnerMap = (Map)predictResultMap.get(previousPeriodkeySb.toString());
                    Map predictResultPrePeriodInnerMap = (Map)predictResultMap.get(orgId_depreUseId_prePeriodId);
                    Set previousPeriodNumberSet = predictResultNextPeriodInnerMap.keySet();
                    Set prePeriodNumberSet = predictResultPrePeriodInnerMap.keySet();
                    HashSet finishDepreNumberSet = new HashSet(previousPeriodNumberSet.size(), 1.0f);
                    finishDepreNumberSet.addAll(previousPeriodNumberSet);
                    finishDepreNumberSet.removeAll(prePeriodNumberSet);
                    int previousPrePeriodYear = previousPrePeriod.getInt("periodyear");
                    DynamicObject maxPrePeriod = (DynamicObject)periodList.get(periodList.size() - 1);
                    int maxPrePeriodYear = maxPrePeriod.getInt("periodyear");
                    for (String number : finishDepreNumberSet) {
                        Map predictResult = (Map)predictResultNextPeriodInnerMap.get(number);
                        HashMap<String, Number> newPredictResult = new HashMap<String, Number>();
                        newPredictResult.putAll(predictResult);
                        newPredictResult.put("monthdepre", BigDecimal.ZERO);
                        newPredictResult.put("addidepreamount", 0);
                        if (maxPrePeriodYear != previousPrePeriodYear) {
                            newPredictResult.put("addupyeardepre", BigDecimal.ZERO);
                        }
                        finishDepredPreReultMap.put(number, newPredictResult);
                    }
                }
                this.finishThreadCount.set(0);
                List<Exception> exceptions = depreThreadResult.getExceptions();
                if (exceptions.size() > 0) {
                    Exception exception = exceptions.get(0);
                    throw exception;
                }
                FaDisDepreLogUtils.updateDisDepreLog4BillHead(this.disLogId, DepreStatusEnum2.SUC, null, true, true);
            }
            if (addFinishDepreDataToMax && periodList.size() > 1) {
                DynamicObject preMaxPeriod = (DynamicObject)periodList.get(periodList.size() - 1);
                keySb = new StringBuilder();
                keySb.append(orgId).append("_").append(depreUseId).append("_").append(preMaxPeriod.getLong("id"));
                String orgId_depreUseId_preMaxPeriodId = keySb.toString();
                for (Map.Entry entry : predictResultMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.equals(orgId_depreUseId_preMaxPeriodId)) continue;
                    Map value = (Map)entry.getValue();
                    value.putAll(finishDepredPreReultMap);
                }
            }
            if (needTemPredictData) {
                return predictResultMap;
            }
            HashMap<String, Map<String, Map<String, Object>>> lastPeriodpredictResultMap = new HashMap<String, Map<String, Map<String, Object>>>(1, 1.0f);
            keySb = new StringBuilder();
            keySb.append(orgId).append("_").append(depreUseId).append("_").append(predictPeriod.getLong("id"));
            String orgId_depreUseId_prePeriodId = keySb.toString();
            Map preResult = (Map)predictResultMap.get(orgId_depreUseId_prePeriodId);
            if (preResult == null) {
                lastPeriodpredictResultMap.put(orgId_depreUseId_prePeriodId, new HashMap());
            } else {
                lastPeriodpredictResultMap.put(orgId_depreUseId_prePeriodId, preResult);
            }
            return lastPeriodpredictResultMap;
        }
        catch (KDBizException e) {
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
            throw e;
        }
        catch (KDException e) {
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
            throw e;
        }
        catch (Exception e) {
            errMsg = String.format(errMsg, ThrowableHelper.toString((Throwable)e));
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError(this.disLogId, e, false, true);
            throw new KDException((Throwable)e, new ErrorCode("1", errMsg), new Object[0]);
        }
    }

    public Map<Long, Map<String, BigDecimal>> depreClearValue2Restartbill(Object orgId, Long depreUseId, Long clearPeriodId, Long endPeriodId, Map<Long, ClearValue> realMasterId2ClrValueMap) {
        try {
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("depreuse", "=", (Object)depreUseId)});
            DynamicObjectCollection periodList = DepreForecast.getPeriodList(bookObj, clearPeriodId, endPeriodId);
            if (periodList == null || periodList.size() == 0) {
                return new HashMap<Long, Map<String, BigDecimal>>(1);
            }
            List<DepreAlgoInter> depreCardList = null;
            DepreBook bookBox = new DepreBook(bookObj, true, clearPeriodId);
            for (int a = 0; a < periodList.size(); ++a) {
                DynamicObject prePeriod = (DynamicObject)periodList.get(a);
                boolean isFirstPeriod = a == 0;
                boolean isLastedPeriod = a == periodList.size() - 1;
                bookBox.initCurPeriod(prePeriod);
                depreCardList = isFirstPeriod ? bookBox.depreClearValue2Restartbill(realMasterId2ClrValueMap, null) : bookBox.depreClearValue2Restartbill(null, depreCardList);
                if (!isLastedPeriod) continue;
                HashMap<Long, Map<String, BigDecimal>> resultMap = new HashMap<Long, Map<String, BigDecimal>>(depreCardList.size(), 1.0f);
                for (DepreAlgoInter depreCard : depreCardList) {
                    DynamicObject finDy = depreCard.getFinCard();
                    if (depreUseId.longValue() != finDy.getLong("depreuse_id")) continue;
                    Long realMasterId = finDy.getLong("realcardmasterid");
                    BigDecimal accumDepre = finDy.getBigDecimal("accumdepre");
                    ClearValue clearValue = realMasterId2ClrValueMap.get(realMasterId);
                    BigDecimal initAccumDepre = clearValue.getClearAddupdepre();
                    BigDecimal clearDepredAmount = clearValue.getClearDepredAmount();
                    HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(2, 1.0f);
                    result.put("addedAccumDepre", accumDepre.subtract(initAccumDepre));
                    result.put("reStartAddedDepredAmount", finDy.getBigDecimal("depredamount").subtract(clearDepredAmount));
                    resultMap.put(realMasterId, result);
                }
                return resultMap;
            }
            return new HashMap<Long, Map<String, BigDecimal>>(1);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private DynamicObject insertHeadByBook(Object bookPK) {
        DynamicObject book = BusinessDataServiceHelper.loadSingle((Object)bookPK, (String)"fa_assetbook");
        DynamicObject depre = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"fa_depre_sum").createInstance();
        depre.set("org", (Object)book.getDynamicObject("org"));
        depre.set("assetbook", (Object)book);
        depre.set("depreuse", (Object)book.getDynamicObject("depreuse"));
        DynamicObject curPeriod = book.getDynamicObject("curperiod");
        depre.set("period", (Object)curPeriod);
        Date begin = curPeriod.getDate("begindate");
        Date end = curPeriod.getDate("enddate");
        Date now = new Date();
        if (now.compareTo(begin) >= 0 && now.compareTo(end) <= 0) {
            depre.set("bizdate", (Object)now);
        } else {
            depre.set("bizdate", (Object)end);
        }
        this.setDefaultHead(depre);
        return depre;
    }

    private void setDefaultHead(DynamicObject depre) {
        depre.set("billno", (Object)new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        depre.set("totaldepreamount", (Object)0);
        depre.set("billstatus", (Object)BillStatus.C.toString());
        depre.set("createtime", (Object)new Date());
        depre.set("auditdate", (Object)new Date());
        depre.set("creator", (Object)ContextUtil.getUserId());
        depre.set("auditor", (Object)ContextUtil.getUserId());
    }

    private boolean checkIfHasCardDepred(Long bookOrgId, Long bookDepreusegId, Long bookCurperiodId) {
        QFilter qfOrg = new QFilter("org", "=", (Object)bookOrgId);
        QFilter qfDepreuse = new QFilter("depreuse", "=", (Object)bookDepreusegId);
        QFilter qfPeriod = new QFilter("period", "=", (Object)bookCurperiodId);
        return QueryServiceHelper.exists((String)"fa_depresplitdetail", (QFilter[])new QFilter[]{qfOrg, qfDepreuse, qfPeriod});
    }

    private Map<Long, Long> queryByBookIdAndParse(DynamicObject bookObj, Set<Long> noEnterWkRealSet) {
        long bookOrgId = bookObj.getLong("org_id");
        long bookDepreuseId = bookObj.getLong("depreuse_id");
        long bookCurperiodId = bookObj.getLong("curperiod_id");
        Long periodtypeId = bookObj.getLong("periodtype.id");
        Long previousPeriodid = FaPeriodUtils.getPreviousPeriodId(bookCurperiodId, periodtypeId);
        QFilter[] depreMethodFilters = new QFilter[]{new QFilter("type", "=", (Object)"5")};
        Map depremethodCacheMap = BusinessDataServiceHelper.loadFromCache((String)"fa_depremethod", (QFilter[])depreMethodFilters);
        HashSet<Long> depremethodId_isWorkLoadSet = new HashSet<Long>(1, 1.0f);
        for (DynamicObject depremethod : depremethodCacheMap.values()) {
            String type = depremethod.getString("type");
            if (!type.equals("5")) continue;
            depremethodId_isWorkLoadSet.add((Long)depremethod.getPkValue());
        }
        HashMap<Long, Long> cardIds = new HashMap<Long, Long>(3000);
        HashSet<Long> wkRealcardIdSet = new HashSet<Long>(100);
        String sql = "SELECT fid id, frealcardid realId,foriginalval originalval,faccumdepre accumdepre,fdecval decval,fpreresidualval preresidualval,fbizperiodid bizperiodid,fdepremethodid depremethodId   FROM T_FA_CARD_FIN WHERE fbillstatus=? and forg = ? and fdepreuseid=? and fendperiodid > ? and (fbizperiodid in (?,0) or (fbizperiodid = ? and fisneeddepre='1')) and (fclearperiodid = 0 or fclearperiodid = ?)";
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{"C", bookOrgId, bookDepreuseId, bookCurperiodId, previousPeriodid, bookCurperiodId, bookCurperiodId});){
            for (Object row : ds) {
                Long bizperiodid = row.getLong("bizperiodid");
                if (bizperiodid.longValue() == previousPeriodid.longValue() || bizperiodid == 0L) {
                    boolean noValueToDepre;
                    BigDecimal originalval = row.getBigDecimal("originalval");
                    BigDecimal accumdepre = row.getBigDecimal("accumdepre");
                    BigDecimal decval = row.getBigDecimal("decval");
                    BigDecimal preresidualval = row.getBigDecimal("preresidualval");
                    BigDecimal leftValueToDepre = originalval.subtract(accumdepre).subtract(decval).subtract(preresidualval);
                    boolean bl = noValueToDepre = leftValueToDepre.compareTo(BigDecimal.ZERO) == 0;
                    if (noValueToDepre) continue;
                }
                cardIds.put(row.getLong("id"), row.getLong("realId"));
                if (!depremethodId_isWorkLoadSet.contains(row.getLong("depremethodId"))) continue;
                wkRealcardIdSet.add(row.getLong("realId"));
            }
        }
        HashSet<Long> existedWkRealcardIdSet = new HashSet<Long>(100);
        if (wkRealcardIdSet.size() > 0) {
            Object row;
            SqlBuilder queryWkql = new SqlBuilder();
            queryWkql.append("SELECT frealcardid FROM t_fa_workload  ", new Object[0]);
            queryWkql.append(" WHERE forgid = ? ", new Object[]{bookOrgId}).append(" and fdepreuseid = ? ", new Object[]{bookDepreuseId}).append(" and FPERIODID = ? ", new Object[]{bookCurperiodId}).appendIn("and frealcardid ", wkRealcardIdSet.toArray());
            DataSet dsWk = DB.queryDataSet((String)"queryByBookIdAndParse_selectwk", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryWkql);
            row = null;
            try {
                for (Row rowWk : dsWk) {
                    existedWkRealcardIdSet.add(rowWk.getLong("frealcardid"));
                }
            }
            catch (Throwable bizperiodid) {
                row = bizperiodid;
                throw bizperiodid;
            }
            finally {
                if (dsWk != null) {
                    if (row != null) {
                        try {
                            dsWk.close();
                        }
                        catch (Throwable bizperiodid) {
                            ((Throwable)row).addSuppressed(bizperiodid);
                        }
                    } else {
                        dsWk.close();
                    }
                }
            }
        }
        wkRealcardIdSet.removeAll(existedWkRealcardIdSet);
        if (wkRealcardIdSet.size() > 0) {
            noEnterWkRealSet.addAll(wkRealcardIdSet);
        }
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"}), "auditdate"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)bookOrgId), new QFilter("depreuse", "=", (Object)bookDepreuseId), new QFilter("period", "=", (Object)bookCurperiodId)};
        DynamicObjectCollection depreAdjustBills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)selectFields, (QFilter[])filters);
        Set realIdSet = depreAdjustBills.stream().map(v -> v.get(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toSet());
        filters = new QFilter[]{new QFilter("org", "=", (Object)bookOrgId), new QFilter("depreuse", "=", (Object)bookDepreuseId), new QFilter("bizperiod", "<=", (Object)bookCurperiodId), new QFilter("endperiod", ">", (Object)bookCurperiodId), new QFilter("realcardmasterid", "in", realIdSet)};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])filters);
        Set _finIds = finCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        for (Object finId : _finIds) {
            cardIds.remove(finId);
        }
        return cardIds;
    }

    private Map<Long, Long> queryNumberByBookIdAndParse(DynamicObject bookObj, Set<String> numberSet) {
        long bookOrgId = bookObj.getLong("org_id");
        long bookDepreuseId = bookObj.getLong("depreuse_id");
        long bookCurperiodId = bookObj.getLong("curperiod_id");
        long bookId = (Long)bookObj.getPkValue();
        Long periodtypeId = bookObj.getLong("periodtype.id");
        Long previousPeriodid = FaPeriodUtils.getPreviousPeriodId(bookCurperiodId, periodtypeId);
        HashMap<Long, Long> cardIds = new HashMap<Long, Long>(200);
        SqlBuilder sbSql = new SqlBuilder();
        sbSql.append("SELECT fid id, frealcardid realId ,foriginalval originalval,faccumdepre accumdepre,fdecval decval,fpreresidualval preresidualval,fbizperiodid bizperiodid FROM T_FA_CARD_FIN WHERE ", new Object[0]).append("fbillstatus = ? ", new Object[]{"C"}).append(" and forg = ? ", new Object[]{bookOrgId}).append(" and fdepreuseid = ? ", new Object[]{bookDepreuseId}).append(" and fendperiodid > ? ", new Object[]{bookCurperiodId}).append(" and (fbizperiodid in (?,0) ", new Object[]{previousPeriodid}).append(" or (fbizperiodid = ? ", new Object[]{bookCurperiodId}).append(" and fisneeddepre='1')) ", new Object[0]).append(" and (fclearperiodid = 0 or fclearperiodid = ?) ", new Object[]{bookCurperiodId}).appendIn(" and fnumber ", numberSet.toArray());
        DataSet finDS = DB.queryDataSet((String)"queryNumberByBookIdAndParse", (DBRoute)faDBRoute, (SqlBuilder)sbSql);
        for (Row row : finDS) {
            Long bizperiodid = row.getLong("bizperiodid");
            if (bizperiodid.longValue() == previousPeriodid.longValue() || bizperiodid == 0L) {
                boolean noValueToDepre;
                BigDecimal originalval = row.getBigDecimal("originalval");
                BigDecimal accumdepre = row.getBigDecimal("accumdepre");
                BigDecimal decval = row.getBigDecimal("decval");
                BigDecimal preresidualval = row.getBigDecimal("preresidualval");
                BigDecimal leftValueToDepre = originalval.subtract(accumdepre).subtract(decval).subtract(preresidualval);
                boolean bl = noValueToDepre = leftValueToDepre.compareTo(BigDecimal.ZERO) == 0;
                if (noValueToDepre) continue;
            }
            cardIds.put(row.getLong("id"), row.getLong("realId"));
        }
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"}), "auditdate"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)bookOrgId), new QFilter("depreuse", "=", (Object)bookDepreuseId), new QFilter("period", "=", (Object)bookCurperiodId)};
        DynamicObjectCollection depreAdjustBills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)selectFields, (QFilter[])filters);
        Set realIdSet = depreAdjustBills.stream().map(v -> v.get(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toSet());
        filters = new QFilter[]{new QFilter("org", "=", (Object)bookOrgId), new QFilter("depreuse", "=", (Object)bookDepreuseId), new QFilter("bizperiod", "<=", (Object)bookCurperiodId), new QFilter("endperiod", ">", (Object)bookCurperiodId), new QFilter("realcard", "in", realIdSet)};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])filters);
        Set _finIds = finCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        for (Object finId : _finIds) {
            cardIds.remove(finId);
        }
        return cardIds;
    }

    private void getAmounts(String bookid, int size, DepreStatusEnum depreStatus, long times, boolean hasCardDepred, String errMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("finishcard", this.depreFinCount + "");
        map.put("cardSize", size + "");
        map.put("status", depreStatus.getValue());
        map.put("times", times + "");
        map.put("hasCardDepred", hasCardDepred + "");
        map.put("errMsg", errMsg);
        this.cache.put(bookid + CACHE_KEY, map);
    }

    private void depreForABatch(DailyDepreImpl dailyDepreImpl, AssetBookDepreData data, Map<String, String> dimField, ObjectPool<Object> objPool, DepreThreadResult depreResult, boolean updateDB, boolean isAddCardLock) {
        this.depreForABatch(dailyDepreImpl, data, depreResult, updateDB, isAddCardLock);
    }

    private void depreForABatch(DailyDepreImpl dailyDepreImpl, AssetBookDepreData data, DepreThreadResult depreResult, boolean updateDB, boolean isAddCardLock) {
        List<DepreAlgoInter> cardBoxDepred = data.bookBox.depreFinCards(data.finCardIdSet, updateDB, isAddCardLock, data.bookBox.isClearPreDepre());
        if (cardBoxDepred == null || cardBoxDepred.isEmpty()) {
            return;
        }
        dailyDepreImpl.finCardCountAdd(cardBoxDepred.size());
        if (!updateDB) {
            Set<String> isNeedFinIds = cardBoxDepred.stream().filter(v -> v.isNeedDepre()).map(v -> v.getCardNumber()).collect(Collectors.toSet());
            depreResult.setNeedDepreFinNums(isNeedFinIds);
            HashMap<String, Map<String, Object>> resultList = new HashMap<String, Map<String, Object>>(1000);
            for (DepreAlgoInter depreCard : cardBoxDepred) {
                if (!depreCard.isClearPreDepre() && !depreCard.isNeedPredictData()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("number", depreCard.getFinCard().getString("number"));
                map.put("originalval", depreCard.getFinCard().get("originalval"));
                map.put("monthdepre", depreCard.getFinCard().get("monthdepre"));
                map.put("accumdepre", depreCard.getFinCard().get("accumdepre"));
                map.put("networth", depreCard.getFinCard().get("networth"));
                map.put("decval", depreCard.getFinCard().get("decval"));
                map.put("netamount", depreCard.getFinCard().get("netamount"));
                map.put("addupyeardepre", depreCard.getFinCard().get("addupyeardepre"));
                map.put("preusingamount", depreCard.getFinCard().get("preusingamount"));
                map.put("depredamount", depreCard.getFinCard().get("depredamount"));
                map.put("preresidualval", depreCard.getFinCard().get("preresidualval"));
                map.put("addidepreamount", depreCard.getFinCard().get("addidepreamount"));
                map.put("curmonthdepre", depreCard.getFinCard().get("curmonthdepre"));
                resultList.put(depreCard.getCardNumber(), map);
            }
            depreResult.setPredictResultMap(resultList);
        }
        if (!data.isLastedPeriod) {
            HashMap<Long, DynamicObject> predictPrefinCardMap = new HashMap<Long, DynamicObject>(cardBoxDepred.size());
            for (DepreAlgoInter depreCard : cardBoxDepred) {
                DynamicObject finCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)depreCard.getFinCard());
                finCard.set("id", depreCard.getFinCard().get("id"));
                predictPrefinCardMap.put((Long)depreCard.getFinCard().get("id"), finCard);
            }
            depreResult.putPredictPrefinCardMap(predictPrefinCardMap);
        }
    }

    public void threadCountAdd() {
        this.finishThreadCount.getAndIncrement();
    }

    public synchronized void finCardCountAdd(int count) {
        this.depreFinCount += count;
    }

    public static class DeprePredictParam {
        private Object orgId;
        private Long depreUseId;
        private DynamicObject predictPeriod;
        private boolean needTemPredictData;
        private boolean addFinishDepreDataToMax;
        private Set<String> numberSet;
        private boolean ignoreUseStatus = false;

        public DeprePredictParam(Object orgId, Long depreUseId, DynamicObject predictPeriod, boolean needTemPredictData, boolean addFinishDepreDataToMax, Set<String> numberSet) {
            this.orgId = orgId;
            this.depreUseId = depreUseId;
            this.predictPeriod = predictPeriod;
            this.needTemPredictData = needTemPredictData;
            this.addFinishDepreDataToMax = addFinishDepreDataToMax;
            this.numberSet = numberSet;
        }

        public Object getOrgId() {
            return this.orgId;
        }

        public Long getDepreUseId() {
            return this.depreUseId;
        }

        public DynamicObject getPredictPeriod() {
            return this.predictPeriod;
        }

        public boolean isNeedTemPredictData() {
            return this.needTemPredictData;
        }

        public boolean isAddFinishDepreDataToMax() {
            return this.addFinishDepreDataToMax;
        }

        public Set<String> getNumberSet() {
            return this.numberSet;
        }

        public boolean isIgnoreUseStatus() {
            return this.ignoreUseStatus;
        }

        public void setIgnoreUseStatus(boolean ignoreUseStatus) {
            this.ignoreUseStatus = ignoreUseStatus;
        }
    }

    static class AssetBookDepreData {
        DepreBook bookBox;
        Set<Long> finCardIdSet;
        Set<Long> realCardIdSet;
        boolean isLastedPeriod = true;
        int disBatchNo;

        public AssetBookDepreData(DepreBook bookBox, Set<Long> finCardIdSet, Set<Long> realCardIdSet) {
            this.bookBox = bookBox;
            this.finCardIdSet = finCardIdSet;
            this.realCardIdSet = realCardIdSet;
        }

        public boolean isLastedPeriod() {
            return this.isLastedPeriod;
        }

        public void setLastedPeriod(boolean isLasted) {
            this.isLastedPeriod = isLasted;
        }

        public String toString() {
            return String.format("%s[%s]", this.bookBox.getBook().get("id"), this.finCardIdSet.toString());
        }

        public int getDisBatchNo() {
            return this.disBatchNo;
        }

        public void setDisBatchNo(int disBatchNo) {
            this.disBatchNo = disBatchNo;
        }
    }

    class DepreThread
    implements Runnable {
        private final ArrayBlockingQueue<DepreThread> queue;
        private final AssetBookDepreData data;
        private final DepreThreadResult depreResult;
        private final Map<String, String> dimField;
        private final Object o;
        private final int threadCount;
        private final DailyDepreImpl dailyDepreImpl;
        private final ObjectPool<Object> objPool;
        private final boolean updateDB;
        private final DepreSplitTask splitTask;
        private final boolean isAddCardLock;

        DepreThread(AssetBookDepreData data, DepreThreadResult depreResult, ArrayBlockingQueue<DepreThread> queue, Map<String, String> dimField, Object o, int listsize, DailyDepreImpl dailyDepreImpl, ObjectPool<Object> objPool, DepreSplitTask splitTask, boolean updateDB, boolean isAddCardLock) {
            this.queue = queue;
            this.data = data;
            this.depreResult = depreResult;
            this.o = o;
            this.objPool = objPool;
            this.dimField = dimField;
            this.threadCount = listsize;
            this.dailyDepreImpl = dailyDepreImpl;
            this.splitTask = splitTask;
            this.updateDB = updateDB;
            this.isAddCardLock = isAddCardLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Object tx = TX.requiresNew();){
                try {
                    FaDisDepreLogEntryInsertPo logEntryInsertPo = new FaDisDepreLogEntryInsertPo(DailyDepreImpl.this.disLogId, this.data.getDisBatchNo());
                    FaDisDepreLogUtils.insertDoingDisDepreLogEntry(logEntryInsertPo);
                    DailyDepreImpl.this.depreForABatch(this.dailyDepreImpl, this.data, this.dimField, this.objPool, this.depreResult, this.updateDB, this.isAddCardLock);
                    if (this.splitTask != null) {
                        this.splitTask.execute(this.data.realCardIdSet);
                    }
                    Integer allConut = 0;
                    if (this.data.realCardIdSet != null) {
                        allConut = this.data.realCardIdSet.size();
                    } else if (this.data.finCardIdSet != null) {
                        allConut = this.data.finCardIdSet.size();
                    }
                    FaDisDepreLogEntryUpdatePo logEntryUpdatePo = new FaDisDepreLogEntryUpdatePo(DailyDepreImpl.this.disLogId, this.data.getDisBatchNo(), DepreStatusEnum2.SUC, allConut);
                    FaDisDepreLogUtils.updateDisDepreLog4SubTask(logEntryUpdatePo, false);
                    tx.commit();
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Exception e) {
                DailyDepreImpl.this.logger.error("FaDepreError:" + ThrowableHelper.toString((Throwable)e));
                this.depreResult.addException(e);
                String detailResult = "FaDepreError:" + ThrowableHelper.toString((Throwable)e);
                Integer allConut = 0;
                if (this.data.realCardIdSet != null) {
                    allConut = this.data.realCardIdSet.size();
                } else if (this.data.finCardIdSet != null) {
                    allConut = this.data.finCardIdSet.size();
                }
                FaDisDepreLogEntryUpdatePo logEntryUpdatePo = new FaDisDepreLogEntryUpdatePo(DailyDepreImpl.this.disLogId, this.data.getDisBatchNo(), DepreStatusEnum2.FAI, allConut);
                logEntryUpdatePo.setErrorLog(detailResult);
                FaDisDepreLogUtils.updateDisDepreLog4SubTask(logEntryUpdatePo, true);
            }
            finally {
                this.dailyDepreImpl.threadCountAdd();
                if (!this.queue.remove(this)) {
                    this.depreResult.addException((Exception)((Object)new KDBizException("DailyDepreImpl remove queue error." + RequestContext.get().getTraceId() + ",Thread:" + Thread.currentThread().getId())));
                }
                if (this.threadCount == this.dailyDepreImpl.finishThreadCount.get()) {
                    Object object = this.o;
                    synchronized (object) {
                        this.o.notifyAll();
                    }
                }
            }
        }
    }
}

