/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.common.util.ThrowableHelper;

public class DepreSplitResult {
    private static final Log logger = LogFactory.getLog(DepreSplitResult.class);
    private BigDecimal residualAmount;
    private final List<Throwable> exceptions = new ArrayList<Throwable>(3);

    DepreSplitResult(BigDecimal residualAmount) {
        if (residualAmount == null) {
            residualAmount = BigDecimal.ZERO;
        }
        this.residualAmount = residualAmount;
    }

    public synchronized void addAmount(BigDecimal residualAmount) {
        if (residualAmount == null) {
            return;
        }
        this.residualAmount = this.residualAmount.add(residualAmount);
    }

    public BigDecimal getAmount() {
        return this.residualAmount;
    }

    public synchronized BigDecimal resetAmount() {
        this.residualAmount = BigDecimal.ZERO;
        return this.residualAmount;
    }

    public synchronized void addException(Throwable e) {
        logger.info("resplit" + ThrowableHelper.toString((Throwable)e));
        this.exceptions.add(e);
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }
}

