/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitTask;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.common.util.Fa;

public class DepreSplitSum {
    protected static DBRoute FA_DBROUTE = new DBRoute("fa");
    protected static final BigDecimal HUNDRED = new BigDecimal(100);
    protected static final String SYSISUSERDEPRESUM = "isuse_depredetail";
    private static final Log logger = LogFactory.getLog(DepreSplitSum.class);

    private void updateDepreSplit4SetUp(Long orgId, Long depreuseId, Long beginPeriodId, Long endPeriodId, boolean genDepreSum, Set<Long> realCardIds, boolean needLock, SplitMode splitMode) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter depreuseFilter = new QFilter("depreuse", "=", (Object)depreuseId);
        QFilter begeinPeriodFilter = new QFilter("period", ">=", (Object)beginPeriodId);
        QFilter endPeriodFilter = null;
        if (endPeriodId != null && endPeriodId > 0L) {
            endPeriodFilter = new QFilter("period", "<=", (Object)endPeriodId);
        }
        HashSet<Long> periodSet = new HashSet<Long>(5);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"depre_setup_resplit", (String)"fa_depre_sum", (String)"period,createtime", (QFilter[])new QFilter[]{orgFilter, depreuseFilter, begeinPeriodFilter, endPeriodFilter}, (String)"period desc");){
            Row row = null;
            while (ds.hasNext()) {
                row = ds.next();
                periodSet.add(row.getLong("period"));
            }
        }
        for (Long periodId : periodSet) {
            if (needLock) {
                this.updateDepreSplit(orgId, depreuseId, periodId, genDepreSum, realCardIds, splitMode);
                continue;
            }
            this.updateDepreSplitnoLock(orgId, depreuseId, periodId, genDepreSum, realCardIds, splitMode);
        }
    }

    public void updateDepreSplit4SetUp(Long orgId, Long depreuseId, Long beginPeriodId, Long endPeriodId, boolean genDepreSum, Set<Long> realCardIds) {
        this.updateDepreSplit4SetUp(orgId, depreuseId, beginPeriodId, endPeriodId, genDepreSum, realCardIds, true, SplitMode.DETAILADDREVERSE);
    }

    public void updateDepreSplit(Long orgId, Long depreuseId, Long curperiodId, boolean genDepreSum, Set<Long> realCardIds, SplitMode splitMode) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfDepreuse = new QFilter("depreuse", "=", (Object)depreuseId);
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"id,curperiod.id,basecurrency", (QFilter[])new QFilter[]{qfOrg, qfDepreuse});
        FunctionMutexHelper.lockWithBook("fa_depresplitsetup", assetBook, () -> this.innerExcuteDepreSplit(orgId, depreuseId, curperiodId, genDepreSum, realCardIds, splitMode));
    }

    private void updateDepreSplitnoLock(Long orgId, Long depreuseId, Long curperiodId, boolean genDepreSum, Set<Long> realCardIds, SplitMode splitMode) {
        this.innerExcuteDepreSplit(orgId, depreuseId, curperiodId, genDepreSum, realCardIds, splitMode);
    }

    public void updateDepreSplit4ChangeBill(Long orgId, Long depreuseId, Set<Long> realCardIds) {
        this.innerExcuteDepreSplit(orgId, depreuseId, null, true, realCardIds, SplitMode.DETAILADDREVERSE);
    }

    public void repairDepreSplit(Long orgId, Long depreuseId, Long curperiodId) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfDepreuse = new QFilter("depreuse", "=", (Object)depreuseId);
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"id,curperiod.id,basecurrency", (QFilter[])new QFilter[]{qfOrg, qfDepreuse});
        Long periodId = (Long)assetBook.get("curperiod.id");
        if (FaDepreUtil.hasVoucher(orgId, depreuseId, periodId, true)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DepreSplitSum_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        FunctionMutexHelper.lockWithBook("fa_depresplitsetup", assetBook, () -> this.innerRepairDepreSplit(orgId, depreuseId, curperiodId));
    }

    public void repairDepreSplit4Multi(Long orgId, Long depreuseId, Long curperiodId) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfDepreuse = new QFilter("depreuse", "=", (Object)depreuseId);
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"id,curperiod.id,basecurrency", (QFilter[])new QFilter[]{qfOrg, qfDepreuse});
        Long periodId = (Long)assetBook.get("curperiod.id");
        if (FaDepreUtil.hasVoucher(orgId, depreuseId, periodId, false)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DepreSplitSum_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        FunctionMutexHelper.lockWithBook("fa_depresplitsetup", assetBook, () -> {
            DepreSplitTask task = new DepreSplitTask(orgId, depreuseId, curperiodId, true, false, SplitMode.DETAILADDREVERSE);
            task.setBeginDate(new Date());
            task.executeRepair4Muti();
        });
    }

    private void innerRepairDepreSplit(Long orgId, Long depreuseId, Long curperiodId) {
        DepreSplitTask task = new DepreSplitTask(orgId, depreuseId, curperiodId, true, false, SplitMode.DETAILADDREVERSE);
        task.setBeginDate(new Date());
        task.execute4Repair();
    }

    private void innerExcuteDepreSplit(Long orgId, Long depreuseId, Long curperiodId, boolean genDepreSum, Set<Long> realCardIds, SplitMode splitMode) {
        DepreSplitTask task = new DepreSplitTask(orgId, depreuseId, curperiodId, genDepreSum, false, splitMode);
        task.setBeginDate(new Date());
        task.execute(realCardIds);
        task.close();
    }

    /*
     * WARNING - void declaration
     */
    public void deduct(DynamicObject[] finCards, boolean includeCurPeriod, boolean needLock) {
        Long[] periodIds;
        void var7_9;
        HashMap<String, HashSet<Long>> dataMap = new HashMap<String, HashSet<Long>>(finCards.length);
        DynamicObject[] dynamicObjectArray = finCards;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            DynamicObject fincard = dynamicObjectArray[var7_9];
            String key = Fa.join((String)"-", (String[])new String[]{fincard.getString("org.id"), fincard.getString("depreuse.id")});
            HashSet<Long> cardIds = (HashSet<Long>)dataMap.get(key);
            if (cardIds == null) {
                cardIds = new HashSet<Long>(finCards.length);
                dataMap.put(key, cardIds);
            }
            cardIds.add(fincard.getLong("realcardmasterid"));
            ++var7_9;
        }
        HashMap<String, Long[]> nextPeriodMap = new HashMap<String, Long[]>(dataMap.size());
        for (String string : dataMap.keySet()) {
            String[] assets = string.split("-");
            periodIds = FaBizUtils.getNextPeriodByDepre(Long.parseLong(assets[0]), Long.parseLong(assets[1]), 1);
            nextPeriodMap.put(string, periodIds);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            Long nextPeriod;
            String[] key = ((String)entry.getKey()).split("-");
            periodIds = (Long[])nextPeriodMap.get(Fa.join((String)"-", (String[])new String[]{key[0], key[1]}));
            Long l = nextPeriod = includeCurPeriod ? periodIds[0] : periodIds[1];
            if (nextPeriod == 0L) continue;
            this.updateDepreSplit4SetUp(Long.valueOf(key[0]), Long.valueOf(key[1]), nextPeriod, null, true, (Set)entry.getValue(), needLock, SplitMode.DELEINCOUCHER);
        }
    }

    public void deductForFinCard(DynamicObject[] finCards, boolean needLock) {
        HashMap<String, Set> dataMap = new HashMap<String, Set>(16);
        for (DynamicObject finCard : finCards) {
            long beginPeriodId = finCard.getLong(Fa.id((String)"period"));
            if (beginPeriodId == 0L) {
                DynamicObject assetBook = finCard.getDynamicObject("assetbook");
                beginPeriodId = assetBook.getLong(Fa.id((String)"startperiod"));
            }
            long orgId = finCard.getLong(Fa.id((String)"org"));
            long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            String key = orgId + "-" + depreUseId + "-" + beginPeriodId;
            Set cardIds = dataMap.computeIfAbsent(key, k -> new HashSet(finCards.length));
            long masterId = finCard.getLong(Fa.dot((String[])new String[]{"realcard", "masterid"}));
            cardIds.add(masterId);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            String[] key = ((String)entry.getKey()).split("-");
            long orgId = Long.parseLong(key[0]);
            long depreUseId = Long.parseLong(key[1]);
            long beginPeriodId = Long.parseLong(key[2]);
            this.updateDepreSplit4SetUp(orgId, depreUseId, beginPeriodId, null, true, (Set)entry.getValue(), needLock, SplitMode.DELEINCOUCHER);
        }
    }
}

