/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depretask;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitDetailUtils;
import kd.fi.fa.business.depretask.DepreSplitResult;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class DepreSplitSumUtils {
    private static final Log logger = LogFactory.getLog(DepreSplitSumUtils.class);
    protected static final String ALGOKEY = "DepreSplitSumUtils";
    protected static final String defaultSelectFields = "assetcat,totalsplitdept,orgduty,";

    /*
     * WARNING - void declaration
     */
    protected static void genDepreSumEntry(DynamicObject depreSum, DepreSplitResult depreSplitResult, Map<String, String> dimFieldMap, Long orgId, Long depreUseId, Long periodId, Set<Long> reverseSumIds, boolean generaSum) {
        long sumStartTime = System.currentTimeMillis();
        DynamicObjectCollection depreSumEntries = depreSum.getDynamicObjectCollection("depresplitsum");
        depreSumEntries.clear();
        depreSplitResult.resetAmount();
        String dimSumSql = DepreSplitDetailUtils.getDimSql(dimFieldMap, "T1");
        dimSumSql = "".equals(dimSumSql) ? "" : "," + dimSumSql + " ";
        StringBuilder querySql = new StringBuilder("SELECT");
        querySql.append(" T1.FSPLITDEPTID deptid,T1.fassetcatid assetcatid, T1.fsplitdeptid splitdeptid, T2.fcostcentrerid costcentrerid,T2.fproductlineid productlineid,");
        querySql.append(" T2.forgdutyid orgdutyid,T2.fassinfo assinfo, T2.fsplitamount fsplitamount ");
        querySql.append(dimSumSql);
        querySql.append(" FROM T_FA_DEPRESPLITDETAIL T1 ").append(" INNER JOIN T_FA_DEPREDETAILENTRY T2 ON T1.FDETAILSID=T2.FDETAILSID ").append(" WHERE T1.FORGID = ? AND T1.FDEPREUSEID= ? AND T1.FPERIODID = ?");
        HashMap<Object, Object> sumGroupMap = new HashMap<Object, Object>(200);
        try (DataSet ds = DB.queryDataSet((String)"DepreSplitSumUtilssetupDataSet", (DBRoute)new DBRoute("fa"), (String)querySql.toString(), (Object[])new Object[]{orgId, depreUseId, periodId});){
            while (ds.hasNext()) {
                void var18_21;
                String lastChar;
                Row row = ds.next();
                HashMap<String, Long> dimMap = new HashMap<String, Long>(10);
                dimMap.put("assetcatid", row.getLong("assetcatid"));
                dimMap.put("splitdeptid", row.getLong("splitdeptid"));
                dimMap.put("costcentrerid", row.getLong("costcentrerid"));
                dimMap.put("productlineid", row.getLong("productlineid"));
                for (Map.Entry<String, String> entry : dimFieldMap.entrySet()) {
                    dimMap.put(entry.getKey(), (Long)row.get(entry.getValue()));
                }
                dimMap.put("orgdutyid", row.getLong("orgdutyid") == null ? Long.valueOf(0L) : row.getLong("orgdutyid"));
                String string = row.getString("assinfo");
                int n = string.length();
                if (n > 1 && (lastChar = string.substring(n - 1, n)).equals(";")) {
                    String string2 = string.substring(0, n - 1);
                }
                dimMap.put("assinfo", (Long)var18_21);
                Object amount = (BigDecimal)sumGroupMap.get(dimMap);
                amount = amount == null ? row.getBigDecimal("fsplitamount") : row.getBigDecimal("fsplitamount").add((BigDecimal)amount);
                sumGroupMap.put(dimMap, amount);
            }
            if (generaSum && reverseSumIds.size() > 0) {
                Map<Map<String, Object>, BigDecimal> reverseSumEntryMap = DepreSplitSumUtils.genReverseSumEntry(reverseSumIds, dimFieldMap, dimSumSql);
                for (Map.Entry entry : reverseSumEntryMap.entrySet()) {
                    if (sumGroupMap.containsKey(entry.getKey())) {
                        BigDecimal bigDecimal2 = (BigDecimal)sumGroupMap.get(entry.getKey());
                        bigDecimal2 = ((BigDecimal)entry.getValue()).add(bigDecimal2);
                        sumGroupMap.put(entry.getKey(), bigDecimal2);
                        continue;
                    }
                    sumGroupMap.put(entry.getKey(), entry.getValue());
                }
                ArrayList deleteSumGroupMap = new ArrayList(16);
                for (Map.Entry entry : sumGroupMap.entrySet()) {
                    if (((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) != 0) continue;
                    deleteSumGroupMap.add(entry.getKey());
                }
                for (Map map : deleteSumGroupMap) {
                    sumGroupMap.remove(map);
                }
            }
            DynamicObject entry = null;
            int seq = 1;
            for (Map.Entry entry2 : sumGroupMap.entrySet()) {
                entry = depreSumEntries.addNew();
                entry.set("seq", (Object)seq++);
                entry.set("totalsplitamount", entry2.getValue());
                depreSplitResult.addAmount((BigDecimal)entry2.getValue());
                entry.set("totalsplitdept", ((Map)entry2.getKey()).get("splitdeptid"));
                entry.set("orgduty", ((Map)entry2.getKey()).get("orgdutyid"));
                entry.set("totalcostcentrer", ((Map)entry2.getKey()).get("costcentrerid"));
                entry.set("totalproductline", ((Map)entry2.getKey()).get("productlineid"));
                for (Map.Entry entry3 : dimFieldMap.entrySet()) {
                    entry.set((String)entry3.getKey(), ((Map)entry2.getKey()).get(entry3.getKey()));
                }
                Object assInfo = ((Map)entry2.getKey()).get("assinfo");
                if (assInfo == null) continue;
                DepreSplitSumUtils.setAssSubEntry(assInfo.toString(), entry.getDynamicObjectCollection("depresplitsubentry"));
            }
        }
        depreSum.set("totaldepreamount", (Object)depreSplitResult.getAmount());
        long SumUsedTime = System.currentTimeMillis() - sumStartTime;
        logger.info("------\u7528\u65f6\uff1a\u751f\u6210\u6c47\u603b\u6570\u636e\uff0c\u4e00\u5171\u7528\u65f6" + SumUsedTime + "ms\uff01");
    }

    private static Map<Map<String, Object>, BigDecimal> genReverseSumEntry(Set<Long> reverseSumIds, Map<String, String> dimFieldMap, String dimSumSql) {
        Map<String, Long> sumEntryMap;
        HashMap<Long, Object[]> sumEntryId2List = new HashMap<Long, Object[]>(200);
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("depresplitsum.id,depresplitsum.assetcat,depresplitsum.totalsplitdept,depresplitsum.totalsplitamount,depresplitsum.orgduty,depresplitsum.totalcostcentrer,depresplitsum.totalproductline,");
        for (Map.Entry<String, String> field : dimFieldMap.entrySet()) {
            if (defaultSelectFields.contains(field.getKey())) continue;
            selectFields.append("depresplitsum.").append(field.getKey()).append(",");
        }
        selectFields.append("depresplitsum.depresplitsubentry.asstype,depresplitsum.depresplitsubentry.assid");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)reverseSumIds.toArray())};
        DynamicObjectCollection existedVouncherSumes = QueryServiceHelper.query((String)"fa_depre_sum", (String)selectFields.toString(), (QFilter[])filters);
        for (DynamicObject existedVouncherSum : existedVouncherSumes) {
            Long sumEntryId = existedVouncherSum.getLong("depresplitsum.id");
            if (sumEntryId2List.get(sumEntryId) == null) {
                sumEntryMap = new HashMap<String, Long>(16);
                sumEntryMap.put("assetcatid", existedVouncherSum.getLong("depresplitsum.assetcat"));
                sumEntryMap.put("splitdeptid", existedVouncherSum.getLong("depresplitsum.totalsplitdept"));
                sumEntryMap.put("costcentrerid", existedVouncherSum.getLong("depresplitsum.totalcostcentrer"));
                sumEntryMap.put("productlineid", existedVouncherSum.getLong("depresplitsum.totalproductline"));
                for (Map.Entry<String, String> field : dimFieldMap.entrySet()) {
                    Object value = existedVouncherSum.get("depresplitsum." + field.getKey());
                    sumEntryMap.put(field.getKey(), (Long)value);
                }
                sumEntryMap.put("orgdutyid", existedVouncherSum.getLong("depresplitsum.orgduty"));
                String asstype = existedVouncherSum.getString("depresplitsum.depresplitsubentry.asstype");
                String assid = existedVouncherSum.getString("depresplitsum.depresplitsubentry.assid");
                String asstypeValue = "";
                if (asstype != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(asstype).append("|").append(assid);
                    asstypeValue = sb.toString();
                }
                sumEntryMap.put("assinfo", (Long)((Object)asstypeValue));
                BigDecimal amount = existedVouncherSum.getBigDecimal("depresplitsum.totalsplitamount").negate();
                Object[] sumEntrykey_value = new Object[]{sumEntryMap, amount};
                sumEntryId2List.put(sumEntryId, sumEntrykey_value);
                continue;
            }
            Object[] sumEntrykey_value = (Object[])sumEntryId2List.get(sumEntryId);
            Map sumEntryMap2 = (Map)sumEntrykey_value[0];
            String assinfo = (String)sumEntryMap2.get("assinfo");
            String asstype = existedVouncherSum.getString("depresplitsum.depresplitsubentry.asstype");
            String assid = existedVouncherSum.getString("depresplitsum.depresplitsubentry.assid");
            StringBuilder sb = new StringBuilder();
            sb.append(assinfo);
            if (asstype != null) {
                sb.append(";").append(asstype).append("|").append(assid);
            }
            sumEntryMap2.put("assinfo", sb.toString());
        }
        HashMap<Map<String, Object>, BigDecimal> sumEntryMap2Amount = new HashMap<Map<String, Object>, BigDecimal>(200);
        for (Object[] sumEntrykey_value : sumEntryId2List.values()) {
            sumEntryMap = (Map)sumEntrykey_value[0];
            BigDecimal totalsplitdept = (BigDecimal)sumEntrykey_value[1];
            if (sumEntryMap2Amount.get(sumEntryMap) == null) {
                sumEntryMap2Amount.put(sumEntryMap, totalsplitdept);
                continue;
            }
            BigDecimal updatedTotalsplitdept = (BigDecimal)sumEntryMap2Amount.get(sumEntryMap);
            updatedTotalsplitdept = updatedTotalsplitdept.add(totalsplitdept);
            sumEntryMap2Amount.put(sumEntryMap, updatedTotalsplitdept);
        }
        return sumEntryMap2Amount;
    }

    private static void setAssSubEntry(String assInfo, DynamicObjectCollection subentries) {
        subentries.clear();
        String[] assCol = assInfo.split(";");
        int seq = 1;
        for (String ass : assCol) {
            String[] arrass = ass.split("\\|");
            if (arrass.length != 2) continue;
            DynamicObject depreassDy = subentries.addNew();
            depreassDy.set("seq", (Object)seq);
            depreassDy.set("asstype", (Object)arrass[0]);
            depreassDy.set("assid", (Object)arrass[1]);
            ++seq;
        }
    }

    protected static DynamicObject initDepresplitSum(Long orgId, Long depreuseId, Long periodId, DynamicObject assetBook) {
        Date now;
        DynamicObject depresplit = BusinessDataServiceHelper.newDynamicObject((String)"fa_depre_sum");
        depresplit.set("id", (Object)DBServiceHelper.genLongIds((String)"T_FA_DEPRE", (int)1)[0]);
        depresplit.set("billno", (Object)Fa.getTF2().format(new Date()));
        depresplit.set("org", (Object)orgId);
        depresplit.set("depreuse", (Object)depreuseId);
        depresplit.set("period", (Object)periodId);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"begindate,enddate");
        Date begindate = period.getDate("begindate");
        Date enddate = period.getDate("enddate");
        Date bizDate = now = TimeServiceHelper.now();
        bizDate = now.before(begindate) ? begindate : (now.after(enddate) ? enddate : now);
        bizDate = DateUtil.stripTime((Date)bizDate);
        depresplit.set("bizdate", (Object)bizDate);
        depresplit.set("creator", (Object)ContextUtil.getUserId());
        depresplit.set("createtime", (Object)new Date());
        depresplit.set("modifier", (Object)ContextUtil.getUserId());
        depresplit.set("modifytime", (Object)new Date());
        depresplit.set("billstatus", (Object)"B");
        depresplit.set("deprestatus", (Object)"1");
        depresplit.set("auditor", (Object)ContextUtil.getUserId());
        depresplit.set("auditdate", (Object)new Date());
        depresplit.set("currency", (Object)assetBook.getLong("basecurrency.id"));
        depresplit.set("assetbook", (Object)assetBook.getLong("id"));
        return depresplit;
    }

    protected static String isSameVersion(SortedMap<String, String> dimFieldMap, DynamicObject splitSchema, String oldVersion) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dimFieldMap.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
        }
        int prime = 31;
        long result = 17L;
        result = 31L * result + (long)(sb.length() > 0 ? sb.toString().hashCode() : 0);
        StringBuilder sb2 = new StringBuilder();
        if (splitSchema != null) {
            sb2.append(";").append(splitSchema.getString("text"));
        }
        result = 31L * result + (long)(sb2.length() > 0 ? sb2.toString().hashCode() : 0);
        String newVersion = result + "";
        return newVersion.equals(oldVersion) ? null : newVersion;
    }

    protected static void save(DynamicObject depreSum, boolean generaSum) {
        if (DepreSplitSumUtils.isSaveSum(depreSum, generaSum)) {
            if (depreSum.getDate("auditdate") != null) {
                depreSum.set("billstatus", (Object)"C");
                depreSum.set("deprestatus", (Object)"2");
            } else {
                QFilter[] depreFilters;
                boolean isExistDepre;
                Long orgId = depreSum.getLong("org.id");
                Long periodid = depreSum.getLong("period.id");
                if (orgId == 0L) {
                    orgId = depreSum.getLong("org");
                    periodid = depreSum.getLong("period");
                }
                if (isExistDepre = QueryServiceHelper.exists((String)"fa_depre_sum", (QFilter[])(depreFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", (Object)periodid)}))) {
                    depreSum.set("billstatus", (Object)"C");
                    depreSum.set("deprestatus", (Object)"2");
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{depreSum});
            DataEntityCacheManager cacheManager = new DataEntityCacheManager("T_FA_DEPRE");
            cacheManager.removeByPrimaryKey(new Object[]{depreSum.getPkValue()});
            ArrayList<Object> sumIds = new ArrayList<Object>();
            sumIds.add(depreSum.getPkValue());
            DepreSplitSumUtils.saveIntelliWhitelist(sumIds.toArray(), "fa_depre_sum");
        } else {
            DeleteServiceHelper.delete((IDataEntityType)depreSum.getDataEntityType(), (Object[])new Long[]{depreSum.getLong("id")});
        }
    }

    protected static boolean isSaveSum(DynamicObject depreSum, boolean generaSum) {
        BigDecimal totalDepreAmount = depreSum.getBigDecimal("totaldepreamount");
        if (totalDepreAmount.compareTo(BigDecimal.ZERO) != 0) {
            return true;
        }
        if (generaSum) {
            DynamicObjectCollection sumEntry = depreSum.getDynamicObjectCollection("depresplitsum");
            if (sumEntry == null || sumEntry.size() == 0) {
                return false;
            }
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)depreSum.getLong("id"))};
            DynamicObjectCollection detailEntry = QueryServiceHelper.query((String)"fa_depre_sum", (String)"assentry.id", (QFilter[])filters, null, (int)1);
            if (detailEntry == null || detailEntry.size() == 0) {
                return false;
            }
            DynamicObject detail0 = (DynamicObject)detailEntry.get(0);
            Long assentryId = detail0.getLong("assentry.id");
            if (assentryId == 0L) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static void saveIntellBusiness(Object[] entityIds, String entityKey) {
        QFilter[] filters = new QFilter[]{new QFilter("business", "=", (Object)entityKey), new QFilter("entityid", "in", (Object)entityIds)};
        DynamicObjectCollection bizTasks = QueryServiceHelper.query((String)"iep_businesstask", (String)"entityid", (QFilter[])filters);
        Set existEntityId = bizTasks.stream().map(v -> v.get("entityid")).collect(Collectors.toSet());
        ArrayList<DynamicObject> intellBusinesses = new ArrayList<DynamicObject>(entityIds.length);
        for (Object id : entityIds) {
            if (existEntityId.contains(id)) continue;
            DynamicObject intellBusiness = DepreSplitSumUtils.createIntellBusinessDb(id, entityKey);
            intellBusinesses.add(intellBusiness);
        }
        SaveServiceHelper.save((DynamicObject[])intellBusinesses.toArray(new DynamicObject[0]));
    }

    public static void saveIntelliWhitelist(Object[] entityIds, String entityKey) {
        if (entityIds == null || entityIds.length == 0) {
            logger.info("entityKey[{}]: entityIds\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u5ba1\u6838\u540c\u6b65\u65b0\u767d\u540d\u5355\u64cd\u4f5c\uff01", (Object)entityKey);
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapCommonOperationService", (String)"whiteListOperation", (Object[])new Object[]{entityKey, "audit", Arrays.stream(entityIds).collect(Collectors.toList()), 1});
    }

    private static DynamicObject createIntellBusinessDb(Object entityId, String entityKey) {
        DynamicObject intellBusiness = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"iep_businesstask"));
        intellBusiness.set("business", (Object)entityKey);
        intellBusiness.set("oper", (Object)"buildvoucher");
        intellBusiness.set("entityid", entityId);
        return intellBusiness;
    }

    @Deprecated
    public static void deleteIntellBusiness(Object[] entityIds, String entityKey) {
        QFilter[] filters = new QFilter[]{new QFilter("business", "=", (Object)entityKey), new QFilter("entityid", "in", (Object)entityIds)};
        DeleteServiceHelper.delete((String)"iep_businesstask", (QFilter[])filters);
    }

    public static void deleteIntelliWhitelist(Object[] entityIds, String entityKey) {
        if (entityIds == null || entityIds.length == 0) {
            logger.info("entityKey[{}]: entityIds\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u53cd\u5ba1\u6838\u540c\u6b65\u65b0\u767d\u540d\u5355\u64cd\u4f5c\uff01", (Object)entityKey);
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapCommonOperationService", (String)"whiteListOperation", (Object[])new Object[]{entityKey, "audit", Arrays.stream(entityIds).collect(Collectors.toList()), 0});
    }

    protected static SortedMap<String, String> getDimFields() {
        TreeMap<String, String> dimFieldMap = new TreeMap<String, String>();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        EntityType depreSplitSum = (EntityType)EntityMetadataCache.getDataEntityType((String)"fa_depre_sum").getAllEntities().get("depresplitsum");
        if (depreSplitSum != null) {
            Map tt = depreSplitSum.getFields();
            for (String key : tt.keySet()) {
                if ("totalsplitdept".equals(key) || "totalsplitamount".equals(key) || met.getProperty(key) == null) continue;
                DynamicProperty prop = met.getProperty(key);
                dimFieldMap.put(prop.getName(), prop.getAlias());
            }
        }
        return dimFieldMap;
    }

    protected static void updateDepreStatus(DynamicObject depreObj, String depreStatus) {
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depre set fdeprestatus = ? where fid = ?", (Object[])new Object[]{depreStatus, depreObj.getLong("id")});
    }

    protected static void initSumAssEntry(Long orgId, Long depreUseId, Long periodId, DynamicObject depreSum, List<String> schemaFields) {
        Long depreSumId = depreSum.getLong("id");
        if (depreSum.getDataEntityState().getFromDatabase()) {
            String sql = "delete from t_fa_depresum_assentry where fid = " + depreSumId;
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql);
        }
        HashSet<String> assTypeSet = new HashSet<String>(8);
        if (schemaFields != null) {
            for (String schemaField : schemaFields) {
                String[] split = schemaField.split(":");
                assTypeSet.add(split[0]);
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("beginperiod", "<=", (Object)periodId), new QFilter("endperiod", ">", (Object)periodId), new QFilter("status", "=", (Object)BillStatus.C.name())};
        DynamicObject[] splitSetUpList = BusinessDataServiceHelper.load((String)"fa_depresplitsetup", (String)"asstypes", (QFilter[])filters);
        for (DynamicObject splitSetUp : splitSetUpList) {
            DynamicObjectCollection mulAssTypesCollection = splitSetUp.getDynamicObjectCollection("asstypes");
            for (DynamicObject item : mulAssTypesCollection) {
                DynamicObject asstActType = item.getDynamicObject("fbasedataid");
                String valueSourceId = asstActType.getString("valuesource_id");
                if ("bos_assistantdata_detail".equals(valueSourceId)) {
                    String assistantTypeId = asstActType.getString("assistanttype_id");
                    assTypeSet.add(assistantTypeId);
                    continue;
                }
                assTypeSet.add(valueSourceId);
            }
        }
        if (!assTypeSet.isEmpty()) {
            long[] entryIds = DBServiceHelper.genLongIds((String)"t_fa_depresum_assentry", (int)assTypeSet.size());
            ArrayList<Object[]> params = new ArrayList<Object[]>(assTypeSet.size());
            int i = 0;
            for (String assType : assTypeSet) {
                Object[] objs = new Object[]{depreSumId, entryIds[i], i + 1, assType};
                params.add(objs);
                ++i;
            }
            String sql = "INSERT INTO T_FA_DEPRESUM_ASSENTRY (FID, FENTRYID, FSEQ, FASSTYPE) VALUES (?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
        }
    }
}

