/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.lease.LeaseContractCal;
import kd.fi.fa.business.lease.convert.AbstractLeaseContractConverter;
import kd.fi.fa.business.lease.convert.LeaseContractData;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseContractGenerator {
    private final AbstractLeaseContractConverter converter;

    public LeaseContractGenerator(AbstractLeaseContractConverter converter) {
        this.converter = converter;
    }

    public List<DynamicObject> generate(boolean isGenId) {
        List<LeaseContractData> contractDataList = this.converter.convert();
        ArrayList<DynamicObject> contractList = new ArrayList<DynamicObject>(contractDataList.size());
        for (LeaseContractData data : contractDataList) {
            DynamicObject leaseContract = BusinessDataServiceHelper.newDynamicObject((String)"fa_lease_contract");
            this.generateBillHead(leaseContract, data);
            this.setBillHeadLk(leaseContract, data);
            this.handleAutoCalFields(leaseContract);
            contractList.add(leaseContract);
        }
        if (isGenId) {
            this.generateId(contractList);
        }
        return contractList;
    }

    private void generateBillHead(DynamicObject leaseContract, LeaseContractData data) {
        leaseContract.set("assetunit", (Object)data.getAssetUnit());
        leaseContract.set("org", (Object)data.getOrg());
        leaseContract.set("currency", (Object)data.getCurrency());
        leaseContract.set("name", (Object)data.getContractName());
        leaseContract.set("leaser", (Object)data.getLeaser());
        leaseContract.set("assetcat", (Object)data.getAssetCat());
        leaseContract.set("assetname", (Object)data.getAssetName());
        leaseContract.set("storeplace", (Object)data.getStorePlace());
        leaseContract.set("unit", (Object)data.getUnit());
        leaseContract.set("assetamount", (Object)data.getAssetAmount());
        leaseContract.set("leasestartdate", (Object)data.getLeaseStartDate());
        leaseContract.set("leaseenddate", (Object)data.getLeaseEndDate());
        leaseContract.set("srccontract", (Object)data.getSrcContract());
        leaseContract.set("enable", (Object)"1");
        leaseContract.set("status", (Object)BillStatus.A.name());
        leaseContract.set("bizstatus", (Object)LeaseContractBizStatus.A.name());
        leaseContract.set("assetqtycreate", (Object)1);
        leaseContract.set("isbak", (Object)Boolean.FALSE);
        leaseContract.set("version", (Object)"0");
        leaseContract.set("sourcetype", (Object)LeaseContractSourceType.A.name());
        leaseContract.set("isinitdata", (Object)Boolean.TRUE);
        leaseContract.set(Fa.join((String)"_", (String[])new String[]{"creator", "id"}), (Object)ContextUtil.getUserId());
        leaseContract.set("createtime", (Object)new Date());
    }

    private void setBillHeadLk(DynamicObject leaseContract, LeaseContractData data) {
        String srcEntityNumber = data.getSrcEntityNumber();
        Object srcBillId = data.getSrcBillId();
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillId == null) {
            return;
        }
        MainEntityType leaseContractType = EntityMetadataCache.getDataEntityType((String)"fa_lease_contract");
        DynamicObjectType billHeadType = ((EntryProp)leaseContractType.getProperty("billhead_lk")).getDynamicCollectionItemPropertyType();
        long leaseContractTableId = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntityNumber).getTableId();
        DynamicObjectCollection billHeads = leaseContract.getDynamicObjectCollection("billhead_lk");
        DynamicObject billHead = new DynamicObject(billHeadType);
        billHead.set("billhead_lk_stableid", (Object)leaseContractTableId);
        billHead.set("billhead_lk_sbillid", data.getSrcBillId());
        billHead.set("billhead_lk_sid", data.getSrcBillId());
        billHead.set("seq", (Object)1);
        billHeads.add((Object)billHead);
    }

    private void handleAutoCalFields(DynamicObject leaseContract) {
        DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(leaseContract);
        LeaseContractCal.setLeaseMonths(objWrapper);
        LeaseContractCal.setInitConfirmDate(objWrapper);
        LeaseContractCal.setLeaseTermStartDate(objWrapper);
        LeaseContractCal.setIsExempt(objWrapper);
        LeaseContractCal.setDiscountRate(objWrapper);
        LeaseContractCal.setDailyDiscountRate(objWrapper);
        LeaseContractCal.setDepreMonths(objWrapper);
    }

    private void generateId(List<DynamicObject> leaseContracts) {
        if (leaseContracts.isEmpty()) {
            return;
        }
        IDataEntityType dt = leaseContracts.get(0).getDataEntityType();
        long[] ids = DBServiceHelper.genLongIds((String)dt.getAlias(), (int)leaseContracts.size());
        for (int i = 0; i < ids.length; ++i) {
            leaseContracts.get(i).set("id", (Object)ids[i]);
        }
    }
}

