/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.lease.RentSettleGenerator;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class RentSettleGenerator4LeaseChange
extends RentSettleGenerator {
    private final DynamicObject leaseContract;
    private final DynamicObject interestDetail;
    private final long curPeriodId;
    private int beginIndex4Generate = 0;

    public RentSettleGenerator4LeaseChange(DynamicObject leaseContract, DynamicObject interestDetail, long curPeriodId) {
        super(null);
        this.leaseContract = leaseContract;
        this.interestDetail = interestDetail;
        this.curPeriodId = curPeriodId;
    }

    @Override
    public void reverse() {
        throw new KDBizException(ResManager.loadKDString((String)"\u7528\u4e8e\u79df\u8d41\u53d8\u66f4\u7684\u79df\u91d1\u7ed3\u7b97\u751f\u6210\u5668\u4e0d\u652f\u6301\u53cd\u51b2\u3002", (String)"RentSettleGenerator4LeaseChange_4", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    @Override
    public void generate() {
        throw new KDBizException(ResManager.loadKDString((String)"\u7528\u4e8e\u79df\u8d41\u53d8\u66f4\u7684\u79df\u91d1\u7ed3\u7b97\u751f\u6210\u5668\u4e0d\u652f\u6301\u6b63\u5e38\u751f\u6210\u3002", (String)"RentSettleGenerator4LeaseChange_1", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    @Override
    protected int getBeginIndex4Generate() {
        return this.beginIndex4Generate;
    }

    @Override
    protected boolean isBeginGenerate(long amortizationPeriodId) {
        return amortizationPeriodId >= this.curPeriodId;
    }

    public void regenerate() {
        ArrayList<DynamicObject> rentSettleList = new ArrayList<DynamicObject>(32);
        DynamicObjectCollection allRentSettles = this.queryAllRentSettle();
        this.deleteRentSettleAndSetBeginIndex(allRentSettles);
        rentSettleList.addAll(super.generateByInterestDetail(this.interestDetail, this.leaseContract));
        LeaseUtil.saveRentSettle(rentSettleList.toArray(new DynamicObject[0]), true);
    }

    private void deleteRentSettleAndSetBeginIndex(DynamicObjectCollection allRentSettles) {
        DynamicObject rentSettle = null;
        for (DynamicObject dyn : allRentSettles) {
            long amortizationPeriodId = dyn.getLong("amortizationperiod");
            if (amortizationPeriodId < this.curPeriodId) continue;
            rentSettle = dyn;
            break;
        }
        if (rentSettle != null) {
            Tuple<String, String> billNoTuple = this.splitBillNo(rentSettle.getString("billno"));
            this.beginIndex4Generate = Integer.parseInt((String)billNoTuple.item2);
        } else {
            this.beginIndex4Generate = allRentSettles.size() + 1;
        }
        this.deleteSubsequentRentSettle();
    }

    private void deleteSubsequentRentSettle() {
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "=", (Object)this.leaseContract.getLong("id")), new QFilter("amortizationperiod", ">=", (Object)this.curPeriodId)};
        LeaseUtil.deleteRentSettle(filters, true);
    }

    private DynamicObjectCollection queryAllRentSettle() {
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "=", (Object)this.leaseContract.getLong("id"))};
        String selectFields = Fa.comma((String[])new String[]{"id", "billno", "amortizationperiod"});
        return QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)selectFields, (QFilter[])filters, (String)"amortizationperiod ASC");
    }

    private Tuple<String, String> splitBillNo(String billNo) {
        int index = billNo.lastIndexOf("-");
        String contractNumber = billNo.substring(0, index);
        String seq = billNo.substring(index + 1);
        return new Tuple((Object)contractNumber, (Object)seq);
    }
}

