/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.backup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.BackupMode;
import kd.fi.fa.business.lease.backup.LeaseContractAllDataCopy;
import kd.fi.fa.business.lease.backup.LeaseContractBackupInnerUtils;
import kd.fi.fa.business.lease.backup.LeaseContractBaseDataCopy;
import kd.fi.fa.business.lease.backup.LeaseContractRestore2Code;
import kd.fi.fa.business.lease.backup.RestoreLeaseContractInfo;

public class LeaseContractBackupUtils {
    static final String SELECT_CONTRACT_FIELDS = "id,previousbackid,masterid,version,isbak";

    public static DynamicObject backup(Long contractId, BackupMode backupMode) {
        ArrayList<Long> contractIdList = new ArrayList<Long>(1);
        contractIdList.add(contractId);
        Map<String, DynamicObject> result = LeaseContractBackupUtils.backup(contractIdList, backupMode);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(contractId + "");
    }

    public static Map<String, DynamicObject> backup(List<Long> contractIds, BackupMode backupMode) {
        if (contractIds == null || contractIds.size() == 0) {
            return null;
        }
        LeaseContractBaseDataCopy copyScheme = null;
        if (backupMode.name().equals(BackupMode.BASICDATA.name())) {
            copyScheme = new LeaseContractBaseDataCopy();
        } else if (backupMode.name().equals(BackupMode.ALLDATA.name())) {
            copyScheme = new LeaseContractAllDataCopy();
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5907\u4efd\u6a21\u5f0f[%s]", (String)"LeaseContractBackupUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), backupMode.name()));
        }
        List<DynamicObject> newBackupContractList = copyScheme.copy(contractIds);
        if (newBackupContractList == null || newBackupContractList.size() == 0) {
            return null;
        }
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(newBackupContractList.size(), 1.0f);
        for (DynamicObject newBackupContract : newBackupContractList) {
            String masterID = newBackupContract.getLong("masterid") + "";
            result.put(masterID, newBackupContract);
        }
        return result;
    }

    public static void restore(RestoreLeaseContractInfo contractInfo) {
        ArrayList<RestoreLeaseContractInfo> contractInfoList = new ArrayList<RestoreLeaseContractInfo>(1);
        contractInfoList.add(contractInfo);
        LeaseContractBackupUtils.restore(contractInfoList);
    }

    public static void restore(List<RestoreLeaseContractInfo> contractInfoList) {
        for (RestoreLeaseContractInfo contractInfo : contractInfoList) {
            if (contractInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b58\u5728\u4e3a\u7a7a", (String)"LeaseContractBackupUtils_1", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            Long beforeBackupedContrId = contractInfo.getBeforeBackupedContrId();
            if (beforeBackupedContrId == null || beforeBackupedContrId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b58\u5728\u4e3a\u7a7a", (String)"LeaseContractBackupUtils_1", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            Long afterBackupedContrId = contractInfo.getAfterBackupedContrId();
            if (afterBackupedContrId != null && afterBackupedContrId != 0L) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b58\u5728\u4e3a\u7a7a", (String)"LeaseContractBackupUtils_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        HashMap<String, String> afterBackupedContrId2BeforeIdMap = new HashMap<String, String>(contractInfoList.size(), 1.0f);
        ArrayList<Long> backContractIdList = new ArrayList<Long>(contractInfoList.size());
        for (RestoreLeaseContractInfo contractInfo : contractInfoList) {
            afterBackupedContrId2BeforeIdMap.put(contractInfo.getAfterBackupedContrId() + "", contractInfo.getBeforeBackupedContrId() + "");
            backContractIdList.add(contractInfo.getBeforeBackupedContrId());
            backContractIdList.add(contractInfo.getAfterBackupedContrId());
        }
        if (contractInfoList.size() != afterBackupedContrId2BeforeIdMap.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570[%s]\u5b58\u5728\u91cd\u590dID,\u6062\u590d\u5931\u8d25", (String)"LeaseContractBackupUtils_2", (String)"fi-fa-business", (Object[])new Object[0]), contractInfoList.toString()));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", backContractIdList)};
        DynamicObjectCollection contrList = QueryServiceHelper.query((String)"fa_lease_contract", (String)SELECT_CONTRACT_FIELDS, (QFilter[])filters);
        if (contrList == null || contrList.size() == 0 || backContractIdList.size() != contrList.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570ID%s\u4e2d\u5b58\u5728\u6ca1\u6709\u5bf9\u5e94\u5408\u540c,\u6062\u590d\u5931\u8d25", (String)"LeaseContractBackupUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), backContractIdList));
        }
        HashMap<String, DynamicObject> id2ContractMap = new HashMap<String, DynamicObject>();
        for (DynamicObject contract : contrList) {
            id2ContractMap.put(contract.getString("id"), contract);
        }
        for (Map.Entry afterBackupedContrId2BeforeId : afterBackupedContrId2BeforeIdMap.entrySet()) {
            String masterIdBefore;
            DynamicObject afterContract = (DynamicObject)id2ContractMap.get(afterBackupedContrId2BeforeId.getKey());
            DynamicObject beforeContract = (DynamicObject)id2ContractMap.get(afterBackupedContrId2BeforeId.getValue());
            String masterIdAfter = afterContract.getString("masterid");
            if (!masterIdAfter.equals(masterIdBefore = beforeContract.getString("masterid"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570beforeBackupedContrId[%1$s]\u4e0eafterBackupedContrId[%2$s]\u7684master\u4e0d\u4e00\u81f4,\u6062\u590d\u5931\u8d25", (String)"LeaseContractBackupUtils_4", (String)"fi-fa-business", (Object[])new Object[0]), afterBackupedContrId2BeforeId.getValue(), afterBackupedContrId2BeforeId.getKey()));
            }
            boolean isBakAfter = afterContract.getBoolean("isbak");
            if (!isBakAfter) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570afterBackupedContrId[%s]\u4e3a\u975e\u5907\u4efd\u5408\u540c,\u6062\u590d\u5931\u8d25", (String)"LeaseContractBackupUtils_5", (String)"fi-fa-business", (Object[])new Object[0]), afterBackupedContrId2BeforeId.getKey()));
            }
            boolean isBakBefore = beforeContract.getBoolean("isbak");
            if (!isBakBefore) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570beforeBackupedContrId[%s]\u4e3a\u975e\u5907\u4efd\u5408\u540c,\u6062\u590d\u5931\u8d25", (String)"LeaseContractBackupUtils_6", (String)"fi-fa-business", (Object[])new Object[0]), afterBackupedContrId2BeforeId.getValue()));
            }
            Long previousbackid = afterContract.getLong("previousbackid");
            Long beforeContractId = beforeContract.getLong("id");
            if (previousbackid.longValue() == beforeContractId.longValue()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570afterBackupedContrId[%1$s]\u7684\u4e0a\u4e00\u6b21\u5907\u4efdID\u4e0ebeforeBackupedContrId[%2$s]\u4e0d\u4e00\u81f4,\u6062\u590d\u5931\u8d25", (String)"LeaseContractBackupUtils_7", (String)"fi-fa-business", (Object[])new Object[0]), afterBackupedContrId2BeforeId.getKey(), afterBackupedContrId2BeforeId.getValue()));
        }
        LeaseContractRestore2Code restoreScheme = new LeaseContractRestore2Code();
        ArrayList<Long> toRestoreBackupedContrIds = new ArrayList<Long>(contractInfoList.size());
        ArrayList<Long> toDeleteBackupedContrId = new ArrayList<Long>(contractInfoList.size());
        for (RestoreLeaseContractInfo contractInfo : contractInfoList) {
            toRestoreBackupedContrIds.add(contractInfo.getBeforeBackupedContrId());
            toDeleteBackupedContrId.add(contractInfo.getAfterBackupedContrId());
        }
        restoreScheme.restore(toRestoreBackupedContrIds, toDeleteBackupedContrId);
    }

    public static void deleteFirstBack(Long backContractId) {
        if (backContractId == null) {
            return;
        }
        ArrayList<Long> backContractIdList = new ArrayList<Long>(1);
        backContractIdList.add(backContractId);
        LeaseContractBackupUtils.deleteFirstBack(backContractIdList);
    }

    public static void deleteFirstBack(List<Long> backContractIds) {
        if (backContractIds == null || backContractIds.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)backContractIds.toArray());
        DynamicObjectCollection backContractList = QueryServiceHelper.query((String)"fa_lease_contract", (String)SELECT_CONTRACT_FIELDS, (QFilter[])filter.toArray());
        if (backContractList == null || backContractList.size() == 0) {
            return;
        }
        ArrayList<Object> firstBackContracts = new ArrayList<Object>(backContractList.size());
        HashSet<String> firstBackContractIdSet = new HashSet<String>(backContractList.size());
        for (Object backContract : backContractList) {
            String string = backContract.getString("version");
            String previousbackid = backContract.getString("previousbackid");
            boolean isbak = backContract.getBoolean("isbak");
            if (!string.equals("0") || !previousbackid.equals("0") || !isbak) continue;
            firstBackContracts.add(backContract);
            String id = backContract.getString("id");
            firstBackContractIdSet.add(id);
        }
        QFilter filter_existRelation = null;
        for (DynamicObject dynamicObject : firstBackContracts) {
            Long masterId = dynamicObject.getLong("masterid");
            Long id = dynamicObject.getLong("id");
            QFilter filter1 = new QFilter("masterid", "=", (Object)masterId);
            QFilter filter2 = new QFilter("previousbackid", "=", (Object)id);
            QFilter filter3 = new QFilter("isbak", "=", (Object)"1");
            if (filter_existRelation == null) {
                filter_existRelation = filter1.and(filter2).and(filter3);
                continue;
            }
            QFilter andfilter = filter1.and(filter2).and(filter3);
            filter_existRelation = filter_existRelation.or(andfilter);
        }
        if (filter_existRelation == null) {
            return;
        }
        DynamicObjectCollection existRelContrList = QueryServiceHelper.query((String)"fa_lease_contract", (String)SELECT_CONTRACT_FIELDS, (QFilter[])filter_existRelation.toArray());
        if (existRelContrList != null && existRelContrList.size() != 0) {
            HashSet<String> hashSet = new HashSet<String>(existRelContrList.size());
            for (DynamicObject existRelationBackContra : existRelContrList) {
                String previousbackid = existRelationBackContra.getString("previousbackid");
                hashSet.add(previousbackid);
            }
            firstBackContractIdSet.removeAll(hashSet);
        }
        if (firstBackContractIdSet == null || firstBackContractIdSet.size() == 0) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(firstBackContractIdSet.size());
        for (String backContractId : firstBackContractIdSet) {
            arrayList.add(Long.parseLong(backContractId));
        }
        LeaseContractBackupInnerUtils.deleteBackupVersion(arrayList);
    }
}

