/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.backup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.lease.backup.LeaseContractBackupInnerUtils;
import kd.fi.fa.business.lease.backup.inter.ILeaseContractRestore;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaCommonUtils;

public class LeaseContractRestore
implements ILeaseContractRestore {
    List<DynamicObject> curContractList;
    Map<String, DynamicObject> masterid2CurContractMap;
    List<DynamicObject> backupContractList;
    static final String preRestoreFields = "id,masterid,isbak";

    @Override
    public void restore(List<Long> toRestoreBackupedContrIds, List<Long> toDeleteBackupedContrId) {
        this.backupContractList = this.select(toRestoreBackupedContrIds);
        if (this.backupContractList == null || this.backupContractList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6062\u590dID\u6ca1\u6709\u5bf9\u5e94\u7684\u5408\u540c\uff0c\u6062\u590d\u5931\u8d25", (String)"LeaseContractRestore_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        this.preRestore();
        this.deleteCurVersion();
        ArrayList<DynamicObject> newCurContractList = new ArrayList<DynamicObject>(toRestoreBackupedContrIds.size());
        for (DynamicObject backupContract : this.backupContractList) {
            DynamicObject newCurContract = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)backupContract);
            this.resetBackupInfo(newCurContract);
            newCurContractList.add(newCurContract);
        }
        SaveServiceHelper.save((DynamicObject[])newCurContractList.toArray(new DynamicObject[1]));
        LeaseContractBackupInnerUtils.deleteBackupVersion(toDeleteBackupedContrId);
        this.handleRentSettle(this.backupContractList);
        this.handleInterestDetail(this.backupContractList);
    }

    List<DynamicObject> select(List<Long> contractIds) {
        DynamicObject[] contractList = BusinessDataServiceHelper.load((Object[])contractIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        return Arrays.asList(contractList);
    }

    private void preRestore() {
        ArrayList<Long> masterIdList = new ArrayList<Long>(this.backupContractList.size());
        for (DynamicObject backupContract : this.backupContractList) {
            masterIdList.add(backupContract.getLong("masterid"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", masterIdList)};
        List curContrIds = QueryServiceHelper.queryPrimaryKeys((String)"fa_lease_contract", (QFilter[])filters, null, (int)1000000);
        DynamicObject[] curContrList = BusinessDataServiceHelper.load((Object[])curContrIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        ArrayList<Long> curContrMasterIDList = new ArrayList<Long>(curContrList.length);
        for (DynamicObject curContr : curContrList) {
            boolean isbak = curContr.getBoolean("isbak");
            if (!isbak) continue;
            Long id = curContr.getLong("id");
            curContrMasterIDList.add(id);
        }
        if (curContrMasterIDList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9d\u636emasterID=id\u627e\u5230\u5f53\u524d\u5408\u540c\u4e3a\u5907\u4efd\u72b6\u6001\uff0c\u6570\u636e\u6062\u590d\u5931\u8d25\uff0cid%s", (String)"LeaseContractRestore_1", (String)"fi-fa-business", (Object[])new Object[0]), ((Object)curContrMasterIDList).toString()));
        }
        this.curContractList = Arrays.asList(curContrList);
        this.masterid2CurContractMap = new HashMap<String, DynamicObject>(curContrList.length);
        for (DynamicObject curContr : curContrList) {
            this.masterid2CurContractMap.put(curContr.getString("masterid"), curContr);
        }
    }

    private void deleteCurVersion() {
        if (this.curContractList == null || this.curContractList.size() == 0) {
            return;
        }
        ArrayList<Long> curIdList = new ArrayList<Long>(this.curContractList.size());
        for (DynamicObject cur : this.curContractList) {
            curIdList.add(cur.getLong("id"));
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"), (Object[])curIdList.toArray());
        QFilter[] settleFilters = new QFilter[]{new QFilter("leasecontract", "in", (Object)curIdList.toArray())};
        LeaseUtil.deleteRentSettle(settleFilters, true);
        QFilter[] interestFilters = new QFilter[]{new QFilter("leasecontract", "in", (Object)curIdList.toArray())};
        DeleteServiceHelper.delete((String)"fa_interest_detail", (QFilter[])interestFilters);
    }

    private void resetBackupInfo(DynamicObject curContract) {
        curContract.set("isbak", (Object)"0");
        curContract.set("backtime", null);
        curContract.set("settlesharesrcid", (Object)0L);
        curContract.set("id", (Object)curContract.getLong("masterid"));
        DynamicObjectCollection ruleList = curContract.getDynamicObjectCollection("payruleentryentity");
        for (DynamicObject ruleDo : ruleList) {
            ruleDo.set("id", (Object)ruleDo.getLong("ruleentrysrcid"));
        }
        DynamicObjectCollection planList = curContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject planDo : planList) {
            planDo.set("id", (Object)planDo.getLong("planentrysrcid"));
        }
        this.handleInsertContractFor2Code(curContract);
    }

    protected void handleInsertContractFor2Code(DynamicObject insertedCurContract) {
    }

    private void handleRentSettle(List<DynamicObject> backupContrList) {
        ArrayList<Long> backContrIdList = new ArrayList<Long>(backupContrList.size());
        HashMap<String, Long> backContrId2MasterIdMap = new HashMap<String, Long>(backupContrList.size(), 1.0f);
        for (DynamicObject backupContract : this.backupContractList) {
            Long settlesharesrcid = backupContract.getLong("settlesharesrcid");
            if (settlesharesrcid != 0L) {
                backContrIdList.add(settlesharesrcid);
                backContrId2MasterIdMap.put(settlesharesrcid + "", backupContract.getLong("masterid"));
                continue;
            }
            Long contrid = backupContract.getLong("id");
            backContrIdList.add(contrid);
            backContrId2MasterIdMap.put(contrid + "", backupContract.getLong("masterid"));
        }
        List<DynamicObject> newCurSettleList = this.selectAndResetSettle(backContrIdList, backContrId2MasterIdMap);
        if (newCurSettleList == null || newCurSettleList.size() == 0) {
            return;
        }
        LeaseUtil.saveRentSettle(newCurSettleList.toArray(new DynamicObject[0]), true);
    }

    private List<DynamicObject> selectAndResetSettle(List<Long> fromContractIdList, Map<String, Long> contractId2MasterIdMap) {
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "in", (Object)fromContractIdList.toArray())};
        List settleIdList = QueryServiceHelper.queryPrimaryKeys((String)"fa_lease_rent_settle", (QFilter[])filters, null, (int)1000000);
        DynamicObject[] settleList = BusinessDataReader.load((Object[])settleIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_rent_settle"), (Boolean)true);
        if (settleList == null || settleList.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> curSettleList = new ArrayList<DynamicObject>(settleList.length);
        for (DynamicObject settleDo : settleList) {
            DynamicObject curSettle = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)settleDo);
            curSettle.set("id", settleDo.get("srcid"));
            String bakContractId = settleDo.getString("leasecontract.id");
            curSettle.set("leasecontract_id", (Object)contractId2MasterIdMap.get(bakContractId));
            curSettle.set("srcid", (Object)0L);
            curSettleList.add(curSettle);
        }
        return curSettleList;
    }

    private void handleInterestDetail(List<DynamicObject> backupContractList) {
        ArrayList<Long> backContrIdList = new ArrayList<Long>(backupContractList.size());
        HashMap<String, Long> backContrId2MasterIdMap = new HashMap<String, Long>(backContrIdList.size(), 1.0f);
        for (DynamicObject backupContract : backupContractList) {
            Long settlesharesrcid = backupContract.getLong("settlesharesrcid");
            if (settlesharesrcid != 0L) {
                backContrIdList.add(settlesharesrcid);
                backContrId2MasterIdMap.put(settlesharesrcid + "", backupContract.getLong("masterid"));
                continue;
            }
            Long contrid = backupContract.getLong("id");
            backContrIdList.add(contrid);
            backContrId2MasterIdMap.put(contrid + "", backupContract.getLong("masterid"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "in", (Object)backContrIdList.toArray())};
        List interestIdList = QueryServiceHelper.queryPrimaryKeys((String)"fa_interest_detail", (QFilter[])filters, null, (int)1000000);
        DynamicObject[] interestList = BusinessDataReader.load((Object[])interestIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_interest_detail"), (Boolean)true);
        if (interestList == null || interestList.length == 0) {
            return;
        }
        ArrayList<DynamicObject> curInterestList = new ArrayList<DynamicObject>(interestList.length);
        for (DynamicObject interestDo : interestList) {
            DynamicObject curInterest = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)interestDo);
            String bakContractId = interestDo.getString("leasecontract.id");
            curInterest.set("leasecontract_id", backContrId2MasterIdMap.get(bakContractId));
            curInterestList.add(curInterest);
        }
        if (curInterestList == null || curInterestList.size() == 0) {
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_interest_detail", (DynamicObject[])curInterestList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        FaCommonUtils.handleOperationResult(result);
    }
}

