/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.model;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PayPlanCompareObject {
    private boolean isBeforeEffectiveDate;
    private String number;
    private long payItemId;
    private String payItemClass;
    private Date startDate;
    private Date endDate;
    private Date planPayDate;
    private String invoiceType;
    private boolean deductible;
    private BigDecimal taxRate;
    private BigDecimal rentNoTax;
    private BigDecimal tax;
    private BigDecimal rent;
    private BigDecimal unPaidRent;

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.format("PayPlanCompareObject -> number: %s; payItemId: %s; payItemClass: %s; startDate: %s; endDate: %s; planPayDate: %s; invoiceType: %s; deductible: %s; taxRate: %s; rentNoTax: %s; tax: %s; rent: %s; unPaidRent: %s.", this.number, this.payItemId, this.payItemClass, this.formatDate(this.startDate), this.formatDate(this.endDate), this.formatDate(this.planPayDate), this.invoiceType, this.deductible, this.formatBigDecimal(this.taxRate), this.formatBigDecimal(this.rentNoTax), this.formatBigDecimal(this.tax), this.formatBigDecimal(this.rent), this.formatBigDecimal(this.unPaidRent));
    }

    public boolean equalsExcludeEndDate(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPlanCompareObject o = (PayPlanCompareObject)obj;
        if (this.isDiffString(this.number, o.getNumber())) {
            return false;
        }
        if (this.payItemId != o.getPayItemId()) {
            return false;
        }
        if (this.isDiffString(this.payItemClass, o.getPayItemClass())) {
            return false;
        }
        if (this.isDiffDate(this.startDate, o.getStartDate())) {
            return false;
        }
        if (this.isDiffDate(this.planPayDate, o.getPlanPayDate())) {
            return false;
        }
        if (this.isDiffString(this.invoiceType, o.getInvoiceType())) {
            return false;
        }
        if (this.deductible ^ o.isDeductible()) {
            return false;
        }
        if (this.isDiffBigDecimal(this.taxRate, o.getTaxRate())) {
            return false;
        }
        if (this.isDiffBigDecimal(this.rentNoTax, o.getRentNoTax())) {
            return false;
        }
        if (this.isDiffBigDecimal(this.tax, o.getTax())) {
            return false;
        }
        if (this.isDiffBigDecimal(this.rent, o.getRent())) {
            return false;
        }
        return !this.isDiffBigDecimal(this.unPaidRent, o.getUnPaidRent());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPlanCompareObject o = (PayPlanCompareObject)obj;
        if (this.isDiffString(this.number, o.getNumber())) {
            return false;
        }
        if (this.payItemId != o.getPayItemId()) {
            return false;
        }
        if (this.isDiffString(this.payItemClass, o.getPayItemClass())) {
            return false;
        }
        if (this.isDiffDate(this.startDate, o.getStartDate())) {
            return false;
        }
        if (this.isDiffDate(this.endDate, o.getEndDate())) {
            return false;
        }
        if (this.isDiffDate(this.planPayDate, o.getPlanPayDate())) {
            return false;
        }
        if (this.isDiffString(this.invoiceType, o.getInvoiceType())) {
            return false;
        }
        if (this.deductible ^ o.isDeductible()) {
            return false;
        }
        if (this.isDiffBigDecimal(this.taxRate, o.getTaxRate())) {
            return false;
        }
        if (this.isDiffBigDecimal(this.rentNoTax, o.getRentNoTax())) {
            return false;
        }
        if (this.isDiffBigDecimal(this.tax, o.getTax())) {
            return false;
        }
        if (this.isDiffBigDecimal(this.rent, o.getRent())) {
            return false;
        }
        return !this.isDiffBigDecimal(this.unPaidRent, o.getUnPaidRent());
    }

    public boolean isBeforeEffectiveDate() {
        return this.isBeforeEffectiveDate;
    }

    public void setBeforeEffectiveDate(boolean beforeEffectiveDate) {
        this.isBeforeEffectiveDate = beforeEffectiveDate;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public long getPayItemId() {
        return this.payItemId;
    }

    public void setPayItemId(long payItemId) {
        this.payItemId = payItemId;
    }

    public String getPayItemClass() {
        return this.payItemClass;
    }

    public void setPayItemClass(String payItemClass) {
        this.payItemClass = payItemClass;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getPlanPayDate() {
        return this.planPayDate;
    }

    public void setPlanPayDate(Date planPayDate) {
        this.planPayDate = planPayDate;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public boolean isDeductible() {
        return this.deductible;
    }

    public void setDeductible(boolean deductible) {
        this.deductible = deductible;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getRentNoTax() {
        return this.rentNoTax;
    }

    public void setRentNoTax(BigDecimal rentNoTax) {
        this.rentNoTax = rentNoTax;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getRent() {
        return this.rent;
    }

    public void setRent(BigDecimal rent) {
        this.rent = rent;
    }

    public BigDecimal getUnPaidRent() {
        return this.unPaidRent;
    }

    public void setUnPaidRent(BigDecimal unPaidRent) {
        this.unPaidRent = unPaidRent;
    }

    private boolean isDiffString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return false;
        }
        if (s1 == null || s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }

    private boolean isDiffDate(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return false;
        }
        if (d1 == null || d2 == null) {
            return true;
        }
        return !this.formatDate(d1).equals(this.formatDate(d2));
    }

    private boolean isDiffBigDecimal(BigDecimal d1, BigDecimal d2) {
        if (d1 == null && d2 == null) {
            return false;
        }
        if (d1 == null || d2 == null) {
            return true;
        }
        return d1.compareTo(d2) != 0;
    }

    private String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    private String formatBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "";
        }
        return bigDecimal.stripTrailingZeros().toPlainString();
    }
}

