/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.lease.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitSumUtils;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.PayFrequency;
import kd.fi.fa.business.enums.lease.PayPoint;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseUtil {
    private static final String algoKey = "kd.fi.fa.business.lease.utils.LeaseUtil";
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.business.lease.utils.LeaseUtil");

    public static BigDecimal getSettleRent(DynamicObject payPlan, boolean isdeductible, boolean is_deduct_vat_discount) {
        if (!isdeductible) {
            return payPlan.getBigDecimal("rent");
        }
        if (is_deduct_vat_discount) {
            return payPlan.getBigDecimal("rent");
        }
        return payPlan.getBigDecimal("rentnotax");
    }

    public static double irr(double[] cashFlows) {
        return LeaseUtil.irr(cashFlows, 0.1);
    }

    public static double irr(double[] cashFlows, double estimatedResult) {
        double result = Double.NaN;
        if (cashFlows != null && cashFlows.length > 0 && cashFlows[0] != 0.0) {
            int noOfCashFlows = cashFlows.length;
            double sumCashFlows = 0.0;
            int noOfNegativeCashFlows = 0;
            int noOfPositiveCashFlows = 0;
            for (double cashFlow : cashFlows) {
                sumCashFlows += cashFlow;
                if (cashFlow > 0.0) {
                    ++noOfPositiveCashFlows;
                    continue;
                }
                if (!(cashFlow < 0.0)) continue;
                ++noOfNegativeCashFlows;
            }
            if (noOfNegativeCashFlows > 0 && noOfPositiveCashFlows > 0) {
                double irrGuess = 0.1;
                if (!Double.isNaN(estimatedResult) && (irrGuess = estimatedResult) <= 0.0) {
                    irrGuess = 0.5;
                }
                double irr = sumCashFlows < 0.0 ? -irrGuess : irrGuess;
                double minDistance = 1.0E-15;
                double cashFlowStart = cashFlows[0];
                int maxIteration = 100;
                boolean wasHi = false;
                for (int i = 0; i <= maxIteration; ++i) {
                    double cashValue = cashFlowStart;
                    for (int j = 1; j < noOfCashFlows; ++j) {
                        cashValue += cashFlows[j] / Math.pow(1.0 + irr, j);
                    }
                    if (Math.abs(cashValue) < 1.0E-7) {
                        result = irr;
                        break;
                    }
                    if (cashValue > 0.0) {
                        if (wasHi) {
                            irrGuess /= 2.0;
                        }
                        irr += irrGuess;
                        if (wasHi) {
                            irrGuess -= minDistance;
                            wasHi = false;
                        }
                    } else {
                        irr -= (irrGuess /= 2.0);
                        wasHi = true;
                    }
                    if (!(irrGuess <= minDistance)) continue;
                    result = irr;
                    break;
                }
            }
        }
        return result;
    }

    private static Date getNewStandardStartDate() {
        Calendar startDate = Calendar.getInstance();
        startDate.set(2021, 0, 1, 0, 0, 0);
        startDate.set(14, 0);
        return startDate.getTime();
    }

    public static Date getFirstExecDateFromSysParam(long orgId) {
        return SystemParamHelper.getDateParam("firstexecday", orgId, LeaseUtil.getNewStandardStartDate());
    }

    public static Date getSysSwitchDateFromSysParam(long orgId) {
        return SystemParamHelper.getDateParam("systemswitchday", orgId);
    }

    public static boolean isStockContract(Date leaseTermStartDate, boolean isExempt) {
        return DateUtil.compareDate((Date)leaseTermStartDate, (Date)LeaseUtil.getNewStandardStartDate()) < 0 && !isExempt;
    }

    public static boolean isNeedRentSettle(DynamicObject leaseContract) {
        BigDecimal leaseLiab;
        boolean isExempt = leaseContract.getBoolean("isexempt");
        DynamicObjectCollection payPlanList = leaseContract.getDynamicObjectCollection("payplanentryentity");
        if (!isExempt && payPlanList.isEmpty()) {
            return false;
        }
        if (!(isExempt || (leaseLiab = leaseContract.getBigDecimal("leaseliab")) != null && BigDecimal.ZERO.compareTo(leaseLiab) != 0)) {
            return false;
        }
        if (isExempt) {
            String sourceType = leaseContract.getString("sourcetype");
            if (LeaseContractSourceType.C.name().equals(sourceType)) {
                long masterId = leaseContract.getLong("masterid");
                DynamicObject masterContract = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)"fa_lease_contract", (String)"sourcetype");
                sourceType = masterContract.getString("sourcetype");
            }
            Date interestDetailBeginDate = LeaseContractSourceType.A.name().equals(sourceType) ? leaseContract.getDate("initconfirmdate") : leaseContract.getDate("sysswitchdate");
            HashSet<String> payItemAcctClass = new HashSet<String>(4);
            for (DynamicObject row : payPlanList) {
                Date planPayDate = row.getDate("planpaydate");
                if (DateUtil.compareDate((Date)planPayDate, (Date)interestDetailBeginDate) < 0) continue;
                DynamicObject payItem = row.getDynamicObject("plan_payitem");
                String acctClass = payItem.getString("accountingclass");
                payItemAcctClass.add(acctClass);
            }
            return payItemAcctClass.contains("A");
        }
        return true;
    }

    public static void generatePayPlan4Chg(DynamicObject chgLeaseContract, DynamicObject oriContract) {
        String planStartDateStr;
        Date planStartDate;
        LeaseUtil.generatePayPlan(chgLeaseContract);
        log.info("enter-into-generatePayPlan4Chg method");
        if (oriContract == null) {
            return;
        }
        DynamicObjectCollection chgBakPlanEntry = chgLeaseContract.getDynamicObjectCollection("payplanentryentity");
        DynamicObjectCollection oriPlanEntry = oriContract.getDynamicObjectCollection("payplanentryentity");
        HashMap<String, DynamicObject> payItemIdStartDate2OriPlayEntry = new HashMap<String, DynamicObject>(oriPlanEntry.size());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject planRow : oriPlanEntry) {
            DynamicObject payItem = planRow.getDynamicObject("plan_payitem");
            String payItemId = payItem.getString("id");
            planStartDate = planRow.getDate("plan_startdate");
            planStartDateStr = format.format(planStartDate);
            payItemIdStartDate2OriPlayEntry.put(payItemId + "_" + planStartDateStr, planRow);
        }
        HashMap<String, Integer> payItemSwiftNumMap = new HashMap<String, Integer>(chgBakPlanEntry.size());
        for (DynamicObject planRow : chgBakPlanEntry) {
            DynamicObject payItem = planRow.getDynamicObject("plan_payitem");
            String payItemId = payItem.getString("id");
            Date planStartDate2 = planRow.getDate("plan_startdate");
            String planStartDateStr2 = format.format(planStartDate2);
            DynamicObject oriPlanEntryDy = (DynamicObject)payItemIdStartDate2OriPlayEntry.get(payItemId + "_" + planStartDateStr2);
            if (oriPlanEntryDy == null) {
                log.info("enter-into-generatePayPlan4Chg oriPlanEntryDy is null planStartDateStr:" + planStartDateStr2);
            }
            if (oriPlanEntryDy != null && LeaseUtil.lsSamePayPlan(oriPlanEntryDy, planRow)) {
                log.info("enter-into-generatePayPlan4Chg lsSamePayPlan planStartDateStr:" + planStartDateStr2);
                String oriPlanNumber = oriPlanEntryDy.getString("plannumber");
                planRow.set("plannumber", (Object)oriPlanNumber);
                log.info("enter-into-generatePayPlan4Chg lsSamePayPlan planStartDateStr:" + planStartDateStr2 + ",oriPlanNumber:" + oriPlanNumber);
                Integer seq = LeaseUtil.getPayPlanNumberSeq(oriPlanNumber);
                Integer maxSeq = (Integer)payItemSwiftNumMap.get(payItem.getString("number"));
                if (maxSeq == null) {
                    payItemSwiftNumMap.put(payItem.getString("number"), seq);
                    continue;
                }
                if (seq.longValue() <= maxSeq.longValue()) continue;
                payItemSwiftNumMap.put(payItem.getString("number"), seq);
                continue;
            }
            log.info("enter-into-generatePayPlan4Chg not lsSamePayPlan planStartDateStr:" + planStartDateStr2);
            planRow.set("plannumber", (Object)"");
        }
        for (DynamicObject planRow : chgBakPlanEntry) {
            String planNumber = planRow.getString("plannumber");
            planStartDate = planRow.getDate("plan_startdate");
            planStartDateStr = format.format(planStartDate);
            log.info("enter-into-generatePayPlan4Chg setplanNumber planStartDateStr:" + planStartDateStr);
            if (planNumber.length() != 0) continue;
            DynamicObject payItem = planRow.getDynamicObject("plan_payitem");
            String payItemNumber = payItem.getString("number");
            int swiftNum = payItemSwiftNumMap.containsKey(payItemNumber) ? (Integer)payItemSwiftNumMap.get(payItemNumber) + 1 : 1;
            String payPlanNumber = LeaseUtil.buildPayPlanNumber(payItemNumber, swiftNum);
            payItemSwiftNumMap.put(payItemNumber, swiftNum);
            log.info("enter-into-generatePayPlan4Chg setplanNumber planStartDateStr:" + planStartDateStr + ",planNumber=" + payPlanNumber);
            planRow.set("plannumber", (Object)payPlanNumber);
        }
    }

    private static boolean lsSamePayPlan(DynamicObject oriCtrPayPlan, DynamicObject chgCtrPayPlan) {
        String chgPlanpaydateStr;
        String chgCtrPayPlanStr;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String oriCtrPayPlanStr = format.format(oriCtrPayPlan.getDate("plan_enddate"));
        if (!oriCtrPayPlanStr.equals(chgCtrPayPlanStr = format.format(chgCtrPayPlan.getDate("plan_enddate")))) {
            return false;
        }
        String oriPlanpaydateStr = format.format(oriCtrPayPlan.getDate("planpaydate"));
        if (!oriPlanpaydateStr.equals(chgPlanpaydateStr = format.format(chgCtrPayPlan.getDate("planpaydate")))) {
            return false;
        }
        if (!oriCtrPayPlan.getString("plan_invoicetype").equals(chgCtrPayPlan.getString("plan_invoicetype"))) {
            return false;
        }
        if (oriCtrPayPlan.getBoolean("plan_deductible") != chgCtrPayPlan.getBoolean("plan_deductible")) {
            return false;
        }
        if (oriCtrPayPlan.getBigDecimal("plan_taxrate").compareTo(chgCtrPayPlan.getBigDecimal("plan_taxrate")) != 0) {
            return false;
        }
        if (oriCtrPayPlan.getBigDecimal("rentnotax").compareTo(chgCtrPayPlan.getBigDecimal("rentnotax")) != 0) {
            return false;
        }
        if (oriCtrPayPlan.getBigDecimal("tax").compareTo(chgCtrPayPlan.getBigDecimal("tax")) != 0) {
            return false;
        }
        if (oriCtrPayPlan.getBigDecimal("rent").compareTo(chgCtrPayPlan.getBigDecimal("rent")) != 0) {
            return false;
        }
        return oriCtrPayPlan.getBigDecimal("unpaidrent").compareTo(chgCtrPayPlan.getBigDecimal("unpaidrent")) == 0;
    }

    public static void generatePayPlan(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = org.getLong("id");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        boolean isDeductVatDiscount = SystemParamHelper.getBooleanParam("is_deduct_vat_discount", orgId, false);
        DynamicObjectCollection ruleEntry = leaseContract.getDynamicObjectCollection("payruleentryentity");
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        planEntry.clear();
        HashMap<String, Integer> payItemSwiftNumMap = new HashMap<String, Integer>(ruleEntry.size());
        int seq = 1;
        for (DynamicObject ruleRow : ruleEntry) {
            DynamicObject payItem = ruleRow.getDynamicObject("rule_payitem");
            String frequency = ruleRow.getString("frequency");
            int intervalMonth = Enum.valueOf(PayFrequency.class, frequency).getIntervalMonth();
            Date ruleStartDate = ruleRow.getDate("rule_startdate");
            Date ruleEndDate = ruleRow.getDate("rule_enddate");
            String payPoint = ruleRow.getString("paypoint");
            int relativePayDate = ruleRow.getInt("relativepaydate");
            String ruleInvoiceType = ruleRow.getString("rule_invoicetype");
            boolean ruleDeductible = ruleRow.getBoolean("rule_deductible");
            BigDecimal ruleTaxRate = ruleRow.getBigDecimal("rule_taxrate");
            BigDecimal amount = ruleRow.getBigDecimal("amount");
            BigDecimal ruleTax = ruleRow.getBigDecimal("rule_tax");
            Date planEndDate = DateUtil.addDay((Date)ruleStartDate, (int)-1);
            while (DateUtil.compareDate((Date)planEndDate, (Date)ruleEndDate) < 0) {
                DynamicObject planRow = planEntry.addNew();
                planRow.set("seq", (Object)seq++);
                planRow.set("contractsrcid", (Object)leaseContract);
                String payItemNumber = payItem.getString("number");
                int swiftNum = payItemSwiftNumMap.containsKey(payItemNumber) ? (Integer)payItemSwiftNumMap.get(payItemNumber) + 1 : 1;
                String payPlanNumber = LeaseUtil.buildPayPlanNumber(payItemNumber, swiftNum);
                payItemSwiftNumMap.put(payItemNumber, swiftNum);
                planRow.set("plannumber", (Object)payPlanNumber);
                planRow.set("plan_payitem", (Object)payItem);
                Date planStartDate = DateUtil.addDay((Date)planEndDate, (int)1);
                planRow.set("plan_startdate", (Object)planStartDate);
                if (PayFrequency.F.name().equals(frequency)) {
                    planEndDate = ruleEndDate;
                } else {
                    planEndDate = DateUtil.addNaturalMonth((Date)planStartDate, (int)intervalMonth);
                    planEndDate = DateUtil.addDay((Date)planEndDate, (int)-1);
                }
                if (DateUtil.compareDate((Date)planEndDate, (Date)ruleEndDate) > 0) {
                    planEndDate = ruleEndDate;
                }
                planRow.set("plan_enddate", (Object)planEndDate);
                Date planPayDate = LeaseUtil.calPlanPayDate(planStartDate, planEndDate, payPoint, relativePayDate);
                planRow.set("planpaydate", (Object)planPayDate);
                planRow.set("plan_invoicetype", (Object)ruleInvoiceType);
                planRow.set("plan_deductible", (Object)ruleDeductible);
                planRow.set("plan_taxrate", (Object)ruleTaxRate);
                planRow.set("rent", (Object)amount);
                planRow.set("tax", (Object)ruleTax);
                BigDecimal rentNoTax = amount.subtract(ruleTax);
                planRow.set("rentnotax", (Object)rentNoTax);
                planRow.set("plan_unpay", (Object)amount);
                planRow.set("real_unpay", (Object)amount);
                planRow.set("plan_currency", (Object)currency);
                planRow.set("billstatus", (Object)BillStatus.C);
                String acctClass = payItem.getString("accountingclass");
                BigDecimal unpaidRent = BigDecimal.ZERO;
                if (DateUtil.compareDate((Date)planPayDate, (Date)initConfirmDate) >= 0 && "A".equals(acctClass)) {
                    unpaidRent = ruleDeductible && !isDeductVatDiscount ? rentNoTax : amount;
                }
                planRow.set("unpaidrent", (Object)unpaidRent);
            }
        }
    }

    public static DynamicObject getPayRuleRow(DynamicObject leaseContract, long payItemId, Date planStartDate) {
        DynamicObjectCollection ruleEntry = leaseContract.getDynamicObjectCollection("payruleentryentity");
        for (DynamicObject row : ruleEntry) {
            DynamicObject rulePayItem = row.getDynamicObject("rule_payitem");
            long rulePayItemLong = rulePayItem.getLong("id");
            if (payItemId != rulePayItemLong) continue;
            Date ruleStartDate = row.getDate("rule_startdate");
            Date ruleEndDate = row.getDate("rule_enddate");
            if (DateUtil.compareDate((Date)planStartDate, (Date)ruleStartDate) < 0 || DateUtil.compareDate((Date)planStartDate, (Date)ruleEndDate) > 0) continue;
            return row;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u4ed8\u6b3e\u8ba1\u5212\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4ed8\u6b3e\u89c4\u5219, \u5408\u540cid[%1$s]\uff0c\u4ed8\u6b3e\u9879\u76eeid[%2$s]\uff0c\u53d7\u76ca\u671f\u5f00\u59cb\u65e5[%3$s]\u3002", (String)"LeaseUtil_0", (String)"fi-fa-business", (Object[])new Object[0]), leaseContract.getPkValue(), payItemId, planStartDate));
    }

    public static Date calPlanPayDate(Date startDate, Date endDate, String payPoint, int relativePayDate) {
        Date payPointDate = PayPoint.A.name().equals(payPoint) ? startDate : endDate;
        Date planPayDate = relativePayDate > 0 ? DateUtil.addDay((Date)payPointDate, (int)(relativePayDate - 1)) : DateUtil.addDay((Date)payPointDate, (int)relativePayDate);
        return planPayDate;
    }

    public static void calLeaseContractAmount4Submit(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = org.getLong("id");
        boolean isDeductVatDiscount = SystemParamHelper.getBooleanParam("is_deduct_vat_discount", orgId, false);
        LeaseUtil.fillPayPlan(leaseContract, isDeductVatDiscount);
        LeaseUtil.calFinInfoFields(leaseContract, isDeductVatDiscount);
    }

    private static void fillPayPlan(DynamicObject leaseContract, boolean isDeductVatDiscount) {
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int amtPrecision = currency.getInt("amtprecision");
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        Date leaseTermStartDate = leaseContract.getDate("leasetermstartdate");
        BigDecimal dailyDiscountRate = leaseContract.getBigDecimal("dailydiscountrate");
        BigDecimal dailyDiscountRate4Cal = dailyDiscountRate.divide(FaBigDecimalUtil.HUNDRED, 8, 4);
        String transitionPlan = leaseContract.getString("transitionplan");
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject row : planEntry) {
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            Date planPayDate = row.getDate("planpaydate");
            boolean deductible = row.getBoolean("plan_deductible");
            BigDecimal rent = row.getBigDecimal("rent");
            BigDecimal rentNoTax = row.getBigDecimal("rentnotax");
            BigDecimal unpaidRent = row.getBigDecimal("unpaidrent");
            int liabDiscountDays = 0;
            String acctClass = payItem.getString("accountingclass");
            if ("A".equals(acctClass) && DateUtil.compareDate((Date)planPayDate, (Date)initConfirmDate) >= 0) {
                liabDiscountDays = DateUtil.getDiffDays((Date)initConfirmDate, (Date)planPayDate);
            }
            row.set("discountdays", (Object)liabDiscountDays);
            BigDecimal liabDiscountFactor = BigDecimal.ONE.add(dailyDiscountRate4Cal).pow(liabDiscountDays).setScale(6, 4);
            row.set("discountfactor", (Object)liabDiscountFactor);
            BigDecimal liabPresentValue = BigDecimal.ZERO;
            if ("A".equals(acctClass)) {
                liabPresentValue = unpaidRent.divide(liabDiscountFactor, amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            }
            row.set("presentvalue", (Object)liabPresentValue);
            if (!LeaseUtil.isCalLeaseAssetsForPayPlan(transitionPlan)) continue;
            int assetsDiscountDays = 0;
            if ("A".equals(acctClass) && DateUtil.compareDate((Date)planPayDate, (Date)leaseTermStartDate) >= 0) {
                assetsDiscountDays = DateUtil.getDiffDays((Date)leaseTermStartDate, (Date)planPayDate);
            }
            row.set("discountdays2", (Object)assetsDiscountDays);
            BigDecimal assetsDiscountFactor = BigDecimal.ONE.add(dailyDiscountRate4Cal).pow(assetsDiscountDays).setScale(6, 4);
            row.set("discountfactor2", (Object)assetsDiscountFactor);
            BigDecimal assetsPresentValue = BigDecimal.ZERO;
            if ("A".equals(acctClass)) {
                BigDecimal amountTemp = deductible && !isDeductVatDiscount ? rentNoTax : rent;
                assetsPresentValue = amountTemp.divide(assetsDiscountFactor, amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            }
            row.set("presentvalue2", (Object)assetsPresentValue);
        }
    }

    private static void calFinInfoFields(DynamicObject leaseContract, boolean isDeductVatDiscount) {
        boolean isExempt;
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = org.getLong("id");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int amtPrecision = currency.getInt("amtprecision");
        Date leaseTermStartDate = leaseContract.getDate("leasetermstartdate");
        String transitionPlan = leaseContract.getString("transitionplan");
        String sourceType = leaseContract.getString("sourcetype");
        if (!LeaseContractSourceType.A.name().equals(sourceType) && !LeaseContractSourceType.B.name().equals(sourceType)) {
            long masterId = leaseContract.getLong("masterid");
            DynamicObject masterContract = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)"fa_lease_contract", (String)"sourcetype");
            sourceType = masterContract.getString("sourcetype");
        }
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        BigDecimal leaseLiab = BigDecimal.ZERO;
        BigDecimal leaseLiabOri = BigDecimal.ZERO;
        BigDecimal leaseAssets = BigDecimal.ZERO;
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject row : planEntry) {
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String acctClass = payItem.getString("accountingclass");
            if ("C".equals(acctClass)) continue;
            Date planPayDate = row.getDate("planpaydate");
            if (LeaseContractSourceType.B.name().equals(sourceType) && DateUtil.compareDate((Date)planPayDate, (Date)sysSwitchDate) < 0) continue;
            boolean deductible = row.getBoolean("plan_deductible");
            BigDecimal rent = row.getBigDecimal("rent");
            BigDecimal rentNoTax = row.getBigDecimal("rentnotax");
            BigDecimal tax = row.getBigDecimal("tax");
            BigDecimal unpaidRent = row.getBigDecimal("unpaidrent");
            BigDecimal liabPresentValue = row.getBigDecimal("presentvalue");
            leaseLiab = leaseLiab.add(liabPresentValue);
            leaseLiabOri = leaseLiabOri.add(unpaidRent);
            if (TransitionPlan.A.name().equals(transitionPlan) || TransitionPlan.C.name().equals(transitionPlan)) {
                BigDecimal assetsPresentValue = row.getBigDecimal("presentvalue2");
                leaseAssets = leaseAssets.add(assetsPresentValue);
                if (!"B".equals(acctClass)) continue;
                leaseAssets = leaseAssets.add(deductible && !isDeductVatDiscount ? rentNoTax : rent);
                continue;
            }
            BigDecimal tempAmount = BigDecimal.ZERO;
            if ("A".equals(acctClass)) {
                tempAmount = deductible ? tax : BigDecimal.ZERO;
            } else if ("B".equals(acctClass)) {
                tempAmount = deductible ? rentNoTax : rent;
            }
            leaseAssets = leaseAssets.add(liabPresentValue);
            if ("B".equals(acctClass)) {
                leaseAssets = leaseAssets.add(tempAmount);
                continue;
            }
            if (!isDeductVatDiscount || !"A".equals(acctClass)) continue;
            leaseAssets = leaseAssets.subtract(tempAmount);
        }
        BigDecimal assetsAccumDepre = BigDecimal.ZERO;
        if (TransitionPlan.A.name().equals(transitionPlan)) {
            Date leaseEndDate = leaseContract.getDate("leaseenddate");
            int diffMonths1 = DateUtil.getDiffMonthsByLocalDate((Date)leaseTermStartDate, (Date)leaseEndDate, (boolean)true);
            int diffMonths2 = DateUtil.getDiffMonthsByLocalDate((Date)leaseTermStartDate, (Date)LeaseUtil.getFirstExecDateFromSysParam(orgId), (boolean)true);
            assetsAccumDepre = leaseAssets.multiply(new BigDecimal(diffMonths2)).divide(new BigDecimal(diffMonths1), amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
        }
        leaseContract.set("leaseliabori", (Object)((isExempt = leaseContract.getBoolean("isexempt")) ? BigDecimal.ZERO : leaseLiabOri));
        leaseContract.set("leaseliab", (Object)(isExempt ? BigDecimal.ZERO : leaseLiab));
        leaseContract.set("leaseassets", (Object)(isExempt ? BigDecimal.ZERO : leaseAssets));
        leaseContract.set("assetsaccumdepre", (Object)(isExempt ? BigDecimal.ZERO : assetsAccumDepre));
    }

    public static void saveRentSettle(DynamicObject[] rentSettleArr, boolean syncIep) {
        DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])rentSettleArr);
        if (!syncIep) {
            return;
        }
        Object[] pks = Arrays.stream(result).map(v -> v.getLong("id")).toArray();
        DepreSplitSumUtils.saveIntelliWhitelist(pks, "fa_lease_rent_settle");
    }

    public static void deleteRentSettle(QFilter[] filters, boolean syncIep) {
        DynamicObjectCollection rentSettles = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)"id", (QFilter[])filters);
        Object[] pks = rentSettles.stream().map(v -> v.get("id")).toArray();
        if (syncIep) {
            DepreSplitSumUtils.deleteIntelliWhitelist(pks, "fa_lease_rent_settle");
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_lease_rent_settle"), (Object[])pks);
    }

    private static String buildPayPlanNumber(String payItemNumber, int swiftNum) {
        DecimalFormat format = new DecimalFormat("000");
        String seqStr = format.format(swiftNum);
        return payItemNumber + "-" + seqStr;
    }

    private static Integer getPayPlanNumberSeq(String payPlanNumber) {
        int index = payPlanNumber.lastIndexOf("-");
        String seq = payPlanNumber.substring(index + 1);
        return Integer.parseInt(seq);
    }

    public static int getRoundingMode4CalAmount() {
        return 4;
    }

    public static boolean isExpirationTermination(Date leaseEndDate, Date leaseTerminationDate) {
        return DateUtil.compareDate((Date)leaseEndDate, (Date)leaseTerminationDate) <= 0;
    }

    public static boolean isCalLeaseAssetsForPayPlan(String transitionPlan) {
        return TransitionPlan.A.name().equals(transitionPlan) || TransitionPlan.C.name().equals(transitionPlan);
    }

    public static Map<Long, Long> calTerminationAmortizationPeriodId(Set<Long> leaseContractIds) {
        HashMap<Long, Long> amortizationPeriodIdMap = new HashMap<Long, Long>(256);
        if (leaseContractIds == null || leaseContractIds.isEmpty()) {
            return amortizationPeriodIdMap;
        }
        String algoKey = "kd.fi.fa.business.lease.utils.LeaseUtil.calTerminationAmortizationPeriodId";
        DBRoute faRoute = DBRoute.of((String)"fa");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fleasecontractid, famortizationperiodid from t_fa_lease_term_records where fundotermination = '0' and ", new Object[0]);
        sqlBuilder.appendIn(" fleasecontractid ", (Object[])leaseContractIds.toArray(new Long[0]));
        DataSet termRecordsDataSet = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (SqlBuilder)sqlBuilder);
        for (Row row : termRecordsDataSet) {
            Long leaseContractId = row.getLong("fleasecontractid");
            Long amortizationPeriodId = row.getLong("famortizationperiodid");
            amortizationPeriodIdMap.put(leaseContractId, amortizationPeriodId);
        }
        return amortizationPeriodIdMap;
    }

    public static void upgradeLeaseInterestDetailPeriod() {
        DBRoute faRoute = DBRoute.of((String)"fa");
        String queryInterestDetail = "select S.fid,S.fleasecontractid,P.famortizationperiodid,P.fsourcetype,P.fdate,P.fentryid,N.fperiodtypeid from t_fa_interest_detail S left join t_fa_interest_detail_e P on S.fid = P.fid left join t_fa_lease_init N on S.forgid = N.forgid;";
        String updateInterestDetailEntry = "update t_fa_interest_detail_e set famortizationperiodid = ? where fentryid = ? and famortizationperiodid = 0;";
        int paramMaxSize = 1000;
        DataSet leaseInterestDetailDs = DB.queryDataSet((String)"FaUpdateLeaseInterestDetailServiceImpl", (DBRoute)faRoute, (String)queryInterestDetail);
        HashSet<Long> terminationContracts = new HashSet<Long>(32);
        ArrayList<Object[]> addTypeUpdateParams = new ArrayList<Object[]>(32);
        ArrayList<Object[]> terminationTypeUpdateParams = new ArrayList<Object[]>(32);
        String queryPeriod = "select forgid,fperiodtypeid from t_fa_lease_init";
        HashMap<Long, FaFindPeriodHelper> periodHelperMap = new HashMap<Long, FaFindPeriodHelper>(32);
        DataSet periodDs = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (String)queryPeriod);
        for (Row row : periodDs) {
            Long periodType = row.getLong("fperiodtypeid");
            FaFindPeriodHelper faFindPeriodHelper = new FaFindPeriodHelper(periodType);
            periodHelperMap.put(periodType, faFindPeriodHelper);
        }
        for (Row row : leaseInterestDetailDs) {
            String sourcetype = row.getString("fsourcetype");
            Long contractId = row.getLong("fleasecontractid");
            Long interestDetailEntryId = row.getLong("fentryid");
            Date interestdate = row.getDate("fdate");
            Long periodType = row.getLong("fperiodtypeid");
            if ("A".equals(sourcetype)) {
                Long periodIdByDateId = 0L;
                if (periodHelperMap.containsKey(periodType)) {
                    FaFindPeriodHelper faFindPeriodHelper = (FaFindPeriodHelper)periodHelperMap.get(periodType);
                    periodIdByDateId = faFindPeriodHelper.findPeriodIdByDate(interestdate);
                }
                Object[] param = new Object[]{periodIdByDateId, interestDetailEntryId};
                addTypeUpdateParams.add(param);
                if (addTypeUpdateParams.size() == paramMaxSize) {
                    DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, addTypeUpdateParams);
                    addTypeUpdateParams.clear();
                }
            }
            if (!"B".equals(sourcetype)) continue;
            terminationContracts.add(contractId);
        }
        ArrayList<Long> terminationContractList = new ArrayList<Long>(32);
        terminationContractList.addAll(terminationContracts);
        if (!addTypeUpdateParams.isEmpty()) {
            DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, addTypeUpdateParams);
        }
        if (terminationContractList.isEmpty()) {
            return;
        }
        SqlBuilder queryClearPeriodDetail = new SqlBuilder();
        queryClearPeriodDetail.append("select C.fclearperiodid,L.fid,L.fisexempt,D.fenddate,E.fdate,S.fid interest,E.fentryid,T.fperiodtypeid", new Object[0]);
        queryClearPeriodDetail.append("from t_fa_lease_contract_new L left join t_fa_clrbill C ", new Object[0]);
        queryClearPeriodDetail.append("on L.fclearbillid = C.fid ", new Object[0]);
        queryClearPeriodDetail.append("left join t_bd_period D", new Object[0]);
        queryClearPeriodDetail.append("on C.fclearperiodid = D.fid ", new Object[0]);
        queryClearPeriodDetail.append("left join t_fa_interest_detail S", new Object[0]);
        queryClearPeriodDetail.append("on L.fid = S.fleasecontractid", new Object[0]);
        queryClearPeriodDetail.append("left join t_fa_interest_detail_e E", new Object[0]);
        queryClearPeriodDetail.append("on E.fid = S.fid", new Object[0]);
        queryClearPeriodDetail.append("left join t_fa_lease_init T", new Object[0]);
        queryClearPeriodDetail.append("on L.forgid = T.forgid", new Object[0]);
        queryClearPeriodDetail.append("where ", new Object[0]);
        queryClearPeriodDetail.appendIn("L.fid ", terminationContractList);
        queryClearPeriodDetail.append("and E.fsourcetype = 'B'", new Object[0]);
        DataSet clearPeriodDs = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (SqlBuilder)queryClearPeriodDetail);
        for (Row row : clearPeriodDs) {
            Object[] param;
            Object[] param2;
            FaFindPeriodHelper faFindPeriodHelper;
            Long periodIdByDateId;
            Long periodType;
            Long clearperiodid = row.getLong("fclearperiodid");
            Date clearEndDate = row.getDate("fenddate");
            Long interestId = row.getLong("interest");
            Date interestdate = row.getDate("fdate");
            Long fentryid = row.getLong("fentryid");
            String isexempt = row.getString("fisexempt");
            if (null != interestdate && null != clearEndDate) {
                if (interestdate.compareTo(clearEndDate) > 0) {
                    periodType = row.getLong("fperiodtypeid");
                    periodIdByDateId = 0L;
                    if (periodHelperMap.containsKey(periodType)) {
                        faFindPeriodHelper = (FaFindPeriodHelper)periodHelperMap.get(periodType);
                        periodIdByDateId = faFindPeriodHelper.findPeriodIdByDate(interestdate);
                    }
                    param2 = new Object[]{periodIdByDateId, fentryid};
                    terminationTypeUpdateParams.add(param2);
                } else {
                    param = new Object[]{clearperiodid, fentryid};
                    terminationTypeUpdateParams.add(param);
                }
            }
            if ("1".equals(isexempt) && null != interestdate) {
                periodType = row.getLong("fperiodtypeid");
                periodIdByDateId = 0L;
                if (periodHelperMap.containsKey(periodType)) {
                    faFindPeriodHelper = (FaFindPeriodHelper)periodHelperMap.get(periodType);
                    periodIdByDateId = faFindPeriodHelper.findPeriodIdByDate(interestdate);
                }
                param2 = new Object[]{periodIdByDateId, fentryid};
                terminationTypeUpdateParams.add(param2);
            }
            param = new Object[]{clearperiodid, interestId};
            terminationTypeUpdateParams.add(param);
            if (terminationTypeUpdateParams.size() != paramMaxSize) continue;
            DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, terminationTypeUpdateParams);
            terminationTypeUpdateParams.clear();
        }
        if (!terminationTypeUpdateParams.isEmpty()) {
            DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, terminationTypeUpdateParams);
        }
    }

    public static void upgradeRentSettlePeriod() {
        DBRoute faRoute = DBRoute.of((String)"fa");
        String queryRentSettle = "select S.fid,S.famortizationperiodid,S.fsourcetype,S.fsettledate,S.fleasecontractid,S.forgid,P.fperiodtypeid from t_fa_lease_rent_settle S left join t_fa_lease_init P on S.forgid = P.forgid;";
        String updateRentSettle = "update t_fa_lease_rent_settle set famortizationperiodid = ? where fid = ? and famortizationperiodid = 0;";
        String insertParamsSql = "insert into t_fa_billparam (fid, forgid, fvalue_tag, fparam) values (?, ?, ?, 'oldTerminalLeaseIdForReportQuery')";
        DataSet leaseRentSettleDs = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (String)queryRentSettle);
        int paramMaxSize = 1000;
        ArrayList<Long> terminationContracts = new ArrayList<Long>(32);
        ArrayList<Object[]> addTypeUpdateParams = new ArrayList<Object[]>(paramMaxSize);
        ArrayList<Object[]> terminationTypeUpdateParams = new ArrayList<Object[]>(paramMaxSize);
        HashMap<Long, FaFindPeriodHelper> periodHelperMap = new HashMap<Long, FaFindPeriodHelper>(32);
        String queryPeriod = "select forgid,fperiodtypeid from t_fa_lease_init";
        DataSet periodDs = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (String)queryPeriod);
        HashMap<Long, ArrayList<Long>> oldTerminalLeaseIdMap = new HashMap<Long, ArrayList<Long>>(32);
        ArrayList<Object[]> insertOldTerminalLeaseIdParams = new ArrayList<Object[]>(paramMaxSize);
        for (Row row : periodDs) {
            Long periodType = row.getLong("fperiodtypeid");
            FaFindPeriodHelper faFindPeriodHelper = new FaFindPeriodHelper(periodType);
            periodHelperMap.put(periodType, faFindPeriodHelper);
        }
        for (Row row : leaseRentSettleDs) {
            String sourcetype = row.getString("fsourcetype");
            Long l = row.getLong("fid");
            Long contractId = row.getLong("fleasecontractid");
            Date settleDate = row.getDate("fsettledate");
            Long periodType = row.getLong("fperiodtypeid");
            Long orgId = row.getLong("forgid");
            Long amortizationperiodid = row.getLong("famortizationperiodid");
            if ("A".equals(sourcetype)) {
                Long periodIdByDateId = 0L;
                if (periodHelperMap.containsKey(periodType)) {
                    FaFindPeriodHelper faFindPeriodHelper = (FaFindPeriodHelper)periodHelperMap.get(periodType);
                    periodIdByDateId = faFindPeriodHelper.findPeriodIdByDate(settleDate);
                }
                Object[] param = new Object[]{periodIdByDateId, l};
                addTypeUpdateParams.add(param);
                if (addTypeUpdateParams.size() == paramMaxSize) {
                    DB.executeBatch((DBRoute)faRoute, (String)updateRentSettle, addTypeUpdateParams);
                    addTypeUpdateParams.clear();
                }
            }
            if (!"B".equals(sourcetype)) continue;
            List<Long> oldTerminalLeaseList = LeaseUtil.queryOldTerminaBillparam();
            terminationContracts.add(contractId);
            if (oldTerminalLeaseList.contains(contractId) || null != amortizationperiodid && 0L != amortizationperiodid) continue;
            ArrayList<Long> orgList = (ArrayList<Long>)oldTerminalLeaseIdMap.get(orgId);
            if (null == orgList) {
                orgList = new ArrayList<Long>(1);
            }
            orgList.add(contractId);
            oldTerminalLeaseIdMap.put(orgId, orgList);
        }
        long[] pkIds = DBServiceHelper.genLongIds((String)"t_fa_billparam", (int)oldTerminalLeaseIdMap.size());
        int i = 0;
        for (Map.Entry entry : oldTerminalLeaseIdMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            List leaseIdList = (List)entry.getValue();
            Object[] param = new Object[]{pkIds[i], orgId, leaseIdList.toString()};
            insertOldTerminalLeaseIdParams.add(param);
            ++i;
            if (insertOldTerminalLeaseIdParams.size() != paramMaxSize) continue;
            DB.executeBatch((DBRoute)faRoute, (String)insertParamsSql, insertOldTerminalLeaseIdParams);
            insertOldTerminalLeaseIdParams.clear();
        }
        if (!insertOldTerminalLeaseIdParams.isEmpty()) {
            DB.executeBatch((DBRoute)faRoute, (String)insertParamsSql, insertOldTerminalLeaseIdParams);
        }
        if (!addTypeUpdateParams.isEmpty()) {
            DB.executeBatch((DBRoute)faRoute, (String)updateRentSettle, addTypeUpdateParams);
        }
        if (terminationContracts.isEmpty()) {
            return;
        }
        SqlBuilder queryClearPeriodDetail = new SqlBuilder();
        queryClearPeriodDetail.append("select C.fclearperiodid,L.fid,L.fisexempt,D.fenddate,S.fsettledate,S.fid settleId,T.fperiodtypeid", new Object[0]);
        queryClearPeriodDetail.append("from t_fa_lease_contract_new L left join t_fa_clrbill C ", new Object[0]);
        queryClearPeriodDetail.append("on L.fclearbillid = C.fid ", new Object[0]);
        queryClearPeriodDetail.append("left join t_bd_period D", new Object[0]);
        queryClearPeriodDetail.append("on C.fclearperiodid = D.fid ", new Object[0]);
        queryClearPeriodDetail.append("left join t_fa_lease_rent_settle S", new Object[0]);
        queryClearPeriodDetail.append("on L.fid = S.fleasecontractid", new Object[0]);
        queryClearPeriodDetail.append("left join t_fa_lease_init T", new Object[0]);
        queryClearPeriodDetail.append("on L.forgid = T.forgid", new Object[0]);
        queryClearPeriodDetail.append("where ", new Object[0]);
        queryClearPeriodDetail.appendIn("L.fid ", terminationContracts);
        queryClearPeriodDetail.append("and S.fsourcetype = 'B'", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (SqlBuilder)queryClearPeriodDetail);
        for (Row row : dataSet) {
            Object[] param;
            FaFindPeriodHelper faFindPeriodHelper;
            Long periodIdByDateId;
            Long clearperiodid = row.getLong("fclearperiodid");
            Date clearEndDate = row.getDate("fenddate");
            Long rentSettleId = row.getLong("settleId");
            Date settledate = row.getDate("fsettledate");
            String isexempt = row.getString("fisexempt");
            Long periodType = row.getLong("fperiodtypeid");
            if (null != settledate && null != clearEndDate) {
                if (settledate.compareTo(clearEndDate) > 0) {
                    periodIdByDateId = 0L;
                    if (periodHelperMap.containsKey(periodType)) {
                        faFindPeriodHelper = (FaFindPeriodHelper)periodHelperMap.get(periodType);
                        periodIdByDateId = faFindPeriodHelper.findPeriodIdByDate(settledate);
                    }
                    param = new Object[]{periodIdByDateId, rentSettleId};
                    terminationTypeUpdateParams.add(param);
                } else {
                    Object[] param2 = new Object[]{clearperiodid, rentSettleId};
                    terminationTypeUpdateParams.add(param2);
                }
            }
            if ("1".equals(isexempt) && null != settledate) {
                periodIdByDateId = 0L;
                if (periodHelperMap.containsKey(periodType)) {
                    faFindPeriodHelper = (FaFindPeriodHelper)periodHelperMap.get(periodType);
                    periodIdByDateId = faFindPeriodHelper.findPeriodIdByDate(settledate);
                }
                param = new Object[]{periodIdByDateId, rentSettleId};
                terminationTypeUpdateParams.add(param);
            }
            if (terminationTypeUpdateParams.size() != paramMaxSize) continue;
            DB.executeBatch((DBRoute)faRoute, (String)updateRentSettle, terminationTypeUpdateParams);
            terminationTypeUpdateParams.clear();
        }
        if (!terminationTypeUpdateParams.isEmpty()) {
            DB.executeBatch((DBRoute)faRoute, (String)updateRentSettle, terminationTypeUpdateParams);
        }
    }

    public static List<Long> queryOldTerminaBillparam() {
        DataSet dataSet = DB.queryDataSet((String)"LeaseUtil#queryOldTerminaBillparam", (DBRoute)DBRoute.of((String)"fa"), (String)"select fvalue_tag from t_fa_billparam where fparam = 'oldTerminalLeaseIdForReportQuery'");
        ArrayList<Long> oldTerminaLeaseList = new ArrayList<Long>(1);
        for (Row row : dataSet) {
            String value = row.getString("fvalue_tag");
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            JSONArray objects = JSON.parseArray((String)value);
            List leaseIdLease = JSONObject.parseArray((String)objects.toJSONString(), Long.class);
            oldTerminaLeaseList.addAll(leaseIdLease);
        }
        return oldTerminaLeaseList;
    }

    public static void updateRentSettleBillStatus(Map<Long, Long> termRecordsMap, String billStatus) {
        List rentSettleIds = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)Fa.comma((String[])new String[]{"id", "leasecontract", "amortizationperiod"}), (QFilter[])new QFilter[]{new QFilter("leasecontract", "in", termRecordsMap.keySet())}).stream().filter(v -> v.getLong("amortizationperiod") > (Long)termRecordsMap.get(v.getLong("leasecontract"))).map(v -> v.getLong("id")).collect(Collectors.toList());
        if (!rentSettleIds.isEmpty()) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(rentSettleIds.size());
            for (Long rentSettleId : rentSettleIds) {
                Object[] param = new Object[]{billStatus, rentSettleId};
                paramList.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_lease_rent_settle set fbillstatus = ? where fid = ?", paramList);
        }
    }
}

