/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.merge.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.merge.IFaMergeBillService;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;

public class FaMergeBillServiceImpl
implements IFaMergeBillService {
    @Override
    public Set<Long> findMergedInCards(Set<Long> realCardMasterIdSet, Long periodId) {
        if (CollectionUtils.isEmpty(realCardMasterIdSet)) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(realCardMasterIdSet.size());
        QFilter[] filters = new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}), "in", realCardMasterIdSet), new QFilter("mergeperiod", "=", (Object)periodId)};
        DynamicObjectCollection records = QueryServiceHelper.query((String)"fa_mergebill", (String)Fa.dot((String[])new String[]{"inentryentity", "inrealcard"}), (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.stream().forEach(t -> result.add(t.getLong(Fa.dot((String[])new String[]{"inentryentity", "inrealcard"}))));
        }
        return result;
    }

    @Override
    public Map<String, DynamicObject> findCardLatestMergedPeriod(Set<Long> realCardMasterIdSet) {
        if (CollectionUtils.isEmpty(realCardMasterIdSet)) {
            return new HashMap<String, DynamicObject>(0);
        }
        HashMap<String, DynamicObject> results = new HashMap<String, DynamicObject>(realCardMasterIdSet.size());
        Map<String, Long> depUseIdMasterId2PeriodIdMap = this.findCardLatestMergedPeriodId(realCardMasterIdSet);
        if (depUseIdMasterId2PeriodIdMap == null || depUseIdMasterId2PeriodIdMap.isEmpty()) {
            return results;
        }
        HashSet<Long> periodIds = new HashSet<Long>(depUseIdMasterId2PeriodIdMap.size());
        for (Map.Entry<String, Long> entry : depUseIdMasterId2PeriodIdMap.entrySet()) {
            periodIds.add(entry.getValue());
        }
        Map<Long, DynamicObject> periodMap = PeriodUtil.getPeriodMapByIds(Fa.comma((String[])new String[]{"id", "begindate", "enddate"}), periodIds);
        if (!periodMap.isEmpty()) {
            for (Map.Entry<String, Long> entry : depUseIdMasterId2PeriodIdMap.entrySet()) {
                results.put(entry.getKey(), periodMap.get(entry.getValue()));
            }
        }
        return results;
    }

    private Map<String, Long> findCardLatestMergedPeriodId(Set<Long> realCardMasterIdSet) {
        if (CollectionUtils.isEmpty(realCardMasterIdSet)) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> result = new HashMap<String, Long>(realCardMasterIdSet.size());
        SqlBuilder builder = new SqlBuilder();
        builder.append("select i.findepreuseid depreUseId,i.finrealcardmasterid realCardMasterId,b.fmergeperiodid periodId from t_fa_merge_in i ", new Object[0]);
        builder.append("left join t_fa_mergebill b on i.fid = b.fid where ", new Object[0]);
        builder.appendIn("i.finrealcardmasterid", realCardMasterIdSet.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)builder);){
            if (null != dataSet && !dataSet.isEmpty()) {
                dataSet.forEach(t -> {
                    String key = t.getLong("depreUseId") + "_" + t.getLong("realCardMasterId");
                    Long periodIdVal = t.getLong("periodId");
                    if (!result.containsKey(key) || (Long)result.get(key) < periodIdVal) {
                        result.put(key, periodIdVal);
                    }
                });
            }
        }
        return result;
    }
}

