/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.operate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.IFaRealCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.operate.AbstractFaOpCmd;
import kd.fi.fa.business.operate.IFaOpCmd;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.ChangeBillUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;

public class FaChangeCmd
extends AbstractFaOpCmd
implements IFaOpCmd {
    private static final Log log = LogFactory.getLog(FaChangeCmd.class);
    private static final long changTypeID_originalValue = 733956066525898752L;
    private static final String originalFiled = "fa_card_fin.originalval";
    IFaRealCardDao rCardDao = FaRealCardDaoFactory.getInstance();
    IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
    private static final String CARD_ID = "cardid";
    private static final String REAL_CARD_TYPE_PREFIX = "real";
    private static final String FIN_CARD_TYPE_PREFIX = "fin";

    public FaChangeCmd(Object pk) {
        super(pk);
    }

    @Override
    public String getEntityName() {
        return "fa_change_dept";
    }

    @Override
    protected AbstractFaOpCmd.BizStatusEnumCombo getBizStatusEnumCombo() {
        return new AbstractFaOpCmd.BizStatusEnumCombo(BizStatusEnum.READY, BizStatusEnum.CHG);
    }

    @Override
    protected AbstractFaOpCmd.BillStatusCombo getBillStatusCombo() {
        return new AbstractFaOpCmd.BillStatusCombo(BillStatus.C, BillStatus.A);
    }

    public Map<Long, Long> saveAftChangeBackFin(Set<DynamicObject> finCards) {
        if (finCards.size() < 1) {
            return new HashMap<Long, Long>();
        }
        DataEntityPropertyCollection cardProperties = finCards.iterator().next().getDynamicObjectType().getProperties();
        Set exitPropertyNames = cardProperties.stream().map(v -> v.getName()).collect(Collectors.toSet());
        DynamicObject[] saveCards = new DynamicObject[finCards.size()];
        Iterator<DynamicObject> finItr = finCards.iterator();
        int i = 0;
        while (finItr.hasNext()) {
            DynamicObject sourceCard = finItr.next();
            DynamicObject saveCard = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin"));
            DataEntityPropertyCollection properties = saveCard.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if ("id".equalsIgnoreCase(propertyName) || !exitPropertyNames.contains(propertyName)) continue;
                saveCard.set(propertyName, sourceCard.get(propertyName));
            }
            saveCard.set(CARD_ID, sourceCard.getPkValue());
            saveCards[i++] = saveCard;
        }
        SaveServiceHelper.save((DynamicObject[])saveCards);
        return Stream.of(saveCards).collect(Collectors.toMap(v -> v.getLong(CARD_ID), v -> (Long)v.getPkValue()));
    }

    private boolean checkIfHasFinChanged(Map<Object, List<DynamicObject>> changeFieldFinMap, Object fPK) {
        if (changeFieldFinMap.isEmpty()) {
            return false;
        }
        List<DynamicObject> targetList = changeFieldFinMap.get(fPK);
        if (null == targetList) {
            return false;
        }
        for (DynamicObject target : targetList) {
            String beforeValue = target.getString("beforevalue");
            String afterValue = target.getString("aftervalue");
            if (beforeValue == null && afterValue != null) {
                return true;
            }
            if (beforeValue == null || beforeValue.equals(afterValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateCard() {
        Date curPeriodEndDate;
        DynamicObject bill = this.bill;
        Object[] pks = this.getRealCardPKs(bill);
        if (FaCommonUtils.isEmpty(pks)) {
            return;
        }
        Long orgId = bill.getLong("org_id");
        DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg(orgId);
        DynamicObject mainAssetBook = this.getMainAssetBook(assetBooks);
        boolean isFutureBus = false;
        Date changedate = bill.getDate("changedate");
        if (changedate.after(curPeriodEndDate = mainAssetBook.getDate("enddate"))) {
            isFutureBus = true;
        }
        IBizSetCardDataHandler realHandler = this.getChangeBillAuditCardHandler(bill);
        Map<Object, Object> realCardIdMap = new HashMap();
        Set rCardIdChanged = this.getRealCardChanged(bill);
        Date changeDate = bill.getDate("changedate");
        Map<String, Long[]> orgDepreUse2PeriodMap = FaPeriodUtils.getAssetBookPeriodMap(assetBooks, changeDate);
        if (!rCardIdChanged.isEmpty()) {
            FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
            cardVersionParameter.setAccountdate(changeDate);
            cardVersionParameter.setSrcbillid(bill.getLong("id"));
            cardVersionParameter.setSrcbillentityname("fa_change_dept");
            realCardIdMap = this.rCardDao.copyCards(rCardIdChanged.toArray(), realHandler, orgId, this.pk, cardVersionParameter);
        }
        DynamicObjectCollection realEntries = bill.getDynamicObjectCollection("realentry");
        Map<Object, DynamicObject> finCardSourceMap = this.getFinCardSourceMap(realEntries);
        Map<String, DynamicObject> assetBookSourceMap = this.getAssetBookSourceMap();
        Map<Object, List<DynamicObject>> changeFieldFinMap = this.getChangeFieldFinMap(bill);
        LinkedList<DynamicObject> finCardSnapshots = new LinkedList<DynamicObject>();
        MainEntityType changeBakFinType = MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin");
        for (DynamicObject realEntry : realEntries) {
            realEntry.set("aftrealcard_id", realEntry.getDynamicObject("realcard").getPkValue());
            Object oldReal = realCardIdMap.get(realEntry.getDynamicObject("realcard").getPkValue());
            if (oldReal != null) {
                realEntry.set("realcard_id", oldReal);
            }
            if (isFutureBus) continue;
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            for (DynamicObject finEntry : finEntries) {
                Object fCardId = finEntry.get("fincard_id");
                DynamicObject finCardSnapshot = this.createFinCardSnapshot(fCardId, finCardSourceMap, assetBookSourceMap, (DynamicObjectType)changeBakFinType);
                finCardSnapshots.add(finCardSnapshot);
                finEntry.set("bf_fin_info", (Object)finCardSnapshot);
                if (this.checkIfHasFinChanged(changeFieldFinMap, fCardId)) continue;
                finEntry.set("af_fin_info", (Object)finCardSnapshot);
            }
        }
        if (!CollectionUtils.isEmpty(finCardSnapshots)) {
            SaveServiceHelper.save((DynamicObject[])finCardSnapshots.toArray(new DynamicObject[finCardSnapshots.size()]));
        }
        if (!bill.getString("chtypedetail").equals("2")) {
            this.insetChgFinRel(bill, assetBooks, orgDepreUse2PeriodMap, isFutureBus);
        }
        Map<Long, Map<Long, Long>> mainRealID2FinID = new HashMap<Long, Map<Long, Long>>();
        Map<String, Map<Long, Long>> number2FinID = new HashMap<String, Map<Long, Long>>();
        for (DynamicObject assetBook : assetBooks) {
            IBizSetCardDataHandler handle = this.getChangeBillAuditCardHandler(bill);
            long periodId = assetBook.getLong("curperiod");
            long depureId = assetBook.getLong("depreuse");
            ArrayList<Long> masterIdList = new ArrayList<Long>(realEntries.size());
            Object[] curRealCardIdArr = this.getRealCardPKs(bill, depureId, masterIdList);
            if (!assetBook.getBoolean("ismainbook") && curRealCardIdArr.length == 0 && this.isHasRealCardField(bill)) {
                masterIdList = new ArrayList(realEntries.size());
                curRealCardIdArr = this.getRealCardPKs(bill, mainAssetBook.getLong("depreuse"), masterIdList);
            }
            Map<Long, Map<Long, Long>> curMainRealID2FinID = new HashMap<Long, Map<Long, Long>>();
            HashMap<String, Map<Long, Long>> number2FinIDTemp = new HashMap();
            if (isFutureBus) {
                number2FinIDTemp = this.getMaxNewFinId(depureId, masterIdList);
            } else {
                curMainRealID2FinID = this.fCardDao.copyFinCards(periodId, depureId, curRealCardIdArr, handle, this.getFinChangeSelector(bill), realCardIdMap);
            }
            mainRealID2FinID = FaCommonUtils.mergeMap(mainRealID2FinID, curMainRealID2FinID);
            number2FinID = FaCommonUtils.mergeMap2(number2FinID, number2FinIDTemp);
        }
        for (Object realEntry : realEntries) {
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            for (Object finEntry : finEntries) {
                Long finID;
                Map depreUse2FinID;
                if (!isFutureBus) {
                    depreUse2FinID = (Map)mainRealID2FinID.get(realEntry.getDynamicObject("realcard").getLong("masterid"));
                    finID = (Long)depreUse2FinID.get(finEntry.getLong("depreuse_id"));
                    if (finID == null) continue;
                    finEntry.set("fincard_id", (Object)finID);
                    continue;
                }
                depreUse2FinID = (Map)number2FinID.get(realEntry.getDynamicObject("realcard").getString("number"));
                finID = (Long)depreUse2FinID.get(finEntry.getLong("depreuse_id"));
                if (finID == null) continue;
                finEntry.set("fincard_id", (Object)finID);
            }
        }
        finCardSourceMap = this.getFinCardSourceMap(realEntries);
        LinkedList<DynamicObject> finCardChangeSnapshots = new LinkedList<DynamicObject>();
        for (Object realEntry : realEntries) {
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            for (DynamicObject finEntry : finEntries) {
                if (isFutureBus || finEntry.get("af_fin_info") != null) continue;
                Object curFinID = finEntry.get("fincard_id");
                DynamicObject finCardSnapshot = this.createFinCardSnapshot(curFinID, finCardSourceMap, assetBookSourceMap, (DynamicObjectType)changeBakFinType);
                finCardChangeSnapshots.add(finCardSnapshot);
                finEntry.set("af_fin_info", (Object)finCardSnapshot);
            }
        }
        if (!CollectionUtils.isEmpty(finCardChangeSnapshots)) {
            SaveServiceHelper.save((DynamicObject[])finCardChangeSnapshots.toArray(new DynamicObject[finCardChangeSnapshots.size()]));
        }
        DynamicObjectCollection fieldentries = bill.getDynamicObjectCollection("fieldentry");
        for (DynamicObject fieldEntryEntity : fieldentries) {
            Long finID;
            Map<Long, Long> depreUse2FinID;
            Long depreUseIdInBill;
            Long finIdInBill;
            if (!isFutureBus) {
                Long realIdInBill = (Long)fieldEntryEntity.getDynamicObject("realcard1").getPkValue();
                finIdInBill = (Long)fieldEntryEntity.getDynamicObject("fincard1").getPkValue();
                depreUseIdInBill = (Long)fieldEntryEntity.getDynamicObject("depreuse1").getPkValue();
                depreUse2FinID = mainRealID2FinID.get(realIdInBill);
                finID = null;
                if (depreUse2FinID != null) {
                    finID = depreUse2FinID.get(depreUseIdInBill);
                }
                if (finID == null || finID.longValue() == finIdInBill.longValue()) continue;
                fieldEntryEntity.set("fincard1_id", (Object)finID);
                continue;
            }
            String number = fieldEntryEntity.getDynamicObject("realcard1").getString("number");
            finIdInBill = (Long)fieldEntryEntity.getDynamicObject("fincard1").getPkValue();
            depreUseIdInBill = (Long)fieldEntryEntity.getDynamicObject("depreuse1").getPkValue();
            depreUse2FinID = number2FinID.get(number);
            finID = null;
            if (depreUse2FinID != null) {
                finID = depreUse2FinID.get(depreUseIdInBill);
            }
            if (finID == null || finID.longValue() == finIdInBill.longValue()) continue;
            fieldEntryEntity.set("fincard1_id", (Object)finID);
        }
        bill.set("auditdate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        if (!realCardIdMap.isEmpty() && isFutureBus) {
            this.updateDepreDetails4Future(mainAssetBook, realCardIdMap, changedate);
        }
        if (isFutureBus) {
            return;
        }
        boolean isMoreBook = assetBooks.size() > 1;
        Map<String, Set<Long>> affectMap = this.getAffectFin4OrgAndDepreUse(bill, isMoreBook);
        if (affectMap.size() > 0) {
            HashSet finCardIds = new HashSet(fieldentries.size());
            for (Map.Entry<String, Set<Long>> map : affectMap.entrySet()) {
                finCardIds.addAll(map.getValue());
            }
            this.updateNeedDepre(finCardIds);
        }
        if (this.needPredictDepre()) {
            this.doPredictDepre(bill);
        } else {
            this.doDepreForAffectDepre(bill, affectMap);
            this.reSplit(bill);
        }
    }

    private Map<Object, List<DynamicObject>> getChangeFieldFinMap(DynamicObject bill) {
        DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
        HashMap<Object, List<DynamicObject>> resultMap = new HashMap<Object, List<DynamicObject>>(fieldEntries.size());
        for (DynamicObject fieldEntry : fieldEntries) {
            String[] split = fieldEntry.getString("field").split("\\.");
            if (!split[0].equals("fa_card_fin")) continue;
            Object key = fieldEntry.get("fincard1_id");
            ArrayList<DynamicObject> fieldValues = (ArrayList<DynamicObject>)resultMap.get(key);
            if (fieldValues == null) {
                fieldValues = new ArrayList<DynamicObject>();
                resultMap.put(key, fieldValues);
            }
            fieldValues.add(fieldEntry);
        }
        return resultMap;
    }

    private Map<String, DynamicObject> getAssetBookSourceMap() {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        String selectFields = Fa.comma((String[])new String[]{"org", "depreuse", "curperiod"});
        QFilter[] filters = new QFilter[]{QFilter.isNotNull((String)"org")};
        DynamicObjectCollection records = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        for (DynamicObject record : records) {
            String key = record.getString("org").concat("_").concat(record.getString("depreuse"));
            result.put(key, record);
        }
        return result;
    }

    private Map<Object, DynamicObject> getFinCardSourceMap(DynamicObjectCollection realEntries) {
        DynamicObject[] finArr;
        HashMap<Object, DynamicObject> resultMap = new HashMap<Object, DynamicObject>(1);
        LinkedList<Long> finCardIds = new LinkedList<Long>();
        for (DynamicObject realEntry : realEntries) {
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            if (CollectionUtils.isEmpty((Collection)finEntries)) continue;
            for (DynamicObject finEntry : finEntries) {
                Long fCardId = finEntry.getLong("fincard_id");
                finCardIds.add(fCardId);
            }
        }
        if (CollectionUtils.isEmpty(finCardIds)) {
            return resultMap;
        }
        for (DynamicObject fin : finArr = BusinessDataServiceHelper.load((Object[])finCardIds.stream().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"))) {
            resultMap.put(fin.get("id"), fin);
        }
        return resultMap;
    }

    private Map<String, Map<Long, Long>> getMaxNewFinId(long depreuseId, List<Long> masterIdList) {
        if (masterIdList == null || masterIdList.size() == 0) {
            return new HashMap<String, Map<Long, Long>>();
        }
        QFilter[] realfilters = new QFilter[]{new QFilter("masterid", "in", masterIdList)};
        List realIdList = QueryServiceHelper.queryPrimaryKeys((String)"fa_card_real", (QFilter[])realfilters, null, (int)10000000);
        QFilter filter = new QFilter("realcard", "in", (Object)realIdList).and(new QFilter("endperiod", "=", (Object)99999999999L));
        if (depreuseId > 0L) {
            filter = filter.and(new QFilter("depreuse", "=", (Object)depreuseId));
        }
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)"id,realcard,depreuse,number", (QFilter[])filter.toArray(), (String)"bizperiod asc");
        HashMap<String, Map<Long, Long>> mainRealID2FinID = new HashMap<String, Map<Long, Long>>();
        for (DynamicObject finCard : finCards) {
            Map<Long, Long> depreUse2FinID;
            String number = finCard.getString("number");
            if (mainRealID2FinID.get(number) == null) {
                depreUse2FinID = new HashMap();
                mainRealID2FinID.put(number, depreUse2FinID);
            } else {
                depreUse2FinID = (Map)mainRealID2FinID.get(number);
            }
            depreUse2FinID.put(finCard.getLong("depreuse.id"), finCard.getLong("id"));
        }
        return mainRealID2FinID;
    }

    private void insetChgFinRel(DynamicObject bill, DynamicObjectCollection assetBooks, Map<String, Long[]> orgDepreUse2PeriodMap, boolean isFutureBus) {
        DynamicObjectCollection realEntries = bill.getDynamicObjectCollection("realentry");
        ArrayList<DynamicObject> chgFinRelList = new ArrayList<DynamicObject>(realEntries.size() * 3);
        for (DynamicObject assetBook : assetBooks) {
            String key = assetBook.getString("org") + "_" + assetBook.getString("depreuse");
            Long[] chgPeriodId_prePedId = orgDepreUse2PeriodMap.get(key);
            for (DynamicObject realEntry : realEntries) {
                DynamicObject realDy = realEntry.getDynamicObject("realcard");
                String number = realDy.getString("number");
                Long masterId = realDy.getLong("masterid");
                DynamicObject cheFinRel = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"fa_future_chg_fin_rel").createInstance();
                cheFinRel.set("org_id", (Object)assetBook.getLong("org"));
                cheFinRel.set("depreuse_id", (Object)assetBook.getLong("depreuse"));
                cheFinRel.set("bizperiod_id", (Object)assetBook.getLong("curperiod"));
                cheFinRel.set("chgdateperiod_id", (Object)chgPeriodId_prePedId[0]);
                cheFinRel.set("number", (Object)number);
                cheFinRel.set("masterid", (Object)masterId);
                if (isFutureBus) {
                    cheFinRel.set("isgenfin", (Object)"0");
                } else {
                    cheFinRel.set("isgenfin", (Object)"1");
                }
                cheFinRel.set("changebillid", (Object)bill.getLong("id"));
                cheFinRel.set("createtime", (Object)new Date());
                cheFinRel.set("modifytime", (Object)new Date());
                chgFinRelList.add(cheFinRel);
            }
        }
        SaveServiceHelper.save((DynamicObject[])chgFinRelList.toArray(new DynamicObject[chgFinRelList.size()]));
    }

    private void updateDepreDetails4Future(DynamicObject mainAssetBook, Map<Object, Object> realCardIdMap, Date changedate) {
        if (realCardIdMap.size() < 1) {
            return;
        }
        Long periodTypeId = mainAssetBook.getLong("periodtype");
        DynamicObject changePeriod = PeriodUtil.getPeriodByDate(changedate, "id", periodTypeId);
        ArrayList<Object[]> params = new ArrayList<Object[]>(realCardIdMap.size());
        for (Map.Entry<Object, Object> realCardIds : realCardIdMap.entrySet()) {
            params.add(new Object[]{realCardIds.getValue(), changePeriod.getLong("id"), realCardIds.getKey()});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set FREALCARDID =?  where fbizperiodid<? and FREALCARDID = ?", params);
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depresplitdetail set FREALCARDID =?  where fperiodid <? and FREALCARDID = ? ", params);
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depredetailentry set frealcardid =?  where fperiodid <? and FREALCARDID = ?", params);
    }

    private void reSplit(DynamicObject bill) {
        HashMap<String, HashSet<Long>> needDepreSplit = new HashMap<String, HashSet<Long>>();
        String org = bill.getString("org.id");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("fieldentry");
        for (DynamicObject entry : entrys) {
            Long depre = entry.getLong("depreuse1.id");
            Long realCardId = entry.getLong("realcard1.id");
            String ckey = org + "_" + depre.toString();
            HashSet<Long> cardIds = (HashSet<Long>)needDepreSplit.get(ckey);
            if (cardIds == null) {
                cardIds = new HashSet<Long>();
                needDepreSplit.put(ckey, cardIds);
            }
            cardIds.add(realCardId);
        }
        for (Map.Entry next : needDepreSplit.entrySet()) {
            String key = (String)next.getKey();
            Set value = (Set)next.getValue();
            String[] split = key.split("_");
            new DepreSplitSum().updateDepreSplit4ChangeBill(Long.parseLong(split[0]), Long.parseLong(split[1]), value);
        }
    }

    private void doPredictDepre(DynamicObject bill) {
        DynamicObjectCollection changeItems = bill.getDynamicObjectCollection("changeitem");
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        boolean hasFinDepre = this.getNeedPredictDepreCards(bill, map);
        if (!hasFinDepre) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String orgId_depreuseId = (String)entry.getKey();
            Set depreFinIdSet = (Set)entry.getValue();
            if (depreFinIdSet.isEmpty()) continue;
            String[] array = orgId_depreuseId.split("_");
            DynamicObject bookObj = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(array[0])), new QFilter("depreuse", "=", (Object)Long.parseLong(array[1]))});
            bookObj = BusinessDataServiceHelper.loadSingle((Object)bookObj.get("id"), (String)"fa_assetbook");
            DepreBook bookBox = new DepreBook(bookObj);
            bookBox.depreFinCardsAndRecordLog("fa_change_dept", depreFinIdSet, false, false, false);
        }
    }

    private boolean getNeedPredictDepreCards(DynamicObject bill, Map<String, Set<Long>> depreFinSet) {
        boolean hasFinDepre = false;
        Long orgId = bill.getLong("org.id");
        DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
        String originalFiled = Fa.dot((String[])new String[]{"fa_card_fin", "originalval"});
        String preresidualvalFiled = Fa.dot((String[])new String[]{"fa_card_fin", "preresidualval"});
        String preusingamountFiled = Fa.dot((String[])new String[]{"fa_card_fin", "preusingamount"});
        for (DynamicObject fieldEntry : fieldEntries) {
            String filedValue = fieldEntry.getString("field");
            if (!filedValue.equals(originalFiled) && !filedValue.equals(preresidualvalFiled) && !filedValue.equals(preusingamountFiled)) continue;
            BigDecimal beforeValue = fieldEntry.getBigDecimal("beforevalue");
            BigDecimal afterValue = fieldEntry.getBigDecimal("aftervalue");
            if ((!filedValue.equals(originalFiled) && !filedValue.equals(preusingamountFiled) || beforeValue.compareTo(afterValue) <= 0) && (!filedValue.equals(preresidualvalFiled) || beforeValue.compareTo(afterValue) >= 0)) continue;
            Long depreuseId = fieldEntry.getLong("depreuse1.id");
            Long cardfinId = fieldEntry.getLong("fincard1.id");
            Set<Long> depreFinIdSet = depreFinSet.get(orgId + "_" + depreuseId);
            if (CollectionUtils.isEmpty(depreFinIdSet)) {
                depreFinIdSet = new HashSet<Long>(8);
                depreFinSet.put(orgId + "_" + depreuseId, depreFinIdSet);
            }
            depreFinIdSet.add(cardfinId);
            hasFinDepre = true;
        }
        return hasFinDepre;
    }

    private void doDepreForAffectDepre(DynamicObject bill, Map<String, Set<Long>> affectMap) {
        if (affectMap == null || affectMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Set<Long>> entry : affectMap.entrySet()) {
            String orgId_depreuseId = entry.getKey();
            Set<Long> depreFinIdSet = entry.getValue();
            if (depreFinIdSet.isEmpty()) continue;
            String[] array = orgId_depreuseId.split("_");
            DynamicObject bookObj = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(array[0])), new QFilter("depreuse", "=", (Object)Long.parseLong(array[1]))});
            bookObj = BusinessDataServiceHelper.loadSingle((Object)bookObj.get("id"), (String)"fa_assetbook");
            DepreBook bookBox = new DepreBook(bookObj);
            bookBox.depreFinCardsAndRecordLog("fa_change_dept", depreFinIdSet, true, false, false);
        }
    }

    private Set getRealCardChanged(DynamicObject bill) {
        DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
        HashSet<Object> rCardIds = new HashSet<Object>();
        for (DynamicObject fieldEntry : fieldEntries) {
            String[] split = fieldEntry.getString("field").split("\\.");
            if (!"fa_card_real".equalsIgnoreCase(split[0]) || fieldEntry.get("beforevalue").equals(fieldEntry.get("aftervalue"))) continue;
            rCardIds.add(fieldEntry.get("realcard1_id"));
        }
        return rCardIds;
    }

    private Map<String, Set<Long>> getAffectFin4OrgAndDepreUse(DynamicObject bill, boolean isMoreBook) {
        DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
        HashMap<String, Set<Long>> affectCardIdAndDepreUseId = new HashMap<String, Set<Long>>();
        Long orgId = bill.getDynamicObject("org").getLong("id");
        HashSet<Object> realCardIds = new HashSet<Object>(fieldEntries.size());
        for (DynamicObject fieldEntry : fieldEntries) {
            String field = fieldEntry.getString("field");
            boolean affectDepre = ChangeBillUtils.canAdjustDepre(field);
            if (!affectDepre) continue;
            Long finCardId = fieldEntry.getLong("fincard1_id");
            Long depreUseId = fieldEntry.getLong("depreuse1_id");
            String key = orgId + "_" + depreUseId;
            HashSet<Long> finCardIdSet = (HashSet<Long>)affectCardIdAndDepreUseId.get(key);
            if (finCardIdSet == null) {
                finCardIdSet = new HashSet<Long>(fieldEntries.size());
                affectCardIdAndDepreUseId.put(key, finCardIdSet);
            }
            finCardIdSet.add(finCardId);
            if (!field.contains("fa_card_real") || !isMoreBook) continue;
            realCardIds.add(fieldEntry.get("realcard1_id"));
        }
        if (!realCardIds.isEmpty()) {
            List<DynamicObject> finCardList = FaUtils.queryFinCardList(realCardIds, null, null, null);
            for (DynamicObject finCard : finCardList) {
                long finCardId = finCard.getLong("id");
                long depreUseId = finCard.getDynamicObject("depreuse").getLong("id");
                String key = orgId + "_" + depreUseId;
                HashSet<Long> finCardIdSet = (HashSet<Long>)affectCardIdAndDepreUseId.get(key);
                if (finCardIdSet == null) {
                    finCardIdSet = new HashSet<Long>(fieldEntries.size());
                    affectCardIdAndDepreUseId.put(key, finCardIdSet);
                }
                finCardIdSet.add(finCardId);
            }
        }
        return affectCardIdAndDepreUseId;
    }

    public DynamicObject createFinCardSnapshot(Object fCardId) {
        DynamicObject fCard = BusinessDataServiceHelper.loadSingle((Object)fCardId, (String)"fa_card_fin");
        DynamicObject fCardSnapshot = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin"));
        DataEntityPropertyCollection properties = fCardSnapshot.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if ("id".equalsIgnoreCase(propertyName) || "changebillid".equalsIgnoreCase(propertyName) || CARD_ID.equalsIgnoreCase(propertyName)) continue;
            if ("accumdepre".equalsIgnoreCase(propertyName)) {
                QFilter[] filter = new QFilter[]{new QFilter("org", "=", ((DynamicObject)fCard.get("org")).getPkValue()), new QFilter("depreuse", "=", ((DynamicObject)fCard.get("depreuse")).getPkValue())};
                DynamicObject assetbook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"curperiod.id", (QFilter[])filter);
                Object nowPeriod = assetbook.get("curperiod.id");
                if (fCard.get("bizperiod") != null && fCard.get("bizperiod") != "0" && nowPeriod.equals(((DynamicObject)fCard.get("bizperiod")).getPkValue())) {
                    BigDecimal nowdepre = (BigDecimal)fCard.get("monthdepre");
                    BigDecimal newdepre = ((BigDecimal)fCard.get(propertyName)).subtract(nowdepre);
                    fCardSnapshot.set(propertyName, (Object)newdepre);
                    continue;
                }
                fCardSnapshot.set(propertyName, fCard.get(propertyName));
                continue;
            }
            fCardSnapshot.set(propertyName, fCard.get(propertyName));
        }
        fCardSnapshot.set("changebillid", this.pk);
        fCardSnapshot.set(CARD_ID, fCardId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fCardSnapshot});
        return fCardSnapshot;
    }

    public DynamicObject createFinCardSnapshot(Object fCardId, Map<Object, DynamicObject> finCardSourceMap, Map<String, DynamicObject> assetBookSourceMap, DynamicObjectType changeBakFinType) {
        DynamicObject fCard;
        DynamicObject dynamicObject = fCard = null == finCardSourceMap || finCardSourceMap.isEmpty() ? null : finCardSourceMap.get(fCardId);
        if (null == fCard && null == (fCard = BusinessDataServiceHelper.loadSingle((Object)fCardId, (String)"fa_card_fin"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"id[%s]\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FaChangeCmd_0", (String)"fi-fa-business", (Object[])new Object[0]), fCardId));
        }
        DynamicObject fCardSnapshot = new DynamicObject(changeBakFinType);
        DataEntityPropertyCollection properties = fCardSnapshot.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if ("id".equalsIgnoreCase(propertyName) || "changebillid".equalsIgnoreCase(propertyName) || CARD_ID.equalsIgnoreCase(propertyName)) continue;
            if ("accumdepre".equalsIgnoreCase(propertyName)) {
                DynamicObject bizPeriod;
                String assetBookKey = String.valueOf(((DynamicObject)fCard.get("org")).getPkValue()).concat("_").concat(String.valueOf(((DynamicObject)fCard.get("depreuse")).getPkValue()));
                DynamicObject assetBook = null == assetBookSourceMap || assetBookSourceMap.isEmpty() ? null : assetBookSourceMap.get(assetBookKey);
                Object nowPeriod = null;
                if (null != assetBook) {
                    nowPeriod = assetBook.get("curperiod");
                }
                if ((bizPeriod = fCard.getDynamicObject("bizperiod")) != null && nowPeriod != null && nowPeriod.equals(bizPeriod.getLong("id"))) {
                    BigDecimal nowdepre = (BigDecimal)fCard.get("monthdepre");
                    BigDecimal newdepre = ((BigDecimal)fCard.get(propertyName)).subtract(nowdepre);
                    fCardSnapshot.set(propertyName, (Object)newdepre);
                    continue;
                }
                fCardSnapshot.set(propertyName, fCard.get(propertyName));
                continue;
            }
            fCardSnapshot.set(propertyName, fCard.get(propertyName));
        }
        fCardSnapshot.set("changebillid", this.pk);
        fCardSnapshot.set(CARD_ID, fCardId);
        String tableName = changeBakFinType.getAlias();
        Long snapshotId = DB.genLongId((String)tableName);
        fCardSnapshot.set("id", (Object)snapshotId);
        return fCardSnapshot;
    }

    private void updateNeedDepre(Set fCardIdSet) {
        DynamicObject[] fCards;
        for (DynamicObject fCard : fCards = BusinessDataServiceHelper.load((Object[])fCardIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"))) {
            fCard.set("isneeddepre", (Object)true);
        }
        SaveServiceHelper.save((DynamicObject[])fCards);
    }

    private IBizSetCardDataHandler getChangeBillAuditCardHandler(DynamicObject changeBill) {
        Map<String, List<DynamicObject>> cardMap = this.convert2CardChangeMap(changeBill.getDynamicObjectCollection("fieldentry"));
        boolean isSysPreDepreMethod4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload(changeBill.getDynamicObject("changetype"));
        return card -> this.updateCardHandler(card, cardMap, true, isSysPreDepreMethod4Workload);
    }

    private IBizSetCardDataHandler getChangeBillUnAuditCardHandler(DynamicObject changeBill) {
        Map<String, List<DynamicObject>> cardMap = this.convert2CardChangeMap(changeBill.getDynamicObjectCollection("fieldentry"));
        boolean isSysPreDepreMethod4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload(changeBill.getDynamicObject("changetype"));
        return card -> this.updateCardHandler(card, cardMap, false, isSysPreDepreMethod4Workload);
    }

    private void updateCardHandler(DynamicObject card, Map<String, List<DynamicObject>> cardMap, boolean isAudit, boolean isSysPreDepreMethod4Workload) {
        DynamicObjectType type = card.getDynamicObjectType();
        String cardTypeName = type.getName();
        boolean isRealCard = "fa_card_real".equalsIgnoreCase(cardTypeName);
        String cardFieldName = isRealCard ? "realcard1" : "fincard1";
        cardFieldName = cardFieldName + "_id";
        DynamicObject realCard = isRealCard ? card : card.getDynamicObject("realcard");
        String cardNumber = realCard.getString("number");
        boolean originalValChanged = false;
        BigDecimal deltaOriginalVal = BigDecimal.ZERO;
        boolean match = false;
        List<DynamicObject> targetRealCardList = null;
        String targetKey = isRealCard ? String.valueOf(card.getLong("masterid")) + "_" + REAL_CARD_TYPE_PREFIX : String.valueOf(card.getLong("realcard.masterid")) + "_" + FIN_CARD_TYPE_PREFIX + "_" + String.valueOf(card.get("depreuse_id"));
        targetRealCardList = cardMap.get(targetKey);
        boolean bl = match = !CollectionUtils.isEmpty(targetRealCardList);
        if (match) {
            for (DynamicObject targetRealCard : targetRealCardList) {
                String[] split = targetRealCard.getString("field").split("\\.");
                if (!split[0].equalsIgnoreCase(cardTypeName)) continue;
                String propName = split[1];
                Object parsedValue = FaChangeBillUtil.parseValue(type, propName, targetRealCard.getString(isAudit ? "aftervalue" : "beforevalue"));
                if (!isAudit || parsedValue != null) {
                    card.set(propName, parsedValue);
                }
                if (!propName.equalsIgnoreCase("originalval") || parsedValue == null) continue;
                originalValChanged = true;
                BigDecimal aftOriVal = (BigDecimal)parsedValue;
                BigDecimal bfrOriVal = (BigDecimal)FaChangeBillUtil.parseValue(type, "originalval", targetRealCard.getString(!isAudit ? "aftervalue" : "beforevalue"));
                deltaOriginalVal = aftOriVal.subtract(bfrOriVal);
            }
        }
        if (originalValChanged) {
            BigDecimal originalVal = card.getBigDecimal("originalval");
            BigDecimal accumDepre = card.getBigDecimal("accumdepre");
            BigDecimal monthDepre = card.getBigDecimal("monthdepre");
            BigDecimal decVal = card.getBigDecimal("decval");
            BigDecimal netWorth = originalVal.subtract(accumDepre);
            BigDecimal netAmount = netWorth.subtract(decVal);
            card.set("networth", (Object)netWorth);
            card.set("netamount", (Object)netWorth.subtract(decVal));
            card.set("monthorigvalchg", (Object)card.getBigDecimal("monthorigvalchg").add(deltaOriginalVal));
            card.set("yearorigvalchg", (Object)card.getBigDecimal("yearorigvalchg").add(deltaOriginalVal));
        }
        if (isSysPreDepreMethod4Workload) {
            card.set("addidepreamount", (Object)BigDecimal.ZERO);
        }
    }

    private Map<String, List<DynamicObject>> convert2CardChangeMap(DynamicObjectCollection fieldEntries) {
        if (CollectionUtils.isEmpty((Collection)fieldEntries)) {
            return null;
        }
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject fieldObj : fieldEntries) {
            String[] changeField = fieldObj.getString("field").split("\\.");
            String cardTypeName = changeField[0];
            boolean isRealCard = "fa_card_real".equalsIgnoreCase(cardTypeName);
            String key = isRealCard ? String.valueOf(fieldObj.getLong("realcard1.masterid")) + "_" + REAL_CARD_TYPE_PREFIX : String.valueOf(fieldObj.getLong("realcard1.masterid")) + "_" + FIN_CARD_TYPE_PREFIX + "_" + String.valueOf(fieldObj.getLong("depreuse1_id"));
            ArrayList<DynamicObject> valueList = (ArrayList<DynamicObject>)resultMap.get(key);
            if (CollectionUtils.isEmpty((Collection)valueList)) {
                valueList = new ArrayList<DynamicObject>();
            }
            valueList.add(fieldObj);
            resultMap.put(key, valueList);
        }
        return resultMap;
    }

    @Override
    protected void restoreCard() {
        DynamicObject[] rCards;
        DynamicObject bill = this.bill;
        Map<Object, Object> befAndAftChange = this.getBefAndAftRealCardIdMap(bill);
        Map<Object, Object> idMap = this.getFinAndRealCardIdMap(bill);
        if (idMap.isEmpty()) {
            return;
        }
        IBizSetCardDataHandler changeBillUnAuditCardHandler = this.getChangeBillUnAuditCardHandler(bill);
        if (!befAndAftChange.isEmpty()) {
            FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
            cardVersionParameter.setSrcbillid(bill.getLong("id"));
            cardVersionParameter.setSrcbillentityname("fa_change_dept");
            this.rCardDao.restoreCards(idMap.values().toArray(), befAndAftChange, this.getBizStatusEnumCombo().getAfter(), changeBillUnAuditCardHandler, this.pk, cardVersionParameter);
        }
        Set rCardIds = bill.getDynamicObjectCollection("realentry").stream().map(v -> v.getLong("aftrealcard_id")).collect(Collectors.toSet());
        rCardIds.removeAll(befAndAftChange.values());
        for (DynamicObject rCard : rCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)"bizstatus", (QFilter[])new QFilter("id", "in", rCardIds).toArray())) {
            rCard.set("bizstatus", (Object)this.getBizStatusEnumCombo().getAfter());
        }
        SaveServiceHelper.save((DynamicObject[])rCards);
        Object[] params2 = new Object[]{bill.getLong("id")};
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_future_chg_fin_rel set fisgenfin ='0',fisdeleted='1'  where fchangebillid = ? ", (Object[])params2);
        Long orgId = bill.getLong("org_id");
        DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg(orgId);
        DynamicObject mainAssetBook = this.getMainAssetBook(assetBooks);
        boolean isFutureBus = false;
        Date changedate = bill.getDate("changedate");
        Date curPeriodEndDate = mainAssetBook.getDate("enddate");
        if (changedate.after(curPeriodEndDate)) {
            isFutureBus = true;
        }
        for (DynamicObject assetBook : assetBooks) {
            long periodId = assetBook.getLong("curperiod");
            long depureId = assetBook.getLong("depreuse");
            Object[] curRealCardIdArr = this.getRealCardPKs(bill, depureId, null);
            if (!assetBook.getBoolean("ismainbook") && curRealCardIdArr.length == 0 && this.isHasRealCardField(bill)) {
                curRealCardIdArr = this.getRealCardPKs(bill, mainAssetBook.getLong("depreuse"), null);
            }
            this.fCardDao.restoreCard(periodId, depureId, curRealCardIdArr, changeBillUnAuditCardHandler, this.getFinChangeSelector(bill));
            DynamicObjectCollection realEntries = bill.getDynamicObjectCollection("realentry");
            ArrayList<Long> changeBackCards = new ArrayList<Long>(realEntries.size() * 2);
            for (DynamicObject realEntry : realEntries) {
                realEntry.set("aftrealcard_id", null);
                Object aftRealID = befAndAftChange.get(realEntry.getDynamicObject("realcard").getPkValue());
                if (aftRealID != null) {
                    realEntry.set("realcard_id", aftRealID);
                }
                for (DynamicObject finEntry : realEntry.getDynamicObjectCollection("finentry")) {
                    Long aftFinInfoId;
                    Long bfFinInfoId = finEntry.getLong("bf_fin_info_id");
                    if (bfFinInfoId != null && bfFinInfoId != 0L) {
                        changeBackCards.add(bfFinInfoId);
                    }
                    if ((aftFinInfoId = Long.valueOf(finEntry.getLong("af_fin_info_id"))) != null && aftFinInfoId != 0L) {
                        changeBackCards.add(aftFinInfoId);
                    }
                    finEntry.set("bf_fin_info_id", null);
                    finEntry.set("af_fin_info_id", null);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            if (changeBackCards.size() <= 0) continue;
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin"), (Object[])changeBackCards.toArray());
        }
        if (isFutureBus) {
            return;
        }
        boolean isMoreBook = assetBooks.size() > 1;
        Map<String, Set<Long>> affectMap = this.getAffectFin4OrgAndDepreUse(bill, isMoreBook);
        if (affectMap.size() > 0) {
            HashSet finCardIds = new HashSet(bill.getDynamicObjectCollection("fieldentry").size());
            for (Map.Entry<String, Set<Long>> map : affectMap.entrySet()) {
                finCardIds.addAll(map.getValue());
            }
            this.updateNeedDepre(finCardIds);
        }
        if (this.needPredictDepre()) {
            this.doPredictDepre(bill);
        } else {
            this.doDepreForAffectDepre(bill, affectMap);
            this.reSplit(bill);
        }
    }

    private boolean needPredictDepre() {
        DynamicObject depreSplitConfigObj = QueryServiceHelper.queryOne((String)"fa_billparam", (String)"value", (QFilter[])new QFilter[]{new QFilter("entity", "=", (Object)"fa_change_dept"), new QFilter("param", "=", (Object)"changebill.depresplit.simplification"), new QFilter("enable", "=", (Object)true)});
        if (depreSplitConfigObj != null) {
            return depreSplitConfigObj.getBoolean("value");
        }
        return false;
    }

    private Object[] getRealCardPKs(DynamicObject bill, Long depreuseId, List<Long> masterIdList) {
        ArrayList<Object> realCardPKList = new ArrayList<Object>();
        for (DynamicObject entry : bill.getDynamicObjectCollection("fieldentry")) {
            DynamicObject depreuse = entry.getDynamicObject("depreuse1");
            if (depreuse == null) {
                realCardPKList.add(entry.getDynamicObject("realcard1").getPkValue());
                if (masterIdList == null) continue;
                masterIdList.add(entry.getDynamicObject("realcard1").getLong("masterid"));
                continue;
            }
            long curDepreuseId = entry.getDynamicObject("depreuse1").getLong("id");
            if (depreuseId > 0L && curDepreuseId != depreuseId) continue;
            realCardPKList.add(entry.getDynamicObject("realcard1").getPkValue());
            if (masterIdList == null) continue;
            masterIdList.add(entry.getDynamicObject("realcard1").getLong("masterid"));
        }
        if (realCardPKList.isEmpty()) {
            return new Object[0];
        }
        return realCardPKList.toArray();
    }

    private boolean isHasRealCardField(DynamicObject bill) {
        for (DynamicObject entry : bill.getDynamicObjectCollection("fieldentry")) {
            String field = entry.getString("field");
            if (field == null || !field.contains("fa_card_real")) continue;
            return true;
        }
        return false;
    }

    private DynamicObject getMainAssetBook(DynamicObjectCollection assetBooks) {
        for (DynamicObject assetBook : assetBooks) {
            if (!assetBook.getBoolean("ismainbook")) continue;
            return assetBook;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u4e3b\u8d26\u7c3f", (String)"FaChangeCmd_1", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    protected Object[] getRealCardPKs(DynamicObject bill) {
        ArrayList<Object> realCardPKList = new ArrayList<Object>();
        for (DynamicObject entry : bill.getDynamicObjectCollection("realentry")) {
            realCardPKList.add(entry.getDynamicObject("realcard").getPkValue());
        }
        if (realCardPKList.isEmpty()) {
            return new Object[0];
        }
        return realCardPKList.toArray();
    }

    protected Map<Object, Object> getFinAndRealCardIdMap(DynamicObject bill) {
        HashMap<Object, Object> finAndRealCardIdMap = new HashMap<Object, Object>();
        for (DynamicObject realEntry : bill.getDynamicObjectCollection("realentry")) {
            Object rCardPk = realEntry.getDynamicObject("realcard").getPkValue();
            for (DynamicObject finEntry : realEntry.getDynamicObjectCollection("finentry")) {
                Object fCardPk = finEntry.getDynamicObject("fincard").getPkValue();
                finAndRealCardIdMap.put(fCardPk, rCardPk);
            }
        }
        return finAndRealCardIdMap;
    }

    protected Map<Object, Object> getBefAndAftRealCardIdMap(DynamicObject bill) {
        HashMap<Object, Object> befAndAftRealCardids = new HashMap<Object, Object>();
        for (DynamicObject entry : bill.getDynamicObjectCollection("realentry")) {
            Object rAfterPk;
            Object rPk = entry.getDynamicObject("realcard").getPkValue();
            if (rPk.equals(rAfterPk = entry.getDynamicObject("aftrealcard").getPkValue())) continue;
            befAndAftRealCardids.put(rPk, rAfterPk);
        }
        return befAndAftRealCardids;
    }

    private String[] getFinChangeSelector(DynamicObject bill) {
        DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
        HashSet<String> ret = new HashSet<String>();
        ret.add("realcard");
        for (DynamicObject fieldEntry : fieldEntries) {
            String[] split = fieldEntry.getString("field").split("\\.");
            if ("fa_card_real".equalsIgnoreCase(split[0])) {
                if (split[1].equalsIgnoreCase("headusedept")) {
                    ret.add("depredept");
                }
                if (!split[1].equalsIgnoreCase("assetcat")) continue;
                ret.add("assetcat");
                continue;
            }
            ret.add(split[1]);
            if (!split[1].equalsIgnoreCase("originalval")) continue;
            ret.add("networth");
            ret.add("netamount");
            ret.add("decval");
            ret.add("accumdepre");
            ret.add("monthdepre");
            ret.add("monthorigvalchg");
            ret.add("yearorigvalchg");
        }
        return ret.toArray(new String[0]);
    }

    @Override
    protected void auditUpdateRealBizStatus() {
        FaModiRealStatsUtils.update_oneBill_bizStatus(this.bill, "realentry", "realcard", this.getBizStatusEnumCombo().getBefore(), this.getBizStatusEnumCombo().getAfter());
    }

    @Override
    protected void unAuditUpdateRealBizStatus() {
        FaModiRealStatsUtils.update_oneBill_bizStatus(this.bill, "realentry", "realcard", this.getBizStatusEnumCombo().getAfter(), this.getBizStatusEnumCombo().getBefore());
    }
}

