/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.operate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.operate.IFaOpCmd;
import kd.fi.fa.business.utils.AttachmentUtils;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.utils.FaCardInitFieldUtil;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaChangeItemUtil;

public class FaFinCardCmd
implements IFaOpCmd {
    private static Log log = LogFactory.getLog(FaFinCardCmd.class);
    private static final String[] DEPRE_VALUE_SELECTOR = new String[]{"period", "bizperiod", "endperiod", "isneeddepre", "realcard", Fa.dot((String[])new String[]{"realcard", "masterid"}), "assetbook", "originalval", "monthdepre", "addupyeardepre", Fa.dot((String[])new String[]{"realcard", "initialcard"}), "accumdepre", "depredamount", "networth", "netamount", "decval", "addidepreamount", "org", "depreuse"};
    private static final String queryAllFin2Fields = Fa.comma((String[])new String[]{"fid", "realcard", "assetbook", "billstatus"});
    private final Object[] pks;

    public FaFinCardCmd(Object[] pks) {
        this.pks = pks;
    }

    @Override
    public void doAudit() {
        HashSet<Long> oriFinRealMasterIds = new HashSet<Long>(this.pks.length);
        Collection<DynamicObject> finCardPlainObjs = this.findFinCards4Audit(this.pks, oriFinRealMasterIds);
        Set realCardPks = finCardPlainObjs.stream().map(v -> v.get("realcard.id")).collect(Collectors.toSet());
        realCardPks.addAll(oriFinRealMasterIds);
        QFilter[] unAuditFilter = new QFilter[]{new QFilter("realcard.id", "in", realCardPks), new QFilter("billstatus", "!=", (Object)BillStatus.C.toString())};
        DynamicObjectCollection finCardUnAuditPlainObjs = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard.id", (QFilter[])unAuditFilter);
        Set realCardNotReadyPks = finCardUnAuditPlainObjs.stream().map(v -> v.get("realcard.id")).collect(Collectors.toSet());
        realCardPks.removeAll(realCardNotReadyPks);
        FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(realCardPks.toArray(), BizStatusEnum.READY);
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>(16);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        for (DynamicObject finCard : finCardPlainObjs) {
            if (finCard.getBoolean("realcard.initialcard") || BigDecimal.ZERO.compareTo(finCard.getBigDecimal("accumdepre")) == 0 && BigDecimal.ZERO.compareTo(finCard.getBigDecimal("decval")) == 0) continue;
            DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
            dynamicCard.set("realcard", (Object)finCard.getLong("realcardmasterid"));
            dynamicCard.set("assetbook", (Object)finCard.getLong("assetbook.id"));
            dynamicCard.set("depreuse", (Object)finCard.getLong("depreuse.id"));
            dynamicCard.set("date", (Object)finCard.getDate("finaccountdate"));
            dynamicCard.set("entityname", (Object)"fa_card_fin");
            dynamicCard.set("changebillid", (Object)finCard.getLong("assetbook.id"));
            dynamicCards.add(dynamicCard);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doUnaudit() {
        void var23_27;
        DynamicObject[] realId;
        IFaFinCardDao dao = FaFinCardDaoFactory.getInstance();
        HashSet<String> selectFields = new HashSet<String>(Arrays.asList(DEPRE_VALUE_SELECTOR));
        selectFields.addAll(FaChangeItemUtil.getAllInitFields((String)"fa_card_fin"));
        selectFields.add("realcardmasterid");
        DynamicObject[] finCards = dao.query(Fa.join((String)",", (String[])selectFields.toArray(new String[0])), new QFilter("id", "in", (Object)this.pks));
        Map realId_bookIds = Stream.of(finCards).collect(Collectors.groupingBy(v -> v.getDynamicObject("realcard").getPkValue(), Collectors.mapping(v -> v.getDynamicObject("assetbook").getPkValue(), Collectors.toSet())));
        HashSet<Object> realCardPKs = new HashSet<Object>(finCards.length);
        HashSet<Object> realCardMasterId = new HashSet<Object>(finCards.length);
        for (DynamicObject finCard : finCards) {
            Object realCardPK = finCard.getDynamicObject("realcard").getPkValue();
            Object realMasterId = finCard.get(Fa.dot((String[])new String[]{"realcard", "masterid"}));
            realCardMasterId.add(realMasterId);
            realCardPKs.add(realCardPK);
        }
        Long orgId = finCards[0].getLong(Fa.id((String)"org"));
        Long depreuseId = finCards[0].getLong(Fa.id((String)"depreuse"));
        boolean enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit(orgId);
        Map<Object, Object> oriIdFinIdMap = new HashMap(finCards.length);
        if (enableCurPeriodSplit) {
            oriIdFinIdMap = dao.findOriIdFinIdMap(realCardMasterId, depreuseId);
        }
        String order = Fa.join((Object[])new String[]{"realcard", "endperiod"}, (String)",");
        long assetBookId = finCards[0].getLong(Fa.id((String)"assetbook"));
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCardPKs), new QFilter("assetbook", "=", (Object)assetBookId)};
        DynamicObjectCollection relatedFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.join((Object[])new String[]{"id", "realcard", "endperiod", "assetbook"}, (String)","), (QFilter[])filters, (String)order);
        HashSet<Object> firstFinCardIdSet = new HashSet<Object>();
        HashSet<Object> backupFinCardPKs = new HashSet<Object>();
        DynamicObject[] preRealCardPK = null;
        for (DynamicObject relatedFinCard : relatedFinCards) {
            Set bookIds;
            realId = relatedFinCard.get("realcard");
            if (!realId.equals(preRealCardPK)) {
                firstFinCardIdSet.add(relatedFinCard.get("id"));
            }
            if ((bookIds = realId_bookIds.get(realId)).contains(relatedFinCard.get("assetbook"))) {
                backupFinCardPKs.add(relatedFinCard.get("id"));
            }
            preRealCardPK = realId;
        }
        DynamicObject[] firstFinCards = FaFinCardDaoFactory.getInstance().query(Fa.join((Object[])DEPRE_VALUE_SELECTOR, (String)","), new QFilter("id", "in", firstFinCardIdSet));
        HashMap<Object, DynamicObject> firstFinCardMap = new HashMap<Object, DynamicObject>(firstFinCards.length);
        realId = firstFinCards;
        int bookIds = realId.length;
        boolean bl = false;
        while (var23_27 < bookIds) {
            DynamicObject firstFinCard = realId[var23_27];
            firstFinCardMap.put(firstFinCard.get("realcard_id"), firstFinCard);
            ++var23_27;
        }
        HashMap<Long, HashSet<Long>> dynamicMap = new HashMap<Long, HashSet<Long>>(10);
        for (DynamicObject finCard : finCards) {
            Long realCardPK = finCard.getLong("realcard_id");
            Long realMasterId = finCard.getLong("realcardmasterid");
            DynamicObject firstFinCard = (DynamicObject)firstFinCardMap.get(realCardPK);
            if (firstFinCard.getBigDecimal("monthdepre").compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal monthDepr = firstFinCard.getBigDecimal("monthdepre");
                finCard.set("accumdepre", (Object)firstFinCard.getBigDecimal("accumdepre").subtract(monthDepr));
                finCard.set("bizperiod", firstFinCard.get("bizperiod"));
                finCard.set("depredamount", (Object)firstFinCard.getBigDecimal("depredamount").subtract(firstFinCard.getBigDecimal("addidepreamount")));
                finCard.set("addupyeardepre", (Object)firstFinCard.getBigDecimal("addupyeardepre").subtract(monthDepr));
            } else {
                finCard.set("accumdepre", (Object)firstFinCard.getBigDecimal("accumdepre"));
                finCard.set("bizperiod_id", firstFinCard.get("bizperiod_id"));
                finCard.set("depredamount", (Object)firstFinCard.getBigDecimal("depredamount"));
                finCard.set("addupyeardepre", (Object)firstFinCard.getBigDecimal("addupyeardepre"));
            }
            finCard.set("isneeddepre", (Object)"1");
            finCard.set("monthdepre", (Object)BigDecimal.ZERO);
            finCard.set("addidepreamount", (Object)BigDecimal.ZERO);
            finCard.set("networth", (Object)finCard.getBigDecimal("originalval").subtract(finCard.getBigDecimal("accumdepre")));
            finCard.set("netamount", (Object)finCard.getBigDecimal("networth").subtract(finCard.getBigDecimal("decval")));
            if (finCard.getBoolean(Fa.dot((String[])new String[]{"realcard", "initialcard"})) || BigDecimal.ZERO.compareTo(finCard.getBigDecimal("accumdepre")) == 0 && BigDecimal.ZERO.compareTo(finCard.getBigDecimal("decval")) == 0) continue;
            HashSet<Long> ids = (HashSet<Long>)dynamicMap.get(finCard.getLong(Fa.dot((String[])new String[]{"assetbook", "id"})));
            if (ids == null) {
                ids = new HashSet<Long>(10);
                dynamicMap.put(finCard.getLong(Fa.dot((String[])new String[]{"assetbook", "id"})), ids);
            }
            ids.add(realMasterId);
        }
        if (dynamicMap.size() > 0) {
            for (Map.Entry entry : dynamicMap.entrySet()) {
                DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])new QFilter[]{new QFilter("assetbook", "=", entry.getKey()), new QFilter("realcard", "in", entry.getValue())});
            }
        }
        HashSet needUpdateBizStatusRealPKs = new HashSet(realCardPKs.size());
        realCardPKs.stream().forEach(t -> needUpdateBizStatusRealPKs.add(t));
        if (enableCurPeriodSplit) {
            realCardMasterId.stream().forEach(t -> needUpdateBizStatusRealPKs.add(t));
        }
        FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(needUpdateBizStatusRealPKs.toArray(), BizStatusEnum.ADD);
        backupFinCardPKs.removeAll(Arrays.asList(this.pks));
        if (!backupFinCardPKs.isEmpty()) {
            dao.delete(backupFinCardPKs.toArray());
        }
        FaCardInitFieldUtil.restoreInitFields(finCards);
        dao.save(finCards);
        if (enableCurPeriodSplit) {
            DynamicObject[] dynamicObjectArray = dao.query(Fa.join((String)",", (String[])selectFields.toArray(new String[0])), new QFilter("id", "in", oriIdFinIdMap.values()));
            new DepreSplitSum().deductForFinCard(dynamicObjectArray, false);
            log.info("\u7ec4\u7ec7[{}]\u7684\u4e1a\u52a1\u53c2\u6570[split.currentperiod.enable]\u6253\u5f00\uff0c\u53cd\u5ba1\u6838\u539f\u59cb\u8d22\u52a1\u5361\u7247\u9700\u8981\u5220\u9664\u5bf9\u5e94\u7684\u6700\u65b0\u8d22\u52a1\u5361\u7247\uff0c\u6b63\u5728\u6267\u884c\u3002", (Object)orgId);
            if (oriIdFinIdMap != null && !oriIdFinIdMap.isEmpty()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("fromOriFinCard", "true");
                Set<Long> needDelFinIds = oriIdFinIdMap.values().stream().collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(backupFinCardPKs)) {
                    needDelFinIds.removeAll(backupFinCardPKs);
                }
                if (CollectionUtils.isNotEmpty(needDelFinIds)) {
                    needDelFinIds = this.getSameRealFinIds(needDelFinIds, orgId, depreuseId);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_card_fin", (Object[])needDelFinIds.toArray(new Long[0]), (OperateOption)option);
                    FaCommonUtils.handleOperationResult(result);
                }
                SqlBuilder updateFinEntrySql = new SqlBuilder();
                updateFinEntrySql.append("update t_fa_asset_finentry set ffincardid = foriginalfincardid where", new Object[0]);
                updateFinEntrySql.appendIn(" foriginalfincardid ", (Object[])oriIdFinIdMap.keySet().toArray(new Long[0]));
                DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateFinEntrySql);
                SqlBuilder updateEndPeriodSql = new SqlBuilder();
                updateEndPeriodSql.append("update t_fa_card_fin set fendperiodid = 99999999999 where ", new Object[0]);
                updateEndPeriodSql.appendIn(" fid ", (Object[])oriIdFinIdMap.keySet().toArray(new Long[0]));
                DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateEndPeriodSql);
            }
        } else {
            new DepreSplitSum().deductForFinCard(finCards, false);
        }
    }

    private Set<Long> getSameRealFinIds(Set<Long> finIds, Long orgId, Long depreuseId) {
        DynamicObjectCollection needDelFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard", (QFilter[])new QFilter[]{new QFilter("id", "in", finIds)});
        HashSet realIds = new HashSet(needDelFinCards.size());
        needDelFinCards.stream().forEach(t -> realIds.add(t.getLong("realcard")));
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])new QFilter[]{new QFilter("realcard", "in", realIds), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId)});
        HashSet<Long> sameRealFinIds = new HashSet<Long>(finCards.size());
        finCards.stream().forEach(t -> sameRealFinIds.add(t.getLong("id")));
        return sameRealFinIds;
    }

    private Collection<DynamicObject> findFinCards4Audit(Object[] pks, Set<Long> oriFinRealMasterIds) {
        HashMap<Long, Long> finIdOrgIdMap = new HashMap<Long, Long>(pks.length);
        HashMap<Long, Object[]> finId2RealMasterIdMap = new HashMap<Long, Object[]>(pks.length);
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"id", "org", "realcardmasterid"}), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        for (DynamicObject finCard : finCards) {
            Long finId = finCard.getLong("id");
            Long orgId = finCard.getLong("org");
            Object[] realMasterId = Long.valueOf(finCard.getLong("realcardmasterid"));
            finIdOrgIdMap.put(finId, orgId);
            finId2RealMasterIdMap.put(finId, realMasterId);
        }
        HashSet<Long> orgSet = new HashSet<Long>(8);
        orgSet.addAll(finIdOrgIdMap.values());
        Map<Long, Boolean> orgBillParamMap = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit(orgSet);
        ArrayList<Long> curSplitEnablePks = new ArrayList<Long>(16);
        ArrayList<Long> curSplitDisablePks = new ArrayList<Long>(16);
        for (Object id : pks) {
            Long orgId = (Long)finIdOrgIdMap.get(id);
            Boolean enable = orgBillParamMap.get(orgId);
            if (enable != null && enable.booleanValue()) {
                curSplitEnablePks.add((Long)id);
                oriFinRealMasterIds.add((Long)finId2RealMasterIdMap.get((Long)id));
                continue;
            }
            curSplitDisablePks.add((Long)id);
        }
        ArrayList<DynamicObject> finCardPlainObjs = new ArrayList<DynamicObject>(curSplitEnablePks.size() + curSplitDisablePks.size());
        if (CollectionUtils.isNotEmpty(curSplitEnablePks)) {
            Collection<DynamicObject> enableCards = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("id", "in", curSplitEnablePks)}).values();
            this.originalFinCardsHandler(enableCards);
            finCardPlainObjs.addAll(enableCards);
        }
        if (CollectionUtils.isNotEmpty(curSplitDisablePks)) {
            String selectFields = "realcard.id,assetbook.id,depreuse.id,finaccountdate,accumdepre,decval,realcard.initialcard,realcardmasterid";
            DynamicObjectCollection disableCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])new QFilter("id", "in", curSplitDisablePks).toArray());
            finCardPlainObjs.addAll((Collection<DynamicObject>)disableCards);
        }
        return finCardPlainObjs;
    }

    private void originalFinCardsHandler(Collection<DynamicObject> finCards) {
        if (CollectionUtils.isEmpty(finCards)) {
            return;
        }
        List originalFinCards = finCards.stream().filter(t -> t.getBoolean("originaldata")).collect(Collectors.toList());
        log.info("finCards size: [{}]; originalFinCards size: [{}]", (Object)finCards.size(), (Object)originalFinCards.size());
        HashSet<Long> realCardMasterIds = new HashSet<Long>(finCards.size());
        finCards.stream().forEach(t -> realCardMasterIds.add(t.getLong("realcardmasterid")));
        Map<Long, Long> masterId2OriRealIdMap = this.findMasterIdOriRealIdMap(realCardMasterIds);
        HashMap<Long, Long> oriFinId2FinIdMap = new HashMap<Long, Long>(originalFinCards.size());
        HashMap<Long, Long> finIdRealIdMap = new HashMap<Long, Long>(originalFinCards.size());
        HashMap<Long, Long> oriRealId2OriFinIdMap = new HashMap<Long, Long>(originalFinCards.size());
        long[] ids = DB.genLongIds((String)"t_fa_card_fin", (int)originalFinCards.size());
        int i = 0;
        ArrayList<DynamicObject> newFinCards = new ArrayList<DynamicObject>(originalFinCards.size());
        HashSet existCards = new HashSet(finCards.size());
        DynamicObjectCollection existFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"realcardmasterid", "depreuse"}), (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", realCardMasterIds), new QFilter("originaldata", "=", (Object)Boolean.FALSE)});
        if (CollectionUtils.isNotEmpty((Collection)existFinCards)) {
            existFinCards.stream().forEach(t -> existCards.add(t.getLong("realcardmasterid") + "_" + t.getLong("depreuse")));
        }
        HashMap<Object, List<Object>> sourceId2TargetIdMap = new HashMap<Object, List<Object>>(originalFinCards.size());
        for (Object originalFin : originalFinCards) {
            Long l = originalFin.getLong("realcardmasterid");
            Long depreuseId = originalFin.getLong(Fa.id((String)"depreuse"));
            String key = l + "_" + depreuseId;
            if (existCards.contains(key)) continue;
            DynamicObject fin = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)originalFin);
            fin.set("id", (Object)ids[i]);
            fin.set("originaldata", (Object)false);
            fin.set("isneeddepre", (Object)true);
            fin.set("endperiod_id", (Object)99999999999L);
            fin.set("realcard_id", (Object)fin.getLong("realcardmasterid"));
            newFinCards.add(fin);
            oriFinId2FinIdMap.put(originalFin.getLong("id"), ids[i]);
            oriRealId2OriFinIdMap.put(masterId2OriRealIdMap.get(originalFin.getLong("realcardmasterid")), originalFin.getLong("id"));
            finIdRealIdMap.put(ids[i], fin.getLong("realcardmasterid"));
            ArrayList<Long> targetIds = new ArrayList<Long>(1);
            targetIds.add(ids[i]);
            sourceId2TargetIdMap.put(originalFin.getLong("id"), targetIds);
            ++i;
        }
        if (CollectionUtils.isEmpty(newFinCards)) {
            log.info("originalFinCardsHandler: \u672c\u6b21\u6ca1\u6709\u9700\u8981\u521b\u5efa\u7684\u5f53\u671f\u6700\u65b0\u8d22\u52a1\u5361\u7247\uff01");
            return;
        }
        SaveServiceHelper.save((DynamicObject[])newFinCards.toArray(new DynamicObject[0]));
        AttachmentUtils.copyAttachments("fa_card_fin", "fa_card_fin", "attachmentpanel", sourceId2TargetIdMap);
        ArrayList<Object[]> updateOriFinParams = new ArrayList<Object[]>(originalFinCards.size());
        for (Map.Entry entry : oriRealId2OriFinIdMap.entrySet()) {
            updateOriFinParams.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set frealcardid = ?,fendperiodid=fperiodid where fid = ?;", updateOriFinParams);
        ArrayList<Object[]> updateAssetFinEntryParams = new ArrayList<Object[]>(originalFinCards.size());
        for (Map.Entry entry : oriFinId2FinIdMap.entrySet()) {
            updateAssetFinEntryParams.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_asset_finentry set ffincardid = ? where foriginalfincardid = ?;", updateAssetFinEntryParams);
        FaCardBotpUtil.oriFinCardBotpHandler4Audit(oriFinId2FinIdMap, oriRealId2OriFinIdMap, finIdRealIdMap);
    }

    private Map<Long, Long> findMasterIdOriRealIdMap(Set<Long> realCardMasterIds) {
        DynamicObjectCollection oriRealCards = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id", "masterid"}), (QFilter[])new QFilter[]{new QFilter("masterid", "in", realCardMasterIds), new QFilter("isbak", "=", (Object)Boolean.TRUE), new QFilter("originaldata", "=", (Object)Boolean.TRUE)});
        HashMap<Long, Long> oriRealCardMap = new HashMap<Long, Long>(oriRealCards.size());
        oriRealCards.stream().forEach(t -> oriRealCardMap.put(t.getLong("masterid"), t.getLong("id")));
        return oriRealCardMap;
    }
}

