/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.operate;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaClearBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class FaOpCmdUtils {
    private static final Log logger = LogFactory.getLog(FaOpCmdUtils.class);
    public static final int OPRT_REALCARD = 99;
    public static final int OPRT_FINCARD = 100;
    public static final int OPRT_CHG_ORIGINALVAL = 0;
    public static final int OPRT_CHG_USEDEPT = 1;
    public static final int OPRT_CLEAR_ALL = 2;
    public static final int OPRT_DISPATCH = 3;
    private static final boolean[][] OPERATE = new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}};

    public static boolean isDoOperable(DynamicObject dataEntity, Object[] realCardPKs, List<String> errorList) {
        Object orgPK;
        if (dataEntity.containsProperty("org")) {
            orgPK = dataEntity.getDynamicObject("org").getPkValue();
        } else {
            DynamicObject realCard = FaRealCardDaoFactory.getInstance().queryOne(realCardPKs[0]);
            orgPK = realCard.getDynamicObject("org").getPkValue();
        }
        if (!FaOpCmdUtils.isEnableSumMultipleVoucher(orgPK) && FaOpCmdUtils.isDepreAorVByOrg(orgPK)) {
            errorList.add(ResManager.loadKDString((String)"\u6298\u65e7\u5df2\u5ba1\u6838\u6216\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c", (String)"FaOpCmdUtils_0", (String)"fi-fa-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isDoOperable(Object[] realCardPKs, String entityName, List<String> errorList) {
        DynamicObject realCard = FaRealCardDaoFactory.getInstance().queryOne(realCardPKs[0]);
        if (FaOpCmdUtils.isDepreAorVByOrg(realCard.getDynamicObject("org").getPkValue())) {
            errorList.add(ResManager.loadKDString((String)"\u6298\u65e7\u5df2\u5ba1\u6838\u6216\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c", (String)"FaOpCmdUtils_0", (String)"fi-fa-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isUndoOperable(Object bizPK, String entityName, List<String> errorList) {
        DynamicObject bill = FaBillDaoFactory.getInstance(entityName).queryOne(bizPK);
        Object orgPK = bill.getDynamicObject("org").getPkValue();
        if (!FaOpCmdUtils.isEnableSumMultipleVoucher(orgPK) && FaOpCmdUtils.isDepreAorVByOrg(orgPK)) {
            errorList.add(ResManager.loadKDString((String)"\u6298\u65e7\u5df2\u5ba1\u6838\u6216\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c", (String)"FaOpCmdUtils_0", (String)"fi-fa-business", (Object[])new Object[0]));
            return false;
        }
        boolean isBizAandNV = FaOpCmdUtils.isBizAandNV(bizPK, entityName);
        if (!isBizAandNV) {
            errorList.add(ResManager.loadKDString((String)"\u5ba1\u6838\u4e14\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u53cd\u64cd\u4f5c", (String)"FaOpCmdUtils_1", (String)"fi-fa-business", (Object[])new Object[0]));
            return false;
        }
        boolean isOther = true;
        if ("fa_dispatch_in".equals(entityName)) {
            isOther = FaOpCmdUtils.isUndoOperable4Dispatch(bizPK);
            if (!isOther) {
                errorList.add(ResManager.loadKDString((String)"\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"FaOpCmdUtils_2", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        } else if ("fa_clearbill".equals(entityName)) {
            isOther = FaOpCmdUtils.isBalnceStrike(bizPK, errorList);
        }
        return isBizAandNV && isOther;
    }

    public static boolean isUndoOperable4RealCard(Object realCardPK) {
        return !FaFinCardDaoFactory.getInstance().isExistAuditedByRealCard(realCardPK);
    }

    private static boolean isUndoOperable4Dispatch(Object dispatchPK) {
        QFilter dispatchFilter = new QFilter("id", "=", dispatchPK);
        String selectFields = Fa.comma((String[])new String[]{"inassetunit", "billno", Fa.dot((String[])new String[]{"dispatchentry", "realcard", "number"})});
        DynamicObjectCollection dispatchBills = QueryServiceHelper.query((String)"fa_dispatch_in", (String)selectFields, (QFilter[])dispatchFilter.toArray());
        if (dispatchBills == null || dispatchBills.isEmpty()) {
            return false;
        }
        List realCardNumbers = dispatchBills.stream().map(v -> v.get(Fa.dot((String[])new String[]{"dispatchentry", "realcard", "number"}))).collect(Collectors.toList());
        long inAssetUnitId = ((DynamicObject)dispatchBills.get(0)).getLong("inassetunit");
        String billNo = ((DynamicObject)dispatchBills.get(0)).getString("billno");
        QFilter[] realCardFilters = new QFilter[]{new QFilter("org", "=", (Object)inAssetUnitId), new QFilter("isbak", "=", (Object)"0"), new QFilter("srcbillnumber", "=", (Object)billNo), new QFilter("number", "in", realCardNumbers)};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"billstatus", (QFilter[])realCardFilters);
        boolean allStaging = true;
        for (DynamicObject realCard : realCards) {
            String billStatus = realCard.getString("billstatus");
            if ("A".equals(billStatus)) continue;
            allStaging = false;
            break;
        }
        return allStaging;
    }

    private static boolean isBalnceStrike(Object clearPk, List<String> errorList) {
        Long assbookPeriod;
        boolean isUndoOperable = true;
        DynamicObject clearBill = FaClearBillDaoFactory.getInstance().queryOne(clearPk);
        long clearPeriodId = PeriodUtil.getMainBookBizPeriodPK(clearBill.getLong("org_id"), clearBill.getDate("cleardate"));
        if (clearPeriodId < (assbookPeriod = Long.valueOf(FaAssetBookDaoFactory.getInstance().queryMainBookByOrg(clearBill.getLong("org_id")).getLong("curperiod_id")))) {
            isUndoOperable = false;
            errorList.add(ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u6e05\u7406\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaOpCmdUtils_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return isUndoOperable;
    }

    private static boolean isDepreAorVByBizPK(Object bizPK, String entityName) {
        DynamicObject bill = FaBillDaoFactory.getInstance(entityName).queryOne(bizPK);
        return FaOpCmdUtils.isDepreAorVByOrg(bill.getDynamicObject("org").getPkValue());
    }

    private static boolean isDepreAorVByOrg(Object orgPK) {
        return FaAssetBookDaoFactory.getInstance().isExistDepredMainBook(orgPK);
    }

    private static boolean isEnableSumMultipleVoucher(Object orgPK) {
        return SystemParamHelper.getBooleanParam("enable_sum_mutil_voucher", (Long)orgPK, false);
    }

    private static boolean isBizAandNV(Object bizPK, String entityName) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", bizPK), new QFilter("billstatus", "=", (Object)BillStatus.C.toString())};
        if ("fa_dispatch_in".equals(entityName)) {
            filters = new QFilter[]{new QFilter("id", "=", bizPK), new QFilter("billstatus", "=", (Object)BillStatus.D.toString())};
        }
        return FaBillDaoFactory.getInstance(entityName).isExist(filters);
    }
}

