/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.pclock;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.pclock.enums.PcLockType;
import kd.fi.fa.business.pclock.po.DetailHoldLockBill;
import kd.fi.fa.business.pclock.po.PcChildLockParameter;
import kd.fi.fa.business.utils.FaConstants;

public class PcChildLockUtils {
    private static String selectPcLockDetailSql = "dtholdlockentityname,dtholdlockdataid,dtholdlockdatanum,dtmodifytime";
    private static String deletePcLockDetailSql = "delete from t_fa_pc_lock_detail_n where FEntryID in (?)";

    protected static void updatePcLock(PcChildLockParameter parameter, DynamicObject existedData) {
        DynamicObjectCollection existedDetailDoList = existedData.getDynamicObjectCollection("detailentryentity");
        HashSet<String> existedEntryNameIdSet = new HashSet<String>(existedDetailDoList.size());
        for (Object detailDo : existedDetailDoList) {
            String entityName = detailDo.getString("dtholdlockentityname");
            String dataId = detailDo.getString("dtholdlockdataid");
            String entityNameId = entityName + "_" + dataId;
            existedEntryNameIdSet.add(entityNameId);
        }
        HashSet<String> insertEntryNameIdSet = new HashSet<String>(parameter.getDetailHoldLockBillSet().size());
        for (DetailHoldLockBill detailHoldLockBill : parameter.getDetailHoldLockBillSet()) {
            String key = detailHoldLockBill.getHoldLockEntityName() + "_" + detailHoldLockBill.getHoldLockDataId();
            if (existedEntryNameIdSet.contains(key)) continue;
            insertEntryNameIdSet.add(key);
        }
        if (insertEntryNameIdSet.size() == 0) {
            return;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_fa_pc_lock_n set ", new Object[0]);
        sb.append("fmodifytime = ?,", new Object[]{new Date()}).append("fsublocknum = fsublocknum+?,", new Object[]{insertEntryNameIdSet.size()}).append("ftype = ?", new Object[]{PcLockType.C.name()}).append(" where ", new Object[0]).append("flockeddatamasterid = ?", new Object[]{parameter.getLockedDataMasterId()}).append(" and flockedentityname = ?", new Object[]{parameter.getLockedEntityName()}).append(" and fusepurpose = ?", new Object[]{parameter.getUsePurpose()}).append(" and fholdlockentityname = ?", new Object[]{parameter.getInitEntityName()});
        int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        if (updateRows != 1) {
            String alterNumber = PcChildLockUtils.getOtherHoldRealAlterString(parameter);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u64cd\u4f5c\u5f02\u5e38,\u6b63\u5728\u505a\u5982\u4e0b\u4e1a\u52a1\uff1a%s\u3002", (String)"PcChildLockUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), alterNumber));
        }
        QFilter[] filters = new QFilter[]{new QFilter("lockeddatamasterid", "=", (Object)parameter.getLockedDataMasterId()), new QFilter("lockedentityname", "=", (Object)parameter.getLockedEntityName()), new QFilter("usepurpose", "=", (Object)parameter.getUsePurpose())};
        DynamicObject pclock = BusinessDataServiceHelper.loadSingle((String)"fa_pc_lock_n", (String)selectPcLockDetailSql, (QFilter[])filters);
        DynamicObjectCollection detailsDoList = pclock.getDynamicObjectCollection("detailentryentity");
        for (DetailHoldLockBill detail : parameter.getDetailHoldLockBillSet()) {
            String key = detail.getHoldLockEntityName() + "_" + detail.getHoldLockDataId();
            if (!insertEntryNameIdSet.contains(key)) continue;
            DynamicObject newDetailDo = detailsDoList.addNew();
            newDetailDo.set("dtholdlockdataid", (Object)detail.getHoldLockDataId());
            newDetailDo.set("dtholdlockentityname", (Object)detail.getHoldLockEntityName());
            newDetailDo.set("dtholdlockdatanum", (Object)detail.getHoldLockDataNum());
            newDetailDo.set("dtmodifytime", (Object)new Date());
        }
        DynamicObject[] dataEntities = new DynamicObject[]{pclock};
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private static List<Object[]> getExistedEntryIds(DynamicObject pcLockDo, PcChildLockParameter parameter) {
        HashSet<String> holdLockEntityNameIdSet = new HashSet<String>(parameter.getDetailHoldLockBillSet().size());
        for (DetailHoldLockBill detailHoldLockBill : parameter.getDetailHoldLockBillSet()) {
            holdLockEntityNameIdSet.add(detailHoldLockBill.getHoldLockEntityName() + "_" + detailHoldLockBill.getHoldLockDataId());
        }
        DynamicObjectCollection detailDoList = pcLockDo.getDynamicObjectCollection("detailentryentity");
        ArrayList<Object[]> deleteDetailIdList = new ArrayList<Object[]>(detailDoList.size());
        for (DynamicObject detailDo : detailDoList) {
            String dtholdlockentityname = detailDo.getString("dtholdlockentityname");
            String dtholdlockdataid = detailDo.getString("dtholdlockdataid");
            String dtholdlockentitynameId = dtholdlockentityname + "_" + dtholdlockdataid;
            if (!holdLockEntityNameIdSet.contains(dtholdlockentitynameId)) continue;
            Object[] detailEntryIDs = new Object[]{detailDo.getPkValue()};
            deleteDetailIdList.add(detailEntryIDs);
        }
        return deleteDetailIdList;
    }

    protected static void insertPLock(PcChildLockParameter parameter) {
        MainEntityType LockType = EntityMetadataCache.getDataEntityType((String)"fa_pc_lock_n");
        DynamicObject lockDy = new DynamicObject((DynamicObjectType)LockType);
        lockDy.set("lockedentityname", (Object)parameter.getLockedEntityName());
        lockDy.set("lockeddatamasterid", (Object)parameter.getLockedDataMasterId());
        lockDy.set("lockeddatanum", (Object)parameter.getLockedDataNum());
        lockDy.set("usepurpose", (Object)parameter.getUsePurpose());
        lockDy.set("holdlockentityname", (Object)"fa_noentityname");
        lockDy.set("holdlockdataid", (Object)"0");
        lockDy.set("holdlockdatanum", (Object)"0");
        lockDy.set("sublocknum", (Object)parameter.getDetailHoldLockBillSet().size());
        lockDy.set("type", (Object)PcLockType.C.name());
        lockDy.set("modifytime", (Object)new Date());
        DynamicObjectCollection detailEntity = lockDy.getDynamicObjectCollection("detailentryentity");
        for (DetailHoldLockBill detail : parameter.getDetailHoldLockBillSet()) {
            DynamicObject detailEntityEntry = detailEntity.addNew();
            detailEntityEntry.set("dtholdlockentityname", (Object)detail.getHoldLockEntityName());
            detailEntityEntry.set("dtholdlockdataid", (Object)detail.getHoldLockDataId());
            detailEntityEntry.set("dtholdlockdatanum", (Object)detail.getHoldLockDataNum());
            detailEntityEntry.set("dtmodifytime", (Object)new Date());
        }
        DynamicObject[] lockDyArray = new DynamicObject[]{lockDy};
        SaveServiceHelper.save((DynamicObject[])lockDyArray);
    }

    private static String getOtherHoldRealAlterString(PcChildLockParameter parameter) {
        QFilter[] filters = new QFilter[]{new QFilter("lockeddatamasterid", "=", (Object)parameter.getLockedDataMasterId()), new QFilter("lockedentityname", "=", (Object)parameter.getLockedEntityName()), new QFilter("usepurpose", "=", (Object)parameter.getUsePurpose()), new QFilter("lockeddatamasterid", "=", (Object)parameter.getLockedDataMasterId())};
        DynamicObjectCollection pcLockDataList = QueryServiceHelper.query((String)"fa_pc_lock_n", (String)"holdlockentityname", (QFilter[])filters);
        if (pcLockDataList == null || pcLockDataList.size() == 0) {
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u603b\u9501\u7684[%1$s]\u6570\u636e[%2$s]\u53ef\u80fd\u88ab\u5f3a\u5236\u5220\u9664\u4e86\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"PcChildLockUtils_1", (String)"fi-fa-business", (Object[])new Object[0]), billEntityDispName, parameter.getLockedDataNum()));
        }
        DynamicObject pcLockData = (DynamicObject)pcLockDataList.get(0);
        MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)pcLockData.getString("holdlockentityname"));
        String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
        MainEntityType lockedEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
        String lockedEntityDispName = lockedEntityType.getDisplayName().getLocaleValue();
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(lockedEntityDispName).append(":").append(parameter.getLockedDataNum()).append("]").append(billEntityDispName);
        return sb.toString();
    }

    protected static void unlockValidate(DynamicObject pcLockDo, PcChildLockParameter parameter) {
        if (!pcLockDo.getString("holdlockentityname.id").equals(parameter.getInitEntityName())) {
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u7a0b\u5e8f\u5f02\u5e38\uff0c%1$s[%2$s]\u7684\u6301\u9501\u5355\u636e\u4e0d\u662f\u521d\u59cb\u72b6\u6001\uff0c\u4e0d\u80fd\u901a\u8fc7\u5b50\u9501\u89e3\u9501", (String)"PcChildLockUtils_2", (String)"fi-fa-business", (Object[])new Object[0]), billEntityDispName, parameter.getLockedDataNum()));
        }
        if (!pcLockDo.getString("type").equals(PcLockType.C.name())) {
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u7a0b\u5e8f\u5f02\u5e38\uff0c%1$s[%2$s]\u76ee\u524d\u4e0d\u662f\u88ab\u5b50\u9501\u5360\u6709\uff0c\u4e0d\u80fd\u901a\u8fc7\u5b50\u9501\u89e3\u9501", (String)"PcChildLockUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), billEntityDispName, parameter.getLockedDataNum()));
        }
        if (pcLockDo.getLong("sublocknum") <= 0L) {
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u7a0b\u5e8f\u5f02\u5e38\uff0c%1$s[%2$s]\u76ee\u524d\u81ea\u9501\u6570\u91cf\u4e3a0\uff0c\u4e0d\u80fd\u901a\u8fc7\u5b50\u9501\u89e3\u9501", (String)"PcChildLockUtils_4", (String)"fi-fa-business", (Object[])new Object[0]), billEntityDispName, parameter.getLockedDataNum()));
        }
    }

    protected static List<Object[]> getDeleteEntryIds(DynamicObject pcLockDo, PcChildLockParameter parameter) {
        HashSet<String> holdLockEntityNameIdSet = new HashSet<String>(parameter.getDetailHoldLockBillSet().size());
        for (DetailHoldLockBill detailHoldLockBill : parameter.getDetailHoldLockBillSet()) {
            holdLockEntityNameIdSet.add(detailHoldLockBill.getHoldLockEntityName() + "_" + detailHoldLockBill.getHoldLockDataId());
        }
        DynamicObjectCollection detailDoList = pcLockDo.getDynamicObjectCollection("detailentryentity");
        ArrayList<Object[]> deleteDetailIdList = new ArrayList<Object[]>(detailDoList.size());
        for (DynamicObject detailDo : detailDoList) {
            String entityName = detailDo.getString("dtholdlockentityname.id");
            String dataId = detailDo.getString("dtholdlockdataid");
            String entityNameId = entityName + "_" + dataId;
            if (!holdLockEntityNameIdSet.contains(entityNameId)) continue;
            Object[] detailEntryIDs = new Object[]{detailDo.getPkValue()};
            deleteDetailIdList.add(detailEntryIDs);
        }
        return deleteDetailIdList;
    }

    protected static void unlock(DynamicObject pcLockDo, PcChildLockParameter parameter, List<Object[]> deleteDetailIdList) {
        int[] deleteAarray = DB.executeBatch((DBRoute)FaConstants.faDBRoute, (String)deletePcLockDetailSql, deleteDetailIdList);
        if (deleteAarray == null || deleteAarray.length == 0) {
            return;
        }
        int deleteNum = deleteAarray.length;
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_fa_pc_lock_n set ", new Object[0]);
        sb.append("fmodifytime = ?,", new Object[]{new Date()}).append("fsublocknum = fsublocknum-?", new Object[]{deleteNum}).append(" where ", new Object[0]).append("flockeddatamasterid = ?", new Object[]{parameter.getLockedDataMasterId()}).append(" and flockedentityname = ?", new Object[]{parameter.getLockedEntityName()}).append(" and fusepurpose = ?", new Object[]{parameter.getUsePurpose()}).append(" and fholdlockentityname = ?", new Object[]{parameter.getInitEntityName()}).append(" and fsublocknum - ? >= 0", new Object[]{deleteNum});
        int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        if (updateRows != 1) {
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)parameter.getLockedEntityName());
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u7a0b\u5e8f\u5f02\u5e38\uff0c%1$s[%2$s]\u5b50\u9501\u89e3\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"PcChildLockUtils_5", (String)"fi-fa-business", (Object[])new Object[0]), billEntityDispName, parameter.getLockedDataNum()));
        }
    }
}

