/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.pclock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.pclock.enums.PcLockType;
import kd.fi.fa.business.pclock.enums.PcRelBaseType;
import kd.fi.fa.business.pclock.po.LockedBaseData;
import kd.fi.fa.business.pclock.po.PcLockConfigParameter;

public class PcLockConfigUtils {
    public static Set<LockedBaseData> getLockedBaseData(DynamicObject bill, PcLockConfigParameter configPara) {
        String entryBaseCode;
        String entryCode;
        String headBaseCode;
        String relBaseType;
        PcLockType lockType = configPara.getLockType();
        if (lockType.name().equals(PcLockType.P.name())) {
            relBaseType = configPara.getpRelBaseType();
            headBaseCode = configPara.getpHeadBaseCode();
            entryCode = configPara.getpEntryCode();
            entryBaseCode = configPara.getpEntryBaseCode();
        } else {
            relBaseType = configPara.getcRelBaseType();
            headBaseCode = configPara.getcHeadBaseCode();
            entryCode = configPara.getcEntryCode();
            entryBaseCode = configPara.getcEntryBaseCode();
        }
        HashSet<LockedBaseData> lockedBaseDataSet = new HashSet<LockedBaseData>(16);
        if (relBaseType.equals(PcRelBaseType.HEAD.name())) {
            DynamicObject lockedDataDo = bill.getDynamicObject(headBaseCode);
            if (lockedDataDo == null) {
                return null;
            }
            LockedBaseData lockedBaseData = PcLockConfigUtils.generateLockedBaseData(configPara.getLockedEntityCode(), lockedDataDo);
            lockedBaseDataSet.add(lockedBaseData);
        } else if (relBaseType.equals(PcRelBaseType.ONEENTITY.name())) {
            DynamicObjectCollection lockedEntry = bill.getDynamicObjectCollection(entryCode);
            if (lockedEntry == null || lockedEntry.size() == 0) {
                return null;
            }
            for (DynamicObject lockedDataEntryDo : lockedEntry) {
                DynamicObject lockedDataDo = lockedDataEntryDo.getDynamicObject(entryBaseCode);
                if (lockedDataDo == null) continue;
                LockedBaseData lockedBaseData = PcLockConfigUtils.generateLockedBaseData(configPara.getLockedEntityCode(), lockedDataDo);
                lockedBaseDataSet.add(lockedBaseData);
            }
        } else if (!relBaseType.equals(PcRelBaseType.UNSUPPORTED.name())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u914d\u7f6e\u7684\u5f15\u7528\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u652f\u6301[%s]", (String)"PcLockConfigUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), relBaseType));
        }
        return lockedBaseDataSet;
    }

    private static LockedBaseData generateLockedBaseData(String lockedEntityCode, DynamicObject lockedDataDo) {
        long masterId;
        String number;
        String lockedEntityNameDo = lockedDataDo.getDataEntityType().getName();
        if ("fa_cleardetail_base".equals(lockedEntityNameDo)) {
            number = lockedDataDo.getString("assetnumber");
            masterId = lockedDataDo.getLong("id");
        } else {
            number = lockedDataDo.getString("number");
            masterId = lockedDataDo.getLong("masterid");
        }
        if (!lockedEntityCode.equals(lockedEntityNameDo)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e3a[%1$s]\u57fa\u7840\u8d44\u6599\u7684\u5355\u636e\u7c7b\u578b\u4e0d\u662f[%2$s]", (String)"PcLockConfigUtils_1", (String)"fi-fa-business", (Object[])new Object[0]), number, lockedEntityCode));
        }
        LockedBaseData lockedBaseData = new LockedBaseData();
        lockedBaseData.setLockedEntityName(lockedEntityCode);
        lockedBaseData.setLockedDataId((Long)lockedDataDo.getPkValue());
        lockedBaseData.setLockedDataMasterId(masterId);
        lockedBaseData.setLockedDataNum(number);
        return lockedBaseData;
    }

    public static PcLockConfigParameter handleConfigBaseData(String entityName, String operationKey, String pcLockCofigBillNo) {
        ArrayList<String> pcLockCofigBillNoList = new ArrayList<String>(1);
        pcLockCofigBillNoList.add(pcLockCofigBillNo);
        List<PcLockConfigParameter> configList = PcLockConfigUtils.handleConfigBaseData(entityName, operationKey, pcLockCofigBillNoList);
        if (configList == null || configList.size() == 0) {
            return null;
        }
        return configList.get(0);
    }

    public static List<PcLockConfigParameter> handleConfigBaseData(String entityName, String operationKey, List<String> pcLockCofigBillNoList) {
        ArrayList<PcLockConfigParameter> configParameterList = new ArrayList<PcLockConfigParameter>(pcLockCofigBillNoList.size());
        QFilter[] filters = new QFilter[]{new QFilter("billno", "in", (Object)pcLockCofigBillNoList.toArray()), new QFilter("billstatus", "=", (Object)BillStatus.C.name())};
        Map pcLockCofigMap = BusinessDataServiceHelper.loadFromCache((String)"fa_pc_lock_config_n", (QFilter[])filters);
        if (pcLockCofigMap == null || pcLockCofigMap.size() == 0) {
            return null;
        }
        for (DynamicObject pcLockCofig : pcLockCofigMap.values()) {
            PcLockConfigParameter lockConfigPara = new PcLockConfigParameter();
            String lockedEntityCode = pcLockCofig.getString("lockedentitycode.id");
            String usePurpose = pcLockCofig.getString("usepurpose");
            lockConfigPara.setLockedEntityCode(lockedEntityCode);
            lockConfigPara.setUsePurpose(usePurpose);
            lockConfigPara.setBizNormalStatus(pcLockCofig.getString("biznormalstatus"));
            lockConfigPara.setBizFinalStatus(pcLockCofig.getString("bizfinalstatus"));
            lockConfigPara.setStatusCode(pcLockCofig.getString("statuscode"));
            DynamicObjectCollection parentBillList = pcLockCofig.getDynamicObjectCollection("parententryentity");
            if (parentBillList == null || parentBillList.size() == 0) {
                return null;
            }
            block1: for (DynamicObject parentBill : parentBillList) {
                String parentBillEntityCode = parentBill.getString("parentbillentitycode.id");
                if (!entityName.equals(parentBillEntityCode)) continue;
                String pRelBaseType = parentBill.getString("prelbasetype");
                String pHeadBaseCode = parentBill.getString("pheadbasecode");
                String pEntryCode = parentBill.getString("pentrycode");
                String pEntryBaseCode = parentBill.getString("pentrybasecode");
                lockConfigPara.setParentBillEntityCode(parentBillEntityCode);
                lockConfigPara.setpRelBaseType(pRelBaseType);
                lockConfigPara.setpHeadBaseCode(pHeadBaseCode);
                lockConfigPara.setpEntryCode(pEntryCode);
                lockConfigPara.setpEntryBaseCode(pEntryBaseCode);
                lockConfigPara.setLockType(PcLockType.P);
                DynamicObjectCollection statusEntityList = parentBill.getDynamicObjectCollection("statusentryentity");
                if (statusEntityList == null || statusEntityList.size() == 0) {
                    lockConfigPara.setControlStatus(false);
                    break;
                }
                lockConfigPara.setControlStatus(true);
                for (DynamicObject statusEntity : statusEntityList) {
                    String[] operationArray;
                    List<String> operationList;
                    String operations = statusEntity.getString("operations");
                    if (StringUtils.isEmpty((Object)operations) || !(operationList = Arrays.asList(operationArray = operations.split(","))).contains(operationKey)) continue;
                    String fromBizStatus = statusEntity.getString("frombizstatus");
                    String toBizStatus = statusEntity.getString("tobizstatus");
                    lockConfigPara.setOperationKey(operationKey);
                    lockConfigPara.setFromBizStatus(fromBizStatus);
                    lockConfigPara.setToBizStatus(toBizStatus);
                    break block1;
                }
            }
            if (lockConfigPara.getLockType() != null) {
                configParameterList.add(lockConfigPara);
                continue;
            }
            DynamicObjectCollection childBillList = pcLockCofig.getDynamicObjectCollection("childentryentity");
            if (childBillList == null || childBillList.size() == 0) {
                return null;
            }
            for (DynamicObject childBill : childBillList) {
                String childBillEntityCode = childBill.getString("childbillentitycode.id");
                if (!entityName.equals(childBillEntityCode)) continue;
                String cRelBaseType = childBill.getString("crelbasetype");
                String cHeadBaseCode = childBill.getString("cheadbasecode");
                String cEntryCode = childBill.getString("centrycode");
                String cEntryBaseCode = childBill.getString("centrybasecode");
                lockConfigPara.setChildBillEntityCode(childBillEntityCode);
                lockConfigPara.setcRelBaseType(cRelBaseType);
                lockConfigPara.setcHeadBaseCode(cHeadBaseCode);
                lockConfigPara.setcEntryCode(cEntryCode);
                lockConfigPara.setcEntryBaseCode(cEntryBaseCode);
                lockConfigPara.setLockType(PcLockType.C);
                break;
            }
            if (lockConfigPara.getLockType() == null) continue;
            PcLockConfigUtils.validatePcLockConfig(operationKey, lockConfigPara);
            configParameterList.add(lockConfigPara);
        }
        return configParameterList;
    }

    private static void validatePcLockConfig(String operationKey, PcLockConfigParameter lockConfigPara) {
        if (lockConfigPara.isControlStatus()) {
            lockConfigPara.getOperationKey();
            if (StringUtils.isEmpty((Object)lockConfigPara.getOperationKey()) || StringUtils.isEmpty((Object)lockConfigPara.getFromBizStatus()) || StringUtils.isEmpty((Object)lockConfigPara.getToBizStatus())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u914d\u7f6e\u89c4\u5219\uff1a\u64cd\u4f5c\u7b26[%s]\u627e\u4e0d\u5230\u72b6\u6001\u6570\u636e\u5b9a\u4e49", (String)"PcLockConfigUtils_2", (String)"fi-fa-business", (Object[])new Object[0]), operationKey));
            }
        }
    }
}

