/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.periodclose;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.FaUpgradeMasterIdBillTypeEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.FutureChangeTypeEnum;
import kd.fi.fa.business.periodclose.FutureBizCheckerUtils;
import kd.fi.fa.business.service.FaBillUpdateCardMasterIdUpgradeServiceImpl;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FutureBizChecker {
    private static final Log logger = LogFactory.getLog(FutureBizChecker.class);
    private static final String AUDITDATE = "auditdate";
    private static final String BUSYTYPE = "busyType";
    private static final String DEPREUSEID = "depreUseId";
    private static final String DATEISNULL = "dateIsNull";
    private List<String> bizBillNumberLst = new ArrayList<String>();
    private Set<Object> realCardPkSet;
    private Object billPk;
    private Object orgId;
    private Date date;
    private BusyTypeDetailEnum busyType;
    private Map<Object, String> realId2Number;
    private String futureChangeSystemParameter;
    private String fuChgBillParamV;
    private boolean supportFuChgOrg;
    private static Set<String> chtypeDetailFinList = new HashSet<String>(2);
    private static Map<String, String> entry2RealField = new HashMap<String, String>(8);
    private final Map<String, Map<String, Set<String>>> number2Bill2BillNos = new HashMap<String, Map<String, Set<String>>>(8);
    private boolean compDate4EndDate = true;
    private boolean fromFin = false;
    private Date changeBillChangeDate;
    private Map<Long, DynamicObject> bookID2ChangDatePeriodMap = new HashMap<Long, DynamicObject>(3, 1.0f);
    private Long billDepreUseId;
    private DynamicObject[] assetBookObjs;
    private Map<String, String> entityDisplayNameMap = new HashMap<String, String>(8);

    public void setChangeBillChangeDate(Date changeBillChangeDate) {
        this.changeBillChangeDate = DateUtil.getCurrentDayStart((Date)changeBillChangeDate);
    }

    public FutureBizChecker(Object billPk, Object orgId, Set<Object> realCardPkSet, Date date, BusyTypeDetailEnum busyType) {
        this.setFutureBizCheckerParameter(billPk, orgId, realCardPkSet, date, busyType);
    }

    public FutureBizChecker(Object billPk, Object orgId, Set<Object> realCardPkSet, Date date, BusyTypeDetailEnum busyType, Long billDepreUseId) {
        this.setFutureBizCheckerParameter(billPk, orgId, realCardPkSet, date, busyType);
        if (billDepreUseId != null) {
            this.billDepreUseId = billDepreUseId;
        }
    }

    public FutureBizChecker(Object billPk, Object orgId, Date date, BusyTypeDetailEnum busyType, Map<Object, String> realId2Number) {
        this.setFutureBizCheckerParameter(billPk, orgId, realId2Number.keySet(), date, busyType);
        this.realId2Number = realId2Number;
    }

    public FutureBizChecker(Object billPk, Object orgId, Date date, BusyTypeDetailEnum busyType, Map<Object, String> realId2Number, Long billDepreUseId) {
        this.setFutureBizCheckerParameter(billPk, orgId, realId2Number.keySet(), date, busyType);
        this.realId2Number = realId2Number;
        if (billDepreUseId != null) {
            this.billDepreUseId = billDepreUseId;
        }
    }

    private String getEntityDisplayName(String entityKey) {
        String displayName;
        if (!this.entityDisplayNameMap.containsKey(entityKey)) {
            this.entityDisplayNameMap.put("fa_clearapplybill", ResManager.loadKDString((String)"\u6e05\u7406\u7533\u8bf7\u5355", (String)"FutureBizChecker_1", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_change_dept", ResManager.loadKDString((String)"\u53d8\u66f4\u5355", (String)"FutureBizChecker_0", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_clearbill", ResManager.loadKDString((String)"\u6e05\u7406\u5355", (String)"FutureBizChecker_2", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_dispatch", ResManager.loadKDString((String)"\u8c03\u62e8\u5355", (String)"FutureBizChecker_3", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_asset_devalue", ResManager.loadKDString((String)"\u51cf\u503c\u5355\u53f7", (String)"FutureBizChecker_4", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_workload", ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"FutureBizChecker_5", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_depreadjustbill", ResManager.loadKDString((String)"\u6298\u65e7\u8c03\u6574\u5355", (String)"FutureBizChecker_6", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_assetsplitbill", ResManager.loadKDString((String)"\u8d44\u4ea7\u62c6\u5206\u5355", (String)"FutureBizChecker_7", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_mergebill", ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76\u5355", (String)"FutureBizChecker_8", (String)"fi-fa-business", (Object[])new Object[0]));
            this.entityDisplayNameMap.put("fa_restartrealbill", ResManager.loadKDString((String)"\u8d44\u4ea7\u91cd\u542f\u5355", (String)"FutureBizChecker_11", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return (displayName = this.entityDisplayNameMap.get(entityKey)) == null ? entityKey : displayName;
    }

    private void setFutureBizCheckerParameter(Object billPk, Object orgId, Set<Object> realCardPkSet, Date date, BusyTypeDetailEnum busyType) {
        this.billPk = billPk;
        this.orgId = orgId;
        this.realCardPkSet = realCardPkSet;
        this.date = date;
        this.busyType = busyType;
        this.futureChangeSystemParameter = SystemParamHelper.getStringParam("futurechangesystemparameter", (Long)orgId, "1");
        this.fuChgBillParamV = FaBillParamUtils.queryOne(null, null, null, "FUTURE_CHANG_TYPE", FutureChangeTypeEnum.ONE.getValue());
        DynamicObject supportDy = FaBillParamUtils.queryOne((Long)orgId, 0L, "", "FUTURE_CHANG_ORGIDS");
        this.supportFuChgOrg = supportDy != null;
        this.assetBookObjs = FaAssetBookDaoFactory.getInstance().queryAllBookByOrg(orgId);
    }

    public void setCompDate4EndDate(boolean compDate4EndDate) {
        this.compDate4EndDate = compDate4EndDate;
    }

    public void setFromFin(boolean fromFin) {
        this.fromFin = fromFin;
    }

    private void repairFinRealCardMasterId() {
        if (CollectionUtils.isEmpty(this.realCardPkSet)) {
            return;
        }
        boolean exist = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("realcard", "in", this.realCardPkSet), new QFilter("realcardmasterid", "=", (Object)0)});
        if (exist) {
            logger.info("repairFinRealCardMasterId: \u672c\u6b21\u6821\u9a8c\u53d1\u73b0\u5b58\u5728frealcardmasterid=0\u7684\u8d22\u52a1\u5361\u7247\uff0c\u6267\u884c\u5347\u7ea7\u7a0b\u5e8f\u8fdb\u884c\u4fee\u590d\u5904\u7406\u3002");
            FaBillUpdateCardMasterIdUpgradeServiceImpl service = new FaBillUpdateCardMasterIdUpgradeServiceImpl(FaUpgradeMasterIdBillTypeEnum.CARD_FIN);
            service.executeUpgradeService();
        }
    }

    public Optional<String> check() {
        this.repairFinRealCardMasterId();
        boolean oldRoute = this.switchRoute();
        if (oldRoute) {
            this.checkBizBill();
        } else {
            this.checkBizBillByChgRecords();
        }
        if (this.bizBillNumberLst.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.bizBillNumberLst.stream().collect(Collectors.joining(";")));
    }

    public Map<String, String> checkMap() {
        this.repairFinRealCardMasterId();
        boolean oldRoute = this.switchRoute();
        if (oldRoute) {
            this.checkBizBill();
        } else {
            this.checkBizBillByChgRecords();
        }
        return this.getMsg(this.number2Bill2BillNos);
    }

    private Boolean switchRoute() {
        String busyChgGaSelectFields = Fa.comma((String[])new String[]{"period", "gatheritem"});
        QFilter[] busyChgGafilters = new QFilter[]{new QFilter("org", "=", this.orgId)};
        DynamicObjectCollection busyChgGaBills = QueryServiceHelper.query((String)"fa_busy_chg_gather", (String)busyChgGaSelectFields, (QFilter[])busyChgGafilters, (String)"org,period desc");
        Map<String, Boolean> resultMap = FutureBizCheckerUtils.switchRoute(this.orgId, this.assetBookObjs, busyChgGaBills);
        boolean oldRoute = resultMap.get("oldRoute");
        boolean toCollect = resultMap.get("toCollect");
        if (toCollect) {
            FutureBizCheckerUtils.collectBusyChgGather(busyChgGaBills, this.assetBookObjs);
        }
        return oldRoute;
    }

    private void checkBizBill() {
        String entityName;
        if (this.fromFin) {
            entityName = "fa_clearapplybill";
            this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u6e05\u7406\u7533\u8bf7\u5355", (String)"FutureBizChecker_1", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "cleardate", this.date, FutureBizChecker::cardFilterForClearApply);
        }
        entityName = "fa_change_dept";
        this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u53d8\u66f4\u5355", (String)"FutureBizChecker_0", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "changeDate", this.date, FutureBizChecker::cardFilterForChange);
        entityName = "fa_clearbill";
        this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u6e05\u7406\u5355", (String)"FutureBizChecker_2", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "cleardate", this.date, FutureBizChecker::cardFilterForClear);
        entityName = "fa_dispatch";
        this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u8c03\u62e8\u5355", (String)"FutureBizChecker_3", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "dispatchdate", this.date, FutureBizChecker::cardFilterForDispatch);
        this.checkPeriodBill(this.assetBookObjs, ResManager.loadKDString((String)"\u51cf\u503c\u5355\u53f7", (String)"FutureBizChecker_4", (String)"fi-fa-business", (Object[])new Object[0]), "fa_asset_devalue", FutureBizChecker::cardFilterForDeValue, this.date, "devalueperiod");
        this.checkPeriodBill(this.assetBookObjs, ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"FutureBizChecker_5", (String)"fi-fa-business", (Object[])new Object[0]), "fa_workload", FutureBizChecker::cardFilterForWorkload, this.date, "period");
        this.checkPeriodBill(this.assetBookObjs, ResManager.loadKDString((String)"\u6298\u65e7\u8c03\u6574\u5355", (String)"FutureBizChecker_6", (String)"fi-fa-business", (Object[])new Object[0]), "fa_depreadjustbill", FutureBizChecker::cardFilterForDepreAdjust, this.date, "period");
        entityName = "fa_assetsplitbill";
        this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u8d44\u4ea7\u62c6\u5206\u5355", (String)"FutureBizChecker_7", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "splitdate", this.date, FutureBizChecker::cardFilterForAssetSplit);
        entityName = "fa_mergebill";
        this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76\u5355", (String)"FutureBizChecker_8", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "mergedate", this.date, FutureBizChecker::cardFilterForMerge);
        entityName = "fa_restartrealbill";
        this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u8d44\u4ea7\u91cd\u542f\u5355", (String)"FutureBizChecker_11", (String)"fi-fa-business", (Object[])new Object[0]), entityName, "restartdate", this.date, FutureBizChecker::cardFilterForFaRestartRealBill);
    }

    private void checkBizBillByChgRecords() {
        if (this.fromFin) {
            this.collectBizBillNumbers(this.assetBookObjs, ResManager.loadKDString((String)"\u6e05\u7406\u7533\u8bf7\u5355", (String)"FutureBizChecker_1", (String)"fi-fa-business", (Object[])new Object[0]), "fa_clearapplybill", "cleardate", this.date, FutureBizChecker::cardFilterForClearApply);
        }
        this.checkPeriodBill(this.assetBookObjs, ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"FutureBizChecker_5", (String)"fi-fa-business", (Object[])new Object[0]), "fa_workload", FutureBizChecker::cardFilterForWorkload, this.date, "period");
        DynamicObject curAssetBook = null;
        for (DynamicObject assetBook : this.assetBookObjs) {
            if (this.billDepreUseId == null) {
                boolean isMainBook = assetBook.getBoolean("ismainbook");
                if (!isMainBook) continue;
                curAssetBook = assetBook;
                break;
            }
            Long depreUseId = assetBook.getLong("depreuse.id");
            if (this.billDepreUseId.longValue() != depreUseId.longValue()) continue;
            curAssetBook = assetBook;
            break;
        }
        if (curAssetBook == null) {
            return;
        }
        DynamicObject periodType = curAssetBook.getDynamicObject("periodtype");
        DynamicObject bizPeriod = null;
        ArrayList<QFilter> cardFilter = new ArrayList<QFilter>(3);
        if (this.date != null) {
            bizPeriod = PeriodUtil.getPeriodByDate(this.date, "id,enddate,begindate", periodType.getLong("id"));
            if (this.compDate4EndDate) {
                cardFilter.add(new QFilter("busydate", ">", bizPeriod.get("enddate")));
            } else {
                cardFilter.add(new QFilter("busydate", ">=", bizPeriod.get("begindate")));
            }
        }
        String realCardField = Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"});
        cardFilter.add(new QFilter(realCardField, "in", this.realCardPkSet));
        cardFilter.add(new QFilter("isdelete", "=", (Object)Character.valueOf('0')));
        String queryField = Fa.comma((String[])new String[]{"billid", "billno", "billentityname", "chtypedetail", "depreuse", Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"})});
        QFilter[] filterArr = cardFilter.toArray(new QFilter[0]);
        DynamicObjectCollection bizBillObjs = QueryServiceHelper.query((String)"fa_busy_chg_record", (String)queryField, (QFilter[])filterArr);
        HashMap<String, HashSet<String>> bizBillName2NumSetMap = new HashMap<String, HashSet<String>>(200);
        if (bizBillObjs != null && bizBillObjs.size() > 0) {
            for (DynamicObject bill : bizBillObjs) {
                String bizBillName = bill.getString("billentityname");
                if (this.billPk != null && bill.get("billid").equals(this.billPk)) continue;
                if (bizBillName.equals("fa_change_dept")) {
                    String chtypedetail = bill.getString("chtypedetail");
                    if (this.futureChangeSystemParameter.equals(FutureChangeTypeEnum.ONE.getValue()) ? this.busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) && this.fuChgBillParamV.equals(FutureChangeTypeEnum.THREE.getValue()) && this.supportFuChgOrg && !chtypeDetailFinList.contains(chtypedetail) : this.busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) && this.futureChangeSystemParameter.equals(FutureChangeTypeEnum.THREE.getValue()) && !chtypeDetailFinList.contains(chtypedetail)) {
                        continue;
                    }
                } else if ((bizBillName.equals("fa_asset_devalue") || bizBillName.equals("fa_depreadjustbill")) && this.billDepreUseId != null) {
                    Long depreUseId = bill.getLong("depreuse");
                    if (this.billDepreUseId.longValue() != depreUseId.longValue()) continue;
                }
                if (this.realId2Number != null) {
                    Set<String> billNos;
                    Map<Object, Object> bill2BillNo;
                    long realCardId = bill.getLong(Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"}));
                    String number = this.realId2Number.get(realCardId);
                    if (!this.number2Bill2BillNos.containsKey(number)) {
                        bill2BillNo = new HashMap();
                        billNos = new HashSet<String>(8);
                        billNos.add(bill.getString("billno"));
                        bill2BillNo.put(bizBillName, billNos);
                        this.number2Bill2BillNos.put(number, bill2BillNo);
                        continue;
                    }
                    bill2BillNo = this.number2Bill2BillNos.get(number);
                    if (!bill2BillNo.containsKey(bill.getString("billentityname"))) {
                        billNos = new HashSet(8);
                        billNos.add(bill.getString("billno"));
                        bill2BillNo.put(bizBillName, billNos);
                        continue;
                    }
                    billNos = (Set)bill2BillNo.get(bizBillName);
                    billNos.add(bill.getString("billno"));
                    continue;
                }
                HashSet<String> numberSet = (HashSet<String>)bizBillName2NumSetMap.get(bizBillName);
                if (numberSet == null) {
                    numberSet = new HashSet<String>();
                    bizBillName2NumSetMap.put(bizBillName, numberSet);
                }
                numberSet.add(bill.getString("billno"));
            }
        }
        this.checkCardFromSplit(bizPeriod);
        for (Map.Entry entry : bizBillName2NumSetMap.entrySet()) {
            this.bizBillNumberLst.add(this.getEntityDisplayName((String)entry.getKey()) + "\uff1a" + Fa.join((Collection)((Collection)entry.getValue()), (String)","));
        }
    }

    private Map<String, String> getMsg(Map<String, Map<String, Set<String>>> number2Bill2BillNos) {
        HashMap<String, String> number2Msg = new HashMap<String, String>(number2Bill2BillNos.size());
        if (number2Bill2BillNos.isEmpty()) {
            return number2Msg;
        }
        for (Map.Entry<String, Map<String, Set<String>>> mapEntry : number2Bill2BillNos.entrySet()) {
            String number = mapEntry.getKey();
            Map<String, Set<String>> value = mapEntry.getValue();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Set<String>> entry : value.entrySet()) {
                String bizBillName = entry.getKey();
                String bizBillNameAlter = this.getEntityDisplayName(bizBillName);
                if (bizBillNameAlter != null) {
                    bizBillName = bizBillNameAlter;
                }
                Set<String> billNos = entry.getValue();
                sb.append(bizBillName).append("\uff1a").append(Fa.join(billNos, (String)",")).append(";");
            }
            number2Msg.put(number, sb.toString());
        }
        return number2Msg;
    }

    public Optional<String> checkWhenun() {
        this.repairFinRealCardMasterId();
        boolean oldRoute = this.switchRoute();
        if (oldRoute) {
            this.checkBizBill4Un();
        } else {
            this.checkBizBill4UnByChgRecords();
        }
        if (this.bizBillNumberLst.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.bizBillNumberLst.stream().collect(Collectors.joining(";")));
    }

    public Map<String, String> check4UnMap() {
        boolean oldRoute = this.switchRoute();
        if (oldRoute) {
            this.checkBizBill4Un();
        } else {
            this.checkBizBill4UnByChgRecords();
        }
        return this.getMsg(this.number2Bill2BillNos);
    }

    private void checkBizBill4Un() {
        String entityName;
        if (this.fromFin) {
            entityName = "fa_clearapplybill";
            this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u6e05\u7406\u7533\u8bf7\u5355", (String)"FutureBizChecker_1", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForClearApply);
        }
        entityName = "fa_change_dept";
        if (this.changeBillChangeDate != null) {
            for (DynamicObject assetBook : this.assetBookObjs) {
                Long periodTypeId = assetBook.getLong("periodtype.id");
                DynamicObject changeDatePeriod = PeriodUtil.getPeriodByDate(this.changeBillChangeDate, "id,beginDate,enddate", periodTypeId);
                this.bookID2ChangDatePeriodMap.put(assetBook.getLong("id"), changeDatePeriod);
            }
        }
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u53d8\u66f4\u5355", (String)"FutureBizChecker_0", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForChange4Unaudit);
        entityName = "fa_clearbill";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u6e05\u7406\u5355", (String)"FutureBizChecker_2", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForClear);
        entityName = "fa_dispatch";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u8c03\u62e8\u5355", (String)"FutureBizChecker_3", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForDispatch);
        entityName = "fa_asset_devalue";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u51cf\u503c\u5355", (String)"FutureBizChecker_9", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForDeValue4Unaudit);
        entityName = "fa_depreadjustbill";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u6298\u65e7\u8c03\u6574\u5355", (String)"FutureBizChecker_6", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForDepreAdjust4Unaudit);
        entityName = "fa_assetsplitbill";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u8d44\u4ea7\u62c6\u5206\u5355", (String)"FutureBizChecker_7", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForAssetSplit);
        entityName = "fa_mergebill";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76\u5355", (String)"FutureBizChecker_8", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForMerge);
        entityName = "fa_workload";
        this.checkPeriodBillWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"FutureBizChecker_5", (String)"fi-fa-business", (Object[])new Object[0]), entityName, FutureBizChecker::cardFilterForWorkload4Unaudit, this.date, AUDITDATE);
        entityName = "fa_restartrealbill";
        this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u8d44\u4ea7\u91cd\u542f\u5355", (String)"FutureBizChecker_11", (String)"fi-fa-business", (Object[])new Object[0]), entityName, AUDITDATE, this.date, FutureBizChecker::cardFilterForFaRestartRealBill);
    }

    private void checkBizBill4UnByChgRecords() {
        if (this.fromFin) {
            this.collectBizBillNumbersWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u6e05\u7406\u7533\u8bf7\u5355", (String)"FutureBizChecker_1", (String)"fi-fa-business", (Object[])new Object[0]), "fa_clearapplybill", AUDITDATE, this.date, FutureBizChecker::cardFilterForClearApply);
        }
        if (this.changeBillChangeDate != null) {
            for (DynamicObject assetBook : this.assetBookObjs) {
                Long periodTypeId = assetBook.getLong("periodtype.id");
                DynamicObject changeDatePeriod = PeriodUtil.getPeriodByDate(this.changeBillChangeDate, "id,beginDate,enddate", periodTypeId);
                this.bookID2ChangDatePeriodMap.put(assetBook.getLong("id"), changeDatePeriod);
            }
        }
        this.checkPeriodBillWhenun(this.assetBookObjs, ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"FutureBizChecker_5", (String)"fi-fa-business", (Object[])new Object[0]), "fa_workload", FutureBizChecker::cardFilterForWorkload4Unaudit, this.date, AUDITDATE);
        DynamicObject curAssetBook = null;
        for (DynamicObject assetBook : this.assetBookObjs) {
            if (this.billDepreUseId == null) {
                boolean isMainBook = assetBook.getBoolean("ismainbook");
                if (!isMainBook) continue;
                curAssetBook = assetBook;
                break;
            }
            Long depreUseId = assetBook.getLong("depreuse.id");
            if (this.billDepreUseId.longValue() != depreUseId.longValue()) continue;
            curAssetBook = assetBook;
            break;
        }
        if (curAssetBook == null) {
            return;
        }
        Long curPeriodId = curAssetBook.getDynamicObject("curperiod").getLong("id");
        DynamicObject bizPeriod = PeriodUtil.getBdPeriod(curPeriodId);
        Date curPeriodEnddate = bizPeriod.getDate("enddate");
        curPeriodEnddate = DateUtil.getCurrentDayStart((Date)curPeriodEnddate);
        DynamicObject changDatePeriod = this.bookID2ChangDatePeriodMap.get(curAssetBook.getLong("id"));
        ArrayList<QFilter> cardFilter = new ArrayList<QFilter>();
        if (this.date != null) {
            QFilter dateFilter = new QFilter("billauditdate", ">=", (Object)this.date);
            cardFilter.add(dateFilter);
        }
        String realCardField = Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"});
        cardFilter.add(new QFilter(realCardField, "in", this.realCardPkSet));
        cardFilter.add(new QFilter("isdelete", "=", (Object)Character.valueOf('0')));
        String queryField = Fa.comma((String[])new String[]{"billid", "billno", "billentityname", "chtypedetail", "depreuse", "busydate", "period", Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"})});
        QFilter[] filterArr = cardFilter.toArray(new QFilter[0]);
        DynamicObjectCollection bizBillObjs = QueryServiceHelper.query((String)"fa_busy_chg_record", (String)queryField, (QFilter[])filterArr);
        HashMap<String, HashSet<String>> bizBillName2NumSetMap = new HashMap<String, HashSet<String>>(200);
        if (bizBillObjs != null && bizBillObjs.size() > 0) {
            for (DynamicObject dynamicObject : bizBillObjs) {
                String bizBillName = dynamicObject.getString("billentityname");
                if (this.billPk != null && dynamicObject.get("billid").equals(this.billPk)) continue;
                if (bizBillName.equals("fa_change_dept")) {
                    Date busyDate = dynamicObject.getDate("busydate");
                    busyDate = DateUtil.getCurrentDayStart((Date)busyDate);
                    String chtypedetail = dynamicObject.getString("chtypedetail");
                    if (this.date != null && this.busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name())) {
                        boolean con01 = chtypedetail.equals(BusyTypeDetailEnum.REAL_CHG.getValue()) && !busyDate.after(curPeriodEnddate);
                        boolean con02 = chtypeDetailFinList.contains(chtypedetail);
                        if (!con01 && !con02) continue;
                    }
                    if (this.date != null && this.busyType.name().equals(BusyTypeDetailEnum.REAL_CHG.name()) && busyDate.before(changDatePeriod.getDate("beginDate"))) {
                        continue;
                    }
                } else if (bizBillName.equals("fa_asset_devalue") || bizBillName.equals("fa_depreadjustbill")) {
                    if (this.billDepreUseId != null) {
                        Long depreUseId = dynamicObject.getLong("depreuse");
                        if (this.billDepreUseId.longValue() != depreUseId.longValue()) continue;
                    }
                    Long periodid = dynamicObject.getLong("period");
                    if (this.date != null && this.busyType.name().equals(BusyTypeDetailEnum.REAL_CHG.name()) && periodid < changDatePeriod.getLong("id")) continue;
                }
                if (this.realId2Number != null) {
                    Set<String> billNos;
                    Map<Object, Object> bill2BillNo;
                    long realCardId = dynamicObject.getLong(Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"}));
                    String number = this.realId2Number.get(realCardId);
                    if (!this.number2Bill2BillNos.containsKey(number)) {
                        bill2BillNo = new HashMap();
                        billNos = new HashSet<String>(8);
                        billNos.add(dynamicObject.getString("billno"));
                        bill2BillNo.put(bizBillName, billNos);
                        this.number2Bill2BillNos.put(number, bill2BillNo);
                        continue;
                    }
                    bill2BillNo = this.number2Bill2BillNos.get(number);
                    if (!bill2BillNo.containsKey(dynamicObject.getString("billentityname"))) {
                        billNos = new HashSet(8);
                        billNos.add(dynamicObject.getString("billno"));
                        bill2BillNo.put(bizBillName, billNos);
                        continue;
                    }
                    billNos = (Set)bill2BillNo.get(bizBillName);
                    billNos.add(dynamicObject.getString("billno"));
                    continue;
                }
                HashSet<String> numberSet = (HashSet<String>)bizBillName2NumSetMap.get(bizBillName);
                if (numberSet == null) {
                    numberSet = new HashSet<String>();
                    bizBillName2NumSetMap.put(bizBillName, numberSet);
                }
                numberSet.add(dynamicObject.getString("billno"));
            }
        }
        for (Map.Entry entry : bizBillName2NumSetMap.entrySet()) {
            this.bizBillNumberLst.add(this.getEntityDisplayName((String)entry.getKey()) + "\uff1a" + Fa.join((Collection)((Collection)entry.getValue()), (String)","));
        }
    }

    public Set<Object> checkAndReturnRealCard() {
        this.repairFinRealCardMasterId();
        boolean oldRoute = this.switchRoute();
        if (oldRoute) {
            return this.checkAndReturnRealCardOld();
        }
        return this.checkAndReturnRealCardByChgRecords();
    }

    private Set<Object> checkAndReturnRealCardOld() {
        HashSet<Object> realCardIdSet = new HashSet<Object>(this.realCardPkSet.size());
        String entityName = "fa_change_dept";
        Set<Object> checkResult = this.collectBizBillRealCardIds(this.assetBookObjs, entityName, "changeDate", Fa.dot((String[])new String[]{"fieldentry.realcard1"}), this.date, FutureBizChecker::cardFilterForChange);
        realCardIdSet.addAll(checkResult);
        entityName = "fa_clearbill";
        checkResult = this.collectBizBillRealCardIds(this.assetBookObjs, entityName, "cleardate", Fa.dot((String[])new String[]{"detail_entry", "realcard"}), this.date, FutureBizChecker::cardFilterForClear);
        realCardIdSet.addAll(checkResult);
        entityName = "fa_dispatch";
        checkResult = this.collectBizBillRealCardIds(this.assetBookObjs, entityName, "dispatchdate", Fa.dot((String[])new String[]{"dispatchentry", "realcard"}), this.date, FutureBizChecker::cardFilterForDispatch);
        realCardIdSet.addAll(checkResult);
        checkResult = this.checkPeriodBillWithRealCard(this.assetBookObjs, "fa_asset_devalue", FutureBizChecker::cardFilterForDeValue, this.date, "devalueperiod", "changebillentry.realcard");
        realCardIdSet.addAll(checkResult);
        checkResult = this.checkPeriodBillWithRealCard(this.assetBookObjs, "fa_workload", FutureBizChecker::cardFilterForWorkload, this.date, "period", "realcard");
        realCardIdSet.addAll(checkResult);
        checkResult = this.checkPeriodBillWithRealCard(this.assetBookObjs, "fa_depreadjustbill", FutureBizChecker::cardFilterForDepreAdjust, this.date, "period", Fa.dot((String[])new String[]{"entryentity", "realcard"}));
        realCardIdSet.addAll(checkResult);
        entityName = "fa_assetsplitbill";
        checkResult = this.collectBizBillRealCardIds(this.assetBookObjs, entityName, "splitdate", Fa.dot((String[])new String[]{"assetsplitentry", "subassetsplitentry", "aft_realcard"}), this.date, FutureBizChecker::cardFilterForAssetSplit);
        realCardIdSet.addAll(checkResult);
        entityName = "fa_mergebill";
        checkResult = this.collectBizBillRealCardIds(this.assetBookObjs, entityName, "mergedate", Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}), this.date, FutureBizChecker::cardFilterForMerge);
        realCardIdSet.addAll(checkResult);
        entityName = "fa_restartrealbill";
        checkResult = this.collectBizBillRealCardIds(this.assetBookObjs, entityName, "restartdate", Fa.dot((String[])new String[]{"restartentity", "realcard"}), this.date, FutureBizChecker::cardFilterForFaRestartRealBill);
        realCardIdSet.addAll(checkResult);
        return realCardIdSet;
    }

    private Set<Object> checkAndReturnRealCardByChgRecords() {
        Set<Object> fromSplitCards;
        HashSet<Object> realCardIdSet = new HashSet<Object>(this.realCardPkSet.size());
        Set<Object> checkResult = this.checkPeriodBillWithRealCard(this.assetBookObjs, "fa_workload", FutureBizChecker::cardFilterForWorkload, this.date, "period", "realcard");
        realCardIdSet.addAll(checkResult);
        DynamicObject curAssetBook = null;
        for (DynamicObject assetBook : this.assetBookObjs) {
            if (this.billDepreUseId == null) {
                boolean isMainBook = assetBook.getBoolean("ismainbook");
                if (!isMainBook) continue;
                curAssetBook = assetBook;
                break;
            }
            Long depreUseId = assetBook.getLong("depreuse.id");
            if (this.billDepreUseId.longValue() != depreUseId.longValue()) continue;
            curAssetBook = assetBook;
            break;
        }
        if (curAssetBook == null) {
            return realCardIdSet;
        }
        DynamicObject periodType = curAssetBook.getDynamicObject("periodtype");
        DynamicObject bizPeriod = PeriodUtil.getPeriodByDate(this.date, "id,enddate,begindate", periodType.getLong("id"));
        ArrayList<QFilter> cardFilter = new ArrayList<QFilter>();
        if (this.date != null) {
            if (this.compDate4EndDate) {
                cardFilter.add(new QFilter("busydate", ">", bizPeriod.get("enddate")));
            } else {
                cardFilter.add(new QFilter("busydate", ">=", bizPeriod.get("begindate")));
            }
        }
        String realCardField = Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"});
        cardFilter.add(new QFilter(realCardField, "in", this.realCardPkSet));
        cardFilter.add(new QFilter("isdelete", "=", (Object)Character.valueOf('0')));
        String queryField = Fa.comma((String[])new String[]{"billid", "billno", "billentityname", "chtypedetail", "depreuse", Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"})});
        QFilter[] filterArr = cardFilter.toArray(new QFilter[0]);
        DynamicObjectCollection bizBillObjs = QueryServiceHelper.query((String)"fa_busy_chg_record", (String)queryField, (QFilter[])filterArr);
        if (bizBillObjs != null && bizBillObjs.size() > 0) {
            for (DynamicObject bill : bizBillObjs) {
                String bizBillName = bill.getString("billentityname");
                if (this.billPk != null && bill.get("billid").equals(this.billPk)) continue;
                if (bizBillName.equals("fa_change_dept")) {
                    String chtypedetail = bill.getString("chtypedetail");
                    if (this.futureChangeSystemParameter.equals(FutureChangeTypeEnum.ONE.getValue()) ? this.busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) && this.fuChgBillParamV.equals(FutureChangeTypeEnum.THREE.getValue()) && this.supportFuChgOrg && !chtypeDetailFinList.contains(chtypedetail) : this.busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) && this.futureChangeSystemParameter.equals(FutureChangeTypeEnum.THREE.getValue()) && !chtypeDetailFinList.contains(chtypedetail)) {
                        continue;
                    }
                } else if (bizBillName.equals("fa_asset_devalue") || bizBillName.equals("fa_depreadjustbill")) {
                    Long depreUseId = bill.getLong("depreuse");
                    if (this.billDepreUseId != null && this.billDepreUseId.longValue() != depreUseId.longValue()) continue;
                }
                long realCardId = bill.getLong(Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"}));
                realCardIdSet.add(realCardId);
            }
        }
        if (CollectionUtils.isNotEmpty(fromSplitCards = this.collectBizBillCardFromSplit(bizPeriod))) {
            realCardIdSet.addAll(fromSplitCards);
        }
        return realCardIdSet;
    }

    private void checkPeriodBill(DynamicObject[] assetBookObjs, String billName, String entityName, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp, Date date, String dateFieldName) {
        HashSet<String> numberSet = new HashSet<String>();
        String queryField = "billno,id";
        if (this.isWorkload(entityName)) {
            queryField = "depreuse.name depreusename,period.number periodnumber,id";
        }
        queryField = this.getQueryFields(entityName, queryField);
        for (DynamicObject assetBook : assetBookObjs) {
            List<QFilter> finalFilters = this.genFinalFilter(assetBook, cardFilterSupp, dateFieldName, date, true);
            this.bizBillCheck4Period(billName, entityName, dateFieldName, numberSet, queryField, finalFilters);
        }
        if (!numberSet.isEmpty()) {
            this.bizBillNumberLst.add(billName + "\uff1a" + Fa.join(numberSet, (String)","));
        }
    }

    private void bizBillCheck4Period(String billName, String entityName, String dateFieldName, Set<String> numberSet, String queryField, List<QFilter> finalFilters) {
        QFilter[] filterArr = finalFilters.toArray(new QFilter[0]);
        DynamicObjectCollection devalueBills = QueryServiceHelper.query((String)entityName, (String)queryField, (QFilter[])filterArr);
        if (devalueBills != null && devalueBills.size() > 0) {
            for (DynamicObject bill : devalueBills) {
                if (this.billPk != null && bill.get("id").equals(this.billPk)) continue;
                if (this.realId2Number != null) {
                    Set<String> billNos;
                    Map<Object, Object> bill2BillNo;
                    long realCardId = bill.getLong(entry2RealField.get(entityName));
                    String number = this.realId2Number.get(realCardId);
                    if (!this.number2Bill2BillNos.containsKey(number)) {
                        bill2BillNo = new HashMap();
                        billNos = new HashSet<String>(8);
                        billNos.add(this.getBillNoMsg(entityName, dateFieldName, bill));
                        bill2BillNo.put(billName, billNos);
                        this.number2Bill2BillNos.put(number, bill2BillNo);
                        continue;
                    }
                    bill2BillNo = this.number2Bill2BillNos.get(number);
                    if (!bill2BillNo.containsKey(billName)) {
                        billNos = new HashSet(8);
                        billNos.add(this.getBillNoMsg(entityName, dateFieldName, bill));
                        bill2BillNo.put(billName, billNos);
                        continue;
                    }
                    billNos = (Set)bill2BillNo.get(billName);
                    billNos.add(this.getBillNoMsg(entityName, dateFieldName, bill));
                    continue;
                }
                numberSet.add(this.getBillNoMsg(entityName, dateFieldName, bill));
            }
        }
    }

    private String getBillNoMsg(String entityName, String dateFieldName, DynamicObject bill) {
        String billStr = "";
        billStr = this.isWorkload(entityName) ? bill.getString("depreusename") + "-" + bill.getString("periodnumber") : bill.getString("billno");
        return billStr;
    }

    private void checkPeriodBillWhenun(DynamicObject[] assetBookObjs, String billName, String entityName, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp, Date date, String dateFieldName) {
        HashSet<String> numberSet = new HashSet<String>();
        String queryField = "id, depreuse.name depreusename, period.number periodnumber, realcard.number realcardnumber, billno";
        queryField = this.getQueryFields(entityName, queryField);
        for (DynamicObject assetBook : assetBookObjs) {
            List<QFilter> finalFilters = this.genFinalFilterWhenun(assetBook, cardFilterSupp, dateFieldName, date, true);
            this.bizBillCheck4Period(billName, entityName, dateFieldName, numberSet, queryField, finalFilters);
        }
        if (numberSet.size() > 0) {
            this.bizBillNumberLst.add(billName + "\uff1a" + Fa.join(numberSet, (String)","));
        }
    }

    private boolean isWorkload(String entityName) {
        return "fa_workload".equals(entityName);
    }

    private Set<Object> checkPeriodBillWithRealCard(DynamicObject[] assetBookObjs, String entityName, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp, Date date, String dateFieldName, String realCardFieldName) {
        HashSet<Object> realCardIdSet = new HashSet<Object>(this.realCardPkSet.size());
        for (DynamicObject assetBook : assetBookObjs) {
            String status = assetBook.getString("status");
            if (!status.equalsIgnoreCase("C")) continue;
            List<QFilter> finalFilters = this.genFinalFilter(assetBook, cardFilterSupp, dateFieldName, date, true);
            Object[] filterArr = finalFilters.toArray(new QFilter[0]);
            DynamicObjectCollection devalueBills = QueryServiceHelper.query((String)entityName, (String)Fa.comma((String[])new String[]{realCardFieldName, "id"}), (QFilter[])filterArr);
            if (devalueBills == null || devalueBills.size() <= 0) continue;
            for (DynamicObject bill : devalueBills) {
                if (this.billPk != null && bill.get("id").equals(this.billPk)) continue;
                realCardIdSet.add(bill.get(realCardFieldName));
                logger.info(String.format("\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff1a\u5b9e\u7269\u5361\u7247id\u3010%s\u3011\uff0c\u5355\u636e\u6807\u8bc6\u3010%s\u3011\uff0c\u5355\u636eid\u3010%s\u3011\uff0c\u4e1a\u52a1\u65e5\u671f\u5b57\u6bb5\u540d\u3010%s\u3011\uff0c\u68c0\u67e5\u7684\u65e5\u671f\u3010%s\u3011\uff0c\u8fc7\u6ee4\u6761\u4ef6\uff1a\u3010%s\u3011", bill.get(realCardFieldName), entityName, bill.get("id"), dateFieldName, date == null ? null : DateUtil.getLongDate().format(date), Arrays.toString(filterArr)));
            }
        }
        return realCardIdSet;
    }

    private void collectBizBillNumbers(DynamicObject[] assetBookObjs, String bizBillName, String entityName, String dateFieldName, Date changeDate, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp) {
        HashSet<String> numberSet = new HashSet<String>();
        String queryField = this.getQueryFields(entityName, Fa.comma((String[])new String[]{"id", "billno"}));
        for (DynamicObject assetBook : assetBookObjs) {
            List<QFilter> finalFilters = this.genFinalFilter(assetBook, cardFilterSupp, dateFieldName, changeDate, false);
            this.bizBillCheck4Date(bizBillName, entityName, numberSet, queryField, finalFilters);
        }
        if (numberSet.size() > 0) {
            this.bizBillNumberLst.add(bizBillName + "\uff1a" + Fa.join(numberSet, (String)","));
        }
    }

    private void bizBillCheck4Date(String bizBillName, String entityName, Set<String> numberSet, String queryField, List<QFilter> finalFilters) {
        QFilter[] filterArr = finalFilters.toArray(new QFilter[0]);
        DynamicObjectCollection bizBillObjs = QueryServiceHelper.query((String)entityName, (String)queryField, (QFilter[])filterArr);
        if (bizBillObjs != null && bizBillObjs.size() > 0) {
            for (DynamicObject bill : bizBillObjs) {
                if (this.billPk != null && bill.get("id").equals(this.billPk)) continue;
                if (this.realId2Number != null) {
                    Set<String> billNos;
                    Map<Object, Object> bill2BillNo;
                    long realCardId = bill.getLong(entry2RealField.get(entityName));
                    String number = this.realId2Number.get(realCardId);
                    if (!this.number2Bill2BillNos.containsKey(number)) {
                        bill2BillNo = new HashMap();
                        billNos = new HashSet<String>(8);
                        billNos.add(bill.getString("billno"));
                        bill2BillNo.put(bizBillName, billNos);
                        this.number2Bill2BillNos.put(number, bill2BillNo);
                        continue;
                    }
                    bill2BillNo = this.number2Bill2BillNos.get(number);
                    if (!bill2BillNo.containsKey(bizBillName)) {
                        billNos = new HashSet(8);
                        billNos.add(bill.getString("billno"));
                        bill2BillNo.put(bizBillName, billNos);
                        continue;
                    }
                    billNos = (Set)bill2BillNo.get(bizBillName);
                    billNos.add(bill.getString("billno"));
                    continue;
                }
                numberSet.add(bill.getString("billno"));
            }
        }
    }

    private String getQueryFields(String entityName, String queryField) {
        if (this.realId2Number != null) {
            queryField = Fa.comma((String[])new String[]{queryField, entry2RealField.get(entityName)});
        }
        return queryField;
    }

    private void collectBizBillNumbersWhenun(DynamicObject[] assetBookObjs, String bizBillName, String entityName, String dateFieldName, Date changeDate, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp) {
        HashSet<String> numberSet = new HashSet<String>();
        String queryField = this.getQueryFields(entityName, Fa.comma((String[])new String[]{"id", "billno"}));
        for (DynamicObject assetBook : assetBookObjs) {
            List<QFilter> finalFilters = this.genFinalFilterWhenun(assetBook, cardFilterSupp, dateFieldName, changeDate, false);
            this.bizBillCheck4Date(bizBillName, entityName, numberSet, queryField, finalFilters);
        }
        if (numberSet.size() > 0) {
            this.bizBillNumberLst.add(bizBillName + "\uff1a" + Fa.join(numberSet, (String)","));
        }
    }

    private Set<Object> collectBizBillRealCardIds(DynamicObject[] assetBookObjs, String entityName, String dateFieldName, String realCardFieldName, Date changeDate, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp) {
        HashSet<Object> realCardIdSet = new HashSet<Object>(this.realCardPkSet.size());
        for (DynamicObject assetBook : assetBookObjs) {
            List<QFilter> finalFilters = this.genFinalFilter(assetBook, cardFilterSupp, dateFieldName, changeDate, false);
            QFilter[] filterArr = finalFilters.toArray(new QFilter[0]);
            DynamicObjectCollection bizBillObjs = QueryServiceHelper.query((String)entityName, (String)(realCardFieldName + ", id"), (QFilter[])filterArr);
            if (bizBillObjs == null || bizBillObjs.size() <= 0) continue;
            for (DynamicObject bill : bizBillObjs) {
                if (this.billPk != null && bill.get("id").equals(this.billPk)) continue;
                realCardIdSet.add(bill.get(realCardFieldName));
            }
        }
        return realCardIdSet;
    }

    private List<QFilter> genFinalFilter(DynamicObject assetBookObj, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp, String dateFieldName, Date date, boolean isCheckDevalue) {
        Long depreuseId = assetBookObj.getDynamicObject("depreuse").getLong("id");
        HashMap<String, Object> parameter = new HashMap<String, Object>(2, 1.0f);
        parameter.put(BUSYTYPE, (Object)this.busyType);
        parameter.put(DEPREUSEID, depreuseId);
        parameter.put("futureChangeSystemParameter", this.futureChangeSystemParameter);
        parameter.put("fuChgBillParamV", this.fuChgBillParamV);
        parameter.put("supportFuChgOrg", this.supportFuChgOrg);
        List<QFilter> cardFilter = cardFilterSupp.apply(this.realCardPkSet, parameter);
        if (date != null) {
            DynamicObject periodType = assetBookObj.getDynamicObject("periodtype");
            DynamicObject bizPeriod = PeriodUtil.getPeriodByDate(date, "id,enddate,begindate", periodType.getLong("id"));
            if (bizPeriod == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"FutureBizChecker_10", (String)"fi-fa-business", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(msg);
            }
            QFilter dateFilter = isCheckDevalue ? (this.compDate4EndDate ? new QFilter(dateFieldName, ">", bizPeriod.get("id")) : new QFilter(dateFieldName, ">=", bizPeriod.get("id"))) : (this.compDate4EndDate ? new QFilter(dateFieldName, ">", bizPeriod.get("enddate")) : new QFilter(dateFieldName, ">=", bizPeriod.get("begindate")));
            cardFilter.add(dateFilter);
        }
        return cardFilter;
    }

    private List<QFilter> genFinalFilterWhenun(DynamicObject assetBookObj, BiFunction<Set<Object>, Map<String, Object>, List<QFilter>> cardFilterSupp, String dateFieldName, Date date, boolean isCheckDevalue) {
        Long depreuseId = assetBookObj.getDynamicObject("depreuse").getLong("id");
        Long curPeriodId = assetBookObj.getDynamicObject("curperiod").getLong("id");
        DynamicObject bizPeriod = PeriodUtil.getBdPeriod(curPeriodId);
        HashMap<String, Object> parameter = new HashMap<String, Object>(2, 1.0f);
        parameter.put(BUSYTYPE, (Object)this.busyType);
        parameter.put(DEPREUSEID, depreuseId);
        parameter.put(DATEISNULL, date);
        parameter.put("curPeriodEnddate", bizPeriod.getDate("enddate"));
        parameter.put("changDatePeriod", this.bookID2ChangDatePeriodMap.get(assetBookObj.getLong("id")));
        List<QFilter> cardFilter = cardFilterSupp.apply(this.realCardPkSet, parameter);
        if (date != null) {
            QFilter dateFilter = new QFilter(dateFieldName, ">=", (Object)date);
            cardFilter.add(dateFilter);
        }
        return cardFilter;
    }

    private static List<QFilter> cardFilterForFaRestartRealBill(Set<Object> realCardPkSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String realCardField = Fa.dot((String[])new String[]{"restartentity", "realcard"});
        filters.add(new QFilter(realCardField, "in", realCardPkSet));
        return filters;
    }

    private static List<QFilter> cardFilterForDispatch(Set<Object> realCardPkSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("dispatchentry.realcard", "in", realCardPkSet));
        return filters;
    }

    private static List<QFilter> cardFilterForClear(Set<Object> realCardPkSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("detail_entry.realcard", "in", realCardPkSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("detail_entry.depreuse", "=", (Object)depreuerId));
        return filters;
    }

    private static List<QFilter> cardFilterForClearApply(Set<Object> realCardPkSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("clrapplybill_entry.realcard", "in", realCardPkSet));
        return filters;
    }

    private static List<QFilter> cardFilterForChange(Set<Object> realCardPkSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("fieldentry.realcard1", "in", realCardPkSet));
        BusyTypeDetailEnum busyType = (BusyTypeDetailEnum)((Object)parameter.get(BUSYTYPE));
        String futureChangeSystemParameter = (String)parameter.get("futureChangeSystemParameter");
        String fuChgBillParamV = (String)parameter.get("fuChgBillParamV");
        Boolean supportFuChgOrg = (Boolean)parameter.get("supportFuChgOrg");
        if (futureChangeSystemParameter.equals(FutureChangeTypeEnum.ONE.getValue())) {
            if (busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) && fuChgBillParamV.equals(FutureChangeTypeEnum.THREE.getValue()) && supportFuChgOrg.booleanValue()) {
                filters.add(new QFilter("chtypedetail", "in", chtypeDetailFinList));
            }
        } else if (busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) && futureChangeSystemParameter.equals(FutureChangeTypeEnum.THREE.getValue())) {
            filters.add(new QFilter("chtypedetail", "in", chtypeDetailFinList));
        }
        return filters;
    }

    private static List<QFilter> cardFilterForChange4Unaudit(Set<Object> realCardPkSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("fieldentry.realcard1", "in", realCardPkSet));
        BusyTypeDetailEnum busyType = (BusyTypeDetailEnum)((Object)parameter.get(BUSYTYPE));
        Date date = (Date)parameter.get(DATEISNULL);
        Date curPeriodEnddate = (Date)parameter.get("curPeriodEnddate");
        DynamicObject changDatePeriod = (DynamicObject)parameter.get("changDatePeriod");
        if (date != null && busyType.name().equals(BusyTypeDetailEnum.FIN_CHG.name())) {
            QFilter filter1 = new QFilter("chtypedetail", "=", (Object)BusyTypeDetailEnum.REAL_CHG.getValue()).and(new QFilter("changedate", "<=", (Object)curPeriodEnddate));
            QFilter filter2 = filter1.or(new QFilter("chtypedetail", "in", chtypeDetailFinList));
            filters.add(filter2);
        }
        if (date != null && busyType.name().equals(BusyTypeDetailEnum.REAL_CHG.name())) {
            filters.add(new QFilter("changedate", ">=", (Object)changDatePeriod.getDate("beginDate")));
        }
        return filters;
    }

    private static List<QFilter> cardFilterForDeValue(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("changebillentry.realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    private static List<QFilter> cardFilterForDeValue4Unaudit(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("changebillentry.realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        BusyTypeDetailEnum busyType = (BusyTypeDetailEnum)((Object)parameter.get(BUSYTYPE));
        Date date = (Date)parameter.get(DATEISNULL);
        DynamicObject changDatePeriod = (DynamicObject)parameter.get("changDatePeriod");
        if (date != null && busyType.name().equals(BusyTypeDetailEnum.REAL_CHG.name())) {
            filters.add(new QFilter("devalueperiod", ">=", (Object)changDatePeriod.getLong("id")));
        }
        return filters;
    }

    private static List<QFilter> cardFilterForWorkload(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    private static List<QFilter> cardFilterForWorkload4Unaudit(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        BusyTypeDetailEnum busyType = (BusyTypeDetailEnum)((Object)parameter.get(BUSYTYPE));
        Date date = (Date)parameter.get(DATEISNULL);
        DynamicObject changDatePeriod = (DynamicObject)parameter.get("changDatePeriod");
        if (date != null && busyType.name().equals(BusyTypeDetailEnum.REAL_CHG.name())) {
            filters.add(new QFilter("period", ">=", (Object)changDatePeriod.getLong("id")));
        }
        return filters;
    }

    private static List<QFilter> cardFilterForDepreAdjust(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("entryentity.realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    private static List<QFilter> cardFilterForDepreAdjust4Unaudit(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("entryentity.realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        BusyTypeDetailEnum busyType = (BusyTypeDetailEnum)((Object)parameter.get(BUSYTYPE));
        Date date = (Date)parameter.get(DATEISNULL);
        DynamicObject changDatePeriod = (DynamicObject)parameter.get("changDatePeriod");
        if (date != null && busyType.name().equals(BusyTypeDetailEnum.REAL_CHG.name())) {
            filters.add(new QFilter("period", ">=", (Object)changDatePeriod.getLong("id")));
        }
        return filters;
    }

    private static List<QFilter> cardFilterRecalculate(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("recalculateentry.realcard", "in", realCardIdSet));
        Long depreuerId = (Long)parameter.get(DEPREUSEID);
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    private static List<QFilter> cardFilterForAssetSplit(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("assetsplitentry.subassetsplitentry.aft_realcard", "in", realCardIdSet));
        return filters;
    }

    private void checkCardFromSplit(DynamicObject bizPeriod) {
        DynamicObjectCollection fromSplitCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", this.realCardPkSet), new QFilter("sourceflag", "=", (Object)SourceFlagEnum.SPLIT.name())});
        if (!fromSplitCards.isEmpty()) {
            Set fromSplitRealIds = fromSplitCards.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            if (bizPeriod != null) {
                if (this.compDate4EndDate) {
                    filters.add(new QFilter("splitdate", ">", bizPeriod.get("enddate")));
                } else {
                    filters.add(new QFilter("splitdate", ">=", bizPeriod.get("begindate")));
                }
            }
            filters.add(new QFilter("assetsplitentry.subassetsplitentry.aft_realcard", "in", fromSplitRealIds));
            String queryField = this.getQueryFields("fa_assetsplitbill", Fa.comma((String[])new String[]{"id", "billno"}));
            HashSet<String> numberSet = new HashSet<String>();
            String bizBillName = ResManager.loadKDString((String)"\u8d44\u4ea7\u62c6\u5206\u5355", (String)"FutureBizChecker_7", (String)"fi-fa-business", (Object[])new Object[0]);
            this.bizBillCheck4Date(bizBillName, "fa_assetsplitbill", numberSet, queryField, filters);
            if (numberSet.size() > 0) {
                this.bizBillNumberLst.add(bizBillName + "\uff1a" + Fa.join(numberSet, (String)","));
            }
        }
    }

    private Set<Object> collectBizBillCardFromSplit(DynamicObject bizPeriod) {
        DynamicObjectCollection fromSplitCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", this.realCardPkSet), new QFilter("sourceflag", "=", (Object)SourceFlagEnum.SPLIT.name())});
        if (!fromSplitCards.isEmpty()) {
            Set fromSplitRealIds = fromSplitCards.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            if (this.compDate4EndDate) {
                filters.add(new QFilter("splitdate", ">", bizPeriod.get("enddate")));
            } else {
                filters.add(new QFilter("splitdate", ">=", bizPeriod.get("begindate")));
            }
            String cardField = "assetsplitentry.subassetsplitentry.aft_realcard";
            filters.add(new QFilter(cardField, "in", fromSplitRealIds));
            DynamicObjectCollection bizBillObjs = QueryServiceHelper.query((String)"fa_assetsplitbill", (String)(cardField + ", id"), (QFilter[])filters.toArray(new QFilter[0]));
            if (bizBillObjs != null && bizBillObjs.size() > 0) {
                HashSet<Object> realCardIdSet = new HashSet<Object>(bizBillObjs.size());
                for (DynamicObject bill : bizBillObjs) {
                    if (this.billPk != null && bill.get("id").equals(this.billPk)) continue;
                    realCardIdSet.add(bill.get(cardField));
                }
                return realCardIdSet;
            }
        }
        return Collections.emptySet();
    }

    private static List<QFilter> cardFilterForMerge(Set<Object> realCardIdSet, Map<String, Object> parameter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}), "in", realCardIdSet));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForDispatch(Set<Object> realCardPkSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("dispatchentry.realcard", "in", realCardPkSet));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForClear(Set<Object> realCardPkSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("detail_entry.realcard", "in", realCardPkSet));
        filters.add(new QFilter("detail_entry.depreuse", "=", (Object)depreuerId));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForChange(Set<Object> realCardPkSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("fieldentry.realcard1", "in", realCardPkSet));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForDeValue(Set<Object> realCardIdSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("changebillentry.realcard", "in", realCardIdSet));
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForWorkload(Set<Object> realCardIdSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("realcard", "in", realCardIdSet));
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForDepreAdjust(Set<Object> realCardIdSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("entryentity.realcard", "in", realCardIdSet));
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterRecalculate(Set<Object> realCardIdSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("recalculateentry.realcard", "in", realCardIdSet));
        filters.add(new QFilter("depreuse", "=", (Object)depreuerId));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForAssetSplit(Set<Object> realCardIdSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(Fa.dot((String[])new String[]{"assetsplitentry", "subassetsplitentry", "aft_realcard"}), "in", realCardIdSet));
        return filters;
    }

    @Deprecated
    public static List<QFilter> cardFilterForMerge(Set<Object> realCardIdSet, long depreuerId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}), "in", realCardIdSet));
        return filters;
    }

    static {
        chtypeDetailFinList.add(BusyTypeDetailEnum.FIN_CHG.getValue());
        chtypeDetailFinList.add(BusyTypeDetailEnum.REAL_FIN_CHG.getValue());
        entry2RealField.put("fa_change_dept", Fa.dot((String[])new String[]{"fieldentry", "realcard1"}));
        entry2RealField.put("fa_clearapplybill", Fa.dot((String[])new String[]{"clrapplybill_entry", "realcard"}));
        entry2RealField.put("fa_clearbill", Fa.dot((String[])new String[]{"detail_entry", "realcard"}));
        entry2RealField.put("fa_dispatch", Fa.dot((String[])new String[]{"dispatchentry", "realcard"}));
        entry2RealField.put("fa_asset_devalue", "changebillentry.realcard");
        entry2RealField.put("fa_workload", "realcard");
        entry2RealField.put("fa_depreadjustbill", Fa.dot((String[])new String[]{"entryentity", "realcard"}));
        entry2RealField.put("fa_assetsplitbill", Fa.dot((String[])new String[]{"assetsplitentry", "subassetsplitentry", "aft_realcard"}));
        entry2RealField.put("fa_mergebill", Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}));
        entry2RealField.put("fa_restartrealbill", Fa.dot((String[])new String[]{"restartentity", "realcard"}));
    }
}

