/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.periodclose;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.BusyGatherItemEnum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FutureBizCheckerUtils {
    public static void upgradeBusyChgRecords() {
        SqlBuilder busyChgSql = new SqlBuilder();
        busyChgSql.append("SELECT fbillid FROM t_fa_busy_chg_record WHERE ", new Object[0]);
        busyChgSql.append("fbillentityname = ? ", new Object[]{"fa_change_dept"});
        busyChgSql.append("and fisdelete = ? ", new Object[]{Character.valueOf('0')});
        busyChgSql.append("and fchtypedetail = ? ", new Object[]{Character.valueOf('0')});
        HashSet<Long> billIdSet = new HashSet<Long>(2000);
        try (DataSet busyChgDS = DB.queryDataSet((String)"FutureBizCheckerUtils.upgradeBusyChgRecords.busyChgSql", (DBRoute)new DBRoute("fa"), (SqlBuilder)busyChgSql);){
            for (Row busyChg : busyChgDS) {
                billIdSet.add(busyChg.getLong("fbillid"));
            }
        }
        if (billIdSet.size() == 0) {
            return;
        }
        HashSet<Long> realChangeSet = new HashSet<Long>(billIdSet.size());
        HashSet<Long> finChangeSet = new HashSet<Long>(billIdSet.size());
        HashSet<Long> realFinChangeSet = new HashSet<Long>(billIdSet.size());
        SqlBuilder queryChangeSql = new SqlBuilder();
        queryChangeSql.append("SELECT fid,fchtypedetail FROM T_FA_CHANGEBILL WHERE ", new Object[0]);
        queryChangeSql.appendIn("FID", billIdSet.toArray());
        try (DataSet dsChange = DB.queryDataSet((String)"FutureBizCheckerUtils.upgradeBusyChgRecords", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryChangeSql);){
            for (Row change : dsChange) {
                String chtypedetail = change.getString("fchtypedetail");
                Long changeId = change.getLong("fid");
                if (chtypedetail.equals(BusyTypeDetailEnum.REAL_CHG.getValue())) {
                    realChangeSet.add(changeId);
                    continue;
                }
                if (chtypedetail.equals(BusyTypeDetailEnum.FIN_CHG.getValue())) {
                    finChangeSet.add(changeId);
                    continue;
                }
                realFinChangeSet.add(changeId);
            }
        }
        if (realChangeSet.size() > 0) {
            FutureBizCheckerUtils.updateBUsyChgTypedetailBatch(BusyTypeDetailEnum.REAL_CHG.getValue(), realChangeSet);
        }
        if (finChangeSet.size() > 0) {
            FutureBizCheckerUtils.updateBUsyChgTypedetailBatch(BusyTypeDetailEnum.FIN_CHG.getValue(), finChangeSet);
        }
        if (realFinChangeSet.size() > 0) {
            FutureBizCheckerUtils.updateBUsyChgTypedetailBatch(BusyTypeDetailEnum.REAL_FIN_CHG.getValue(), realFinChangeSet);
        }
    }

    private static void updateBUsyChgTypedetailBatch(String chtypedetail, Set<Long> billIdSet) {
        if (billIdSet.size() <= 1999) {
            FutureBizCheckerUtils.updateBUsyChgTypedetail(chtypedetail, billIdSet);
        } else {
            HashSet<Long> billIdSetTemp = new HashSet<Long>(1999);
            for (Long billId : billIdSet) {
                billIdSetTemp.add(billId);
                if (billIdSetTemp.size() != 1999) continue;
                FutureBizCheckerUtils.updateBUsyChgTypedetail(chtypedetail, billIdSetTemp);
                billIdSetTemp.clear();
            }
            if (billIdSetTemp.size() > 0) {
                FutureBizCheckerUtils.updateBUsyChgTypedetail(chtypedetail, billIdSetTemp);
            }
        }
    }

    private static void updateBUsyChgTypedetail(String chtypedetail, Set<Long> billIdSet) {
        try (TXHandle h = TX.required((String)"upgradeBusyChgRecords");){
            try {
                SqlBuilder sb = new SqlBuilder();
                sb.append("update t_fa_busy_chg_record set ", new Object[0]).append("fchtypedetail = ?", new Object[]{chtypedetail}).append(" where ", new Object[0]).appendIn("fbillid", billIdSet.toArray()).append(" and fbillentityname = ? ", new Object[]{"fa_change_dept"});
                DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
                h.commit();
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static Map<String, Boolean> switchRoute(Object orgId, DynamicObject[] assetBookObjs, DynamicObjectCollection busyChgGaBills) {
        boolean oldRoute = true;
        boolean toCollect = false;
        DynamicObject maxNewbusyChgGaBill = null;
        if (busyChgGaBills.size() > 0) {
            maxNewbusyChgGaBill = (DynamicObject)busyChgGaBills.get(0);
            Long gaPeriodId = maxNewbusyChgGaBill.getLong("period");
            String gatherItem = maxNewbusyChgGaBill.getString("gatheritem");
            boolean is2NewRote = true;
            for (DynamicObject assetBook : assetBookObjs) {
                Long curPeriodId = assetBook.getLong("curperiod.id");
                if (gatherItem.equals(BusyGatherItemEnum.OPTIMIZE.getValue())) {
                    toCollect = false;
                    if (curPeriodId >= gaPeriodId) continue;
                    is2NewRote = false;
                    continue;
                }
                is2NewRote = false;
                toCollect = true;
            }
            if (is2NewRote) {
                oldRoute = false;
            }
        } else {
            toCollect = true;
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2, 1.0f);
        resultMap.put("oldRoute", oldRoute);
        resultMap.put("toCollect", toCollect);
        return resultMap;
    }

    public static void collectBusyChgGather(DynamicObjectCollection busyChgGaBills, DynamicObject[] assetBookObjs) {
        Long periodtypeId;
        DynamicObject mainAssetBook = null;
        for (DynamicObject assetBook : assetBookObjs) {
            boolean isMainBook = assetBook.getBoolean("ismainbook");
            if (!isMainBook) continue;
            mainAssetBook = assetBook;
            break;
        }
        if (mainAssetBook == null) {
            return;
        }
        Long curPeriodId = mainAssetBook.getLong("curperiod.id");
        Long previousPeriodId = FaPeriodUtils.getPreviousPeriodId(curPeriodId, periodtypeId = Long.valueOf(mainAssetBook.getLong("periodtype.id")));
        if (previousPeriodId == -1L) {
            return;
        }
        if (busyChgGaBills != null && busyChgGaBills.size() > 0) {
            DynamicObject maxNewbusyChgGaBill = (DynamicObject)busyChgGaBills.get(0);
            Long gaPeriodId = maxNewbusyChgGaBill.getLong("period");
            if (previousPeriodId <= gaPeriodId) {
                return;
            }
        }
        HashMap<String, Integer> entityname2BillCountMap = new HashMap<String, Integer>(7, 1.0f);
        MainEntityType periodType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject previousPeriod = BusinessDataReader.loadSingle((Object)previousPeriodId, (DynamicObjectType)periodType, (Boolean)false);
        Date begindate = previousPeriod.getDate("begindate");
        Date enddate = previousPeriod.getDate("enddate");
        begindate = DateUtil.getCurrentDayStart((Date)begindate);
        enddate = DateUtil.getCurrentDayStart((Date)enddate);
        Long orgId = mainAssetBook.getLong("org.id");
        entityname2BillCountMap.put("fa_change_dept", FutureBizCheckerUtils.queryChangeBillCount(orgId, begindate, enddate));
        entityname2BillCountMap.put("fa_clearbill", FutureBizCheckerUtils.queryClearBillCount(orgId, begindate, enddate));
        entityname2BillCountMap.put("fa_assetsplitbill", FutureBizCheckerUtils.querySplitBillCount(orgId, begindate, enddate));
        entityname2BillCountMap.put("fa_mergebill", FutureBizCheckerUtils.queryMergeBillCount(orgId, begindate, enddate));
        entityname2BillCountMap.put("fa_dispatch", FutureBizCheckerUtils.queryDispatchBillCount(orgId, begindate, enddate));
        HashSet<Long> depreUseIdSet = new HashSet<Long>(3);
        for (DynamicObject assetBook : assetBookObjs) {
            depreUseIdSet.add(assetBook.getLong("depreuse.id"));
        }
        entityname2BillCountMap.put("fa_asset_devalue", FutureBizCheckerUtils.queryAssetDevalueBillCount(orgId, depreUseIdSet, previousPeriodId));
        entityname2BillCountMap.put("fa_depreadjustbill", FutureBizCheckerUtils.queryDepreAdjustCount(orgId, depreUseIdSet, previousPeriodId));
        Integer allCount = 0;
        for (Integer count : entityname2BillCountMap.values()) {
            allCount = allCount + count;
        }
        MainEntityType busyChgGatherType = EntityMetadataCache.getDataEntityType((String)"fa_busy_chg_gather");
        if (allCount == 0) {
            DynamicObject busyChgGatherDy = new DynamicObject((DynamicObjectType)busyChgGatherType);
            busyChgGatherDy.set("org", (Object)orgId);
            busyChgGatherDy.set("period", (Object)previousPeriodId);
            busyChgGatherDy.set("gatheritem", (Object)BusyGatherItemEnum.UNKNOWN.getValue());
            DynamicObject[] busyChgGatherDyArr = new DynamicObject[]{busyChgGatherDy};
            SaveServiceHelper.save((DynamicObject[])busyChgGatherDyArr);
            return;
        }
        QFilter[] busyChgFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "in", depreUseIdSet), new QFilter("period", "=", (Object)previousPeriodId), new QFilter("isdelete", "=", (Object)Boolean.FALSE)};
        String selectBusyChgFields = Fa.comma((String[])new String[]{"billid", "billentityname"});
        DynamicObjectCollection busyChgBills = QueryServiceHelper.query((String)"fa_busy_chg_record", (String)selectBusyChgFields, (QFilter[])busyChgFilters);
        HashMap<String, HashSet<Long>> busyChgEntityname2BillSetMap = new HashMap<String, HashSet<Long>>(7, 1.0f);
        for (Object busyChgBill : busyChgBills) {
            String string = busyChgBill.getString("billentityname");
            Long billId = busyChgBill.getLong("billid");
            HashSet<Long> billIdSet = (HashSet<Long>)busyChgEntityname2BillSetMap.get(string);
            if (billIdSet == null) {
                billIdSet = new HashSet<Long>(2000);
                busyChgEntityname2BillSetMap.put(string, billIdSet);
            }
            billIdSet.add(billId);
        }
        Integer busyAllCount = 0;
        for (Map.Entry entry : busyChgEntityname2BillSetMap.entrySet()) {
            Set billIdSet = (Set)entry.getValue();
            busyAllCount = busyAllCount + billIdSet.size();
        }
        DynamicObject busyChgGatherDy = new DynamicObject((DynamicObjectType)busyChgGatherType);
        busyChgGatherDy.set("org", (Object)orgId);
        busyChgGatherDy.set("period", (Object)previousPeriodId);
        if (allCount.intValue() == busyAllCount.intValue()) {
            busyChgGatherDy.set("gatheritem", (Object)BusyGatherItemEnum.OPTIMIZE.getValue());
        } else {
            busyChgGatherDy.set("gatheritem", (Object)BusyGatherItemEnum.UNKNOWN.getValue());
        }
        DynamicObject[] dynamicObjectArray = new DynamicObject[]{busyChgGatherDy};
        SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
    }

    private static Integer queryChangeBillCount(Long orgId, Date begindate, Date enddate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("changedate", ">=", (Object)begindate), new QFilter("changedate", "<=", (Object)enddate)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_change_dept", (String)"id", (QFilter[])filters);
        return bills.size();
    }

    private static Integer queryClearBillCount(Long orgId, Date begindate, Date enddate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("cleardate", ">=", (Object)begindate), new QFilter("cleardate", "<=", (Object)enddate)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_clearbill", (String)"id", (QFilter[])filters);
        return bills.size();
    }

    private static Integer querySplitBillCount(Long orgId, Date begindate, Date enddate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("splitdate", ">=", (Object)begindate), new QFilter("splitdate", "<=", (Object)enddate)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_assetsplitbill", (String)"id", (QFilter[])filters);
        return bills.size();
    }

    private static Integer queryMergeBillCount(Long orgId, Date begindate, Date enddate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("mergedate", ">=", (Object)begindate), new QFilter("mergedate", "<=", (Object)enddate)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_mergebill", (String)"id", (QFilter[])filters);
        return bills.size();
    }

    private static Integer queryDispatchBillCount(Long orgId, Date begindate, Date enddate) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("dispatchdate", ">=", (Object)begindate), new QFilter("dispatchdate", "<=", (Object)enddate)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_dispatch", (String)"id", (QFilter[])filters);
        return bills.size();
    }

    private static Integer queryAssetDevalueBillCount(Long orgId, Set<Long> depreUseIdSet, Long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "in", depreUseIdSet), new QFilter("devalueperiod", "=", (Object)periodId)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_asset_devalue", (String)"id", (QFilter[])filters);
        return bills.size();
    }

    private static Integer queryDepreAdjustCount(Long orgId, Set<Long> depreUseIdSet, Long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "in", depreUseIdSet), new QFilter("period", "=", (Object)periodId)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)"id", (QFilter[])filters);
        return bills.size();
    }
}

