/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.fa.business.card.AssetCardQueryServiceHelper;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.common.util.Fa;

public class FaDepreForecastHelper {
    private static final Log logger = LogFactory.getLog(FaDepreForecastHelper.class);
    private static final String ALGO = "kd.fi.fa.report.util.FaDepreForecastUtils";
    public static final String KEY_SUM_DEPREDATA = "fa_rpt_depre_forecast_sumdata";
    private static final int BATCH_SIZE = 9995;

    public DataSet queryDataSet(ReportQueryParam queryParam, Set<String> cardNumbers) {
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("q_org");
        long depreuseId = filterInfo.getLong("depreuse");
        DynamicObject bookObj = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"basecurrency", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId)});
        DynamicObject predictStartPeriod = filterInfo.getDynamicObject("q_startperiod");
        DynamicObject predictEndPeriod = filterInfo.getDynamicObject("q_period");
        return this.batchForecastAndBuildDataSet(orgId, depreuseId, bookObj, predictStartPeriod, predictEndPeriod, cardNumbers);
    }

    public void setDyObjFieldsFromDataSet(DynamicObject dyObj, Row row) {
        List<String> depreForecastFields = this.getDepreForecastFields();
        depreForecastFields.remove("periodnumber");
        depreForecastFields.remove("monthdepre");
        depreForecastFields.stream().forEach(t -> dyObj.set(t, row.get(t)));
    }

    public Map<String, BigDecimal> sumDepreForecast(ReportQueryParam queryParam, IPageCache pageCache) {
        boolean needCache = pageCache != null;
        HashMap<String, BigDecimal> forecastSumMap = new HashMap<String, BigDecimal>(8);
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("q_org");
        long depreuseId = filterInfo.getLong("depreuse");
        DynamicObject bookObj = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "basecurrency", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId)});
        DynamicObject predictStartPeriod = filterInfo.getDynamicObject("q_startperiod");
        DynamicObject predictEndPeriod = filterInfo.getDynamicObject("q_period");
        try {
            forecastSumMap.put("predictdepre", new BigDecimal("0"));
            forecastSumMap.put("preaddupyeardepre", new BigDecimal("0"));
            forecastSumMap.put("predictoriginalval", new BigDecimal("0"));
            forecastSumMap.put("predictaccumdepre", new BigDecimal("0"));
            forecastSumMap.put("predictnetworth", new BigDecimal("0"));
            forecastSumMap.put("predictdecval", new BigDecimal("0"));
            forecastSumMap.put("predictnetamount", new BigDecimal("0"));
            forecastSumMap.put("preresidualval", new BigDecimal("0"));
            DataSet finCardDataSet = AssetCardQueryServiceHelper.queryFinDataSet4DepreForecast(ALGO, queryParam, false);
            int i = 0;
            HashSet<String> cardNumberSet = new HashSet<String>(9995);
            Iterator it = finCardDataSet.iterator();
            while (it.hasNext()) {
                if (i == 9995) {
                    DataSet oneBath = this.batchForecastAndBuildDataSet(orgId, depreuseId, bookObj, predictStartPeriod, predictEndPeriod, cardNumberSet);
                    this.sumForecastData2Map(oneBath, forecastSumMap);
                    cardNumberSet = new HashSet(9995);
                    i = 0;
                    continue;
                }
                Row row = (Row)it.next();
                cardNumberSet.add(row.getString("number"));
                ++i;
            }
            if (CollectionUtils.isNotEmpty(cardNumberSet)) {
                DataSet oneBath = this.batchForecastAndBuildDataSet(orgId, depreuseId, bookObj, predictStartPeriod, predictEndPeriod, cardNumberSet);
                this.sumForecastData2Map(oneBath, forecastSumMap);
            }
            if (needCache) {
                pageCache.put("fa_rpt_depre_forecast_sumdata_" + orgId + "_" + depreuseId + "_" + predictEndPeriod.getLong("id"), JSONUtils.toString(forecastSumMap));
            }
        }
        catch (Exception e) {
            logger.error("sumDepreForecast error is :", (Throwable)e);
        }
        return forecastSumMap;
    }

    private DataSet batchForecastAndBuildDataSet(long orgId, long depreuseId, DynamicObject bookObj, DynamicObject predictStartPeriod, DynamicObject predictEndPeriod, Set<String> cardNumberSet) {
        DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_rpt_depre_forecast");
        Map<String, Map<String, Map<String, Object>>> orgPredictResult = dailyDepreImpl.predictPeriodDepe(orgId, depreuseId, predictEndPeriod, true, true, cardNumberSet);
        String startPeriodKey = orgId + "_" + depreuseId + "_" + predictStartPeriod.getPkValue();
        String endPeriodKey = orgId + "_" + depreuseId + "_" + predictEndPeriod.getLong("id");
        Map<String, Map<String, Object>> predictCurPeriodResultValue = orgPredictResult.get(startPeriodKey);
        if (predictCurPeriodResultValue == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4[%s]\u9884\u6d4b\u6570\u636e\u4e3a\u7a7a", (String)"FaDepreForecastHelper_0", (String)"fi-fa-business", (Object[])new Object[0]), bookObj.getString("curperiod.name")));
        }
        Map<String, Map<String, Object>> predictEndPeriodResult = orgPredictResult.get(endPeriodKey);
        if (predictEndPeriodResult == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4[%s]\u9884\u6d4b\u6570\u636e\u4e3a\u7a7a", (String)"FaDepreForecastHelper_0", (String)"fi-fa-business", (Object[])new Object[0]), predictEndPeriod.getString("name")));
        }
        Collection<Map<String, Object>> predictCurPeriodResult = predictCurPeriodResultValue.values();
        HashMap<String, BigDecimal> curPeriodPreDepreMap = new HashMap<String, BigDecimal>(16);
        for (Map<String, Object> curPredictRs : predictCurPeriodResult) {
            BigDecimal monthdepre = (BigDecimal)curPredictRs.get("monthdepre");
            BigDecimal accumdepre = (BigDecimal)curPredictRs.get("accumdepre");
            BigDecimal predictBeginDepre = accumdepre.subtract(monthdepre);
            curPeriodPreDepreMap.put((String)curPredictRs.get("number"), predictBeginDepre);
        }
        Algo algo = Algo.create((String)ALGO);
        Field[] fields = this.getFieldArray();
        DataSetBuilder builder = algo.createDataSetBuilder(new RowMeta(fields));
        AssetCardQueryServiceHelper.transData2DataSet(builder, fields.length, predictEndPeriod.getLong("id"), predictEndPeriodResult, curPeriodPreDepreMap);
        DataSet predictDataSet = builder.build();
        List<String> lst = this.getDepreForecastFields();
        DataSet resultDataSet = predictDataSet.select(lst.toArray(new String[0])).filter("predictdepre != null and predictdepre != 0");
        return resultDataSet;
    }

    private void sumForecastData2Map(DataSet rowDataSet, Map<String, BigDecimal> forecastSumMap) {
        for (Row row : rowDataSet) {
            for (Map.Entry<String, BigDecimal> entry : forecastSumMap.entrySet()) {
                forecastSumMap.put(entry.getKey(), entry.getValue().add(row.getBigDecimal(entry.getKey())));
            }
        }
    }

    private List<String> getDepreForecastFields() {
        ArrayList<String> result = new ArrayList<String>(14);
        result.add("periodnumber");
        result.add("monthdepre");
        result.add("number");
        result.add("predictoriginalval");
        result.add("predictdepre");
        result.add("predictaccumdepre");
        result.add("predictnetworth");
        result.add("predictdecval");
        result.add("predictnetamount");
        result.add("preaddupyeardepre");
        result.add("preusingamount");
        result.add("predepredamount");
        result.add("preresidualval");
        result.add("preremainderamount");
        return result;
    }

    private Field[] getFieldArray() {
        return new Field[]{new Field("periodnumber", (DataType)DataType.LongType), new Field("number", (DataType)DataType.StringType), new Field("predictoriginalval", (DataType)DataType.BigDecimalType), new Field("predictdepre", (DataType)DataType.BigDecimalType), new Field("predictaccumdepre", (DataType)DataType.BigDecimalType), new Field("predictnetworth", (DataType)DataType.BigDecimalType), new Field("predictdecval", (DataType)DataType.BigDecimalType), new Field("predictnetamount", (DataType)DataType.BigDecimalType), new Field("preaddupyeardepre", (DataType)DataType.BigDecimalType), new Field("preusingamount", (DataType)DataType.BigDecimalType), new Field("predepredamount", (DataType)DataType.BigDecimalType), new Field("preresidualval", (DataType)DataType.BigDecimalType), new Field("preremainderamount", (DataType)DataType.BigDecimalType), new Field("monthdepre", (DataType)DataType.BigDecimalType)};
    }
}

