/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.report.SortField;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.PeriodUtil;

public class FaRptSortQueryService {
    protected static String SORT_ENTRY = "sortentry";
    public static String BATCH_ORG = "batchOrg";
    public static String BATCH_PERIOD = "batchPeriod";
    public static String BATCH_ASSETCAT = "batchAssetcat";
    public static String BATCH_PERIODLAST = "batchPeriodLast";
    public static String BATCH_ORGLAST = "batchOrgLast";
    private String entityId;
    private ReportQueryParam queryParam;
    private String orgKey;
    private String startPeriodKey;
    private String endPeriodKey;
    private List<SortField> orderFieldCfg;

    public FaRptSortQueryService(String entityId, ReportQueryParam queryParam, String orgKey, String startPeriodKey, String endPeriodKey) {
        List sortFields;
        this.entityId = entityId;
        this.queryParam = queryParam;
        this.orgKey = orgKey;
        this.startPeriodKey = startPeriodKey;
        this.endPeriodKey = endPeriodKey;
        FilterInfo filterInfo = queryParam.getFilter();
        Map otherEntryFilter = filterInfo.getOtherEntryFilter();
        this.orderFieldCfg = otherEntryFilter == null || otherEntryFilter.isEmpty() ? this.getDefaultOrderFields() : ((sortFields = (List)otherEntryFilter.get(SORT_ENTRY)) == null || sortFields.isEmpty() ? this.getDefaultOrderFields() : this.fillDefaultOrderFields(sortFields));
    }

    public DataSet queryBatchBy(boolean enableBatch, String perBatchHandlerKey, Consumer<String> perBatchHandler) {
        DataSet dataSet = null;
        FilterInfo filterInfo = this.queryParam.getFilter();
        RowMeta rowMeta = new RowMeta(new Field[]{new Field(BATCH_ORG, (DataType)DataType.LongType), new Field(BATCH_PERIOD, (DataType)DataType.LongType), new Field(BATCH_ASSETCAT, (DataType)DataType.LongType), new Field(BATCH_PERIODLAST, (DataType)DataType.BooleanType), new Field(BATCH_ORGLAST, (DataType)DataType.BooleanType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        List<Long> orgPks = this.handleOrgFilter(filterInfo, this.orderFieldCfg);
        List<Long> periodPks = this.handlePeriodFilter(filterInfo, this.orderFieldCfg);
        DynamicObject depreUse = this.queryParam.getFilter().getDynamicObject("depreuse");
        Set enableBatchOrgs = !enableBatch ? Collections.emptySet() : FaBillParamUtils.isRptEnableBatch(this.entityId, orgPks, depreUse.getLong("id"));
        QFilter commFilter = filterInfo.getCommFilter("fa_card_fin");
        for (int orgIndex = 0; orgIndex < orgPks.size(); ++orgIndex) {
            long orgId = orgPks.get(orgIndex);
            if (perBatchHandler != null) {
                perBatchHandler.accept(perBatchHandlerKey + orgId);
            }
            boolean useAssetcatBatch = commFilter == null && enableBatchOrgs.contains(orgId) && !this.batchFieldAfterDetailField();
            List<Object> assetCatList = Collections.emptyList();
            if (useAssetcatBatch) {
                assetCatList = this.handleAssetcatFilter(this.orderFieldCfg, orgId);
            }
            for (int periodIndex = 0; periodIndex < periodPks.size(); ++periodIndex) {
                boolean periodLast;
                long periodId = periodPks.get(periodIndex);
                boolean bl = periodLast = periodIndex == periodPks.size() - 1;
                if (perBatchHandler != null) {
                    perBatchHandler.accept(perBatchHandlerKey + orgId + "." + periodId);
                }
                if (useAssetcatBatch) {
                    for (int i = 0; i < assetCatList.size(); ++i) {
                        boolean assetLast = i == assetCatList.size() - 1;
                        Long assetcatId = (Long)assetCatList.get(i);
                        dataSetBuilder.append(new Object[]{orgId, periodId, assetcatId, assetLast, assetLast && periodLast});
                    }
                    continue;
                }
                dataSetBuilder.append(new Object[]{orgId, periodId, 0L, true, periodLast});
            }
        }
        dataSet = dataSetBuilder.build();
        IReportBatchQueryInfo byBatchInfo = this.queryParam.byBatchInfo();
        byBatchInfo.setCountPerBatch(1);
        return dataSet;
    }

    protected List<Long> handleOrgFilter(FilterInfo filterInfo, List<SortField> orderFieldCfg) {
        ArrayList<Long> orgPks = new ArrayList<Long>();
        Object orgVal = filterInfo.getValue(this.orgKey);
        if (orgVal instanceof DynamicObjectCollection) {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)orgVal;
            orgPks = this.buildAndSortFields(orderFieldCfg, "org", (Collection<DynamicObject>)orgColl);
        } else {
            DynamicObject org = (DynamicObject)orgVal;
            orgPks.add(org.getLong("id"));
        }
        return orgPks;
    }

    protected List<Long> handlePeriodFilter(FilterInfo filterInfo, List<SortField> fieldCfg) {
        DynamicObject startPeriod;
        ArrayList<Long> periodPks = new ArrayList<Long>();
        if (StringUtils.isEmpty((String)this.endPeriodKey)) {
            startPeriod = filterInfo.getDynamicObject(this.startPeriodKey);
            periodPks.add(startPeriod.getLong("id"));
        } else {
            startPeriod = filterInfo.getDynamicObject(this.startPeriodKey);
            DynamicObject endPeriod = filterInfo.getDynamicObject(this.endPeriodKey);
            periodPks.addAll(PeriodUtil.queryPeriodIdRange(startPeriod.getLong("id"), endPeriod.getLong("id"), false));
        }
        Optional<SortField> find = fieldCfg.stream().filter(f -> f.getSortField().startsWith("period")).findFirst();
        if (!find.isPresent()) {
            return periodPks;
        }
        String sortType = find.get().getSortType();
        if ("desc".equalsIgnoreCase(sortType)) {
            Collections.reverse(periodPks);
        }
        return periodPks;
    }

    protected List<Long> handleAssetcatFilter(List<SortField> fieldCfg, long orgId) {
        Optional<SortField> find = fieldCfg.stream().filter(f -> f.getSortField().startsWith("assetcat")).findFirst();
        String orderType = "asc";
        if (find.isPresent()) {
            orderType = find.get().getSortType();
        }
        SqlBuilder queryRealCardSql = new SqlBuilder();
        queryRealCardSql.append("select fid, fnumber from t_fa_assetcategory where fid in (select distinct fassetcatid from t_fa_card_real where forgid = ?)", new Object[]{orgId});
        queryRealCardSql.append(" order by fnumber " + orderType, new Object[0]);
        DataSet realCardDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryRealCardSql);
        ArrayList<Long> assetCatList = new ArrayList<Long>();
        for (Row row : realCardDataSet) {
            assetCatList.add(row.getLong("fid"));
        }
        return assetCatList;
    }

    private List<Long> buildAndSortFields(List<SortField> fieldCfg, String sortKey, Collection<DynamicObject> vals) {
        Optional<SortField> find = fieldCfg.stream().filter(f -> f.getSortField().startsWith(sortKey)).findFirst();
        if (!find.isPresent()) {
            return vals.stream().sorted(Comparator.comparing(org -> org.getString("number"))).map(row -> row.getLong("id")).collect(Collectors.toList());
        }
        SortField field = find.get();
        String key = field.getSortField().replaceFirst(sortKey, "").replaceFirst("\\.", "");
        List<Long> collect = vals.stream().sorted(Comparator.comparing(row -> row.getString(key))).map(row -> row.getLong("id")).collect(Collectors.toList());
        String sortType = field.getSortType();
        if ("desc".equalsIgnoreCase(sortType)) {
            Collections.reverse(collect);
        }
        return collect;
    }

    private List<SortField> getDefaultOrderFields() {
        List<SortField> sortFields = this.fillDefaultOrderFields(Collections.emptyList());
        return sortFields;
    }

    private List<SortField> fillDefaultOrderFields(List<SortField> srcSortFields) {
        ArrayList<SortField> destSortFields = new ArrayList<SortField>(srcSortFields);
        SortField orgField = new SortField();
        orgField.setSortField("org.number");
        orgField.setSortType("asc");
        if (!srcSortFields.contains(orgField)) {
            destSortFields.add(0, orgField);
        }
        SortField periodField = new SortField();
        periodField.setSortField("period.number");
        periodField.setSortType("asc");
        if (!srcSortFields.contains(periodField)) {
            destSortFields.add(1, periodField);
        }
        if ("fa_rpt_card".equals(this.entityId) || "fa_rpt_depreciation".equals(this.entityId)) {
            SortField assetcatField = new SortField();
            assetcatField.setSortField("assetcat.number");
            assetcatField.setSortType("asc");
            if (!srcSortFields.contains(assetcatField)) {
                destSortFields.add(assetcatField);
            }
        }
        SortField numberField = new SortField();
        numberField.setSortField("number");
        numberField.setSortType("asc");
        if (!srcSortFields.contains(numberField)) {
            destSortFields.add(numberField);
        }
        return destSortFields;
    }

    public boolean batchFieldAfterDetailField() {
        int numIndex = 0;
        int assetcatIndex = 0;
        for (int i = 0; i < this.orderFieldCfg.size(); ++i) {
            SortField sortField = this.orderFieldCfg.get(i);
            if (sortField.getSortField().startsWith("assetcat")) {
                assetcatIndex = i;
            }
            if (!sortField.getSortField().startsWith("number")) continue;
            numIndex = i;
        }
        return assetcatIndex > numIndex;
    }

    public String[] getUsedDetailBatchOrderString(boolean usedDetailBatch) {
        if ("fa_rpt_card".equals(this.entityId)) {
            if (usedDetailBatch) {
                Optional<SortField> numberField = this.orderFieldCfg.stream().filter(cfg -> cfg.getSortField().startsWith("number")).findFirst();
                if (numberField.isPresent()) {
                    return new String[]{"number " + numberField.get().getSortType()};
                }
                return new String[]{"number asc"};
            }
            ArrayList<String> sortList = new ArrayList<String>(2);
            for (SortField cfg2 : this.orderFieldCfg) {
                if (cfg2.getSortField().startsWith("assetcat")) {
                    String assetcatOrder = "assetcat.number " + cfg2.getSortType();
                    sortList.add(assetcatOrder);
                    continue;
                }
                if (!cfg2.getSortField().startsWith("number")) continue;
                String numberOrder = "number " + cfg2.getSortType();
                sortList.add(numberOrder);
            }
            return sortList.toArray(new String[0]);
        }
        if ("fa_rpt_depreciation".equals(this.entityId)) {
            if (usedDetailBatch) {
                Optional<SortField> numberField = this.orderFieldCfg.stream().filter(cfg -> cfg.getSortField().startsWith("number")).findFirst();
                String numberOrder = numberField.map(sortField -> "number " + sortField.getSortType()).orElse("number asc");
                return new String[]{numberOrder};
            }
            ArrayList<String> sortList = new ArrayList<String>(2);
            for (SortField cfg3 : this.orderFieldCfg) {
                if (cfg3.getSortField().startsWith("assetcat")) {
                    String assetcatOrder = "assetcat.number " + cfg3.getSortType();
                    sortList.add(assetcatOrder);
                    continue;
                }
                if (!cfg3.getSortField().startsWith("number")) continue;
                String numberOrder = "number " + cfg3.getSortType();
                sortList.add(numberOrder);
            }
            return sortList.toArray(new String[0]);
        }
        if ("fa_rpt_depre_assgin".equals(this.entityId)) {
            if (usedDetailBatch) {
                Optional<SortField> numberField = this.orderFieldCfg.stream().filter(cfg -> cfg.getSortField().startsWith("number")).findFirst();
                String numberOrder = numberField.map(sortField -> "assentry.copyrealcard.number " + sortField.getSortType()).orElse("assentry.copyrealcard.number asc");
                return new String[]{numberOrder};
            }
            ArrayList<String> sortList = new ArrayList<String>(2);
            for (SortField cfg4 : this.orderFieldCfg) {
                if (cfg4.getSortField().startsWith("assetcat")) {
                    String assetcatOrder = "assetcat.number " + cfg4.getSortType();
                    sortList.add(assetcatOrder);
                    continue;
                }
                if (!cfg4.getSortField().startsWith("number")) continue;
                String numberOrder = "assentry.copyrealcard.number " + cfg4.getSortType();
                sortList.add(numberOrder);
            }
            return sortList.toArray(new String[0]);
        }
        if ("fa_rpt_depre_forecast".equals(this.entityId)) {
            ArrayList<String> sortList = new ArrayList<String>(2);
            for (SortField cfg5 : this.orderFieldCfg) {
                if (cfg5.getSortField().startsWith("assetcat")) {
                    String assetcatOrder = "assetcat.number " + cfg5.getSortType();
                    sortList.add(assetcatOrder);
                    continue;
                }
                if (!cfg5.getSortField().startsWith("number")) continue;
                String numberOrder = "number " + cfg5.getSortType();
                sortList.add(numberOrder);
            }
            return sortList.toArray(new String[0]);
        }
        return new String[0];
    }
}

