/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.fa.business.service.api.AssetCardFinEntryUpgradeService;
import kd.fi.fa.business.utils.FaBillParamUtils;

public class AssetCardFinEntryUpgradeServiceImpl
implements AssetCardFinEntryUpgradeService {
    private static final String ALGO_KEY = "kd.fi.fa.business.service.AssetCardFinEntryUpgradeServiceImpl";
    private static final Log logger = LogFactory.getLog((String)"kd.fi.fa.business.service.AssetCardFinEntryUpgradeServiceImpl");
    private static final String LOCK_KEY = "fi/fa/AssetCardFinEntryUpgradeService";
    private final DBRoute faRoute = DBRoute.of((String)"fa");
    private final String param;

    public AssetCardFinEntryUpgradeServiceImpl(String param) {
        this.param = param;
        logger.info("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u53c2\u6570[{}]", (Object)param);
    }

    @Override
    public void executeUpgradeService() {
        try (DLock dLock = DLock.create((String)LOCK_KEY).fastMode();){
            boolean tryLock = dLock.tryLock();
            if (!tryLock) {
                logger.info("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u672a\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501\uff0c\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u4e0d\u518d\u91cd\u590d\u5904\u7406");
                throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"AssetCardFinEntryUpgradeServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            this.execute();
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u5347\u7ea7\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void unlockUpgradeLock() {
        DLock.forceUnlock((String[])new String[]{LOCK_KEY});
    }

    private void execute() {
        int countCards = this.countCards();
        logger.info("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u5361\u7247\u603b\u91cf[{}]", (Object)countCards);
        SqlBuilder queryRealCardSql = new SqlBuilder();
        queryRealCardSql.append("select fid from t_fa_card_real ", new Object[0]);
        this.appendRealCardFilters(queryRealCardSql);
        DataSet realCardDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)this.faRoute, (SqlBuilder)queryRealCardSql);
        int cardBatchNum = 1000;
        ArrayList<Long> realCardIdList = new ArrayList<Long>(cardBatchNum);
        int processedCardNum = 0;
        for (Row row : realCardDataSet) {
            Long realCardId = row.getLong("fid");
            realCardIdList.add(realCardId);
            if (realCardIdList.size() < cardBatchNum) continue;
            this.processBatch(realCardIdList);
            realCardIdList.clear();
            logger.info("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u5904\u7406\u5b8c\u4e00\u6279\u5361\u7247\uff0c\u5347\u7ea7\u8fdb\u5ea6[{}/{}]", (Object)(processedCardNum += realCardIdList.size()), (Object)countCards);
        }
        if (!realCardIdList.isEmpty()) {
            this.processBatch(realCardIdList);
            processedCardNum += realCardIdList.size();
            realCardIdList.clear();
        }
        logger.info("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u6240\u6709\u5361\u7247\u5347\u7ea7\u5b8c\u6bd5\uff0c\u5347\u7ea7\u8fdb\u5ea6[{}/{}]", (Object)processedCardNum, (Object)countCards);
    }

    private void processBatch(List<Long> realCardIdList) {
        SqlBuilder queryFinCardSql = new SqlBuilder();
        queryFinCardSql.append("select b.fid, b.frealcardid, b.frealcardmasterid ", new Object[0]);
        queryFinCardSql.append(" from t_fa_assetbook a left join t_fa_card_fin b ", new Object[0]);
        queryFinCardSql.append(" on a.fid = b.fassetbookid ", new Object[0]);
        queryFinCardSql.append(" where b.fendperiodid = ? ", new Object[]{99999999999L});
        queryFinCardSql.appendIn(" and b.frealcardid ", realCardIdList.toArray());
        queryFinCardSql.append(" order by b.frealcardid, a.fismainbook desc", new Object[0]);
        DataSet finCardDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)this.faRoute, (SqlBuilder)queryFinCardSql);
        int countFinCard = finCardDataSet.copy().count("fid", false);
        long[] entryIdArr = DBServiceHelper.genLongIds((String)"t_fa_asset_finentry", (int)countFinCard);
        long lastRealCardId = 0L;
        int seq = 1;
        int idIndex = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(countFinCard);
        HashSet<Long> realCardMasterIds = new HashSet<Long>(16);
        for (Row row : finCardDataSet) {
            Long realCardId = row.getLong("frealcardid");
            Long finCardId = row.getLong("fid");
            Long realMasterId = row.getLong("frealcardmasterid");
            realCardMasterIds.add(realMasterId);
            seq = realCardId != lastRealCardId ? 1 : ++seq;
            insertParams.add(new Object[]{realCardId, entryIdArr[idIndex++], seq, finCardId});
            lastRealCardId = realCardId;
        }
        SqlBuilder deleteHisDataSql = new SqlBuilder();
        deleteHisDataSql.append("delete from t_fa_asset_finentry where ", new Object[0]);
        deleteHisDataSql.appendIn(" fid ", realCardIdList.toArray());
        String insertNewDataSql = "insert into t_fa_asset_finentry(fid, fentryid, fseq, ffincardid) values (?, ?, ?, ?);";
        if (insertParams.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DB.execute((DBRoute)this.faRoute, (SqlBuilder)deleteHisDataSql);
                DB.executeBatch((DBRoute)this.faRoute, (String)insertNewDataSql, insertParams);
                ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
                customFilters.add(new QFilter("value", "=", (Object)"true"));
                if (FaBillParamUtils.exists("split.currentperiod.enable", customFilters)) {
                    this.updateOriFinCardId(realCardMasterIds);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateOriFinCardId(Set<Long> realCardMasterId) {
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fid,frealcardmasterid,fdepreuseid,foriginaldata from t_fa_card_fin where (fendperiodid = ? or foriginaldata = '1') and ", new Object[]{99999999999L});
        querySql.appendIn(" frealcardmasterid ", (Object[])realCardMasterId.toArray(new Long[0]));
        HashMap<Long, String> finId2MasterIdDepreuseIdMap = new HashMap<Long, String>(realCardMasterId.size());
        HashMap<String, Long> masterIdDepreuseId2OriFinIdMap = new HashMap<String, Long>(realCardMasterId.size());
        DataSet dataSet = DB.queryDataSet((String)"updateOriFinCardId", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);
        Object object = null;
        try {
            for (Row row : dataSet) {
                Long finId = row.getLong("fid");
                Long realMasterId = row.getLong("frealcardmasterid");
                Long depreuseId = row.getLong("fdepreuseid");
                Boolean originalData = row.getBoolean("foriginaldata");
                String masterIdDepreuseIdKey = realMasterId + "_" + depreuseId;
                if (originalData.booleanValue()) {
                    masterIdDepreuseId2OriFinIdMap.put(masterIdDepreuseIdKey, finId);
                    continue;
                }
                finId2MasterIdDepreuseIdMap.put(finId, masterIdDepreuseIdKey);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!finId2MasterIdDepreuseIdMap.isEmpty()) {
            HashMap finId2OriFinIdMap = new HashMap(finId2MasterIdDepreuseIdMap.size());
            for (Map.Entry entry : finId2MasterIdDepreuseIdMap.entrySet()) {
                void var8_19;
                Long l = (Long)masterIdDepreuseId2OriFinIdMap.get(entry.getValue());
                if (l == null) {
                    Long l2 = 0L;
                }
                finId2OriFinIdMap.put(entry.getKey(), var8_19);
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(finId2OriFinIdMap.size());
            for (Map.Entry entry : finId2OriFinIdMap.entrySet()) {
                params.add(new Object[]{entry.getValue(), entry.getKey()});
            }
            String string = "update t_fa_asset_finentry set foriginalfincardid = ? where ffincardid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)string, params);
        }
    }

    private void appendRealCardFilters(SqlBuilder sqlBuilder) {
        sqlBuilder.append(" where fisbak = '0' ", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)this.param)) {
            try {
                String[] splitParams = this.param.split(";");
                String[] splitOrgParams = splitParams[0].split(":");
                String orgNumber = splitOrgParams[1].trim();
                SqlBuilder queryOrgSql = new SqlBuilder();
                queryOrgSql.append("select fid from t_org_org where fnumber = ?;", new Object[]{orgNumber});
                DataSet orgDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.basedata, (SqlBuilder)queryOrgSql);
                long orgId = 0L;
                for (Row row : orgDataSet) {
                    Long fid = row.getLong("fid");
                    if (orgId == 0L) {
                        orgId = fid;
                        continue;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u7f16\u7801\u7684\u7ec4\u7ec7\u3002", (String)"AssetCardFinEntryUpgradeServiceImpl_1", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (orgId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u3002", (String)"AssetCardFinEntryUpgradeServiceImpl_2", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                sqlBuilder.append(" and fassetunitid = ? ", new Object[]{orgId});
                if (splitParams.length > 1) {
                    String[] splitNumberParams = splitParams[1].split(":");
                    String numberStr = splitNumberParams[1];
                    String[] numberArr = numberStr.split(",");
                    Object[] numbers = Arrays.stream(numberArr).map(String::trim).toArray();
                    sqlBuilder.appendIn(" and fnumber ", numbers);
                }
            }
            catch (KDBizException e1) {
                throw e1;
            }
            catch (Exception e2) {
                logger.error("\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u5347\u7ea7\uff1a\u89e3\u6790\u53c2\u6570\u5f02\u5e38", (Throwable)e2);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6709\u8bef\u3002", (String)"AssetCardFinEntryUpgradeServiceImpl_3", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
    }

    private int countCards() {
        String countSql = "select count(1) as countcard from t_fa_card_real where fisbak = '0';";
        DataSet dataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"fa"), (String)countSql);
        Row next = (Row)dataSet.iterator().next();
        return next.getInteger("countcard");
    }
}

