/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.service.api.DeleteAssetChangeBillService;
import kd.fi.fa.common.util.Fa;

public class DeleteAssetChangeBillServiceImpl
implements DeleteAssetChangeBillService {
    @Override
    public OperationResult deleteBySourceIds(Set<Long> sourceIds) {
        OperationResult result = new OperationResult();
        QFilter idFilter = new QFilter("sourceid", "in", sourceIds);
        DynamicObjectCollection changeBillCollection = this.queryDataOrderByAudit(idFilter);
        if (changeBillCollection == null || changeBillCollection.isEmpty()) {
            this.queryDataIsEmpty(result);
        } else {
            this.unAuditAndDelete(changeBillCollection, result, false);
        }
        return result;
    }

    @Override
    public OperationResult deleteBySourceIdsIgnoreRight(Set<Long> sourceIds) {
        OperationResult result = new OperationResult();
        QFilter idFilter = new QFilter("sourceid", "in", sourceIds);
        DynamicObjectCollection changeBillCollection = this.queryDataOrderByAudit(idFilter);
        if (changeBillCollection == null || changeBillCollection.isEmpty()) {
            this.queryDataIsEmpty(result);
        } else {
            this.unAuditAndDelete(changeBillCollection, result, true);
        }
        return result;
    }

    @Override
    public OperationResult deleteByIds(Set<Long> Ids) {
        OperationResult result = new OperationResult();
        QFilter idFilter = new QFilter("id", "in", Ids);
        DynamicObjectCollection changeBillCollection = this.queryDataOrderByAudit(idFilter);
        if (changeBillCollection == null || changeBillCollection.isEmpty()) {
            this.queryDataIsEmpty(result);
        } else {
            this.unAuditAndDelete(changeBillCollection, result, false);
        }
        return result;
    }

    @Override
    public OperationResult deleteByIdsIgnoreRight(Set<Long> ids) {
        OperationResult result = new OperationResult();
        try (TXHandle x = TX.required();){
            OperateOption unAuditOp = OperateOption.create();
            unAuditOp.setVariableValue("IGNORE_API", "1");
            try {
                for (Long id : ids) {
                    this.unAuditAndDeleteById(id, result, true, unAuditOp);
                }
            }
            catch (Exception e) {
                x.markRollback();
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return result;
    }

    private void queryDataIsEmpty(OperationResult result) {
        result.setSuccess(Boolean.FALSE.booleanValue());
        OperateErrorInfo operateError = new OperateErrorInfo();
        operateError.setMessage(ResManager.loadKDString((String)"\u672a\u751f\u6210\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"DeleteAssetChangeBillServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
        operateError.setLevel(ErrorLevel.Error);
        result.getAllErrorInfo().add(operateError);
    }

    private DynamicObjectCollection queryDataOrderByAudit(QFilter idFilter) {
        QFilter[] qFilters = new QFilter[]{idFilter};
        String orderBys = String.join((CharSequence)" ", "auditdate", "DESC");
        DynamicObjectCollection changeBillCollection = QueryServiceHelper.query((String)"fa_change_dept", (String)Fa.comma((String[])new String[]{"id", "sourceid", "auditdate", "billno"}), (QFilter[])qFilters, (String)orderBys);
        return changeBillCollection;
    }

    private void unAuditAndDelete(DynamicObjectCollection changeBillCollection, OperationResult result, boolean ignoreRight) {
        try (TXHandle x = TX.required();){
            OperateOption unAuditOp = OperateOption.create();
            unAuditOp.setVariableValue("leaseChangeDeleteAssetChange", "1");
            try {
                for (DynamicObject changeBill : changeBillCollection) {
                    this.unAuditAndDeleteById(changeBill.getLong("id"), result, ignoreRight, unAuditOp);
                }
            }
            catch (Exception e) {
                x.markRollback();
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void unAuditAndDeleteById(Long id, OperationResult result, boolean ignoreRight, OperateOption unAuditOp) {
        Boolean opResult;
        unAuditOp.setVariableValue("allowDeleteAssetChange", "1");
        if (ignoreRight) {
            unAuditOp.setVariableValue("ishasright", String.valueOf(true));
        }
        if ((opResult = this.operationAssetChangeBill(id, "unaudit", unAuditOp, result)).booleanValue()) {
            OperateOption deleteOp = OperateOption.create();
            if (ignoreRight) {
                deleteOp.setVariableValue("ishasright", String.valueOf(true));
            }
            this.operationAssetChangeBill(id, "delete", deleteOp, result);
        }
    }

    public Boolean operationAssetChangeBill(Long id, String operation, OperateOption op, OperationResult result) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operation, (String)"fa_change_dept", (Object[])new Object[]{id}, (OperateOption)op);
        List successPkIds = result.getSuccessPkIds();
        successPkIds.addAll(operationResult.getSuccessPkIds());
        result.setSuccessPkIds(successPkIds.stream().distinct().collect(Collectors.toList()));
        if (!operationResult.isSuccess()) {
            List allError = operationResult.getAllErrorOrValidateInfo();
            List allErrorInfo = operationResult.getAllErrorInfo();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    OperateErrorInfo operateError = new OperateErrorInfo();
                    operateError.setPkValue(in.getPkValue());
                    operateError.setMessage(in.getMessage());
                    operateError.setTitle(in.getTitle());
                    operateError.setLevel(ErrorLevel.Error);
                    allErrorInfo.add(operateError);
                }
            }
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.getAllErrorInfo().addAll(allErrorInfo);
            if (successPkIds.contains(operationResult.getSuccessPkIds())) {
                successPkIds.remove(operationResult.getSuccessPkIds());
            }
            return false;
        }
        return true;
    }
}

