/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.report.SumFlagEnum;
import kd.fi.fa.business.report.FaRptSortQueryService;
import kd.fi.fa.business.service.api.DepreciationCommQueryService;
import kd.fi.fa.business.service.api.DepreciationRptQueryService;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.Fa;

public class DepreciationRptQueryServiceImpl
implements DepreciationRptQueryService,
DepreciationCommQueryService {
    private static final Log logger = LogFactory.getLog(DepreciationRptQueryServiceImpl.class);
    private static final String PARAM_PAGE_ID = "pageId";
    private final String algoKey;
    private final ReportQueryParam queryParam;
    private final boolean batchQuery;
    private final Object select;
    private String pageId = "DEFAULT_PAGE_ID";
    private FilterInfo filterInfo;
    private List<Object> orgIds;
    private long depreUseId;
    private long startPeriodId;
    private long endPeriodId;
    private boolean isShowAllCard = false;
    private final Map<String, Object> localCache = new HashMap<String, Object>(16);
    private final IAppCache appCache = AppCache.get((String)"fa");
    private boolean fromQingAnaly = false;
    private FaRptSortQueryService batchAndSortService;

    public DepreciationRptQueryServiceImpl(String algoKey, ReportQueryParam queryParam, boolean batchQuery, Object select) {
        this.algoKey = algoKey;
        this.queryParam = queryParam;
        this.batchQuery = batchQuery;
        this.select = select;
        this.initParam();
        this.batchAndSortService = new FaRptSortQueryService("fa_rpt_depreciation", queryParam, "q_org", "period_start", "period_end");
    }

    @Override
    public DataSet getQueryBatchBy() {
        String cacheKeyPrefix = this.getCacheKeyPrefix();
        String cacheAllOrgSumIdKey = cacheKeyPrefix + ".all.org.sum";
        this.removeCache(cacheAllOrgSumIdKey);
        DataSet dataSet = this.batchAndSortService.queryBatchBy(!this.fromQingAnaly, cacheKeyPrefix, this::removeCache);
        return dataSet;
    }

    @Override
    public DataSet queryBatchData(Row row, boolean totalLastBatch) {
        long curOrgId = row.getLong(FaRptSortQueryService.BATCH_ORG);
        long curPeriodId = row.getLong(FaRptSortQueryService.BATCH_PERIOD);
        boolean orgLastBatch = row.getBoolean(FaRptSortQueryService.BATCH_ORGLAST);
        boolean periodLastBatch = row.getBoolean(FaRptSortQueryService.BATCH_PERIODLAST);
        long curAssetType = row.getLong(FaRptSortQueryService.BATCH_ASSETCAT);
        return this.getQueryData(this.queryParam, this.select, curOrgId, this.depreUseId, curPeriodId, curAssetType, orgLastBatch, periodLastBatch, totalLastBatch);
    }

    @Override
    public DataSet getQueryData(ReportQueryParam queryParam, Object select, long curOrgId, long depreUseId, long curPeriodId, long curAssetType, boolean orgLastBatch, boolean periodLastBatch, boolean totalLastBatch) {
        QFilter filters;
        if (!this.isShowAllCard) {
            QFilter fend = new QFilter("endperiod", ">", (Object)curPeriodId);
            QFilter fperiod = new QFilter("bizperiod", "=", (Object)curPeriodId);
            QFilter fcurCard = new QFilter("bizperiod", "=", (Object)curPeriodId);
            QFilter fmonthdepre = new QFilter("monthdepre", "!=", (Object)0);
            filters = fend.and(fperiod).and(fcurCard).and(fmonthdepre);
        } else {
            QFilter fperiod = new QFilter("bizperiod", "<=", (Object)curPeriodId);
            QFilter fendPeriod = new QFilter("endperiod", ">", (Object)curPeriodId);
            filters = fperiod.and(fendPeriod);
        }
        Set<String> listFields = this.getQueryFileds();
        listFields.addAll(select == null ? new HashSet(0) : (Set)select);
        String listFieldStrs = listFields.toString();
        String strFields = "id," + listFieldStrs.substring(1, listFieldStrs.length() - 1);
        QFilter forg = new QFilter("org", "=", (Object)curOrgId);
        QFilter fdepreUse = new QFilter("depreuse", "=", (Object)depreUseId);
        QFilter fbillstatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"startperiod", (QFilter[])new QFilter[]{forg, fdepreUse});
        long bookStartId = 99999999999L;
        if (assetBook != null) {
            bookStartId = assetBook.getLong("startperiod.id");
        }
        long t2 = System.currentTimeMillis();
        DataSet rootLeafCategory = this.getRootCategorys();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(forg);
        filterList.add(fdepreUse);
        filterList.add(fbillstatus);
        filterList.add(filters);
        if (this.filterInfo.getCommFilter("fa_card_fin") != null) {
            filterList.add(this.filterInfo.getCommFilter("fa_card_fin"));
        }
        if (curAssetType > 0L) {
            filterList.add(new QFilter("assetcat", "=", (Object)curAssetType));
        }
        String selectPeriodFields = Fa.comma((String[])new String[]{"periodtype", Fa.comma((String[])new String[]{"periodyear", "number"})});
        QFilter[] periodFilters = new QFilter[]{new QFilter("id", "=", (Object)curPeriodId)};
        DynamicObject curPeriodDy = QueryServiceHelper.queryOne((String)"bd_period", (String)selectPeriodFields, (QFilter[])periodFilters);
        Long curPeriodYear = curPeriodDy.getLong("periodyear");
        Long curPeriodTypeId = curPeriodDy.getLong("periodtype");
        Long minPeriodIdInyear = FaPeriodUtils.getYearMinPeriodId(curPeriodId, curPeriodTypeId, curPeriodYear);
        filterList.add(new QFilter("clearperiod", "=", (Object)0L).or(new QFilter("clearperiod", "=", (Object)curPeriodId)).or(new QFilter("clearperiod", ">=", (Object)minPeriodIdInyear).and(new QFilter("clearperiod", "<", (Object)curPeriodId)).and(new QFilter("addupyeardepre", "!=", (Object)0L))));
        DataSet querySet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_card_fin", (String)strFields, (QFilter[])filterList.toArray(new QFilter[0]), null);
        List<String> fieldsByDataSet = this.getFieldsByDataSet(querySet);
        fieldsByDataSet.remove("category");
        querySet = querySet.leftJoin(rootLeafCategory).on("category", "astid").select(fieldsByDataSet.toArray(new String[0]), new String[]{"rootastid category"}).finish();
        querySet = querySet.orderBy(this.batchAndSortService.getUsedDetailBatchOrderString(curAssetType > 0L));
        long t3 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("sql query const line 144 time={}", (Object)(t3 - t2));
        }
        if (querySet != null) {
            DataSet build;
            CachedDataSet lastCacheDataSet;
            CachedDataSet cacheDataSet;
            DataSetBuilder dataSetBuilder;
            List<String> fields = this.getFieldsByDataSet(querySet);
            fields.remove("depre_adjust");
            fields.add("case when bizperiod = " + curPeriodId + " and bizperiod = accountperiod and accountperiod != 0 and clearperiod = accountperiod then 0       when bizperiod = " + curPeriodId + " and bizperiod = accountperiod and accountperiod != 0 then depre_reserves_end      when bizperiod < " + curPeriodId + " and bizperiod != 0 then 0      else depre_adjust end as depre_adjust");
            fields.remove("accumulated_depre_adjust");
            fields.add("case when bizperiod = " + curPeriodId + " and bizperiod = accountperiod and accountperiod != 0 and clearperiod = accountperiod then 0 - actual_depreciation\t\t when bizperiod = " + curPeriodId + " and bizperiod = accountperiod and accountperiod != 0 then accumulated_depre_end_1 - actual_depreciation      when bizperiod < " + curPeriodId + " and bizperiod != 0 then 0      else accumulated_depre_adjust end as accumulated_depre_adjust");
            fields.remove("original_adjust");
            fields.add("case when bizperiod < " + curPeriodId + " and bizperiod != 0 then 0      else original_adjust end as original_adjust");
            fields.remove("actual_depreciation");
            fields.add("case when bizperiod < " + curPeriodId + " and bizperiod != 0 then 0      else actual_depreciation end as actual_depreciation");
            fields.remove("year_depreciation");
            fields.add("case when bizperiod != 0 and bizperiod < " + minPeriodIdInyear + "  then 0      when bizperiod = 0 and " + bookStartId + " < " + minPeriodIdInyear + " then 0      else year_depreciation end as year_depreciation");
            fields.add("case when clearperiod != 0 and clearperiod <= " + curPeriodId + " then 0 else original_value_end_1 end as original_value_end");
            fields.add("case when clearperiod != 0 and clearperiod <= " + curPeriodId + " then 0 else accumulated_depre_end_1 end as accumulated_depre_end");
            fields.remove("depre_reserves_end");
            fields.add("case when clearperiod != 0 and clearperiod <= " + curPeriodId + " then 0 else depre_reserves_end end as depre_reserves_end");
            fields.remove("net_value_end");
            fields.add("case when clearperiod != 0 and clearperiod <= " + curPeriodId + " then 0 else net_value_end end as net_value_end");
            fields.remove("net_amount_end");
            fields.add("case when clearperiod != 0 and clearperiod <= " + curPeriodId + " then 0 else net_amount_end end as net_amount_end");
            fields.remove("depreciation_rate");
            fields.add("case when bizperiod < " + curPeriodId + " and bizperiod != 0 then 0 else " + "depreciation_rate" + " *100 end as " + "depreciation_rate");
            fields.add("0 summarytype");
            querySet = querySet.select(fields.toArray(new String[0]));
            querySet = querySet.addField("original_value_end-original_adjust", "original_value_begin").addField("case when bizperiod = " + curPeriodId + " and bizperiod = accountperiod and accountperiod != 0 and clearperiod = accountperiod then 0      else accumulated_depre_end - actual_depreciation - accumulated_depre_adjust end", "accumulated_depre_begin").addField("original_value_begin-accumulated_depre_begin", "net_value_begin").addField("case when bizperiod = " + curPeriodId + " and bizperiod = accountperiod and accountperiod != 0 and clearperiod = accountperiod then 0      else depre_reserves_end - depre_adjust end", "depre_reserves_begin").addField("original_value_begin-accumulated_depre_begin-depre_reserves_begin", "net_amount_begin").addField("" + curPeriodId, "period").addField("" + curPeriodDy.getLong("number"), "period_1_number");
            if (this.fromQingAnaly) {
                return querySet;
            }
            Object enableSum = queryParam.getCustomParam().get("enableSum");
            if ("false".equals(enableSum)) {
                return querySet;
            }
            DataSet curSumDataSet = this.getCurrentBatchSum(querySet, "orgPeriod");
            Row batchSumRow = null;
            if (curSumDataSet.hasNext()) {
                batchSumRow = curSumDataSet.next();
            }
            String cacheKeyPrefix = this.getCacheKeyPrefix();
            String cacheCurOrgIdKey = cacheKeyPrefix + "." + curOrgId;
            String cacheOrgDataSetId = this.getFromCache(cacheCurOrgIdKey, String.class);
            String cacheCurOrgPeriodKey = cacheKeyPrefix + "." + curOrgId + "." + curPeriodId;
            String cacheOrgPeriodDataSetId = this.getFromCache(cacheCurOrgPeriodKey, String.class);
            String cacheAllOrgSumIdKey = cacheKeyPrefix + ".all.org.sum";
            String cacheAllOrgSumDataSetId = this.getFromCache(cacheAllOrgSumIdKey, String.class);
            if (StringUtils.isEmpty((String)cacheOrgPeriodDataSetId)) {
                dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(curSumDataSet.getRowMeta());
                if (Objects.nonNull(batchSumRow)) {
                    dataSetBuilder.append(batchSumRow);
                    cacheDataSet = dataSetBuilder.build().cache(CacheHint.getDefault());
                    cacheOrgPeriodDataSetId = cacheDataSet.getCacheId();
                    this.putCacheData(cacheCurOrgPeriodKey, cacheDataSet.getCacheId());
                }
            } else {
                lastCacheDataSet = Algo.getCacheDataSet((String)cacheOrgPeriodDataSetId);
                List rowList = lastCacheDataSet.getList(0, lastCacheDataSet.getRowCount());
                DataSetBuilder sumDataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(lastCacheDataSet.getRowMeta());
                if (Objects.nonNull(batchSumRow)) {
                    sumDataSetBuilder.append(batchSumRow);
                    rowList.forEach(arg_0 -> ((DataSetBuilder)sumDataSetBuilder).append(arg_0));
                    DataSet dataSet = sumDataSetBuilder.build();
                    CachedDataSet newCacheDataSet = dataSet.cache(CacheHint.getDefault());
                    cacheOrgPeriodDataSetId = newCacheDataSet.getCacheId();
                    this.putCacheData(cacheCurOrgPeriodKey, newCacheDataSet.getCacheId());
                }
            }
            if (StringUtils.isEmpty((String)cacheOrgDataSetId)) {
                dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(curSumDataSet.getRowMeta());
                if (Objects.nonNull(batchSumRow)) {
                    dataSetBuilder.append(batchSumRow);
                    cacheDataSet = dataSetBuilder.build().cache(CacheHint.getDefault());
                    cacheOrgDataSetId = cacheDataSet.getCacheId();
                    this.putCacheData(cacheCurOrgIdKey, cacheDataSet.getCacheId());
                }
            } else if (Objects.nonNull(batchSumRow)) {
                build = this.mergeDataSet(batchSumRow, cacheOrgDataSetId, "org");
                CachedDataSet newCacheDataSet = build.cache(CacheHint.getDefault());
                cacheOrgDataSetId = newCacheDataSet.getCacheId();
                this.putCacheData(cacheCurOrgIdKey, newCacheDataSet.getCacheId());
            }
            if (periodLastBatch && StringUtils.isNotEmpty((String)cacheOrgPeriodDataSetId)) {
                build = this.mergeDataSet(null, cacheOrgPeriodDataSetId, "orgPeriod");
                querySet = querySet.union(build);
                this.removeCache(cacheCurOrgPeriodKey);
            }
            if (orgLastBatch && StringUtils.isNotEmpty((String)cacheOrgDataSetId)) {
                DataSet sumOrgDataSet = this.mergeDataSet(null, cacheOrgDataSetId, "org");
                sumOrgDataSet = sumOrgDataSet.select(querySet.getRowMeta().getFieldNames());
                List<String> begin = this.getAmountFields("begin");
                for (String string : begin) {
                    sumOrgDataSet = sumOrgDataSet.removeFields(new String[]{string}).addField("0", string);
                }
                List<String> end = this.getAmountFields("end");
                for (String endField : end) {
                    sumOrgDataSet = sumOrgDataSet.removeFields(new String[]{endField}).addField("0", endField);
                }
                sumOrgDataSet = sumOrgDataSet.select(querySet.getRowMeta().getFieldNames());
                if (StringUtils.isEmpty((String)cacheAllOrgSumDataSetId)) {
                    DataSetBuilder dataSetBuilder2 = Algo.create((String)this.algoKey).createDataSetBuilder(curSumDataSet.getRowMeta());
                    if (sumOrgDataSet.hasNext()) {
                        dataSetBuilder2.append(sumOrgDataSet.copy().next());
                    }
                    CachedDataSet cacheDataSet2 = dataSetBuilder2.build().cache(CacheHint.getDefault());
                    this.putCacheData(cacheAllOrgSumIdKey, cacheDataSet2.getCacheId());
                } else {
                    CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheAllOrgSumDataSetId);
                    List rowList = cachedDataSet.getList(0, cachedDataSet.getRowCount());
                    DataSetBuilder sumDataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(cachedDataSet.getRowMeta());
                    if (sumOrgDataSet.hasNext()) {
                        sumDataSetBuilder.append(sumOrgDataSet.copy().next());
                    }
                    rowList.forEach(arg_0 -> ((DataSetBuilder)sumDataSetBuilder).append(arg_0));
                    DataSet build3 = sumDataSetBuilder.build();
                    CachedDataSet newCacheDataSet = build3.cache(CacheHint.getDefault());
                    this.putCacheData(cacheAllOrgSumIdKey, newCacheDataSet.getCacheId());
                }
                cacheAllOrgSumDataSetId = this.getFromCache(cacheAllOrgSumIdKey, String.class);
                querySet = querySet.union(sumOrgDataSet);
                this.removeCache(cacheCurOrgIdKey);
            }
            if (totalLastBatch && StringUtils.isNotEmpty((String)cacheAllOrgSumDataSetId)) {
                lastCacheDataSet = Algo.getCacheDataSet((String)cacheAllOrgSumDataSetId);
                DataSetBuilder sumDataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(lastCacheDataSet.getRowMeta());
                List rowList = lastCacheDataSet.getList(0, lastCacheDataSet.getRowCount());
                rowList.forEach(arg_0 -> ((DataSetBuilder)sumDataSetBuilder).append(arg_0));
                DataSet dataSet = sumDataSetBuilder.build();
                DataSet total = this.getCurrentBatchSum(dataSet, "total");
                total = total.select(querySet.getRowMeta().getFieldNames());
                querySet = querySet.union(total);
                this.removeCache(cacheAllOrgSumIdKey);
            }
        }
        return querySet;
    }

    public DataSet getAssetBookId2StartPeriodYearDataSet(Map<Long, Integer> assetBookId2StartPeriodYearMap) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("assetBookStartPeriodYear", (DataType)DataType.IntegerType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        assetBookId2StartPeriodYearMap.forEach((assetBookId, startPeriodYear) -> dataSetBuilder.append(new Object[]{assetBookId, startPeriodYear}));
        return dataSetBuilder.build();
    }

    @Override
    public DataSet processRowData(final DataSet dataSet) {
        final Map<String, Map<String, BigDecimal>> finCardIdToDepreciation = DepreciationRptQueryServiceImpl.getDepAdjustData(this.queryParam);
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                RowMeta rowMeta = this.getResultRowMeta();
                String[] fieldNames = rowMeta.getFieldNames();
                HashMap<String, BigDecimal> updateFieldMap = new HashMap<String, BigDecimal>(fieldNames.length);
                long periodId = row.get("period") == null ? 0L : row.getLong("period");
                long realCardId = row.get("realcard") == null ? 0L : row.getLong("realcard");
                String key = periodId + "_" + realCardId;
                Map depData = (Map)finCardIdToDepreciation.get(key);
                if (depData == null) {
                    updateFieldMap.put("bef_adjust_depreciation", row.getBigDecimal("actual_depreciation"));
                    updateFieldMap.put("aft_adjust_depreciation", row.getBigDecimal("actual_depreciation"));
                } else {
                    updateFieldMap.put("bef_adjust_depreciation", (BigDecimal)depData.get("bef_adjust_depreciation"));
                    updateFieldMap.put("aft_adjust_depreciation", (BigDecimal)depData.get("aft_adjust_depreciation"));
                }
                ArrayList<Object> rowData = new ArrayList<Object>();
                for (String fieldName : fieldNames) {
                    if (updateFieldMap.containsKey(fieldName)) {
                        rowData.add(updateFieldMap.get(fieldName));
                        continue;
                    }
                    rowData.add(row.get(fieldName));
                }
                return rowData.toArray();
            }

            public RowMeta getResultRowMeta() {
                Field[] sourceFields = dataSet.getRowMeta().getFields();
                ArrayList<Field> newFields = new ArrayList<Field>(sourceFields.length);
                newFields.addAll(Arrays.asList(sourceFields));
                newFields.add(new Field("bef_adjust_depreciation", (DataType)DataType.BigDecimalType));
                newFields.add(new Field("aft_adjust_depreciation", (DataType)DataType.BigDecimalType));
                return new RowMeta(newFields.toArray(new Field[0]));
            }
        });
    }

    private void initParam() {
        this.filterInfo = this.queryParam.getFilter();
        this.depreUseId = this.filterInfo.getLong("depreuse");
        this.startPeriodId = this.filterInfo.getLong("period_start");
        this.endPeriodId = this.filterInfo.getLong("period_end");
        this.orgIds = new LinkedList<Object>();
        DynamicObjectCollection orgList = this.filterInfo.getDynamicObjectCollection("q_org");
        for (DynamicObject org : orgList) {
            this.orgIds.add(org.getPkValue());
        }
        if (!this.filterInfo.getBoolean("showexcept0")) {
            this.isShowAllCard = true;
        }
        if (this.batchQuery) {
            Map customParam = this.queryParam.getCustomParam();
            if (!customParam.containsKey(PARAM_PAGE_ID)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u542f\u7528\u5206\u6279\u67e5\u8be2\uff0c\u8bf7\u4f20\u5165pageId\u3002", (String)"DepreciationRptQueryServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            this.pageId = (String)customParam.get(PARAM_PAGE_ID);
        }
    }

    private List<Long> queryCardUseAssetCat(String algoKey, Object orgPk) {
        DynamicObjectCollection assetcategorycol = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id", null);
        ArrayList<Object> assetcategoryIdList = new ArrayList<Object>(assetcategorycol.size());
        for (DynamicObject assetcategory : assetcategorycol) {
            assetcategoryIdList.add(assetcategory.get("id"));
        }
        SqlBuilder queryRealCardSql = new SqlBuilder();
        queryRealCardSql.append("select distinct fassetcatid from t_fa_card_real where forgid = ? ", new Object[]{orgPk}).appendIn("and FAssetcatid", assetcategoryIdList.toArray());
        DataSet realCardDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryRealCardSql);
        ArrayList<Long> assetCatList = new ArrayList<Long>(10);
        for (Row row : realCardDataSet) {
            assetCatList.add(row.getLong("fassetcatid"));
        }
        return assetCatList;
    }

    public Set<String> getQueryFileds() {
        HashSet<String> selFields = new HashSet<String>(24);
        selFields.add("assetbook");
        selFields.add("assetbook.basecurrency basecurrency");
        selFields.add(Fa.dot((String[])new String[]{"period", "number"}));
        selFields.add("assetcat category");
        selFields.add(Fa.dot((String[])new String[]{"assetcat", "level"}));
        selFields.add(Fa.dot((String[])new String[]{"assetcat", "number"}));
        selFields.add("org.name orgname");
        selFields.add("org org");
        selFields.add("number");
        selFields.add("realcard realcard");
        selFields.add(Fa.dot((String[])new String[]{"realcard", "assetname"}));
        selFields.add(Fa.dot((String[])new String[]{"realcard", "assetcat"}));
        selFields.add("id fid");
        selFields.add("preusingamount prepare_use_amount");
        selFields.add("depredamount depreciation_amount");
        selFields.add("depremethod depreciation_method");
        selFields.add(Fa.dot((String[])new String[]{"depremethod", "name"}) + " " + Fa.dot((String[])new String[]{"depreciation_method", "name"}));
        selFields.add("monthdeprerate depreciation_rate");
        selFields.add("monthorigvalchg original_adjust");
        selFields.add("monthaccumdeprechg accumulated_depre_adjust");
        selFields.add("monthdepre actual_depreciation");
        selFields.add("addupyeardepre year_depreciation");
        selFields.add("monthdeprechg depre_adjust");
        selFields.add("originalval original_value_end_1");
        selFields.add("accumdepre accumulated_depre_end_1");
        selFields.add("networth net_value_end");
        selFields.add("decval depre_reserves_end");
        selFields.add("netamount net_amount_end");
        selFields.add("realcard.masterid masterid");
        selFields.add("period accountperiod");
        selFields.add("bizperiod bizperiod");
        selFields.add("clearperiod clearperiod");
        selFields.add("endperiod endperiod");
        selFields.add("bizperiod.periodyear year");
        return selFields;
    }

    private DataSet getRootCategorys() {
        HashMap<Long, LinkedList<Long>> rootLeafs = new HashMap<Long, LinkedList<Long>>(12);
        Map categroysMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetcategory", (String)"id,parent", null);
        DynamicObject[] categroys = categroysMap.values().toArray(new DynamicObject[0]);
        HashMap<Long, Long> tempMap = new HashMap<Long, Long>(20);
        int length = categroys.length;
        for (int i = 0; i < length; ++i) {
            Long id = categroys[i].getLong("id");
            Object parent = categroys[i].getLong("parent.id");
            if (parent == null || (Long)parent == 0L) {
                parent = null;
            }
            tempMap.put(id, (Long)parent);
        }
        Field[] fields = new Field[]{new Field("astid", (DataType)DataType.LongType), new Field("rootastid", (DataType)DataType.LongType)};
        DataSetBuilder builder = Algo.create((String)"fi.fa.FadeprecationQuery").createDataSetBuilder(new RowMeta(fields));
        for (Map.Entry entry : tempMap.entrySet()) {
            Long key = (Long)entry.getKey();
            Long value = (Long)entry.getValue();
            Object[] row = new Object[2];
            row[0] = key;
            if (value == null) {
                row[1] = key;
                LinkedList<Long> tempList = (LinkedList<Long>)rootLeafs.get(key);
                if (tempList != null) {
                    tempList.add(key);
                } else {
                    tempList = new LinkedList<Long>();
                    tempList.add(key);
                    rootLeafs.put(key, tempList);
                }
            } else {
                Long rootid = this.getRootCategory(key, tempMap);
                row[1] = rootid;
                LinkedList<Long> tempList = (LinkedList<Long>)rootLeafs.get(rootid);
                if (tempList != null) {
                    tempList.add(key);
                } else {
                    tempList = new LinkedList<Long>();
                    tempList.add(key);
                    rootLeafs.put(rootid, tempList);
                }
            }
            builder.append(row);
        }
        DataSet astDataSet = builder.build();
        return astDataSet;
    }

    private DataSet getCurrentBatchSum(DataSet querySet, String groupByFlag) {
        String name;
        GroupbyDataSet groupDataSet;
        DataSet curBatchDataSet = querySet.copy();
        List<String> allAmountList = this.getAmountFields("all");
        if ("orgPeriod".equals(groupByFlag)) {
            groupDataSet = curBatchDataSet.groupBy(new String[]{"org", "orgname", "period", "basecurrency"});
            name = SumFlagEnum.SUBTOTAL_PERIOD.name();
        } else if ("org".equals(groupByFlag)) {
            groupDataSet = curBatchDataSet.groupBy(new String[]{"org", "orgname", "basecurrency"});
            name = SumFlagEnum.SUBTOTAL_ORG.name();
        } else if ("total".equals(groupByFlag)) {
            groupDataSet = curBatchDataSet.groupBy(new String[]{"basecurrency"});
            name = SumFlagEnum.TOTAL.name();
        } else {
            groupDataSet = curBatchDataSet.groupBy(new String[]{"basecurrency"});
            name = "''";
        }
        name = "'" + name + "'";
        for (String field : allAmountList) {
            groupDataSet.sum(field);
        }
        DataSet sumDataSet = groupDataSet.finish();
        sumDataSet = sumDataSet.addField(SumFlagEnum.TOTAL.getIndex() + "", "summarytype");
        List<String> dataSetFields = this.getFieldsByDataSet(sumDataSet);
        ArrayList<String> allList = new ArrayList<String>(Arrays.asList(curBatchDataSet.getRowMeta().getFieldNames()));
        if ("orgPeriod".equals(groupByFlag)) {
            dataSetFields.add("basecurrency");
            dataSetFields.add("orgname");
            dataSetFields.add("period");
        }
        if ("org".equals(groupByFlag)) {
            dataSetFields.add("basecurrency");
            dataSetFields.add("orgname");
        }
        if ("total".equals(groupByFlag)) {
            dataSetFields.add("basecurrency");
        }
        allList.removeAll(dataSetFields);
        for (String field : allList) {
            if ("number".equals(field)) {
                sumDataSet = sumDataSet.addField(name, field);
                continue;
            }
            sumDataSet = sumDataSet.addNullField(field);
        }
        sumDataSet = sumDataSet.select(curBatchDataSet.getRowMeta().getFieldNames());
        return sumDataSet;
    }

    private DataSet mergeDataSet(Row batchSumRow, String cacheDataSetId, String groupByFlag) {
        CachedDataSet lastCacheDataSet = Algo.getCacheDataSet((String)cacheDataSetId);
        List rowList = lastCacheDataSet.getList(0, lastCacheDataSet.getRowCount());
        DataSetBuilder sumDataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(lastCacheDataSet.getRowMeta());
        if (batchSumRow != null) {
            sumDataSetBuilder.append(batchSumRow);
        }
        rowList.forEach(arg_0 -> ((DataSetBuilder)sumDataSetBuilder).append(arg_0));
        DataSet build = sumDataSetBuilder.build();
        return this.getCurrentBatchSum(build, groupByFlag);
    }

    private List<String> getAmountFields(String type) {
        ArrayList<String> list = new ArrayList<String>();
        if ("begin".equals(type) || "all".equals(type)) {
            list.add("original_value_begin");
            list.add("accumulated_depre_begin");
            list.add("net_value_begin");
            list.add("depre_reserves_begin");
            list.add("net_amount_begin");
        }
        if ("curperiod".equals(type) || "all".equals(type)) {
            list.add("original_adjust");
            list.add("accumulated_depre_adjust");
            list.add("depre_adjust");
            list.add("actual_depreciation");
        }
        if ("end".equals(type) || "all".equals(type)) {
            list.add("year_depreciation");
            list.add("original_value_end");
            list.add("accumulated_depre_end");
            list.add("net_value_end");
            list.add("depre_reserves_end");
            list.add("net_amount_end");
        }
        return list;
    }

    private void replaceFilterProperty(QFilter filter) {
        List nests;
        String property = filter.getProperty();
        if ("realcard.number".equals(property)) {
            filter.__setProperty("b.fnumber");
            if (filter.getValue() instanceof QEmptyValue) {
                filter.__setValue((Object)"");
            }
        } else if ("assetcat.number".equals(property)) {
            filter.__setProperty("c.fnumber");
            if (filter.getValue() instanceof QEmptyValue) {
                filter.__setValue((Object)"");
            }
        } else if ("assetcat".equals(property)) {
            if (filter.getValue() instanceof QEmptyValue) {
                filter.__setProperty("c.fid");
                filter.__setCP("=");
                filter.__setValue((Object)-1);
            }
        } else if ("realcard".equals(property)) {
            if (filter.getValue() instanceof QEmptyValue) {
                filter.__setProperty("b.fid");
                filter.__setCP("=");
                filter.__setValue((Object)-1);
            }
        } else if ("assetcat.applytype".equals(property)) {
            filter.__setProperty("c.fapplytype");
            if (filter.getValue() instanceof QEmptyValue) {
                filter.__setValue((Object)"");
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8fc7\u6ee4\u5b57\u6bb5\uff1a%s\u3002", (String)"DepreciationRptQueryServiceImpl_1", (String)"fi-fa-business", (Object[])new Object[0]), property));
        }
        if ((nests = filter.getNests(false)).size() == 0) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            this.replaceFilterProperty(nest.getFilter());
        }
    }

    private Long getRootCategory(Long nowid, Map<Long, Long> tempMap) {
        Long parent = tempMap.get(nowid);
        if (parent != null) {
            return this.getRootCategory(parent, tempMap);
        }
        return nowid;
    }

    private String getOrgIds() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object string : this.orgIds) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public int getYearByPeriodId(long periodId) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodyear", (QFilter[])new QFilter[]{filter});
        if (periodDyn != null) {
            return periodDyn.getInt("periodyear");
        }
        return 0;
    }

    private static Map<String, Map<String, BigDecimal>> getDepAdjustData(ReportQueryParam param) {
        HashMap<String, Map<String, BigDecimal>> processData = new HashMap<String, Map<String, BigDecimal>>(16);
        FilterInfo filterInfo = param.getFilter();
        Long depUseId = filterInfo.getLong("depreuse");
        Long startPeriodId = filterInfo.getLong("period_start");
        Long endPeriodId = filterInfo.getLong("period_end");
        DynamicObjectCollection orgColl = filterInfo.getDynamicObjectCollection("q_org");
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgColl) {
            orgIds.add(org.getPkValue());
        }
        String queryField = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"}), Fa.dot((String[])new String[]{"entryentity", "bfrdepreamount"}), Fa.dot((String[])new String[]{"entryentity", "aftdepreamount"}), "period"});
        Map queryDepAdjust = BusinessDataServiceHelper.loadFromCache((String)"fa_depreadjustbill", (String)queryField, (QFilter[])new QFilter[]{new QFilter("depreuse", "=", (Object)depUseId), new QFilter("period", ">=", (Object)startPeriodId), new QFilter("period", "<=", (Object)endPeriodId), new QFilter("org", "in", orgIds)});
        for (Map.Entry depAdjust : queryDepAdjust.entrySet()) {
            DynamicObject depAdjustBill = (DynamicObject)depAdjust.getValue();
            long periodId = depAdjustBill.getDynamicObject("period").getLong("id");
            DynamicObjectCollection entryEntity = depAdjustBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                long realCardId = entry.getDynamicObject("realcard").getLong("id");
                BigDecimal bfrDepAmount = entry.getBigDecimal("bfrdepreamount");
                BigDecimal aftDepAmount = entry.getBigDecimal("aftdepreamount");
                HashMap<String, BigDecimal> depData = new HashMap<String, BigDecimal>(2);
                depData.put("bef_adjust_depreciation", bfrDepAmount);
                depData.put("aft_adjust_depreciation", aftDepAmount);
                processData.put(periodId + "_" + realCardId, depData);
            }
        }
        return processData;
    }

    private List<String> getFieldsByDataSet(DataSet dataSet) {
        Field[] fields;
        ArrayList<String> selFields = new ArrayList<String>(12);
        if (dataSet == null) {
            return selFields;
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            selFields.add(field.getAlias());
        }
        return selFields;
    }

    private String getCacheKeyPrefix() {
        return "fi.fa." + this.getClass().getName() + "." + this.pageId;
    }

    private void removeCache(String cacheKey) {
        if (this.batchQuery) {
            this.appCache.remove(cacheKey);
        } else {
            this.localCache.remove(cacheKey);
        }
    }

    private void putCacheData(String cacheKey, Object value) {
        if (this.batchQuery) {
            this.appCache.put(cacheKey, value);
        } else {
            this.localCache.put(cacheKey, value);
        }
    }

    private <T> T getFromCache(String cacheKey, Class<T> clazz) {
        if (this.batchQuery) {
            return (T)this.appCache.get(cacheKey, clazz);
        }
        return (T)this.localCache.get(cacheKey);
    }

    public void setFromQingAnaly(boolean fromQingAnaly) {
        this.fromQingAnaly = fromQingAnaly;
    }
}

