/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.FaUpgradeMasterIdBillTypeEnum;
import kd.fi.fa.business.service.api.FaBillUpdateCardMasterIdUpgradeService;

public class FaBillUpdateCardMasterIdUpgradeServiceImpl
implements FaBillUpdateCardMasterIdUpgradeService {
    private static Log log = LogFactory.getLog(FaBillUpdateCardMasterIdUpgradeServiceImpl.class);
    public static final int THREAD_SIZE = Integer.parseInt(System.getProperty("prop.fi.fa.depre.threadcount", "3"));
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"kd.fi.fa.business.service.FaBillUpdateCardMasterIdUpgradeServiceImpl", (int)THREAD_SIZE);
    private static final int MAX_SIZE_ONE_THREAD = 5000;
    private static final int ERROR_MSG_LENGTH_LIMIT = 50;
    private AtomicInteger finishThreadCount = new AtomicInteger(0);
    private Long logId = null;
    private int totalSize = 0;
    UpgradeResult result = new UpgradeResult();
    private FaUpgradeMasterIdBillTypeEnum billTypeEnum;
    private Date startTime = new Date();

    public FaBillUpdateCardMasterIdUpgradeServiceImpl(FaUpgradeMasterIdBillTypeEnum billTypeEnum) {
        this.billTypeEnum = billTypeEnum;
    }

    @Override
    public void executeUpgradeService() {
        log.info("startTime is [{}]; THREAD_SIZE is [{}]", (Object)this.startTime, (Object)THREAD_SIZE);
        if (null == this.billTypeEnum) {
            return;
        }
        try {
            this.queryAndUpgrade();
        }
        catch (Exception e) {
            log.error("executeUpgradeService\u5f02\u5e38\uff1a", (Throwable)e);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    if (this.logId == null) {
                        this.insertLog(this.totalSize, e);
                    } else {
                        this.updateLog(this.logId, new UpgradeResult());
                    }
                    tx.commit();
                }
                catch (Throwable e1) {
                    tx.markRollback();
                    log.error("updateMasterId4Bill\u8bb0\u5f55\u5f02\u5e38\u65e5\u5fd7\u5b58\u5728\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", e1);
                    throw e1;
                }
            }
            throw e;
        }
        log.info("executeUpgradeService is end, endTime is [{}]", (Object)new Date());
    }

    private void queryAndUpgrade() {
        String tableName = this.billTypeEnum.getTableName();
        log.info("\u6b63\u5728\u5bf9\u8868[{}]\u8fdb\u884cfrealcardmasterid\u7684\u5347\u7ea7\uff01", (Object)tableName);
        String sql = "select frealcardid as realCardId from " + tableName + " where frealcardmasterid = 0;";
        this.setTotalSize(sql);
        this.logId = this.insertLog(this.totalSize, null);
        if (this.totalSize == 0) {
            this.updateLog(this.logId, new UpgradeResult());
            log.info("\u8868[{}]\u4e0d\u5b58\u5728frealcardmasterid=0\u7684\u6570\u636e\uff0c\u65e0\u9700\u5347\u7ea7\uff01", (Object)tableName);
            return;
        }
        try (DataSet dataSet = DB.queryDataSet((String)"FaBillUpdateCardMasterIdUpgradeServiceImpl.queryAndUpgrade", (DBRoute)DBRoute.of((String)"fa"), (String)sql).distinct();){
            HashSet<Long> realCardSet = new HashSet<Long>(5000);
            int i = 0;
            int batchCount = 0;
            Iterator it = dataSet.iterator();
            while (it.hasNext()) {
                if (i == 5000) {
                    ++batchCount;
                    UpgradeMasterIdData upgradeData = new UpgradeMasterIdData(realCardSet);
                    UpgradeThread thread = new UpgradeThread(upgradeData, this);
                    threadPool.executeIncludeRequestContext((Runnable)thread);
                    realCardSet = new HashSet(5000);
                    i = 0;
                    continue;
                }
                Row row = (Row)it.next();
                realCardSet.add(row.getLong("realCardId"));
                ++i;
            }
            if (CollectionUtils.isNotEmpty(realCardSet)) {
                log.info("batchCount is [{}]; \u5206\u6279\u4e4b\u540e\u5269\u4f59realCardSet size is [{}]", (Object)(++batchCount), (Object)realCardSet.size());
                UpgradeMasterIdData upgradeData = new UpgradeMasterIdData(realCardSet);
                UpgradeThread thread = new UpgradeThread(upgradeData, this);
                threadPool.executeIncludeRequestContext((Runnable)thread);
            }
            while (batchCount != this.finishThreadCount.get()) {
            }
            this.updateLog(this.logId, this.result);
        }
    }

    private void setTotalSize(String sql) {
        long startTime = System.currentTimeMillis();
        try (DataSet dataSet = DB.queryDataSet((String)"FaBillUpdateCardMasterIdUpgradeServiceImpl.getTotalSize", (DBRoute)DBRoute.of((String)"fa"), (String)sql);){
            this.totalSize = dataSet.count("realCardId", false);
        }
        log.info("setTotalSize cost [{}] ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<Long, Long> getRealCardIdMasterIdMap(List<Object> realCardIds) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>();
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid,fmasterid from t_fa_card_real where ", new Object[0]);
        builder.appendIn("fid", realCardIds);
        try (DataSet dataSet = DB.queryDataSet((String)"FaBillUpdateCardMasterIdUpgradeServiceImpl.getRealCardIdMasterIdMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)builder);){
            for (Row row : dataSet) {
                Long masterId = row.getLong("fmasterid");
                if (masterId == null || masterId.intValue() == 0) {
                    masterId = row.getLong("fid");
                }
                resultMap.put(row.getLong("fid"), masterId);
            }
        }
        return resultMap;
    }

    private int updateByDB(List<Object[]> params) {
        int curBatchAlreadyCount = 0;
        String tableName = this.billTypeEnum.getTableName();
        try (TXHandle tx = TX.requiresNew();){
            try {
                String updateSql = "update " + tableName + " set frealcardmasterid = ? where frealcardid = ?;";
                int[] results = DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, params);
                if (results.length > 0) {
                    for (int count : results) {
                        curBatchAlreadyCount += count;
                    }
                }
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        return curBatchAlreadyCount;
    }

    private Long insertLog(int size, Exception e) {
        BizStatusEnum bizStatusEnum = BizStatusEnum.UNDERWAY;
        Date endTime = null;
        Long cost = 0L;
        String errorMsg = "";
        String errorMsgTag = "";
        if (e != null) {
            String clsName;
            bizStatusEnum = BizStatusEnum.INTERRUPT;
            endTime = new Date();
            cost = (endTime.getTime() - this.startTime.getTime()) / 1000L;
            errorMsg = clsName.substring(0, (clsName = e.getClass().getName()).length() > 50 ? 50 : clsName.length());
            errorMsgTag = e.getMessage();
        }
        long[] ids = DBServiceHelper.genLongIds((String)"t_fa_masterid_upgrade_log", (int)1);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("INSERT INTO t_fa_masterid_upgrade_log ", new Object[0]);
        sqlBuilder.append("(fid, fbilltype, fcost, ftotal, fbizstatus, fstarttime, fendtime, ferrormsg, ferrormsg_tag, falready) ", new Object[0]);
        sqlBuilder.append("VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?);", new Object[]{ids[0], this.billTypeEnum.getEntityName(), cost, size, bizStatusEnum.name(), this.startTime, endTime, errorMsg, errorMsgTag, 0});
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            boolean insertResult = DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
            tx.commit();
            if (insertResult) {
                Long l = ids[0];
                return l;
            }
            Long l = null;
            return l;
        }
        catch (Throwable e1) {
            try {
                tx.markRollback();
                throw e1;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void updateLog(Long fid, UpgradeResult result) {
        if (null == fid) {
            return;
        }
        Date endTime = result.getEndTime();
        int alreadyCount = result.getAlreadyCount();
        List<Throwable> errorList = result.getErrorList();
        BizStatusEnum bizStatusEnum = BizStatusEnum.SUCCESS;
        Long cost = (endTime.getTime() - this.startTime.getTime()) / 1000L;
        String errorMsg = "";
        String errorMsgTag = "";
        if (CollectionUtils.isNotEmpty(errorList)) {
            bizStatusEnum = BizStatusEnum.INTERRUPT;
            errorMsg = errorMsgTag.substring(0, (errorMsgTag = errorList.stream().map(Throwable::getMessage).collect(Collectors.joining(";"))).length() > 50 ? 50 : errorMsgTag.length());
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE t_fa_masterid_upgrade_log SET ", new Object[0]).append("fendtime = ?,", new Object[]{endTime}).append("fcost = ?,", new Object[]{cost}).append("falready = ?,", new Object[]{alreadyCount}).append("fbizstatus = ?,", new Object[]{bizStatusEnum.name()}).append("ferrormsg = ?,", new Object[]{errorMsg}).append("ferrormsg_tag = ? ", new Object[]{errorMsgTag}).append("WHERE fid = ?;", new Object[]{fid});
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
                tx.commit();
            }
            catch (Throwable e1) {
                tx.markRollback();
                throw e1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOneBatch(UpgradeMasterIdData data, UpgradeResult result) {
        int curBatchAlreadyCount = 0;
        try {
            List<Object> realCardIdList = Arrays.asList(data.getRealCardIdSet().toArray());
            Map<Long, Long> realCardIdMasterIdMap = this.getRealCardIdMasterIdMap(realCardIdList);
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Object realId : realCardIdList) {
                Long masterId = realCardIdMasterIdMap.get(realId);
                if (masterId == null || masterId.intValue() == 0) {
                    masterId = (Long)realId;
                }
                params.add(new Object[]{masterId, realId});
            }
            curBatchAlreadyCount = this.updateByDB(params);
            UpgradeResult upgradeResult = result;
            synchronized (upgradeResult) {
                result.setEndTime(new Date());
                result.addAlreadyCount(curBatchAlreadyCount);
            }
        }
        catch (Exception e) {
            log.error("doOneBatch\u5f02\u5e38\uff1a", (Throwable)e);
            UpgradeResult upgradeResult = result;
            synchronized (upgradeResult) {
                result.setEndTime(new Date());
                result.addErrorList(e);
            }
        }
    }

    public void threadCountIncrement() {
        this.finishThreadCount.getAndIncrement();
    }

    class UpgradeThread
    implements Runnable {
        private final UpgradeMasterIdData data;
        private final FaBillUpdateCardMasterIdUpgradeServiceImpl serviceImpl;

        public UpgradeThread(UpgradeMasterIdData data, FaBillUpdateCardMasterIdUpgradeServiceImpl serviceImpl) {
            this.data = data;
            this.serviceImpl = serviceImpl;
        }

        @Override
        public void run() {
            try {
                FaBillUpdateCardMasterIdUpgradeServiceImpl.this.doOneBatch(this.data, this.serviceImpl.result);
            }
            finally {
                this.serviceImpl.threadCountIncrement();
            }
        }
    }

    static class UpgradeResult {
        private Date endTime = new Date();
        private List<Throwable> errorList = new ArrayList<Throwable>();
        private int alreadyCount = 0;

        public Date getEndTime() {
            return this.endTime;
        }

        public List<Throwable> getErrorList() {
            return this.errorList;
        }

        public int getAlreadyCount() {
            return this.alreadyCount;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public void addErrorList(Throwable error) {
            this.errorList.add(error);
        }

        public void addAlreadyCount(int alreadyCount) {
            this.alreadyCount += alreadyCount;
        }
    }

    static class UpgradeMasterIdData {
        private final Set<Long> realCardIdSet;

        public UpgradeMasterIdData(Set<Long> realCardIdSet) {
            this.realCardIdSet = realCardIdSet;
        }

        public Set<Long> getRealCardIdSet() {
            return this.realCardIdSet;
        }
    }

    private static enum BizStatusEnum {
        SUCCESS,
        INTERRUPT,
        UNDERWAY;

    }
}

