/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.po.FaAssetBookDataUpgradeLogPo;
import kd.fi.fa.business.utils.AttachmentUtils;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class FaOriginalDataUpgradeService
implements Runnable {
    private static Log log = LogFactory.getLog(FaOriginalDataUpgradeService.class);
    private static FaOriginalDataUpgradeService instance;
    private static final String KEY_CONNECTOR = "_";
    public static final int THREAD_SIZE;
    private static final ThreadPool threadPool;
    private static final String PREFIX_TABLE = "t_";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final int MAX_SIZE_ONE_THREAD = 5000;
    private AtomicInteger finishThreadCount = new AtomicInteger(0);
    private static List<Throwable> errorList;
    private int realCardSize = 0;
    private int finCardSize = 0;
    private static Set<String> finCardFields;
    private static final String DBLOCK_INSERT_SQL = "insert into t_fa_billparam (fid, fparam, fvalue) values (100000, 'original.upgrade.lock', 'true');";
    private static final String DBLOCK_DELETE_SQL = "delete from t_fa_billparam where fid = 100000;";

    public static synchronized FaOriginalDataUpgradeService getInstance() {
        if (instance == null) {
            instance = new FaOriginalDataUpgradeService();
        }
        return instance;
    }

    private FaOriginalDataUpgradeService() {
    }

    @Override
    public void run() {
        try {
            if (this.upgradeLocked()) {
                log.info("\u6570\u636e\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002");
                return;
            }
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)DBLOCK_INSERT_SQL);
            this.executeUpgrade();
        }
        catch (Exception e) {
            log.error("FaOriginalDataUpgradeService error is :", (Throwable)e);
        }
        finally {
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)DBLOCK_DELETE_SQL);
        }
    }

    public boolean upgradeLocked() {
        return QueryServiceHelper.exists((String)"fa_billparam", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)100000L)});
    }

    private void executeUpgrade() {
        long startTime = System.currentTimeMillis();
        this.initFinCardFields();
        List<UnSuccessOrgDTO> orgList = this.findUnUpgradeOrgs();
        int orgSize = 0;
        for (UnSuccessOrgDTO unSuccessOrg : orgList) {
            Long logId = unSuccessOrg.getLogId();
            try {
                DynamicObject orgObj = unSuccessOrg.getOrgObj();
                Long orgId = orgObj.getLong("id");
                if (logId == null) {
                    FaAssetBookDataUpgradeLogPo insertLog = new FaAssetBookDataUpgradeLogPo(orgId, 0L, ResManager.loadKDString((String)"\u5361\u7247\u539f\u59cb\u6570\u636e\u5347\u7ea7", (String)"FaOriginalDataUpgradeServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
                    logId = FaAssetBookDataUpgradeLogUtils.insertLog(insertLog, false);
                    unSuccessOrg.setLogId(logId);
                }
                FunctionMutexHelper.lockWithOrg(orgId, () -> {
                    try (TXHandle tx = TX.requiresNew();){
                        this.upgradeByOrg(unSuccessOrg);
                        tx.commit();
                    }
                });
                ++orgSize;
            }
            catch (Exception e) {
                log.error("executeUpgrade: \u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
                if (logId == null) continue;
                FaAssetBookDataUpgradeLogUtils.updateLog(logId, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.ERROR, e.getMessage());
            }
        }
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_fa_billparam");
        cacheManager.removeByDt();
        log.info("FaOriginalDataUpgradeServiceImpl.executeUpgrade, \u7ec4\u7ec7\u6570\uff1a[{}], \u5b9e\u7269\u5361\u7247\u6570[{}], \u8d22\u52a1\u5361\u7247\u6570[{}], \u6267\u884c\u8017\u65f6[{}]ms", new Object[]{orgSize, this.realCardSize, this.finCardSize, System.currentTimeMillis() - startTime});
    }

    private void initFinCardFields() {
        MainEntityType finEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        Map finPropertyMap = finEntityType.getAllFields();
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : finPropertyMap.values()) {
            String proName = pro.getName();
            parent = pro.getParent();
            if (!(parent instanceof MainEntityType)) continue;
            finCardFields.add(proName);
        }
    }

    private List<UnSuccessOrgDTO> findUnUpgradeOrgs() {
        long startTime = System.currentTimeMillis();
        ArrayList<String> queryFields = new ArrayList<String>(2);
        queryFields.add("id");
        queryFields.add("org");
        queryFields.add("status");
        DynamicObjectCollection logObjs = FaAssetBookDataUpgradeLogUtils.queryByPurpose(ResManager.loadKDString((String)"\u5361\u7247\u539f\u59cb\u6570\u636e\u5347\u7ea7", (String)"FaOriginalDataUpgradeServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), queryFields);
        HashSet<DynamicObject[]> successOrgIds = new HashSet<DynamicObject[]>(16);
        HashMap<DynamicObject[], Long> failedLogMap = new HashMap<DynamicObject[], Long>();
        if (CollectionUtils.isNotEmpty((Collection)logObjs)) {
            for (DynamicObject logObj : logObjs) {
                DynamicObject[] orgId = Long.valueOf(logObj.getLong("org"));
                Long logId = logObj.getLong("id");
                String status = logObj.getString("status");
                if (FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.SUCCESS.name().equals(status)) {
                    successOrgIds.add(orgId);
                    continue;
                }
                failedLogMap.put(orgId, logId);
            }
        }
        DynamicObject[] assetBookArray = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "org"}), (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        HashSet<DynamicObject> allOrgSet = new HashSet<DynamicObject>(assetBookArray.length);
        for (DynamicObject assetBook : assetBookArray) {
            DynamicObject org = assetBook.getDynamicObject("org");
            if (org == null) continue;
            allOrgSet.add(assetBook.getDynamicObject("org"));
        }
        ArrayList<UnSuccessOrgDTO> unSuccessOrgList = new ArrayList<UnSuccessOrgDTO>(16);
        int needUpgradeOrgSize = 0;
        for (DynamicObject orgObj : allOrgSet) {
            Long orgId = orgObj.getLong("id");
            Long failedLogId = (Long)failedLogMap.get(orgId);
            if (CollectionUtils.isNotEmpty(successOrgIds) && successOrgIds.contains(orgId)) continue;
            ++needUpgradeOrgSize;
            unSuccessOrgList.add(new UnSuccessOrgDTO(orgObj, failedLogId));
        }
        log.info("FaOriginalDataUpgradeServiceImpl.findUnUpgradeOrgs\uff08\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u7684\u7ec4\u7ec7\uff09\u6267\u884c\u5b8c\u6bd5, \u8d26\u7c3f\u8868\u7ec4\u7ec7\u603b\u6570[{}], \u9700\u8981\u5347\u7ea7\u7684\u7ec4\u7ec7\u6570[{}], \u8017\u65f6[{}]ms", new Object[]{allOrgSet.size(), needUpgradeOrgSize, System.currentTimeMillis() - startTime});
        return unSuccessOrgList;
    }

    private void upgradeByOrg(UnSuccessOrgDTO orgDTO) {
        Long orgId;
        long startTime;
        block8: {
            startTime = System.currentTimeMillis();
            DynamicObject org = orgDTO.getOrgObj();
            orgId = org.getLong("id");
            Long logId = orgDTO.getLogId();
            try {
                errorList = new ArrayList<Throwable>(16);
                this.upgradeRealCards(orgId);
                if (CollectionUtils.isEmpty(errorList)) {
                    this.upgradeFinCards(orgDTO);
                    if (CollectionUtils.isEmpty(errorList)) {
                        FaAssetBookDataUpgradeLogUtils.updateLog(logId, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.SUCCESS, " ");
                        SqlBuilder sqlBuilder = new SqlBuilder();
                        sqlBuilder.append("update t_fa_billparam set fvalue = 'true' where fparam = 'split.currentperiod.enable' and forgid = ?;", new Object[]{orgId});
                        DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
                        log.info("upgradeByOrg: \u66f4\u65b0\u7ec4\u7ec7[{}]\u7684\u4e1a\u52a1\u53c2\u6570[split.currentperiod.enable]\u4e3atrue\u3002", (Object)orgId);
                    } else {
                        for (Throwable e : errorList) {
                            log.error("upgradeByOrg-upgradeFinCards: \u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", e);
                        }
                        String errorMsg = errorList.stream().map(ThrowableHelper::toString).collect(Collectors.joining(";"));
                        FaAssetBookDataUpgradeLogUtils.updateLog(logId, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.ERROR, errorMsg);
                    }
                } else {
                    for (Throwable e : errorList) {
                        log.error("upgradeByOrg-upgradeRealCards: \u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", e);
                    }
                    String errorMsg = errorList.stream().map(ThrowableHelper::toString).collect(Collectors.joining(";"));
                    FaAssetBookDataUpgradeLogUtils.updateLog(logId, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.ERROR, errorMsg);
                }
            }
            catch (Exception e) {
                log.error("upgradeByOrg: \u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
                if (logId == null) break block8;
                FaAssetBookDataUpgradeLogUtils.updateLog(logId, FaAssetBookDataUpgradeLogPo.UpgradeStatusEnum.ERROR, e.getMessage());
            }
        }
        log.info("upgradeByOrg: \u7ec4\u7ec7[{}]\u5347\u7ea7\u5b8c\u6bd5\uff01\u8017\u65f6\uff1a{} ms", (Object)orgId, (Object)(System.currentTimeMillis() - startTime));
    }

    private void upgradeRealCards(Long orgId) {
        this.finishThreadCount = new AtomicInteger(0);
        long startTime = System.currentTimeMillis();
        SqlBuilder realQuerySql = new SqlBuilder();
        realQuerySql.append("select fid,fmasterid from t_fa_card_real where forgid = ? and fisbak = '0' and foriginaldata = '1' and fbillstatus = 'C'", new Object[]{orgId});
        try (DataSet dataSet = DB.queryDataSet((String)"upgradeRealCards", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)realQuerySql);){
            int i = 0;
            int batchCount = 0;
            int orgCardSize = 0;
            ArrayList<Long> batchRealCardIds = new ArrayList<Long>(16);
            Iterator itRow = dataSet.iterator();
            while (itRow.hasNext()) {
                if (i == 5000) {
                    ++batchCount;
                    RealUpgradeThread thread = new RealUpgradeThread(batchRealCardIds);
                    threadPool.executeIncludeRequestContext((Runnable)thread);
                    batchRealCardIds = new ArrayList(5000);
                    i = 0;
                    continue;
                }
                ++orgCardSize;
                Row row = (Row)itRow.next();
                Long realCardId = row.getLong("fid");
                batchRealCardIds.add(realCardId);
                ++i;
            }
            if (CollectionUtils.isNotEmpty(batchRealCardIds)) {
                log.info("batchCount\u4e3a[{}]; \u5206\u6279\u4e4b\u540e\u5269\u4f59batchRealCardIds size\u4e3a[{}]", (Object)(++batchCount), (Object)batchRealCardIds.size());
                RealUpgradeThread thread = new RealUpgradeThread(batchRealCardIds);
                threadPool.executeIncludeRequestContext((Runnable)thread);
            }
            while (batchCount != this.finishThreadCount.get()) {
            }
            this.realCardSize += orgCardSize;
            log.info("\u7ec4\u7ec7[{}]\u4e0b\u5b9e\u7269\u5361\u7247\u539f\u59cb\u6570\u636e\u5907\u4efd\uff08\u591a\u7ebf\u7a0b\uff09\u6267\u884c\u5b8c\u6bd5\uff01 \u672c\u6279\u6b21\u5904\u7406[{}]\u5f20\uff0c\u8017\u65f6\uff1a[{}] ms", new Object[]{orgId, orgCardSize, System.currentTimeMillis() - startTime});
        }
    }

    private void upgradeFinCards(UnSuccessOrgDTO orgDTO) {
        this.finishThreadCount = new AtomicInteger(0);
        long startTime = System.currentTimeMillis();
        DynamicObject orgObj = orgDTO.getOrgObj();
        Long orgId = orgObj.getLong("id");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,frealcardmasterid,foriginaldata,fdepreuseid from t_fa_card_fin where forg = ? and fperiodid = fbizperiodid and fperiodid != 0;", new Object[]{orgId});
        HashMap<String, Long> allSourceFinCardMap = new HashMap<String, Long>(16);
        HashSet<String> hasOriginalFinCards = new HashSet<String>(16);
        int size = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"upgradeFinCards", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);){
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Boolean originalData = row.getBoolean("foriginaldata");
                Long realCardMasterId = row.getLong("frealcardmasterid");
                Long depreuseId = row.getLong("fdepreuseid");
                Long finCardId = row.getLong("fid");
                String cardKey = realCardMasterId + KEY_CONNECTOR + depreuseId;
                if (originalData.booleanValue()) {
                    hasOriginalFinCards.add(cardKey);
                } else {
                    allSourceFinCardMap.put(cardKey, finCardId);
                }
                ++size;
            }
        }
        for (String cardKey : hasOriginalFinCards) {
            allSourceFinCardMap.remove(cardKey);
        }
        log.info("upgradeFinCards: \u7ec4\u7ec7[{}]\u4e0b\u67e5\u8be2\u5230\u65b0\u589e\u5f53\u671f\u8d22\u52a1\u5361\u7247[{}]\u5f20\uff0c\u5176\u4e2d\u6709[{}]\u5f20\u8d22\u52a1\u5361\u7247\u5347\u7ea7\u8fc7\u539f\u59cb\u6570\u636e\uff0c\u5df2\u7ecf\u53bb\u5904\u8be5\u90e8\u5206\u6570\u636e\u3002", new Object[]{orgId, size - hasOriginalFinCards.size(), hasOriginalFinCards.size()});
        if (allSourceFinCardMap.isEmpty()) {
            return;
        }
        ArrayList<Long> batchFincardIds = new ArrayList<Long>(5000);
        int i = 0;
        int batchCount = 0;
        Iterator it = allSourceFinCardMap.values().iterator();
        while (it.hasNext()) {
            if (i == 5000) {
                ++batchCount;
                FinUpgradeThread thread = new FinUpgradeThread(batchFincardIds);
                threadPool.executeIncludeRequestContext((Runnable)thread);
                batchFincardIds = new ArrayList(5000);
                i = 0;
                continue;
            }
            Long finCardId = (Long)it.next();
            batchFincardIds.add(finCardId);
            ++i;
        }
        if (CollectionUtils.isNotEmpty(batchFincardIds)) {
            log.info("batchCount\u4e3a[{}]; \u5206\u6279\u4e4b\u540e\u5269\u4f59batchFincardIds size\u4e3a[{}]", (Object)(++batchCount), (Object)batchFincardIds.size());
            FinUpgradeThread thread = new FinUpgradeThread(batchFincardIds);
            threadPool.executeIncludeRequestContext((Runnable)thread);
        }
        while (batchCount != this.finishThreadCount.get()) {
        }
        this.finCardSize += allSourceFinCardMap.size();
        log.info("\u7ec4\u7ec7[{}]\u4e0b\u8d22\u52a1\u5361\u7247\u539f\u59cb\u6570\u636e\u5907\u4efd\uff08\u591a\u7ebf\u7a0b\uff09\u6267\u884c\u5b8c\u6bd5\uff01 \u672c\u6279\u6b21\u5904\u7406[{}]\u5f20\uff0c\u8017\u65f6\uff1a[{}] ms", new Object[]{orgId, allSourceFinCardMap.size(), System.currentTimeMillis() - startTime});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchUpgradeFinCard(List<Long> finCardIds) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map<Long, Long> idRelationMap = this.createOriginalData(finCardIds);
                this.updateVoucherFinCardId(idRelationMap);
                this.updateAssetFinCardEntry(idRelationMap);
                this.copyFinAttachments(idRelationMap);
                tx.commit();
            }
            catch (Exception e) {
                log.error("batchUpgradeFinCard error is : ", (Throwable)e);
                List<Throwable> list = errorList;
                synchronized (list) {
                    errorList.add(e);
                }
                tx.markRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchUpgradeRealCard(List<Long> realCardIds) {
        try (TXHandle tx = TX.requiresNew();){
            log.info("batchUpgradeRealCard doing! size : {}", (Object)realCardIds.size());
            try {
                DynamicObject[] realCards;
                SqlBuilder updateSql = new SqlBuilder();
                updateSql.append("update t_fa_card_real set foriginaldata = '0' where ", new Object[0]);
                updateSql.appendIn(" fmasterid ", realCardIds.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateSql);
                log.info("batchUpgradeRealCard update t_fa_card_real foriginaldata done! ");
                ArrayList<DynamicObject> originalRealCards = new ArrayList<DynamicObject>(realCardIds.size());
                for (DynamicObject realCard : realCards = BusinessDataServiceHelper.load((Object[])realCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_real"))) {
                    DynamicObject originalRealCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)realCard);
                    originalRealCard.set("isbak", (Object)Boolean.TRUE);
                    originalRealCard.set("originaldata", (Object)Boolean.TRUE);
                    originalRealCards.add(originalRealCard);
                }
                SaveServiceHelper.save((DynamicObject[])originalRealCards.toArray(new DynamicObject[0]));
                this.copyRealAttachments(originalRealCards);
                log.info("batchUpgradeRealCard save realcards done! size : {}", (Object)originalRealCards.size());
            }
            catch (Exception e) {
                log.error("batchUpgradeRealCard error is : ", (Throwable)e);
                List<Throwable> list = errorList;
                synchronized (list) {
                    errorList.add(e);
                }
                tx.markRollback();
            }
        }
    }

    private void copyRealAttachments(List<DynamicObject> originalRealCards) {
        HashMap<Object, List<Object>> sourceId2TargetIdMap = new HashMap<Object, List<Object>>(originalRealCards.size());
        for (DynamicObject realCard : originalRealCards) {
            Long masterId = realCard.getLong("masterid");
            ArrayList<Long> targetIds = new ArrayList<Long>(1);
            targetIds.add(realCard.getLong("id"));
            sourceId2TargetIdMap.put(masterId, targetIds);
        }
        AttachmentUtils.copyAttachments("fa_card_real", "fa_card_real", ATTACHMENT_PANEL, sourceId2TargetIdMap);
    }

    private void copyFinAttachments(Map<Long, Long> finIdOriFinIdMap) {
        HashMap<Object, List<Object>> sourceId2TargetIdMap = new HashMap<Object, List<Object>>(finIdOriFinIdMap.size());
        for (Map.Entry<Long, Long> entry : finIdOriFinIdMap.entrySet()) {
            Long finId = entry.getKey();
            Long oriFinId = entry.getValue();
            ArrayList<Long> targetIds = new ArrayList<Long>(1);
            targetIds.add(oriFinId);
            sourceId2TargetIdMap.put(finId, targetIds);
        }
        if (!sourceId2TargetIdMap.isEmpty()) {
            AttachmentUtils.copyAttachments("fa_card_real", "fa_card_real", ATTACHMENT_PANEL, sourceId2TargetIdMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> createOriginalData(List<Long> finCardIds) {
        DynamicObject[] finCards = BusinessDataServiceHelper.load((Object[])finCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
        ArrayList<Long> auditFinCardIds = new ArrayList<Long>(finCardIds.size());
        HashSet<Long> auditFinRealMasterIds = new HashSet<Long>(finCardIds.size());
        ArrayList<DynamicObject> auditFinCards = new ArrayList<DynamicObject>(16);
        HashSet<Long> unAuditFinCardIds = new HashSet<Long>(16);
        for (DynamicObject finCard : finCards) {
            String billStatus = finCard.getString("billstatus");
            if (BillStatus.C.name().equalsIgnoreCase(billStatus)) {
                auditFinCards.add(finCard);
                auditFinCardIds.add(finCard.getLong("id"));
                auditFinRealMasterIds.add(finCard.getLong("realcardmasterid"));
                continue;
            }
            unAuditFinCardIds.add(finCard.getLong("id"));
        }
        Map<String, Long> realMasterDepreuse2NewestFinIdMap = this.findRealMasterDepreuse2NewestFinIdMap(auditFinRealMasterIds);
        HashMap<Long, Long> idRelationMap = new HashMap<Long, Long>(auditFinCardIds.size());
        if (CollectionUtils.isNotEmpty(auditFinCards)) {
            HashMap<Long, BigDecimal> finCardOriginalValMap = new HashMap<Long, BigDecimal>(auditFinCardIds.size());
            HashMap<Long, Long> originalRealMap = new HashMap<Long, Long>(auditFinCardIds.size());
            CardBizDTO bizDTO = new CardBizDTO(auditFinCardIds.size());
            this.fieldsInfoFromOtherBills(finCardOriginalValMap, originalRealMap, bizDTO, auditFinCardIds, auditFinRealMasterIds);
            Map<Long, List<CardChangeDTO>> finChangeFieldsMap = bizDTO.getFinChangeFieldsMap();
            Map<String, BigDecimal> devalueMap = bizDTO.getDevalueMap();
            HashMap<Long, Map<String, CardChangeDTO>> earliestChangeMap = new HashMap<Long, Map<String, CardChangeDTO>>(finChangeFieldsMap.size());
            for (Map.Entry<Long, List<CardChangeDTO>> changeEntry : finChangeFieldsMap.entrySet()) {
                earliestChangeMap.put(changeEntry.getKey(), this.getEarliestChange(changeEntry.getValue()));
            }
            long[] cardIds = DB.genLongIds((String)"t_fa_card_fin", (int)auditFinCardIds.size());
            int i = 0;
            ArrayList<DynamicObject> originalFinCards = new ArrayList<DynamicObject>(auditFinCardIds.size());
            for (DynamicObject finCard : auditFinCards) {
                Long finCardId = finCard.getLong("id");
                String cardNumber = finCard.getString("number");
                Long periodId = finCard.getLong(Fa.id((String)"period"));
                Long realCardMasterId = finCard.getLong("realcardmasterid");
                Long depreuseId = finCard.getLong(Fa.id((String)"depreuse"));
                DynamicObject assetBook = finCard.getDynamicObject("assetbook");
                if (assetBook == null) {
                    List<Throwable> list = errorList;
                    synchronized (list) {
                        errorList.add(new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247[%s]\u672a\u627e\u5230\u5173\u8054\u7684\u8d26\u7c3f\uff0c\u8bf7\u5148\u4fee\u590d\u6570\u636e\u3002", (String)"FaOriginalDataUpgradeServiceImpl_2", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber)));
                        continue;
                    }
                }
                Long originalRealId = (Long)originalRealMap.get(realCardMasterId);
                if (originalRealId == null || originalRealId == 0L) {
                    List<Throwable> list = errorList;
                    synchronized (list) {
                        errorList.add(new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247[%s]\u672a\u627e\u5230\u5173\u8054\u7684\u539f\u59cb\u5b9e\u7269\u5361\u7247\u3002", (String)"FaOriginalDataUpgradeServiceImpl_1", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber)));
                        continue;
                    }
                }
                Long periodTypeId = assetBook.getDynamicObject("periodtype").getLong("id");
                BigDecimal iOriginalValue = (BigDecimal)finCardOriginalValMap.get(finCardId);
                DynamicObject originalFinCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)finCard);
                originalFinCard.set("id", (Object)cardIds[i]);
                originalFinCard.set("createtime", finCard.get("createtime"));
                originalFinCard.set("bizperiod", finCard.get("period"));
                originalFinCard.set("endperiod", originalFinCard.get("period"));
                if (iOriginalValue != null && new BigDecimal("-1").compareTo(iOriginalValue) != 0) {
                    originalFinCard.set("originalval", (Object)iOriginalValue);
                }
                originalFinCard.set("monthorigvalchg", originalFinCard.get("originalval"));
                originalFinCard.set("yearorigvalchg", originalFinCard.get("originalval"));
                originalFinCard.set("monthdeprechg", (Object)new BigDecimal("0"));
                BigDecimal originalDecval = finCard.getBigDecimal("decval").subtract(finCard.getBigDecimal("monthdeprechg"));
                String devKey = finCardId + KEY_CONNECTOR + periodId;
                BigDecimal billDevalue = devalueMap.get(devKey);
                if (billDevalue != null) {
                    originalDecval = finCard.getBigDecimal("decval").subtract(billDevalue);
                }
                originalFinCard.set("decval", (Object)originalDecval);
                originalFinCard.set("addupyeardepre", (Object)finCard.getBigDecimal("addupyeardepre").subtract(finCard.getBigDecimal("monthdepre")));
                originalFinCard.set("accumdepre", (Object)finCard.getBigDecimal("accumdepre").subtract(finCard.getBigDecimal("monthdepre")));
                originalFinCard.set("depredamount", (Object)finCard.getBigDecimal("depredamount").subtract(finCard.getBigDecimal("addidepreamount")));
                originalFinCard.set("networth", (Object)originalFinCard.getBigDecimal("originalval").subtract(originalFinCard.getBigDecimal("accumdepre")));
                originalFinCard.set("netamount", (Object)originalFinCard.getBigDecimal("networth").subtract(originalDecval));
                originalFinCard.set("isneeddepre", (Object)false);
                originalFinCard.set("monthdepre", (Object)new BigDecimal("0"));
                originalFinCard.set("addidepreamount", (Object)new BigDecimal("0"));
                originalFinCard.set("originaldata", (Object)Boolean.TRUE);
                if (originalFinCard.getDate("modifytime") != null) {
                    originalFinCard.set("modifytime", (Object)new Date());
                }
                originalFinCard.set("realcard", (Object)originalRealId);
                originalFinCard.set(Fa.id((String)"realcard"), (Object)originalRealId);
                Map earliestFieldChangeMap = (Map)earliestChangeMap.get(finCardId);
                if (earliestFieldChangeMap != null && !earliestFieldChangeMap.isEmpty()) {
                    for (Map.Entry fieldChangeEntry : earliestFieldChangeMap.entrySet()) {
                        Date changeTime;
                        DynamicObject changePeriod;
                        String changeField = (String)fieldChangeEntry.getKey();
                        if (!finCardFields.contains(changeField) || (changePeriod = PeriodUtil.getPeriodByDate(changeTime = ((CardChangeDTO)fieldChangeEntry.getValue()).getChangeTime(), "id", periodTypeId)) == null || periodId.longValue() != changePeriod.getLong("id")) continue;
                        originalFinCard.set(changeField, ((CardChangeDTO)fieldChangeEntry.getValue()).getBeforeValue());
                    }
                }
                DynamicObjectCollection billHeads = originalFinCard.getDynamicObjectCollection("billhead_lk");
                billHeads.clear();
                originalFinCards.add(originalFinCard);
                String key = realCardMasterId + KEY_CONNECTOR + depreuseId;
                Long newestFinId = realMasterDepreuse2NewestFinIdMap.get(key);
                if (newestFinId != null) {
                    idRelationMap.put(newestFinId, cardIds[i]);
                }
                ++i;
            }
            FaCardBotpUtil.createBotpRelation(originalFinCards.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])originalFinCards.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(unAuditFinCardIds)) {
            SqlBuilder updateBuilder = new SqlBuilder();
            updateBuilder.append("update t_fa_card_fin set fendperiodid = fperiodid,foriginaldata = '1',fisneeddepre = '0' where ", new Object[0]);
            updateBuilder.appendIn("fid", unAuditFinCardIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateBuilder);
        }
        return idRelationMap;
    }

    private Map<String, Long> findRealMasterDepreuse2NewestFinIdMap(Set<Long> auditFinRealMasterIds) {
        HashMap<String, Long> realMasterDepreuse2NewestFinIdMap = new HashMap<String, Long>(auditFinRealMasterIds.size());
        if (auditFinRealMasterIds.isEmpty()) {
            return realMasterDepreuse2NewestFinIdMap;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fid,frealcardmasterid,fdepreuseid from t_fa_card_fin where fendperiodid = ? and ", new Object[]{99999999999L});
        querySql.appendIn(" frealcardmasterid ", (Object[])auditFinRealMasterIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)"findRealMasterDepreUse2NewestFinIdMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                Long finId = row.getLong("fid");
                Long realMasterid = row.getLong("frealcardmasterid");
                Long depreuseId = row.getLong("fdepreuseid");
                String key = realMasterid + KEY_CONNECTOR + depreuseId;
                realMasterDepreuse2NewestFinIdMap.put(key, finId);
            }
        }
        return realMasterDepreuse2NewestFinIdMap;
    }

    private void fieldsInfoFromOtherBills(Map<Long, BigDecimal> finCardOriginalValMap, Map<Long, Long> originalRealMap, CardBizDTO bizDTO, List<Long> finCardIds, Set<Long> realMasterId) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid,finitoriginalval from t_fa_card_fin_i where ", new Object[0]);
        builder.appendIn("fid", finCardIds.toArray());
        try (DataSet iDataSet = DB.queryDataSet((String)"fieldsInfoFromOtherBills_0", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)builder);){
            for (Row row : iDataSet) {
                finCardOriginalValMap.put(row.getLong("fid"), row.getBigDecimal("finitoriginalval"));
            }
        }
        this.getOriginalRealCardMap(realMasterId, originalRealMap);
        Map<Long, List<CardChangeDTO>> finChangeFieldsMap = bizDTO.getFinChangeFieldsMap();
        Map<String, BigDecimal> devalueMap = bizDTO.getDevalueMap();
        SqlBuilder chgBuilder = new SqlBuilder();
        chgBuilder.append("select chg.fauditdate audittime,chg.fchangedate changetime,entry.ffield field,entry.ffincardid fincardid,entry.fbeforevalue befval from t_fa_changefieldentry entry left join t_fa_changebill chg on chg.fid = entry.fid where chg.fbillstatus = 'C' and ", new Object[0]);
        chgBuilder.appendIn("frealcardmasterid", realMasterId.toArray());
        try (DataSet chgDataSet = DB.queryDataSet((String)"fieldsInfoFromOtherBills_1", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)chgBuilder);){
            for (Row row : chgDataSet) {
                Date auditTime = row.getDate("audittime");
                Date changeTime = row.getDate("changetime");
                String field = row.getString("field");
                Long finCardId = row.getLong("fincardid");
                Object befVal = row.get("befval");
                String[] fieldArray = field.split("\\.");
                if (!fieldArray[0].equals("fa_card_fin")) continue;
                List<CardChangeDTO> finChangeList = finChangeFieldsMap.get(finCardId);
                if (finChangeList == null) {
                    finChangeList = new ArrayList<CardChangeDTO>(8);
                    finChangeFieldsMap.put(finCardId, finChangeList);
                }
                finChangeList.add(new CardChangeDTO(auditTime, changeTime, fieldArray[1], befVal));
            }
        }
        SqlBuilder devalueBuilder = new SqlBuilder();
        devalueBuilder.append("select a.ffincardid fincardid,a.fdecval decval,b.fdevalueperiod devalueperiodid from t_fa_asset_devalue_info a left join t_fa_asset_devalue b on a.fid = b.fid where ", new Object[0]);
        devalueBuilder.appendIn("a.ffincardid", finCardIds.toArray());
        DataSet devalueDataSet = DB.queryDataSet((String)"fieldsInfoFromOtherBills_2", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)devalueBuilder);
        Object object = null;
        try {
            for (Row row : devalueDataSet) {
                Long fincardId = row.getLong("fincardid");
                BigDecimal decval = row.getBigDecimal("decval");
                Long devaluePeriodId = row.getLong("devalueperiodid");
                BigDecimal oldDecval = devalueMap.get(fincardId + KEY_CONNECTOR + devaluePeriodId);
                if (oldDecval != null) {
                    decval = decval.add(oldDecval);
                }
                devalueMap.put(fincardId + KEY_CONNECTOR + devaluePeriodId, decval);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (devalueDataSet != null) {
                if (object != null) {
                    try {
                        devalueDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    devalueDataSet.close();
                }
            }
        }
    }

    private void getOriginalRealCardMap(Set<Long> realMasterId, Map<Long, Long> originalRealMap) {
        SqlBuilder bakBuilder = new SqlBuilder();
        bakBuilder.append("select fid,fmasterid from t_fa_card_real where foriginaldata = '1' and fisbak = '1' and ", new Object[0]);
        bakBuilder.appendIn("fmasterid", realMasterId.toArray());
        try (DataSet bakDataSet = DB.queryDataSet((String)"getOriginalRealCardMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)bakBuilder);){
            for (Row row : bakDataSet) {
                Long realCardId = row.getLong("fid");
                Long masterId = row.getLong("fmasterid");
                originalRealMap.put(masterId, realCardId);
            }
        }
    }

    private Map<String, CardChangeDTO> getEarliestChange(List<CardChangeDTO> changeList) {
        Map<String, CardChangeDTO> minByAuditTime = changeList.stream().collect(Collectors.groupingBy(CardChangeDTO::getField, Collectors.minBy(CardChangeDTO::compareByAuditTime))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElse(null)));
        return minByAuditTime;
    }

    private void updateVoucherFinCardId(Map<Long, Long> idRelationMap) {
        if (idRelationMap == null || idRelationMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(idRelationMap.size());
        for (Map.Entry<Long, Long> relationEntry : idRelationMap.entrySet()) {
            params.add(new Object[]{relationEntry.getValue(), relationEntry.getKey()});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_ai_daptracker set fsourcebillid = ? where fsourcebillid = ? and fbilltype = 'fa_card_fin';", params);
    }

    private void updateAssetFinCardEntry(Map<Long, Long> idRelationMap) {
        if (idRelationMap == null || idRelationMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(idRelationMap.size());
        for (Map.Entry<Long, Long> relationEntry : idRelationMap.entrySet()) {
            params.add(new Object[]{relationEntry.getValue(), relationEntry.getKey()});
        }
        String updateSql = "update t_fa_asset_finentry set foriginalfincardid = ? where ffincardid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, params);
    }

    static {
        THREAD_SIZE = Integer.parseInt(System.getProperty("prop.fi.fa.depre.threadcount", "3"));
        threadPool = ThreadPools.newFixedThreadPool((String)"kd.fi.fa.business.service.FaOriginalDataUpgradeServiceImpl", (int)THREAD_SIZE);
        finCardFields = new HashSet<String>(16);
    }

    public static class CardBizDTO {
        Map<Long, List<CardChangeDTO>> finChangeFieldsMap;
        Map<String, BigDecimal> devalueMap;

        public CardBizDTO(int size) {
            this.finChangeFieldsMap = new HashMap<Long, List<CardChangeDTO>>(size);
            this.devalueMap = new HashMap<String, BigDecimal>(size);
        }

        public Map<Long, List<CardChangeDTO>> getFinChangeFieldsMap() {
            return this.finChangeFieldsMap;
        }

        public void setFinChangeFieldsMap(Map<Long, List<CardChangeDTO>> finChangeFieldsMap) {
            this.finChangeFieldsMap = finChangeFieldsMap;
        }

        public Map<String, BigDecimal> getDevalueMap() {
            return this.devalueMap;
        }

        public void setDevalueMap(Map<String, BigDecimal> devalueMap) {
            this.devalueMap = devalueMap;
        }
    }

    public static class CardChangeDTO {
        private Date auditTime;
        private Date changeTime;
        private String field;
        private Object beforeValue;

        public CardChangeDTO(Date auditTime, Date changeTime, String field, Object beforeValue) {
            this.auditTime = auditTime;
            this.changeTime = changeTime;
            this.field = field;
            this.beforeValue = beforeValue;
        }

        public Date getAuditTime() {
            return this.auditTime;
        }

        public void setAuditTime(Date auditTime) {
            this.auditTime = auditTime;
        }

        public Date getChangeTime() {
            return this.changeTime;
        }

        public void setChangeTime(Date changeTime) {
            this.changeTime = changeTime;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Object getBeforeValue() {
            return this.beforeValue;
        }

        public void setBeforeValue(Object beforeValue) {
            this.beforeValue = beforeValue;
        }

        public int compareByAuditTime(CardChangeDTO other) {
            return this.auditTime.compareTo(other.getAuditTime());
        }
    }

    public static class UnSuccessOrgDTO {
        private DynamicObject orgObj;
        private Long logId;

        public UnSuccessOrgDTO(DynamicObject orgObj, Long logId) {
            this.orgObj = orgObj;
            this.logId = logId;
        }

        public DynamicObject getOrgObj() {
            return this.orgObj;
        }

        public void setOrgObj(DynamicObject orgObj) {
            this.orgObj = orgObj;
        }

        public Long getLogId() {
            return this.logId;
        }

        public void setLogId(Long logId) {
            this.logId = logId;
        }
    }

    class RealUpgradeThread
    implements Runnable {
        private List<Long> realCardIds;

        public RealUpgradeThread(List<Long> realCardIds) {
            this.realCardIds = realCardIds;
        }

        @Override
        public void run() {
            try {
                FaOriginalDataUpgradeService.this.batchUpgradeRealCard(this.realCardIds);
            }
            finally {
                FaOriginalDataUpgradeService.this.finishThreadCount.getAndIncrement();
            }
        }
    }

    class FinUpgradeThread
    implements Runnable {
        private List<Long> finCardIds;

        public FinUpgradeThread(List<Long> finCardIds) {
            this.finCardIds = finCardIds;
        }

        @Override
        public void run() {
            try {
                FaOriginalDataUpgradeService.this.batchUpgradeFinCard(this.finCardIds);
            }
            finally {
                FaOriginalDataUpgradeService.this.finishThreadCount.getAndIncrement();
            }
        }
    }
}

