/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.service.api.RealCardOriginalDataUpgradeService;

public class RealCardOriginalDataUpgradeServiceImpl
implements RealCardOriginalDataUpgradeService {
    private static final Log logger = LogFactory.getLog(RealCardOriginalDataUpgradeServiceImpl.class);
    private static final String ALGO_KEY = RealCardOriginalDataUpgradeServiceImpl.class.getName();
    private static final DBRoute DB_FA = DBRoute.of((String)"fa");
    private static final int BATCH_NUM = 1000;
    private static final String LOCK_KEY = "fi/fa/RealCardOriginalDataUpgradeService";

    @Override
    public void executeUpgradeService() {
        try (DLock dLock = DLock.create((String)LOCK_KEY).fastMode();){
            boolean tryLock = dLock.tryLock();
            if (!tryLock) {
                logger.info("\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u201c\u539f\u59cb\u6570\u636e\u201d\u5b57\u6bb5\uff1a\u672a\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501\uff0c\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u4e0d\u518d\u91cd\u590d\u5904\u7406");
                throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"RealCardOriginalDataUpgradeServiceImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            this.innerExecute();
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u201c\u539f\u59cb\u6570\u636e\u201d\u5b57\u6bb5\uff1a\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void unlockUpgradeLock() {
        DLock.forceUnlock((String[])new String[]{LOCK_KEY});
    }

    private void innerExecute() {
        String queryAllBook = "select distinct forgid from t_fa_assetbook;";
        DataSet allBooks = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_FA, (String)queryAllBook);
        HashSet<Long> orgIdSet = new HashSet<Long>(512);
        for (Row row : allBooks) {
            Long orgId = row.getLong("forgid");
            orgIdSet.add(orgId);
        }
        logger.info("\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u201c\u539f\u59cb\u6570\u636e\u201d\u5b57\u6bb5\uff1a\u7ec4\u7ec7\u6570[{}]", (Object)orgIdSet.size());
        int cnt = 1;
        Iterator iterator = orgIdSet.iterator();
        while (iterator.hasNext()) {
            long orgId = (Long)iterator.next();
            logger.info("\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u201c\u539f\u59cb\u6570\u636e\u201d\u5b57\u6bb5\uff1a\u5f00\u59cb\u5904\u7406\u7ec4\u7ec7[{}]", (Object)orgId);
            this.handleCardByOrg(orgId);
            logger.info("\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u201c\u539f\u59cb\u6570\u636e\u201d\u5b57\u6bb5\uff1a\u7ec4\u7ec7[{}]\u5904\u7406\u5b8c\u6bd5\uff0c\u5f53\u524d\u8fdb\u5ea6 {}/{}", new Object[]{orgId, cnt++, orgIdSet.size()});
        }
        logger.info("\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u201c\u539f\u59cb\u6570\u636e\u201d\u5b57\u6bb5\uff1a\u5347\u7ea7\u5b8c\u6210");
    }

    private void handleCardByOrg(long orgId) {
        SqlBuilder queryAllRealCardSql = new SqlBuilder();
        queryAllRealCardSql.append("select fid, fmasterid, foriginaldata from t_fa_card_real where forgid = ?;", new Object[]{orgId});
        DataSet realCards = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_FA, (SqlBuilder)queryAllRealCardSql);
        if (realCards.isEmpty()) {
            return;
        }
        realCards = realCards.orderBy(new String[]{"fmasterid", "fid asc"});
        ArrayList<RealCardInfo> realCardInfos = new ArrayList<RealCardInfo>(16);
        HashSet<Long> originalDataMasterIds = new HashSet<Long>();
        for (Row row : realCards) {
            Long id = row.getLong("fid");
            Long masterId = row.getLong("fmasterid");
            Boolean originalData = row.getBoolean("foriginaldata");
            realCardInfos.add(new RealCardInfo(id, masterId));
            if (!originalData.booleanValue()) continue;
            originalDataMasterIds.add(masterId);
        }
        HashSet<Long> realCardIdSet = new HashSet<Long>(1000);
        HashMap<Long, Long> masterIdToOriIdMap = new HashMap<Long, Long>(1000, 1.0f);
        long curMasterId = 0L;
        int curCardIdx = 0;
        for (RealCardInfo realCardInfo : realCardInfos) {
            Long id = realCardInfo.getId();
            Long masterId = realCardInfo.getMasterId();
            if (originalDataMasterIds.contains(masterId)) continue;
            if (masterId != curMasterId) {
                if (masterIdToOriIdMap.size() >= 1000) {
                    HashSet<Long> oriRealCardIdSet = new HashSet<Long>(masterIdToOriIdMap.values());
                    realCardIdSet.removeAll(oriRealCardIdSet);
                    this.updateCards(oriRealCardIdSet, realCardIdSet);
                    realCardIdSet.clear();
                    masterIdToOriIdMap.clear();
                }
                curMasterId = masterId;
                curCardIdx = 1;
            } else {
                ++curCardIdx;
            }
            realCardIdSet.add(id);
            if (curCardIdx != 1 && curCardIdx != 2) continue;
            masterIdToOriIdMap.put(masterId, id);
        }
        if (!masterIdToOriIdMap.isEmpty()) {
            HashSet<Long> oriRealCardIdSet = new HashSet<Long>(masterIdToOriIdMap.values());
            realCardIdSet.removeAll(oriRealCardIdSet);
            this.updateCards(oriRealCardIdSet, realCardIdSet);
            realCardIdSet.clear();
            masterIdToOriIdMap.clear();
        }
    }

    private void updateCards(Set<Long> oriRealCardIdSet, Set<Long> notOriRealCardIdSet) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!oriRealCardIdSet.isEmpty()) {
                    SqlBuilder updateOriDataSql = new SqlBuilder();
                    updateOriDataSql.append("update t_fa_card_real set foriginaldata = '1' where ", new Object[0]);
                    updateOriDataSql.appendIn(" fid ", oriRealCardIdSet.toArray());
                    DB.execute((DBRoute)DB_FA, (SqlBuilder)updateOriDataSql);
                }
                if (!notOriRealCardIdSet.isEmpty()) {
                    SqlBuilder updateNotOriDataSql = new SqlBuilder();
                    updateNotOriDataSql.append("update t_fa_card_real set foriginaldata = '0' where ", new Object[0]);
                    updateNotOriDataSql.appendIn(" fid ", notOriRealCardIdSet.toArray());
                    DB.execute((DBRoute)DB_FA, (SqlBuilder)updateNotOriDataSql);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    static class RealCardInfo {
        private Long id;
        private Long masterId;

        public RealCardInfo(Long id, Long masterId) {
            this.id = id;
            this.masterId = masterId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getMasterId() {
            return this.masterId;
        }

        public void setMasterId(Long masterId) {
            this.masterId = masterId;
        }
    }
}

