/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.fi.fa.business.strategy.DefaultSelectStrategy;

public class FilterStrategy
extends DefaultSelectStrategy {
    private Set<String> filterField;
    private boolean filtrateEntryFlag = false;

    public FilterStrategy(Set<String> filterField) {
        this.filterField = filterField == null ? Collections.EMPTY_SET : filterField;
    }

    public FilterStrategy(Set<String> filterField, boolean filtrateEntryFlag) {
        this.filterField = filterField == null ? Collections.EMPTY_SET : filterField;
        this.filtrateEntryFlag = filtrateEntryFlag;
    }

    @Override
    public boolean filterPro(IDataEntityProperty pro) {
        String name = pro.getName();
        return !this.filterField.contains(name) && !(pro instanceof EntryProp);
    }

    @Override
    public boolean filterEntryPro(EntryType pro) {
        if (this.filtrateEntryFlag) {
            return false;
        }
        String name = pro.getName();
        return !this.filterField.contains(name);
    }

    @Override
    public Set<String> getNeedColsOfBaseData(String baseDataNo) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
        return new HashSet<String>();
    }
}

