/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.Fa;

public class FaBillParamUtils {
    private static Log log = LogFactory.getLog(FaBillParamUtils.class);
    public static final String CLOUD_ID_FIN = "83bfebc8000002ac";
    public static final String APP_ID_FA = "83bfebc800001aac";

    public static DynamicObject queryOne(String paramKey, List<QFilter> customFilters) {
        return FiBillParamUtil.queryOne((String)CLOUD_ID_FIN, (String)APP_ID_FA, (String)paramKey, customFilters);
    }

    public static DynamicObject queryOne(Long orgId, Long depreUseId, String entity, String paramKey) {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(3);
        if (orgId == null) {
            orgId = 0L;
        }
        if (depreUseId == null) {
            depreUseId = 0L;
        }
        if (StringUtils.isEmpty((String)entity)) {
            entity = " ";
        }
        customFilters.add(new QFilter("org", "=", (Object)orgId));
        customFilters.add(new QFilter("depreuse", "=", (Object)depreUseId));
        customFilters.add(new QFilter("entity", "=", (Object)entity));
        return FaBillParamUtils.queryOne(paramKey, customFilters);
    }

    public static String queryOne(Long orgId, Long depreUseId, String entity, String paramKey, String defaultValue) {
        String value = FaBillParamUtils.getStringValue(orgId, depreUseId, entity, paramKey, false);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static DynamicObjectCollection query(String paramKey, List<QFilter> customFilters) {
        return FiBillParamUtil.query((String)CLOUD_ID_FIN, (String)APP_ID_FA, (String)paramKey, customFilters);
    }

    public static Map<String, String> queryParamMap(Long orgId, Long depreUseId, String entity, String paramKey, boolean returnTag) {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(3);
        if (orgId == null) {
            orgId = 0L;
        }
        if (depreUseId == null) {
            depreUseId = 0L;
        }
        if (StringUtils.isEmpty((String)entity)) {
            entity = " ";
        }
        customFilters.add(new QFilter("org", "=", (Object)orgId));
        customFilters.add(new QFilter("depreuse", "=", (Object)depreUseId));
        customFilters.add(new QFilter("entity", "=", (Object)entity));
        DynamicObjectCollection paramObjs = FaBillParamUtils.query(paramKey, customFilters);
        if (CollectionUtils.isEmpty((Collection)paramObjs)) {
            return null;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(paramObjs.size());
        for (DynamicObject param : paramObjs) {
            Long orgId4Record = param.getLong(Fa.id((String)"org"));
            Long depreUseId4Record = param.getLong(Fa.id((String)"depreuse"));
            DynamicObject entityObj = param.getDynamicObject("entity");
            String entity4Record = entityObj == null ? null : entityObj.getString("id");
            String value = param.getString(returnTag ? "value_tag" : "value");
            StringBuilder keyBuilder = new StringBuilder();
            if (orgId4Record != null && orgId4Record != 0L) {
                keyBuilder.append(orgId4Record).append("_");
            }
            if (depreUseId4Record != null && depreUseId4Record != 0L) {
                keyBuilder.append(depreUseId4Record).append("_");
            }
            if (StringUtils.isNotEmpty((String)entity4Record)) {
                keyBuilder.append(entity4Record).append("_");
            }
            keyBuilder.append(paramKey);
            resultMap.putIfAbsent(keyBuilder.toString(), value);
        }
        return resultMap;
    }

    public static String getStringValue(Long orgId, Long depreUseId, String entity, String paramKey, boolean returnTag) {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(3);
        if (orgId == null) {
            orgId = 0L;
        }
        if (depreUseId == null) {
            depreUseId = 0L;
        }
        if (StringUtils.isEmpty((String)entity)) {
            entity = " ";
        }
        customFilters.add(new QFilter("org", "=", (Object)orgId));
        customFilters.add(new QFilter("depreuse", "=", (Object)depreUseId));
        customFilters.add(new QFilter("entity", "=", (Object)entity));
        DynamicObject paramObj = FaBillParamUtils.queryOne(paramKey, customFilters);
        if (paramObj == null) {
            log.info("\u6839\u636eorgId[{}]\u3001depreUseId[{}]\u3001entity[{}]\u3001paramKey[{}]\u672a\u627e\u5230fa_billparam\u6570\u636e\u6216\u914d\u7f6e\u5df2\u88ab\u7981\u7528\uff01", new Object[]{orgId, depreUseId, entity, paramKey});
            return null;
        }
        return paramObj.getString(returnTag ? "value_tag" : "value");
    }

    public static Integer getIntegerValue(Long orgId, Long depreUseId, String entity, String paramKey) {
        String valueStr = FaBillParamUtils.getStringValue(orgId, depreUseId, entity, paramKey, false);
        return StringUtils.isEmpty((String)valueStr) ? null : Integer.valueOf(Integer.parseInt(valueStr));
    }

    public static Long getLongValue(Long orgId, Long depreUseId, String entity, String paramKey) {
        String valueStr = FaBillParamUtils.getStringValue(orgId, depreUseId, entity, paramKey, false);
        return StringUtils.isEmpty((String)valueStr) ? null : Long.valueOf(Long.parseLong(valueStr));
    }

    public static boolean getBooleanValue(Long orgId, Long depreUseId, String entity, String paramKey) {
        String valueStr = FaBillParamUtils.getStringValue(orgId, depreUseId, entity, paramKey, false);
        return StringUtils.isEmpty((String)valueStr) ? false : Boolean.parseBoolean(valueStr);
    }

    public static BigDecimal getBigDecimalValue(Long orgId, Long depreUseId, String entity, String paramKey) {
        String valueStr = FaBillParamUtils.getStringValue(orgId, depreUseId, entity, paramKey, false);
        return StringUtils.isEmpty((String)valueStr) ? null : new BigDecimal(valueStr);
    }

    public static Set<Long> isRptEnableBatch(String rptEntity, Collection<?> orgIds, Long depreUseId) {
        DynamicObjectCollection rptParams = QueryServiceHelper.query((String)"fa_billparam", (String)"org,depreuse,param", (QFilter[])new QFilter[]{new QFilter("entity", "=", (Object)rptEntity), new QFilter("org", "in", (Object)orgIds.toArray()), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("enable", "=", (Object)true), new QFilter("param", "=", (Object)"report.batch")});
        return rptParams.stream().map(obj -> obj.getLong("org")).collect(Collectors.toSet());
    }

    public static boolean exists(String paramKey, List<QFilter> customFilters) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("bizcloud", "=", (Object)CLOUD_ID_FIN));
        filters.add(new QFilter("bizapp", "=", (Object)APP_ID_FA));
        filters.add(new QFilter("param", "=", (Object)paramKey));
        filters.addAll(customFilters);
        return QueryServiceHelper.exists((String)"fa_billparam", (QFilter[])filters.toArray(new QFilter[0]));
    }
}

