/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.common.util.Fa;

public class FaCardBotpUtil {
    private static final Log log = LogFactory.getLog(FaCardBotpUtil.class);

    public static void repairBotp(Object[] finCardIdArr) {
        if (finCardIdArr == null || finCardIdArr.length == 0) {
            return;
        }
        DynamicObject[] finCardArr = BusinessDataServiceHelper.load((Object[])finCardIdArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_fin"));
        ArrayList<DynamicObject> saveFinCards = new ArrayList<DynamicObject>(finCardArr.length);
        for (DynamicObject finCard : finCardArr) {
            DynamicObjectCollection billHeads = finCard.getDynamicObjectCollection("billhead_lk");
            if (!billHeads.isEmpty()) continue;
            long realCardId = finCard.getLong("realcard_id");
            DynamicObject billHead = billHeads.addNew();
            Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
            billHead.set("seq", (Object)1);
            billHead.set("billhead_lk_stableid", (Object)realCardTableId);
            billHead.set("billhead_lk_sbillid", (Object)realCardId);
            billHead.set("billhead_lk_sid", (Object)realCardId);
            saveFinCards.add(finCard);
        }
        if (!saveFinCards.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignore_validate_initial_fincard", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_card_fin", (DynamicObject[])saveFinCards.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            FaCommonUtils.handleOperationResult(result);
        }
    }

    public static void deleteBotp4InitFinCard(Object[] finCardIdArr) {
        if (finCardIdArr == null || finCardIdArr.length == 0) {
            return;
        }
        Long initFinCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_initcard_fin", (String)"fa_initcard_fin").getTableId();
        ArrayList<Object[]> params = new ArrayList<Object[]>(finCardIdArr.length);
        for (Object id : finCardIdArr) {
            params.add(new Object[]{id, initFinCardTableId});
        }
        try (TXHandle tx = TX.requiresNew();){
            DBRoute routeFa = DBRoute.of((String)"fa");
            String deleteFinTc = "delete from t_fa_card_fin_tc where ftid = ? and fttableid = ?;";
            try {
                DB.executeBatch((DBRoute)routeFa, (String)deleteFinTc, params);
            }
            catch (Exception e1) {
                tx.markRollback();
                throw e1;
            }
        }
        tx = TX.requiresNew();
        var4_5 = null;
        try {
            DBRoute routeSys = DBRoute.of((String)"sys");
            String deleteSysBotp = "delete from t_botp_billtracker where ftbillid = ? and fttableid = ?;";
            try {
                DB.executeBatch((DBRoute)routeSys, (String)deleteSysBotp, params);
            }
            catch (Exception e1) {
                tx.markRollback();
                throw e1;
            }
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public static void oriFinCardBotpHandler4Audit(Map<Long, Long> oriFinId2FinIdMap, Map<Long, Long> oriRealId2OriFinIdMap, Map<Long, Long> finIdRealIdMap) {
        if (oriFinId2FinIdMap == null || oriFinId2FinIdMap.isEmpty()) {
            return;
        }
        Long finCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_fin", (String)"fa_card_fin").getTableId();
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        DBRoute routeFa = DBRoute.of((String)"fa");
        DBRoute routeSys = DBRoute.of((String)"sys");
        ArrayList<Object[]> updateTcParams = new ArrayList<Object[]>(oriFinId2FinIdMap.size());
        for (Map.Entry<Long, Long> entry : oriFinId2FinIdMap.entrySet()) {
            updateTcParams.add(new Object[]{entry.getValue(), entry.getValue(), finIdRealIdMap.get(entry.getValue()), finIdRealIdMap.get(entry.getValue()), entry.getKey(), finCardTableId});
        }
        ArrayList<Object[]> insertTcParams = new ArrayList<Object[]>(oriRealId2OriFinIdMap.size());
        long[] ids = DB.genGlobalLongIds((int)oriRealId2OriFinIdMap.size());
        int i = 0;
        for (Map.Entry<Long, Long> entry : oriRealId2OriFinIdMap.entrySet()) {
            insertTcParams.add(new Object[]{ids[i], entry.getValue(), finCardTableId, entry.getValue(), entry.getKey(), realCardTableId, entry.getKey()});
            ++i;
        }
        ArrayList<Object[]> updateTrackerParams = new ArrayList<Object[]>(oriFinId2FinIdMap.size());
        for (Map.Entry<Long, Long> entry : oriFinId2FinIdMap.entrySet()) {
            updateTrackerParams.add(new Object[]{entry.getValue(), entry.getKey(), finCardTableId});
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(oriRealId2OriFinIdMap.size());
        Date date = new Date();
        int j = 0;
        for (Map.Entry<Long, Long> entry : oriRealId2OriFinIdMap.entrySet()) {
            arrayList.add(new Object[]{ids[j], entry.getValue(), finCardTableId, entry.getKey(), realCardTableId, date});
            ++j;
        }
        String updateTcSql = "update t_fa_card_fin_tc set ftid = ?,ftbillid = ?,fsbillid = ?,fsid = ? where ftid = ? and fttableid = ?;";
        String insertTcSql = "INSERT INTO t_fa_card_fin_tc (fid, ftbillid, fttableid, ftid, fsbillid, fstableid, fsid) VALUES(?, ?, ?, ?, ?, ?, ?);";
        try (TXHandle tx = TX.required();){
            try {
                DB.executeBatch((DBRoute)routeFa, (String)updateTcSql, updateTcParams);
                DB.executeBatch((DBRoute)routeFa, (String)insertTcSql, insertTcParams);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        String updateTrackerSql = "update t_botp_billtracker set ftbillid = ? where ftbillid = ? and fttableid = ?;";
        String insertTrackerSql = "INSERT INTO t_botp_billtracker (fid, ftbillid, fttableid, fsbillid, fstableid, fcreatetime) VALUES(?, ?, ?, ?, ?, ?);";
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)routeSys, (String)updateTrackerSql, updateTrackerParams);
                DB.executeBatch((DBRoute)routeSys, (String)insertTrackerSql, arrayList);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void assetOriFinCardBotpHandler4UnAudit(Map<Long, Long> oriFinId2RealIdMap) {
        if (oriFinId2RealIdMap == null || oriFinId2RealIdMap.isEmpty()) {
            return;
        }
        Long finCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_fin", (String)"fa_card_fin").getTableId();
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        DBRoute routeFa = DBRoute.of((String)"fa");
        DBRoute routeSys = DBRoute.of((String)"sys");
        ArrayList<Object[]> updateTcParams = new ArrayList<Object[]>(oriFinId2RealIdMap.size());
        for (Map.Entry<Long, Long> entry : oriFinId2RealIdMap.entrySet()) {
            updateTcParams.add(new Object[]{entry.getValue(), entry.getValue(), entry.getKey(), finCardTableId});
        }
        ArrayList<Object[]> updateTrackerParams = new ArrayList<Object[]>(oriFinId2RealIdMap.size());
        for (Map.Entry<Long, Long> entry : oriFinId2RealIdMap.entrySet()) {
            updateTrackerParams.add(new Object[]{entry.getKey(), entry.getValue(), realCardTableId, finCardTableId});
        }
        String string = "update t_fa_card_fin_tc set fsbillid = ?,fsid = ? where ftid = ? and fttableid = ?;";
        try (TXHandle tXHandle = TX.required();){
            try {
                DB.executeBatch((DBRoute)routeFa, (String)string, updateTcParams);
            }
            catch (Exception e) {
                tXHandle.markRollback();
                throw e;
            }
        }
        String string2 = "update t_botp_billtracker set ftbillid = ? where fsbillid = ? and fstableid = ? and fttableid = ?;";
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)routeSys, (String)string2, updateTrackerParams);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void createBotpRelation(DynamicObject[] finCards) {
        DBRoute dbRouteFa = DBRoute.of((String)"fa");
        List finCardPks = Arrays.stream(finCards).map(v -> v.getLong("id")).collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fid from t_fa_card_fin_lk where ", new Object[0]);
        sqlBuilder.appendIn(" fid ", finCardPks.toArray());
        DataSet existBotpCard = DB.queryDataSet((String)"fi/fa/assetCard/createBotp", (DBRoute)dbRouteFa, (SqlBuilder)sqlBuilder);
        HashSet<DynamicObject[]> existBotpCardSet = new HashSet<DynamicObject[]>(32);
        for (Row row : existBotpCard) {
            DynamicObject[] finCardId = row.getLong("fid");
            existBotpCardSet.add(finCardId);
        }
        log.info("\u5df2\u7ecf\u5b58\u5728botp\u5173\u7cfb\u7684\u5361\u7247\u4e0d\u518d\u91cd\u590d\u751f\u6210\uff1a{}", existBotpCardSet);
        List genBotpCardIds = finCardPks.stream().filter(v -> !existBotpCardSet.contains(v)).collect(Collectors.toList());
        if (genBotpCardIds.isEmpty()) {
            return;
        }
        HashMap<Long, Long> cardIdMap = new HashMap<Long, Long>(32);
        for (DynamicObject finCard : finCards) {
            long finCardId = finCard.getLong("id");
            if (finCardId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u73b0\u5f02\u5e38\u6570\u636e\uff0c\u8d22\u52a1\u5361\u7247id\u4e3a0\u3002", (String)"AbstractAssetCardOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            if (realCardId == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247[%s]\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3002", (String)"AbstractAssetCardOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), finCardId));
            }
            cardIdMap.put(finCardId, realCardId);
        }
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        Long finCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_fin", (String)"fa_card_fin").getTableId();
        long[] ids = DB.genGlobalLongIds((int)(genBotpCardIds.size() * 3));
        int idIndex = 0;
        ArrayList<Object[]> paramsOfLk = new ArrayList<Object[]>(finCards.length);
        ArrayList<Object[]> paramsOfTc = new ArrayList<Object[]>(finCards.length);
        ArrayList<Object[]> paramsOfBillTracker = new ArrayList<Object[]>(finCards.length);
        Date createTime = new Date();
        for (Long finCardId : genBotpCardIds) {
            Long realCardId = (Long)cardIdMap.get(finCardId);
            paramsOfLk.add(new Object[]{finCardId, ids[idIndex++], 1, realCardTableId, realCardId, realCardId});
            paramsOfTc.add(new Object[]{ids[idIndex++], finCardId, finCardTableId, finCardId, realCardId, realCardTableId, realCardId});
            paramsOfBillTracker.add(new Object[]{ids[idIndex++], realCardTableId, realCardId, finCardTableId, finCardId, createTime});
        }
        String insertLk = "INSERT INTO t_fa_card_fin_lk (fid, fpkid, fseq, fstableid, fsbillid, fsid) VALUES(?, ?, ?, ?, ?, ?);";
        String insertTc = "INSERT INTO t_fa_card_fin_tc (fid, ftbillid, fttableid, ftid, fsbillid, fstableid, fsid) VALUES(?, ?, ?, ?, ?, ?, ?);";
        String insertBillTracker = "INSERT INTO t_botp_billtracker (fid, fstableid, fsbillid, fttableid, ftbillid, fcreatetime) VALUES(?, ?, ?, ?, ?, ?);";
        try (TXHandle h1 = TX.required();){
            try {
                log.info("\u5f00\u59cb\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\uff1a\u8d22\u52a1\u5e93");
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertLk, paramsOfLk);
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertTc, paramsOfTc);
                log.info("\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\u5b8c\u6210\uff1a\u8d22\u52a1\u5e93");
                try (TXHandle h2 = TX.requiresNew();){
                    try {
                        log.info("\u5f00\u59cb\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\uff1a\u7cfb\u7edf\u5e93");
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertBillTracker, paramsOfBillTracker);
                        log.info("\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\u5b8c\u6210\uff1a\u7cfb\u7edf\u5e93");
                    }
                    catch (Exception e2) {
                        log.error("\u8d44\u4ea7\u5361\u7247\u521b\u5efabotp\u5173\u7cfb\u51fa\u9519\uff08\u7cfb\u7edf\u5e93\uff09", (Throwable)e2);
                        h2.markRollback();
                        throw e2;
                    }
                }
            }
            catch (Exception e1) {
                log.error("\u8d44\u4ea7\u5361\u7247\u521b\u5efabotp\u5173\u7cfb\u51fa\u9519\uff08\u8d22\u52a1\u5e93\uff09", (Throwable)e1);
                h1.markRollback();
                throw e1;
            }
        }
    }

    public static void copyRepairTC(Map<Long, Long> sourceTargetIdMap, String entityName) {
        if (sourceTargetIdMap == null || sourceTargetIdMap.isEmpty()) {
            return;
        }
        String tcTableName = EntityMetadataCache.getDataEntityType((String)entityName).getAlias() + "_tc";
        HashSet<Long> existTcTargetIds = new HashSet<Long>();
        SqlBuilder querySql4Target = new SqlBuilder();
        querySql4Target.append("select ftbillid from " + tcTableName + " where ", new Object[0]);
        querySql4Target.appendIn(" ftbillid ", (Object[])sourceTargetIdMap.values().toArray(new Long[0]));
        DataSet dataSet = DB.queryDataSet((String)"FaCardBotpUtil.copyRepairTC_querySql4Target", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql4Target);
        Object object = null;
        try {
            for (Row row : dataSet) {
                existTcTargetIds.add(row.getLong("ftbillid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashSet needCopySourceIds = new HashSet();
        for (Map.Entry entry : sourceTargetIdMap.entrySet()) {
            if (existTcTargetIds.contains(entry.getValue())) continue;
            needCopySourceIds.add(entry.getKey());
        }
        log.info("FaCardBotpUtil.copyRepairTC -> sourceTargetIdMap size is [{}], existTcTargetIds size is [{}], needCopySourceIds size is [{}]", new Object[]{sourceTargetIdMap.size(), existTcTargetIds.size(), needCopySourceIds.size()});
        if (CollectionUtils.isEmpty(needCopySourceIds)) {
            return;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fid, ftbillid, fttableid, ftid, fsbillid, fstableid, fsid from " + tcTableName + " where ", new Object[0]);
        querySql.appendIn(" ftbillid ", (Object[])needCopySourceIds.toArray(new Long[0]));
        try (DataSet dataSet2 = DB.queryDataSet((String)"FaCardBotpUtil.copyRepairTC_querySql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            DataSet dataSetCp = dataSet2.copy();
            int countSize = dataSetCp.count("fid", true);
            dataSetCp.close();
            ArrayList<Object[]> paramsOfTc = new ArrayList<Object[]>(countSize);
            long[] ids = DB.genLongIds((String)tcTableName, (int)countSize);
            int i = 0;
            for (Row row : dataSet2) {
                Long cardId = row.getLong("ftbillid");
                Long targetCardId = sourceTargetIdMap.get(cardId);
                paramsOfTc.add(new Object[]{ids[i], targetCardId, row.getLong("fttableid"), targetCardId, row.getLong("fsbillid"), row.getLong("fstableid"), row.getLong("fsid")});
                ++i;
            }
            if (CollectionUtils.isNotEmpty(paramsOfTc)) {
                String insertTc = "INSERT INTO " + tcTableName + " (fid, ftbillid, fttableid, ftid, fsbillid, fstableid, fsid) VALUES(?, ?, ?, ?, ?, ?, ?);";
                log.info("\u5f00\u59cb\u63d2\u5165_tc\u8868[{}]\u5173\u7cfb\u6570\u636e", (Object)tcTableName);
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)insertTc, paramsOfTc);
                log.info("\u63d2\u5165_tc\u8868[{}]\u5173\u7cfb\u6570\u636e\u5b8c\u6210", (Object)tcTableName);
            }
        }
    }
}

